/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util;

import org.slf4j.LoggerFactory;

public class Logger {
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(Logger.class);

    public void warn(String s, Object ... objects) {
        int objectsLength = objects == null ? 0 : objects.length;
        System.out.println("[WARN] " + this.processArgs(s, objectsLength, objects));
    }

    public void debug(String s, Object ... objects) {
        int objectsLength = objects == null ? 0 : objects.length;
        System.out.println("[DEBUG]" + this.processArgs(s, objectsLength, objects));
    }

    public void info(String s, Object ... objects) {
        int objectsLength = objects == null ? 0 : objects.length;
        System.out.println("[INFO] " + this.processArgs(s, objectsLength, objects));
    }

    public void trace(String s, Object ... objects) {
        int objectsLength = objects == null ? 0 : objects.length;
        System.out.println("[TRACE] " + this.processArgs(s, objectsLength, objects));
    }

    public <E extends Exception> void error(String s, E exception) {
        System.out.println("[ERROR] " + this.processArgs(s, 0, new Object[0]));
        exception.printStackTrace();
    }

    public void error(String s, Object ... objects) {
        int objectsLength = objects == null ? 0 : objects.length;
        Throwable exception = null;
        if (objects != null && objects.length > 0 && objects[objects.length - 1] instanceof Exception) {
            exception = (Exception)objects[objects.length - 1];
            --objectsLength;
        }
        System.out.println("[ERROR] " + this.processArgs(s, objectsLength, objects));
        if (exception != null) {
            exception.printStackTrace();
        }
    }

    private String processArgs(String message, int argsLength, Object ... args) {
        if (args == null || argsLength == 0) {
            int index = message.indexOf("{}");
            if (index != -1) {
                throw new RuntimeException("No message args at " + message.substring(Math.max(0, index - 10), Math.min(message.length(), index + 10)));
            }
            return message;
        }
        Object result = message;
        int index = 0;
        int i = 1;
        while (true) {
            if (i < ((String)result).length()) {
                char firstChar = ((String)result).charAt(i - 1);
                char secChar = ((String)result).charAt(i);
                if (firstChar == '{' && secChar == '}') {
                    String arg = args[index].toString();
                    result = ((String)result).substring(0, i - 1) + arg + ((String)result).substring(i + 1);
                    i += arg.length() - 1;
                } else {
                    ++i;
                    continue;
                }
            }
            if (++index >= argsLength) break;
        }
        return result;
    }
}

