/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.client;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.FaceIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.ContextMenu;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.NordButton;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import dev.ftb.mods.ftbteams.data.KnownClientPlayer;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.net.PlayerGUIOperationMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;

public class MemberButton
extends NordButton {
    public final KnownClientPlayer player;
    public final TeamRank rank;

    MemberButton(Panel panel, KnownClientPlayer p, TeamRank r) {
        super(panel, (Component)Component.m_237113_((String)p.name), (Icon)FaceIcon.getFace((GameProfile)p.getProfile()));
        this.setWidth(this.width + 18);
        this.player = p;
        this.rank = r;
    }

    public void drawIcon(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        super.drawIcon(matrixStack, theme, x, y, w, h);
        if (this.player.online) {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)(x + w) - 1.5, (double)y - 0.5, 0.0);
            Color4I.GREEN.draw(matrixStack, 0, 0, 2, 2);
            matrixStack.m_85849_();
        }
        if (ClientTeamManager.INSTANCE.selfTeam.getType() == TeamType.PARTY) {
            TeamRank tr = ClientTeamManager.INSTANCE.selfTeam.getHighestRank(this.player.uuid);
            tr.getIcon().ifPresent(icon -> icon.draw(matrixStack, this.getX() + this.width - 14, this.getY() + 2, 12, 12));
        }
    }

    public void onClicked(MouseButton button) {
        KnownClientPlayer self = ClientTeamManager.INSTANCE.selfKnownPlayer;
        ClientTeam selfTeam = ClientTeamManager.INSTANCE.selfTeam;
        TeamRank selfRank = selfTeam.getHighestRank(self.uuid);
        TeamRank playerRank = selfTeam.getHighestRank(this.player.uuid);
        ArrayList<ContextMenuItem> items0 = new ArrayList<ContextMenuItem>();
        if (this.player.uuid.equals(self.uuid)) {
            if (selfRank.is(TeamRank.OWNER)) {
                if (selfTeam.getMembers().size() == 1) {
                    items0.add(new ContextMenuItem((Component)Component.m_237115_((String)"ftbteams.gui.disband"), Icons.CLOSE, () -> PlayerGUIOperationMessage.Operation.LEAVE.sendMessage(this.player)).setYesNo((Component)Component.m_237115_((String)"ftbteams.gui.disband.confirm")));
                }
            } else {
                items0.add(new ContextMenuItem((Component)Component.m_237115_((String)"ftbteams.gui.leave"), Icons.CLOSE, () -> PlayerGUIOperationMessage.Operation.LEAVE.sendMessage(this.player)).setYesNo((Component)Component.m_237115_((String)"ftbteams.gui.leave.confirm")));
            }
        } else if (selfRank.is(TeamRank.OWNER)) {
            if (playerRank == TeamRank.MEMBER) {
                items0.add(new ContextMenuItem((Component)Component.m_237110_((String)"ftbteams.gui.promote", (Object[])new Object[]{this.player.name}), Icons.SHIELD, () -> PlayerGUIOperationMessage.Operation.PROMOTE.sendMessage(this.player)).setYesNo((Component)Component.m_237110_((String)"ftbteams.gui.promote.confirm", (Object[])new Object[]{this.player.name})));
            } else if (playerRank == TeamRank.OFFICER) {
                items0.add(new ContextMenuItem((Component)Component.m_237110_((String)"ftbteams.gui.demote", (Object[])new Object[]{this.player.name}), Icons.ACCEPT_GRAY, () -> PlayerGUIOperationMessage.Operation.DEMOTE.sendMessage(this.player)).setYesNo((Component)Component.m_237110_((String)"ftbteams.gui.demote.confirm", (Object[])new Object[]{this.player.name})));
            }
            if (playerRank.isMember()) {
                items0.add(new ContextMenuItem((Component)Component.m_237110_((String)"ftbteams.gui.transfer_ownership", (Object[])new Object[]{this.player.name}), Icons.DIAMOND, () -> PlayerGUIOperationMessage.Operation.TRANSFER_OWNER.sendMessage(this.player)).setYesNo((Component)Component.m_237110_((String)"ftbteams.gui.transfer_ownership.confirm", (Object[])new Object[]{this.player.name})));
            }
        }
        if (selfRank.getPower() > playerRank.getPower()) {
            if (playerRank.isMember()) {
                items0.add(new ContextMenuItem((Component)Component.m_237110_((String)"ftbteams.gui.kick", (Object[])new Object[]{this.player.name}), Icons.CLOSE, () -> PlayerGUIOperationMessage.Operation.KICK.sendMessage(this.player)).setYesNo((Component)Component.m_237110_((String)"ftbteams.gui.kick.confirm", (Object[])new Object[]{this.player.name})));
            } else if (selfRank.isOfficer() && playerRank.isAlly()) {
                items0.add(new ContextMenuItem((Component)Component.m_237110_((String)"ftbteams.gui.remove_ally", (Object[])new Object[]{this.player.name}), Icons.CANCEL, () -> PlayerGUIOperationMessage.Operation.REMOVE_ALLY.sendMessage(this.player)).setYesNo((Component)Component.m_237110_((String)"ftbteams.gui.remove_ally.confirm", (Object[])new Object[]{this.player.name})));
            }
        }
        if (!items0.isEmpty()) {
            ArrayList<ContextMenuItem> items = new ArrayList<ContextMenuItem>(List.of(new ContextMenuItem(playerRank.getDisplayName(), (Icon)FaceIcon.getFace((GameProfile)new GameProfile(this.player.uuid, null)), () -> {}).setCloseMenu(false), ContextMenuItem.SEPARATOR));
            items.addAll(items0);
            this.openContextMenu((Panel)new ContextMenu(this.parent, items));
        }
    }
}

