/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import net.optifine.util.IntExpiringCache;

public abstract class IntExpiringCache<T> {
    private final int intervalMs;
    private long timeCheckMs;
    private Int2ObjectOpenHashMap<Wrapper<T>> map = new Int2ObjectOpenHashMap();

    public IntExpiringCache(int intervalMs) {
        this.intervalMs = intervalMs;
    }

    public T get(int key) {
        Wrapper w2;
        long timeNowMs = System.currentTimeMillis();
        if (!this.map.isEmpty() && timeNowMs >= this.timeCheckMs) {
            this.timeCheckMs = timeNowMs + (long)this.intervalMs;
            long timeMinMs = timeNowMs - (long)this.intervalMs;
            IntSet keys = this.map.keySet();
            IntIterator it = keys.iterator();
            while (it.hasNext()) {
                Wrapper w3;
                int k2 = it.nextInt();
                if (k2 == key || (w3 = (Wrapper)this.map.get(k2)).getAccessTimeMs() > timeMinMs) continue;
                it.remove();
            }
        }
        if ((w2 = (Wrapper)this.map.get(key)) == null) {
            Object obj = this.make();
            w2 = new Wrapper(obj);
            this.map.put(key, (Object)w2);
        }
        w2.setAccessTimeMs(timeNowMs);
        return (T)w2.getValue();
    }

    protected abstract T make();
}

