/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.optifine.Config;
import net.optifine.shaders.Program;
import net.optifine.shaders.RenderStage;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersCompatibility;
import net.optifine.shaders.config.HeaderLine;
import net.optifine.shaders.config.HeaderLineFunction;
import net.optifine.shaders.config.HeaderLineText;
import net.optifine.shaders.config.HeaderLineVariable;
import net.optifine.shaders.config.ShaderPackParser;
import net.optifine.shaders.config.ShaderType;
import net.optifine.util.ArrayUtils;
import net.optifine.util.LineBuffer;
import net.optifine.util.StrUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ShadersCompatibility {
    public static Pattern PATTERN_UNIFORM = Pattern.compile("(\\s*layout\\s*\\(.*\\)|)\\s*uniform\\s+\\w+\\s+(\\w+).*");
    public static Pattern PATTERN_IN = Pattern.compile("(\\s*layout\\s*\\(.*\\)|)\\s*in\\s+\\w+\\s+(\\w+).*");
    public static Pattern PATTERN_OUT = Pattern.compile("(\\s*layout\\s*\\(.*\\)|)\\s*out\\s+\\w+\\s+(\\w+).*");
    public static Pattern PATTERN_VARYING = Pattern.compile("\\s*varying\\s+\\w+\\s+(\\w+).*");
    public static Pattern PATTERN_CONST = Pattern.compile("\\s*const\\s+\\w+\\s+(\\w+).*");
    public static Pattern PATTERN_FUNCTION = Pattern.compile("\\s*\\w+\\s+(\\w+)\\s*\\(.*\\).*", 32);
    public static HeaderLine MODEL_VIEW_MATRIX = ShadersCompatibility.makeHeaderLine((String)"uniform mat4 modelViewMatrix;");
    public static HeaderLine MODEL_VIEW_MATRIX_INVERSE = ShadersCompatibility.makeHeaderLine((String)"uniform mat4 modelViewMatrixInverse;");
    public static HeaderLine PROJECTION_MATRIX = ShadersCompatibility.makeHeaderLine((String)"uniform mat4 projectionMatrix;");
    public static HeaderLine PROJECTION_MATRIX_INVERSE = ShadersCompatibility.makeHeaderLine((String)"uniform mat4 projectionMatrixInverse;");
    public static HeaderLine TEXTURE_MATRIX = ShadersCompatibility.makeHeaderLine((String)"uniform mat4 textureMatrix = mat4(1.0);");
    public static HeaderLine NORMAL_MATRIX = ShadersCompatibility.makeHeaderLine((String)"uniform mat3 normalMatrix;");
    public static HeaderLine CHUNK_OFFSET = ShadersCompatibility.makeHeaderLine((String)"uniform vec3 chunkOffset;");
    public static HeaderLine ALPHA_TEST_REF = ShadersCompatibility.makeHeaderLine((String)"uniform float alphaTestRef;");
    public static HeaderLine TEXTURE_MATRIX_2 = ShadersCompatibility.makeHeaderLine((String)"const mat4 TEXTURE_MATRIX_2 = mat4(vec4(0.00390625, 0.0, 0.0, 0.0), vec4(0.0, 0.00390625, 0.0, 0.0), vec4(0.0, 0.0, 0.00390625, 0.0), vec4(0.03125, 0.03125, 0.03125, 1.0));");
    public static HeaderLine FTRANSORM_BASIC = ShadersCompatibility.makeHeaderLine((String)ShadersCompatibility.makeFtransformBasic());
    public static HeaderLine FOG_DENSITY = ShadersCompatibility.makeHeaderLine((String)"uniform float fogDensity;");
    public static HeaderLine FOG_START = ShadersCompatibility.makeHeaderLine((String)"uniform float fogStart;");
    public static HeaderLine FOG_END = ShadersCompatibility.makeHeaderLine((String)"uniform float fogEnd;");
    public static HeaderLine FOG_COLOR = ShadersCompatibility.makeHeaderLine((String)"uniform vec3 fogColor;");
    public static HeaderLine VIEW_WIDTH = ShadersCompatibility.makeHeaderLine((String)"uniform float viewWidth;");
    public static HeaderLine VIEW_HEIGHT = ShadersCompatibility.makeHeaderLine((String)"uniform float viewHeight;");
    public static HeaderLine RENDER_STAGE = ShadersCompatibility.makeHeaderLine((String)"uniform int renderStage;");
    public static HeaderLine FOG_FRAG_COORD_OUT = ShadersCompatibility.makeHeaderLine((String)"out float varFogFragCoord;");
    public static HeaderLine FOG_FRAG_COORD_IN = ShadersCompatibility.makeHeaderLine((String)"in float varFogFragCoord;");
    public static HeaderLine FRONT_COLOR_OUT = ShadersCompatibility.makeHeaderLine((String)"out vec4 varFrontColor;");
    public static HeaderLine FRONT_COLOR_IN = ShadersCompatibility.makeHeaderLine((String)"in vec4 varFrontColor;");
    public static HeaderLine POSITION = ShadersCompatibility.makeHeaderLine((String)"in vec3 vaPosition;");
    public static HeaderLine COLOR = ShadersCompatibility.makeHeaderLine((String)"in vec4 vaColor;");
    public static HeaderLine UV0 = ShadersCompatibility.makeHeaderLine((String)"in vec2 vaUV0;");
    public static HeaderLine UV1 = ShadersCompatibility.makeHeaderLine((String)"in ivec2 vaUV1;");
    public static HeaderLine UV2 = ShadersCompatibility.makeHeaderLine((String)"in ivec2 vaUV2;");
    public static HeaderLine NORMAL = ShadersCompatibility.makeHeaderLine((String)"in vec3 vaNormal;");
    private static final Pattern PATTERN_VERSION = ShaderPackParser.PATTERN_VERSION;
    public static final Pattern PATTERN_EXTENSION = Pattern.compile("\\s*#\\s*extension\\s+(\\w+)(.*)");
    public static final Pattern PATTERN_LINE = Pattern.compile("\\s*#\\s*line\\s+(\\d+)\\s+(\\d+)(.*)");
    private static final Pattern PATTERN_TEXTURE2D_TEXCOORD = Pattern.compile("(.*texture(2D)?\\s*\\(\\s*(texture|colortex0)\\s*,\\s*)(\\w+)(\\s*\\).*)");
    private static final Pattern PATTERN_FRAG_DATA_SET = Pattern.compile("(\\s*)gl_FragData\\[(\\d+)\\](\\S*)\\s*=\\s*(.*)");
    private static final Pattern PATTERN_FRAG_DATA_GET = Pattern.compile("gl_FragData\\[(\\d+)\\]([^ ][^=])");
    private static final Pattern PATTERN_FRAG_DATA = Pattern.compile("gl_FragData\\[(\\d+)\\]");
    private static final String COMMENT_COMPATIBILITY = "// Compatibility (auto-generated)";

    public static LineBuffer remap(Program program, ShaderType shaderType, LineBuffer lines) {
        if (program == null) {
            return lines;
        }
        int version = 120;
        LineBuffer writer = new LineBuffer();
        LinkedHashSet headerLines = new LinkedHashSet();
        for (String line : lines) {
            if (line.equals("// Compatibility (auto-generated)")) {
                return lines;
            }
            if (line.trim().startsWith("//")) {
                writer.add(line);
                continue;
            }
            if (ShadersCompatibility.matches((String)line, (Pattern)PATTERN_VERSION)) {
                version = Math.max(version, ShadersCompatibility.getVersion((String)line, (int)version));
                line = ShadersCompatibility.replace((String)line, (String)"#version 110", (String)"#version 150", headerLines, (HeaderLine[])new HeaderLine[0]);
                line = ShadersCompatibility.replace((String)line, (String)"#version 120", (String)"#version 150", headerLines, (HeaderLine[])new HeaderLine[0]);
                line = ShadersCompatibility.replace((String)line, (String)"#version 130", (String)"#version 150", headerLines, (HeaderLine[])new HeaderLine[0]);
                line = ShadersCompatibility.replace((String)line, (String)"#version 140", (String)"#version 150", headerLines, (HeaderLine[])new HeaderLine[0]);
                line = ShadersCompatibility.replace((String)line, (String)"compatibility", (String)"", headerLines, (HeaderLine[])new HeaderLine[0]);
            }
            if (shaderType == ShaderType.VERTEX) {
                if (program == Shaders.ProgramBasic) {
                    line = ShadersCompatibility.replace((String)line, (Pattern)Pattern.compile("(\\W)gl_ProjectionMatrix\\s*\\*\\s*gl_ModelViewMatrix\\s*\\*\\s*gl_Vertex(\\W)"), (String)"$1ftransform()$2", headerLines, (HeaderLine[])new HeaderLine[0]);
                    line = ShadersCompatibility.replace((String)line, (Pattern)Pattern.compile("(\\W)gl_ModelViewProjectionMatrix\\s*\\*\\s*gl_Vertex(\\W)"), (String)"$1ftransform()$2", headerLines, (HeaderLine[])new HeaderLine[0]);
                    line = ShadersCompatibility.replace((String)line, (String)"ftransform()", (String)"ftransformBasic()", headerLines, (HeaderLine[])new HeaderLine[]{RENDER_STAGE, VIEW_WIDTH, VIEW_HEIGHT, PROJECTION_MATRIX, MODEL_VIEW_MATRIX, POSITION, NORMAL, FTRANSORM_BASIC});
                }
                if (program.getProgramStage().isAnyComposite()) {
                    line = ShadersCompatibility.replace((String)line, (String)"ftransform()", (String)"(projectionMatrix * modelViewMatrix * vec4(vaPosition, 1.0))", headerLines, (HeaderLine[])new HeaderLine[]{PROJECTION_MATRIX, MODEL_VIEW_MATRIX, POSITION});
                    line = ShadersCompatibility.replace((String)line, (String)"gl_Vertex", (String)"vec4(vaPosition, 1.0)", headerLines, (HeaderLine[])new HeaderLine[]{POSITION});
                } else {
                    line = ShadersCompatibility.replace((String)line, (String)"ftransform()", (String)"(projectionMatrix * modelViewMatrix * vec4(vaPosition + chunkOffset, 1.0))", headerLines, (HeaderLine[])new HeaderLine[]{PROJECTION_MATRIX, MODEL_VIEW_MATRIX, POSITION, CHUNK_OFFSET});
                    line = ShadersCompatibility.replace((String)line, (String)"gl_Vertex", (String)"vec4(vaPosition + chunkOffset, 1.0)", headerLines, (HeaderLine[])new HeaderLine[]{POSITION, CHUNK_OFFSET});
                }
                line = ShadersCompatibility.replace((String)line, (String)"gl_Color", (String)"vaColor", headerLines, (HeaderLine[])new HeaderLine[]{COLOR});
                line = ShadersCompatibility.replace((String)line, (String)"gl_Normal", (String)"vaNormal", headerLines, (HeaderLine[])new HeaderLine[]{NORMAL});
                line = ShadersCompatibility.replace((String)line, (String)"gl_MultiTexCoord0", (String)"vec4(vaUV0, 0.0, 1.0)", headerLines, (HeaderLine[])new HeaderLine[]{UV0});
                line = ShadersCompatibility.replace((String)line, (String)"gl_MultiTexCoord1", (String)"vec4(vaUV1, 0.0, 1.0)", headerLines, (HeaderLine[])new HeaderLine[]{UV1});
                line = ShadersCompatibility.replace((String)line, (String)"gl_MultiTexCoord2", (String)"vec4(vaUV2, 0.0, 1.0)", headerLines, (HeaderLine[])new HeaderLine[]{UV2});
                line = ShadersCompatibility.replace((String)line, (String)"gl_MultiTexCoord3", (String)"vec4(0.0, 0.0, 0.0, 1.0)", headerLines, (HeaderLine[])new HeaderLine[0]);
            }
            line = ShadersCompatibility.replace((String)line, (String)"gl_ProjectionMatrix", (String)"projectionMatrix", headerLines, (HeaderLine[])new HeaderLine[]{PROJECTION_MATRIX});
            line = ShadersCompatibility.replace((String)line, (String)"gl_ProjectionMatrixInverse", (String)"projectionMatrixInverse", headerLines, (HeaderLine[])new HeaderLine[]{PROJECTION_MATRIX_INVERSE});
            line = ShadersCompatibility.replace((String)line, (String)"gl_ModelViewMatrix", (String)"modelViewMatrix", headerLines, (HeaderLine[])new HeaderLine[]{MODEL_VIEW_MATRIX});
            line = ShadersCompatibility.replace((String)line, (String)"gl_ModelViewMatrixInverse", (String)"modelViewMatrixInverse", headerLines, (HeaderLine[])new HeaderLine[]{MODEL_VIEW_MATRIX_INVERSE});
            line = ShadersCompatibility.replace((String)line, (String)"gl_ModelViewProjectionMatrix", (String)"(projectionMatrix * modelViewMatrix)", headerLines, (HeaderLine[])new HeaderLine[]{PROJECTION_MATRIX, MODEL_VIEW_MATRIX});
            line = ShadersCompatibility.replace((String)line, (String)"gl_NormalMatrix", (String)"normalMatrix", headerLines, (HeaderLine[])new HeaderLine[]{NORMAL_MATRIX});
            if (shaderType == ShaderType.VERTEX) {
                line = ShadersCompatibility.replace((String)line, (String)"attribute", (String)"in", headerLines, (HeaderLine[])new HeaderLine[0]);
                line = ShadersCompatibility.replace((String)line, (String)"varying", (String)"out", headerLines, (HeaderLine[])new HeaderLine[0]);
                line = ShadersCompatibility.replace((String)line, (String)"gl_FogFragCoord", (String)"varFogFragCoord", headerLines, (HeaderLine[])new HeaderLine[]{FOG_FRAG_COORD_OUT});
                line = ShadersCompatibility.replace((String)line, (String)"gl_FrontColor", (String)"varFrontColor", headerLines, (HeaderLine[])new HeaderLine[]{FRONT_COLOR_OUT});
            }
            if (shaderType == ShaderType.GEOMETRY) {
                line = ShadersCompatibility.replace((String)line, (String)"varying in", (String)"in", headerLines, (HeaderLine[])new HeaderLine[0]);
                line = ShadersCompatibility.replace((String)line, (String)"varying out", (String)"out", headerLines, (HeaderLine[])new HeaderLine[0]);
            }
            if (shaderType == ShaderType.FRAGMENT) {
                line = ShadersCompatibility.replace((String)line, (String)"varying", (String)"in", headerLines, (HeaderLine[])new HeaderLine[0]);
                line = ShadersCompatibility.replace((String)line, (String)"gl_FogFragCoord", (String)"varFogFragCoord", headerLines, (HeaderLine[])new HeaderLine[]{FOG_FRAG_COORD_IN});
                line = ShadersCompatibility.replace((String)line, (String)"gl_FrontColor", (String)"varFrontColor", headerLines, (HeaderLine[])new HeaderLine[]{FRONT_COLOR_IN});
            }
            line = ShadersCompatibility.replace((String)line, (String)"gl_TextureMatrix[0]", (String)"textureMatrix", headerLines, (HeaderLine[])new HeaderLine[]{TEXTURE_MATRIX});
            line = ShadersCompatibility.replace((String)line, (String)"gl_TextureMatrix[1]", (String)"mat4(1.0)", headerLines, (HeaderLine[])new HeaderLine[0]);
            line = ShadersCompatibility.replace((String)line, (String)"gl_TextureMatrix[2]", (String)"TEXTURE_MATRIX_2", headerLines, (HeaderLine[])new HeaderLine[]{TEXTURE_MATRIX_2});
            line = ShadersCompatibility.replace((String)line, (String)"gl_Fog.density", (String)"fogDensity", headerLines, (HeaderLine[])new HeaderLine[]{FOG_DENSITY});
            line = ShadersCompatibility.replace((String)line, (String)"gl_Fog.start", (String)"fogStart", headerLines, (HeaderLine[])new HeaderLine[]{FOG_START});
            line = ShadersCompatibility.replace((String)line, (String)"gl_Fog.end", (String)"fogEnd", headerLines, (HeaderLine[])new HeaderLine[]{FOG_END});
            line = ShadersCompatibility.replace((String)line, (String)"gl_Fog.scale", (String)"(1.0 / (fogEnd - fogStart))", headerLines, (HeaderLine[])new HeaderLine[]{FOG_START, FOG_END});
            line = ShadersCompatibility.replace((String)line, (String)"gl_Fog.color", (String)"vec4(fogColor, 1.0)", headerLines, (HeaderLine[])new HeaderLine[]{FOG_COLOR});
            if (program.getName().contains("entities")) {
                line = ShadersCompatibility.replace((String)line, (Pattern)PATTERN_TEXTURE2D_TEXCOORD, (String)"$1clamp($4, 0.0, 1.0)$5", headerLines, (HeaderLine[])new HeaderLine[0]);
            }
            if (shaderType == ShaderType.FRAGMENT) {
                line = ShadersCompatibility.replace((String)line, (String)"gl_FragColor", (String)"gl_FragData[0]", headerLines, (HeaderLine[])new HeaderLine[0]);
                line = ShadersCompatibility.addAlphaTest((Program)program, (String)line, headerLines);
            }
            if (line.contains("texture")) {
                line = ShadersCompatibility.replace((String)line, (Pattern)Pattern.compile("(sampler2D\\s+)texture(\\W)"), (String)"$1gtexture$2", headerLines, (HeaderLine[])new HeaderLine[0]);
                line = ShadersCompatibility.replace((String)line, (Pattern)Pattern.compile("(\\(\\s*)texture(\\s*,)"), (String)"$1gtexture$2", headerLines, (HeaderLine[])new HeaderLine[0]);
            }
            line = ShadersCompatibility.replace((String)line, (String)"texture2D", (String)"texture", headerLines, (HeaderLine[])new HeaderLine[0]);
            line = ShadersCompatibility.replace((String)line, (String)"texture2DLod", (String)"textureLod", headerLines, (HeaderLine[])new HeaderLine[0]);
            line = ShadersCompatibility.replace((String)line, (String)"texture2DGrad", (String)"textureGrad", headerLines, (HeaderLine[])new HeaderLine[0]);
            line = ShadersCompatibility.replace((String)line, (String)"texture2DGradARB", (String)"textureGrad", headerLines, (HeaderLine[])new HeaderLine[0]);
            line = ShadersCompatibility.replace((String)line, (String)"texture3D", (String)"texture", headerLines, (HeaderLine[])new HeaderLine[0]);
            line = ShadersCompatibility.replace((String)line, (String)"texture3DLod", (String)"textureLod", headerLines, (HeaderLine[])new HeaderLine[0]);
            line = ShadersCompatibility.replaceShadow2D((String)line, (String)"shadow2D", (String)"texture", headerLines);
            line = ShadersCompatibility.replaceShadow2D((String)line, (String)"shadow2DLod", (String)"textureLod", headerLines);
            line = ShadersCompatibility.replace((String)line, (String)"texelFetch2D", (String)"texelFetch", headerLines, (HeaderLine[])new HeaderLine[0]);
            line = ShadersCompatibility.replace((String)line, (String)"texelFetch3D", (String)"texelFetch", headerLines, (HeaderLine[])new HeaderLine[0]);
            line = ShadersCompatibility.replaceFragData((String)line, headerLines);
            if (version <= 120) {
                line = ShadersCompatibility.replace((String)line, (String)"common", (String)"commonX", headerLines, (HeaderLine[])new HeaderLine[0]);
                line = ShadersCompatibility.replace((String)line, (String)"smooth", (String)"smoothX", headerLines, (HeaderLine[])new HeaderLine[0]);
            }
            line = ShadersCompatibility.replace((String)line, (String)"gl_ModelViewProjectionMatrixInverse", (String)"gl_ModelViewProjectionMatrixInverse_TODO", headerLines, (HeaderLine[])new HeaderLine[0]);
            line = ShadersCompatibility.replace((String)line, (String)"gl_TextureMatrixInverse", (String)"gl_TextureMatrixInverse_TODO", headerLines, (HeaderLine[])new HeaderLine[0]);
            line = ShadersCompatibility.replace((String)line, (String)"gl_ModelViewMatrixTranspose", (String)"gl_ModelViewMatrixTranspose_TODO", headerLines, (HeaderLine[])new HeaderLine[0]);
            line = ShadersCompatibility.replace((String)line, (String)"gl_ProjectionMatrixTranspose", (String)"gl_ProjectionMatrixTranspose_TODO", headerLines, (HeaderLine[])new HeaderLine[0]);
            line = ShadersCompatibility.replace((String)line, (String)"gl_ModelViewProjectionMatrixTranspose", (String)"gl_ModelViewProjectionMatrixTranspose_TODO", headerLines, (HeaderLine[])new HeaderLine[0]);
            line = ShadersCompatibility.replace((String)line, (String)"gl_TextureMatrixTranspose", (String)"gl_TextureMatrixTranspose_TODO", headerLines, (HeaderLine[])new HeaderLine[0]);
            line = ShadersCompatibility.replace((String)line, (String)"gl_ModelViewMatrixInverseTranspose", (String)"gl_ModelViewMatrixInverseTranspose_TODO", headerLines, (HeaderLine[])new HeaderLine[0]);
            line = ShadersCompatibility.replace((String)line, (String)"gl_ProjectionMatrixInverseTranspose", (String)"gl_ProjectionMatrixInverseTranspose_TODO", headerLines, (HeaderLine[])new HeaderLine[0]);
            line = ShadersCompatibility.replace((String)line, (String)"gl_ModelViewProjectionMatrixInverseTranspose", (String)"gl_ModelViewProjectionMatrixInverseTranspose_TODO", headerLines, (HeaderLine[])new HeaderLine[0]);
            if ((line = ShadersCompatibility.replace((String)line, (String)"gl_TextureMatrixInverseTranspose", (String)"gl_TextureMatrixInverseTranspose_TODO", headerLines, (HeaderLine[])new HeaderLine[0])).contains("\n")) {
                String[] parts = Config.tokenize((String)line, (String)"\n\r");
                writer.add(parts);
                continue;
            }
            writer.add(line);
        }
        if (headerLines.isEmpty()) {
            return writer;
        }
        writer = ShadersCompatibility.removeExisting((LineBuffer)writer, headerLines);
        writer = ShadersCompatibility.moveExtensionsToHeader((LineBuffer)writer, headerLines);
        Object[] newHeaderLinesArr = (String[])headerLines.stream().map(x2 -> x2.getText()).toArray(String[]::new);
        Arrays.sort(newHeaderLinesArr, ShadersCompatibility.getComparatorHeaderLines());
        newHeaderLinesArr = (String[])ArrayUtils.addObjectToArray((Object[])newHeaderLinesArr, (Object)"// Compatibility (auto-generated)", (int)0);
        int indexInsert = ShadersCompatibility.getIndexInsertHeader((LineBuffer)writer, (int)version);
        if (indexInsert >= 0) {
            writer.insert(indexInsert, (String[])newHeaderLinesArr);
        }
        return writer;
    }

    private static HeaderLine makeHeaderLine(String line) {
        Matcher mu = PATTERN_UNIFORM.matcher(line);
        if (mu.matches()) {
            return new HeaderLineVariable("uniform", mu.group(2), line);
        }
        Matcher mi = PATTERN_IN.matcher(line);
        if (mi.matches()) {
            return new HeaderLineVariable("in", mi.group(2), line);
        }
        Matcher mo = PATTERN_OUT.matcher(line);
        if (mo.matches()) {
            return new HeaderLineVariable("out", mo.group(2), line);
        }
        Matcher mv = PATTERN_VARYING.matcher(line);
        if (mv.matches()) {
            return new HeaderLineVariable("varying", mv.group(1), line);
        }
        Matcher mc = PATTERN_CONST.matcher(line);
        if (mc.matches()) {
            return new HeaderLineVariable("const", mc.group(1), line);
        }
        Matcher mf = PATTERN_FUNCTION.matcher(line);
        if (mf.matches()) {
            return new HeaderLineFunction(mf.group(1), line);
        }
        throw new IllegalArgumentException("Unknown header line: " + line);
    }

    private static String makeFtransformBasic() {
        StringBuilder buf2 = new StringBuilder();
        ShadersCompatibility.addLine((StringBuilder)buf2, (String)"vec4 ftransformBasic()                                                                                           ");
        ShadersCompatibility.addLine((StringBuilder)buf2, (String)"{                                                                                                                ");
        ShadersCompatibility.addLine((StringBuilder)buf2, (String)"  if(renderStage != MC_RENDER_STAGE_OUTLINE)   // Render stage outline                                           ");
        ShadersCompatibility.addLine((StringBuilder)buf2, (String)"    return projectionMatrix * modelViewMatrix * vec4(vaPosition, 1.0);                                           ");
        ShadersCompatibility.addLine((StringBuilder)buf2, (String)"  float lineWidth = 2.5;                                                                                         ");
        ShadersCompatibility.addLine((StringBuilder)buf2, (String)"  vec2 screenSize = vec2(viewWidth, viewHeight);                                                                 ");
        ShadersCompatibility.addLine((StringBuilder)buf2, (String)"  const mat4 VIEW_SCALE = mat4(mat3(1.0 - (1.0 / 256.0)));                                                       ");
        ShadersCompatibility.addLine((StringBuilder)buf2, (String)"  vec4 linePosStart = projectionMatrix * VIEW_SCALE * modelViewMatrix * vec4(vaPosition, 1.0);                   ");
        ShadersCompatibility.addLine((StringBuilder)buf2, (String)"  vec4 linePosEnd = projectionMatrix * VIEW_SCALE * modelViewMatrix * (vec4(vaPosition + vaNormal, 1.0));        ");
        ShadersCompatibility.addLine((StringBuilder)buf2, (String)"  vec3 ndc1 = linePosStart.xyz / linePosStart.w;                                                                 ");
        ShadersCompatibility.addLine((StringBuilder)buf2, (String)"  vec3 ndc2 = linePosEnd.xyz / linePosEnd.w;                                                                     ");
        ShadersCompatibility.addLine((StringBuilder)buf2, (String)"  vec2 lineScreenDirection = normalize((ndc2.xy - ndc1.xy) * screenSize);                                        ");
        ShadersCompatibility.addLine((StringBuilder)buf2, (String)"  vec2 lineOffset = vec2(-lineScreenDirection.y, lineScreenDirection.x) * lineWidth / screenSize;                ");
        ShadersCompatibility.addLine((StringBuilder)buf2, (String)"  if (lineOffset.x < 0.0)                                                                                        ");
        ShadersCompatibility.addLine((StringBuilder)buf2, (String)"    lineOffset *= -1.0;                                                                                          ");
        ShadersCompatibility.addLine((StringBuilder)buf2, (String)"  if (gl_VertexID % 2 == 0)                                                                                      ");
        ShadersCompatibility.addLine((StringBuilder)buf2, (String)"    return vec4((ndc1 + vec3(lineOffset, 0.0)) * linePosStart.w, linePosStart.w);                                ");
        ShadersCompatibility.addLine((StringBuilder)buf2, (String)"  else                                                                                                           ");
        ShadersCompatibility.addLine((StringBuilder)buf2, (String)"    return vec4((ndc1 - vec3(lineOffset, 0.0)) * linePosStart.w, linePosStart.w);                                ");
        ShadersCompatibility.addLine((StringBuilder)buf2, (String)"}                                                                                                                ");
        String src = buf2.toString();
        src = src.replace("MC_RENDER_STAGE_OUTLINE", "" + RenderStage.OUTLINE.ordinal());
        return src;
    }

    private static void addLine(StringBuilder buf2, String line) {
        buf2.append(StrUtils.trimTrailing((String)line, (String)" \t") + "\n");
    }

    private static LineBuffer removeExisting(LineBuffer lines, Set<HeaderLine> headerLines) {
        if (headerLines.isEmpty()) {
            return lines;
        }
        LineBuffer linesNew = new LineBuffer(lines.getLines());
        for (HeaderLine headerLine : headerLines) {
            for (int i2 = 0; i2 < linesNew.size(); ++i2) {
                String lineNew = linesNew.get(i2);
                if (!headerLine.matches(lineNew)) continue;
                String lineNew2 = headerLine.removeFrom(lineNew);
                if (lineNew2 == null) {
                    lineNew2 = "// Moved up";
                }
                linesNew.set(i2, lineNew2);
            }
        }
        return linesNew;
    }

    private static LineBuffer moveExtensionsToHeader(LineBuffer lines, Set<HeaderLine> headerLines) {
        LineBuffer linesNew = new LineBuffer(lines.getLines());
        for (int i2 = 0; i2 < lines.size(); ++i2) {
            Object line = lines.get(i2);
            if (PATTERN_EXTENSION.matcher((CharSequence)line).matches()) {
                String lineHeader = ((String)line).trim();
                lineHeader = ShadersCompatibility.replaceWord((String)lineHeader, (String)"require", (String)"enable");
                HeaderLineText hl2 = new HeaderLineText(lineHeader);
                headerLines.add((HeaderLine)hl2);
                line = "//" + (String)line;
            }
            linesNew.set(i2, (String)line);
        }
        return linesNew;
    }

    private static int getVersion(String line, int def) {
        Matcher m2 = PATTERN_VERSION.matcher(line);
        if (!m2.matches()) {
            return def;
        }
        String verStr = m2.group(1);
        int ver = Config.parseInt((String)verStr, (int)-1);
        if (ver < def) {
            return def;
        }
        return ver;
    }

    private static int getIndexInsertHeader(LineBuffer lines, int version) {
        int indexVersion = lines.indexMatch(PATTERN_VERSION);
        int indexLine = lines.indexMatch(PATTERN_LINE, indexVersion);
        int indexInsert = indexLine;
        if (indexInsert < 0) {
            Config.warn((String)"Header insert line not found");
        }
        return indexInsert;
    }

    private static String addAlphaTest(Program program, String line, Set<HeaderLine> headerLines) {
        Matcher m2;
        if (program.getProgramStage().isAnyComposite()) {
            return line;
        }
        Matcher m3 = PATTERN_FRAG_DATA_SET.matcher(line);
        if (m3.matches()) {
            String line2;
            String index = m3.group(2);
            if (!index.equals("0")) {
                return line;
            }
            HeaderLineText hl2 = new HeaderLineText("vec4 temp_FragData" + index + ";");
            headerLines.add((HeaderLine)hl2);
            headerLines.add(ALPHA_TEST_REF);
            line = line2 = m3.replaceAll("$1{\n$1  temp_FragData$2$3 = $4\n$1  if(temp_FragData$2.a < alphaTestRef) discard;\n$1  gl_FragData[$2] = temp_FragData$2;\n$1}");
        }
        if ((m2 = PATTERN_FRAG_DATA_GET.matcher(line)).find()) {
            String line2;
            String index = m2.group(1);
            if (!index.equals("0")) {
                return line;
            }
            HeaderLineText hl3 = new HeaderLineText("vec4 temp_FragData" + index + ";");
            headerLines.add((HeaderLine)hl3);
            line = line2 = m2.replaceAll("temp_FragData$1$2");
        }
        return line;
    }

    private static String replaceShadow2D(String line, String name, String nameNew, Set<HeaderLine> headerLines) {
        if (line.indexOf(name) < 0) {
            return line;
        }
        String line2 = line;
        line2 = line2.replaceAll(name + "\\((([^()]*+|\\(([^()]*+|\\([^()]*+\\))*\\))*)\\)\\.[xyzrgb]{3}", "vec3(" + nameNew + "($1))");
        line2 = line2.replaceAll(name + "\\((([^()]*+|\\(([^()]*+|\\([^()]*+\\))*\\))*)\\)\\.[xyzrgb]", nameNew + "($1)");
        line2 = line2.replaceAll(name + "\\((([^()]*+|\\(([^()]*+|\\([^()]*+\\))*\\))*)\\)([^.])", "vec4(vec3(" + nameNew + "($1)), 1.0)$4");
        return line2;
    }

    private static String replaceFragData(String line, Set<HeaderLine> headerLines) {
        Matcher m2 = PATTERN_FRAG_DATA.matcher(line);
        if (m2.find()) {
            String line2 = m2.replaceAll("outColor$1");
            for (int i2 = 0; i2 < 8; ++i2) {
                if (!line2.contains("outColor" + i2)) continue;
                headerLines.add((HeaderLine)new HeaderLineText("out vec4 outColor" + i2 + ";"));
            }
            return line2;
        }
        return line;
    }

    private static Comparator<String> getComparatorHeaderLines() {
        1 comp = new /* Unavailable Anonymous Inner Class!! */;
        return comp;
    }

    private static String replace(String line, String find, String replace, Set<HeaderLine> newLines, HeaderLine ... headerLines) {
        String line2 = ShadersCompatibility.replaceWord((String)line, (String)find, (String)replace);
        if (!line2.equals(line) && headerLines.length > 0) {
            newLines.addAll(Arrays.asList(headerLines));
        }
        return line2;
    }

    private static String replaceWord(String line, String find, String replace) {
        Object line2 = line;
        int pos = ((String)line2).length();
        while (pos > 0) {
            char charNext;
            char charPrev;
            if ((pos = ((String)line2).lastIndexOf(find, pos - 1)) < 0) continue;
            int posEnd = pos + find.length();
            if (pos - 1 >= 0 && (Character.isLetter(charPrev = ((String)line2).charAt(pos - 1)) || Character.isDigit(charPrev) || charPrev == '_') || posEnd < ((String)line2).length() && (Character.isLetter(charNext = ((String)line2).charAt(posEnd)) || Character.isDigit(charNext) || charNext == '_')) continue;
            line2 = ((String)line2).substring(0, pos) + replace + ((String)line2).substring(posEnd);
        }
        return line2;
    }

    private static String replace(String line, Pattern pattern, String replace, Set<HeaderLine> newLines, HeaderLine ... headerLines) {
        Matcher m2 = pattern.matcher(line);
        if (!m2.find()) {
            return line;
        }
        String line2 = m2.replaceAll(replace);
        if (!line2.equals(line) && headerLines.length > 0) {
            newLines.addAll(Arrays.asList(headerLines));
        }
        return line2;
    }

    private static boolean matches(String line, Pattern pattern) {
        Matcher m2 = pattern.matcher(line);
        return m2.matches();
    }
}

