/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.ByteBuffer;
import net.optifine.shaders.ICustomTexture;
import net.optifine.util.TextureUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class HFNoiseTexture
implements ICustomTexture {
    private int texID = GL11.glGenTextures();
    private int textureUnit = 15;

    public HFNoiseTexture(int width, int height) {
        byte[] image = this.genHFNoiseImage(width, height);
        ByteBuffer data = BufferUtils.createByteBuffer((int)image.length);
        data.put(image);
        data.flip();
        GlStateManager._bindTexture((int)this.texID);
        TextureUtils.resetDataUnpacking();
        GL11.glTexImage2D((int)3553, (int)0, (int)6407, (int)width, (int)height, (int)0, (int)6407, (int)5121, (ByteBuffer)data);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GlStateManager._bindTexture((int)0);
    }

    public int getID() {
        return this.texID;
    }

    public void deleteTexture() {
        GlStateManager._deleteTexture((int)this.texID);
        this.texID = 0;
    }

    private int random(int seed) {
        seed ^= seed << 13;
        seed ^= seed >> 17;
        seed ^= seed << 5;
        return seed;
    }

    private byte random(int x2, int y, int z2) {
        int seed = (this.random(x2) + this.random(y * 19)) * this.random(z2 * 23) - z2;
        return (byte)(this.random(seed) % 128);
    }

    private byte[] genHFNoiseImage(int width, int height) {
        byte[] image = new byte[width * height * 3];
        int index = 0;
        for (int y = 0; y < height; ++y) {
            for (int x2 = 0; x2 < width; ++x2) {
                for (int z2 = 1; z2 < 4; ++z2) {
                    image[index++] = this.random(x2, y, z2);
                }
            }
        }
        return image;
    }

    public int getTextureId() {
        return this.texID;
    }

    public int getTextureUnit() {
        return this.textureUnit;
    }
}

