/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntityContext;
import net.optifine.RandomEntityRule;
import net.optifine.config.ConnectedParser;
import net.optifine.util.PropertiesOrdered;

public class RandomEntityProperties<T> {
    private String name = null;
    private String basePath = null;
    private RandomEntityContext<T> context;
    private T[] resources = null;
    private RandomEntityRule<T>[] rules = null;
    private int matchingRuleIndex = -1;

    public RandomEntityProperties(String path, abb baseLoc, int[] variants, RandomEntityContext<T> context) {
        ConnectedParser cp = new ConnectedParser(context.getName());
        this.name = cp.parseName(path);
        this.basePath = cp.parseBasePath(path);
        this.context = context;
        this.resources = new Object[variants.length];
        for (int i2 = 0; i2 < variants.length; ++i2) {
            int index = variants[i2];
            this.resources[i2] = context.makeResource(baseLoc, index);
        }
    }

    public RandomEntityProperties(Properties props, String path, abb baseResLoc, RandomEntityContext<T> context) {
        ConnectedParser cp = context.getConnectedParser();
        this.name = cp.parseName(path);
        this.basePath = cp.parseBasePath(path);
        this.context = context;
        this.rules = this.parseRules(props, path, baseResLoc);
    }

    public String getName() {
        return this.name;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public T[] getResources() {
        return this.resources;
    }

    public List<T> getAllResources() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.resources != null) {
            list.addAll(Arrays.asList(this.resources));
        }
        if (this.rules != null) {
            for (int i2 = 0; i2 < this.rules.length; ++i2) {
                RandomEntityRule rule = this.rules[i2];
                if (rule.getResources() == null) continue;
                list.addAll(Arrays.asList(rule.getResources()));
            }
        }
        return list;
    }

    public T getResource(IRandomEntity randomEntity, T resDef) {
        this.matchingRuleIndex = 0;
        if (this.rules != null) {
            for (int i2 = 0; i2 < this.rules.length; ++i2) {
                RandomEntityRule rule = this.rules[i2];
                if (!rule.matches(randomEntity)) continue;
                this.matchingRuleIndex = rule.getIndex();
                return (T)rule.getResource(randomEntity.getId(), resDef);
            }
        }
        if (this.resources != null) {
            int randomId = randomEntity.getId();
            int index = randomId % this.resources.length;
            return (T)this.resources[index];
        }
        return resDef;
    }

    private RandomEntityRule<T>[] parseRules(Properties props, String pathProps, abb baseResLoc) {
        ArrayList<RandomEntityRule> list = new ArrayList<RandomEntityRule>();
        int maxIndex = 10;
        for (int i2 = 0; i2 < maxIndex; ++i2) {
            String key;
            String[] keys;
            int index = i2 + 1;
            String valTextures = null;
            String[] stringArray = keys = this.context.getResourceKeys();
            int n2 = stringArray.length;
            for (int i3 = 0; i3 < n2 && (valTextures = props.getProperty((key = stringArray[i3]) + "." + index)) == null; ++i3) {
            }
            if (valTextures == null) continue;
            RandomEntityRule rule = new RandomEntityRule(props, pathProps, baseResLoc, index, valTextures, this.context);
            list.add(rule);
            maxIndex = index + 10;
        }
        RandomEntityRule[] rules = list.toArray(new RandomEntityRule[list.size()]);
        return rules;
    }

    public boolean isValid(String path) {
        int i2;
        String resNamePlural = this.context.getResourceNamePlural();
        if (this.resources == null && this.rules == null) {
            Config.warn((String)("No " + resNamePlural + " specified: " + path));
            return false;
        }
        if (this.rules != null) {
            for (i2 = 0; i2 < this.rules.length; ++i2) {
                RandomEntityRule rule = this.rules[i2];
                if (rule.isValid(path)) continue;
                return false;
            }
        }
        if (this.resources != null) {
            for (i2 = 0; i2 < this.resources.length; ++i2) {
                Object res = this.resources[i2];
                if (res != null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isDefault() {
        if (this.rules != null) {
            return false;
        }
        return this.resources == null;
    }

    public int getMatchingRuleIndex() {
        return this.matchingRuleIndex;
    }

    public static RandomEntityProperties parse(abb propLoc, abb resLoc, RandomEntityContext context) {
        String contextName = context.getName();
        try {
            String path = propLoc.a();
            Config.dbg((String)(contextName + ": " + resLoc.a() + ", properties: " + path));
            InputStream in2 = Config.getResourceStream((abb)propLoc);
            if (in2 == null) {
                Config.warn((String)(contextName + ": Properties not found: " + path));
                return null;
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in2);
            in2.close();
            RandomEntityProperties rep = new RandomEntityProperties((Properties)props, path, resLoc, context);
            if (!rep.isValid(path)) {
                return null;
            }
            return rep;
        }
        catch (FileNotFoundException e2) {
            Config.warn((String)(contextName + ": File not found: " + propLoc.a()));
            return null;
        }
        catch (IOException e3) {
            e3.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return this.name + ", path: " + this.basePath;
    }
}

