/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.optifine.Config;
import net.optifine.CustomGuiProperties;
import net.optifine.CustomGuis;
import net.optifine.config.BiomeId;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchProfession;
import net.optifine.config.Matches;
import net.optifine.config.NbtTagValue;
import net.optifine.config.RangeListInt;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorField;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomGuiProperties {
    private String fileName = null;
    private String basePath = null;
    private EnumContainer container = null;
    private Map<abb, abb> textureLocations = null;
    private NbtTagValue nbtName = null;
    private BiomeId[] biomes = null;
    private RangeListInt heights = null;
    private Boolean large = null;
    private Boolean trapped = null;
    private Boolean christmas = null;
    private Boolean ender = null;
    private RangeListInt levels = null;
    private MatchProfession[] professions = null;
    private EnumVariant[] variants = null;
    private bzq[] colors = null;
    private static final EnumVariant[] VARIANTS_HORSE = new EnumVariant[]{EnumVariant.HORSE, EnumVariant.DONKEY, EnumVariant.MULE, EnumVariant.LLAMA};
    private static final EnumVariant[] VARIANTS_DISPENSER = new EnumVariant[]{EnumVariant.DISPENSER, EnumVariant.DROPPER};
    private static final EnumVariant[] VARIANTS_INVALID = new EnumVariant[0];
    private static final bzq[] COLORS_INVALID = new bzq[0];
    private static final abb ANVIL_GUI_TEXTURE = new abb("textures/gui/container/anvil.png");
    private static final abb BEACON_GUI_TEXTURE = new abb("textures/gui/container/beacon.png");
    private static final abb BREWING_STAND_GUI_TEXTURE = new abb("textures/gui/container/brewing_stand.png");
    private static final abb CHEST_GUI_TEXTURE = new abb("textures/gui/container/generic_54.png");
    private static final abb CRAFTING_TABLE_GUI_TEXTURE = new abb("textures/gui/container/crafting_table.png");
    private static final abb HORSE_GUI_TEXTURE = new abb("textures/gui/container/horse.png");
    private static final abb DISPENSER_GUI_TEXTURE = new abb("textures/gui/container/dispenser.png");
    private static final abb ENCHANTMENT_TABLE_GUI_TEXTURE = new abb("textures/gui/container/enchanting_table.png");
    private static final abb FURNACE_GUI_TEXTURE = new abb("textures/gui/container/furnace.png");
    private static final abb HOPPER_GUI_TEXTURE = new abb("textures/gui/container/hopper.png");
    private static final abb INVENTORY_GUI_TEXTURE = new abb("textures/gui/container/inventory.png");
    private static final abb SHULKER_BOX_GUI_TEXTURE = new abb("textures/gui/container/shulker_box.png");
    private static final abb VILLAGER_GUI_TEXTURE = new abb("textures/gui/container/villager2.png");

    public CustomGuiProperties(Properties props, String path) {
        ConnectedParser cp = new ConnectedParser("CustomGuis");
        this.fileName = cp.parseName(path);
        this.basePath = cp.parseBasePath(path);
        this.container = (EnumContainer)cp.parseEnum(props.getProperty("container"), (Enum[])EnumContainer.values(), "container");
        this.textureLocations = CustomGuiProperties.parseTextureLocations((Properties)props, (String)"texture", (EnumContainer)this.container, (String)"textures/gui/", (String)this.basePath);
        this.nbtName = cp.parseNbtTagValue("name", props.getProperty("name"));
        this.biomes = cp.parseBiomes(props.getProperty("biomes"));
        this.heights = cp.parseRangeListIntNeg(props.getProperty("heights"));
        this.large = cp.parseBooleanObject(props.getProperty("large"));
        this.trapped = cp.parseBooleanObject(props.getProperty("trapped"));
        this.christmas = cp.parseBooleanObject(props.getProperty("christmas"));
        this.ender = cp.parseBooleanObject(props.getProperty("ender"));
        this.levels = cp.parseRangeListInt(props.getProperty("levels"));
        this.professions = cp.parseProfessions(props.getProperty("professions"));
        EnumVariant[] vars = CustomGuiProperties.getContainerVariants((EnumContainer)this.container);
        this.variants = (EnumVariant[])cp.parseEnums(props.getProperty("variants"), (Enum[])vars, "variants", (Enum[])VARIANTS_INVALID);
        this.colors = CustomGuiProperties.parseEnumDyeColors((String)props.getProperty("colors"));
    }

    private static EnumVariant[] getContainerVariants(EnumContainer cont) {
        if (cont == EnumContainer.HORSE) {
            return VARIANTS_HORSE;
        }
        if (cont == EnumContainer.DISPENSER) {
            return VARIANTS_DISPENSER;
        }
        return new EnumVariant[0];
    }

    private static bzq[] parseEnumDyeColors(String str) {
        if (str == null) {
            return null;
        }
        str = str.toLowerCase();
        String[] tokens = Config.tokenize((String)str, (String)" ");
        bzq[] cols = new bzq[tokens.length];
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            String token = tokens[i2];
            bzq col = CustomGuiProperties.parseEnumDyeColor((String)token);
            if (col == null) {
                CustomGuiProperties.warn((String)("Invalid color: " + token));
                return COLORS_INVALID;
            }
            cols[i2] = col;
        }
        return cols;
    }

    private static bzq parseEnumDyeColor(String str) {
        if (str == null) {
            return null;
        }
        bzq[] colors = bzq.values();
        for (int i2 = 0; i2 < colors.length; ++i2) {
            bzq enumDyeColor = colors[i2];
            if (enumDyeColor.c().equals(str)) {
                return enumDyeColor;
            }
            if (!enumDyeColor.b().equals(str)) continue;
            return enumDyeColor;
        }
        return null;
    }

    private static abb parseTextureLocation(String str, String basePath) {
        if (str == null) {
            return null;
        }
        Object tex = TextureUtils.fixResourcePath((String)(str = str.trim()), (String)basePath);
        if (!((String)tex).endsWith(".png")) {
            tex = (String)tex + ".png";
        }
        return new abb(basePath + "/" + (String)tex);
    }

    private static Map<abb, abb> parseTextureLocations(Properties props, String property, EnumContainer container, String pathPrefix, String basePath) {
        HashMap<abb, abb> map = new HashMap<abb, abb>();
        String propVal = props.getProperty(property);
        if (propVal != null) {
            abb locKey = CustomGuiProperties.getGuiTextureLocation((EnumContainer)container);
            abb locVal = CustomGuiProperties.parseTextureLocation((String)propVal, (String)basePath);
            if (locKey != null && locVal != null) {
                map.put(locKey, locVal);
            }
        }
        String keyPrefix = property + ".";
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            if (!string.startsWith(keyPrefix)) continue;
            String pathRel = string.substring(keyPrefix.length());
            pathRel = pathRel.replace('\\', '/');
            pathRel = StrUtils.removePrefixSuffix((String)pathRel, (String)"/", (String)".png");
            String path = pathPrefix + pathRel + ".png";
            String val = props.getProperty(string);
            abb locKey = new abb(path);
            abb locVal = CustomGuiProperties.parseTextureLocation((String)val, (String)basePath);
            map.put(locKey, locVal);
        }
        return map;
    }

    private static abb getGuiTextureLocation(EnumContainer container) {
        if (container == null) {
            return null;
        }
        switch (1.$SwitchMap$net$optifine$CustomGuiProperties$EnumContainer[container.ordinal()]) {
            case 1: {
                return ANVIL_GUI_TEXTURE;
            }
            case 2: {
                return BEACON_GUI_TEXTURE;
            }
            case 3: {
                return BREWING_STAND_GUI_TEXTURE;
            }
            case 4: {
                return CHEST_GUI_TEXTURE;
            }
            case 5: {
                return CRAFTING_TABLE_GUI_TEXTURE;
            }
            case 6: {
                return null;
            }
            case 7: {
                return DISPENSER_GUI_TEXTURE;
            }
            case 8: {
                return ENCHANTMENT_TABLE_GUI_TEXTURE;
            }
            case 9: {
                return FURNACE_GUI_TEXTURE;
            }
            case 10: {
                return HOPPER_GUI_TEXTURE;
            }
            case 11: {
                return HORSE_GUI_TEXTURE;
            }
            case 12: {
                return INVENTORY_GUI_TEXTURE;
            }
            case 13: {
                return SHULKER_BOX_GUI_TEXTURE;
            }
            case 14: {
                return VILLAGER_GUI_TEXTURE;
            }
        }
        return null;
    }

    public boolean isValid(String path) {
        if (this.fileName == null || this.fileName.length() <= 0) {
            CustomGuiProperties.warn((String)("No name found: " + path));
            return false;
        }
        if (this.basePath == null) {
            CustomGuiProperties.warn((String)("No base path found: " + path));
            return false;
        }
        if (this.container == null) {
            CustomGuiProperties.warn((String)("No container found: " + path));
            return false;
        }
        if (this.textureLocations.isEmpty()) {
            CustomGuiProperties.warn((String)("No texture found: " + path));
            return false;
        }
        if (this.professions == ConnectedParser.PROFESSIONS_INVALID) {
            CustomGuiProperties.warn((String)("Invalid professions or careers: " + path));
            return false;
        }
        if (this.variants == VARIANTS_INVALID) {
            CustomGuiProperties.warn((String)("Invalid variants: " + path));
            return false;
        }
        if (this.colors == COLORS_INVALID) {
            CustomGuiProperties.warn((String)("Invalid colors: " + path));
            return false;
        }
        return true;
    }

    private static void warn(String str) {
        Config.warn((String)("[CustomGuis] " + str));
    }

    private boolean matchesGeneral(EnumContainer ec, gt pos, cha blockAccess) {
        cht biome;
        if (this.container != ec) {
            return false;
        }
        if (this.biomes != null && !Matches.biome((cht)(biome = (cht)blockAccess.w(pos).a()), (BiomeId[])this.biomes)) {
            return false;
        }
        return this.heights == null || this.heights.isInRange(pos.v());
    }

    public boolean matchesPos(EnumContainer ec, gt pos, cha blockAccess, elm screen) {
        String name;
        if (!this.matchesGeneral(ec, pos, blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(name = CustomGuiProperties.getName((elm)screen))) {
            return false;
        }
        switch (1.$SwitchMap$net$optifine$CustomGuiProperties$EnumContainer[ec.ordinal()]) {
            case 2: {
                return this.matchesBeacon(pos, (cga)blockAccess);
            }
            case 4: {
                return this.matchesChest(pos, (cga)blockAccess);
            }
            case 7: {
                return this.matchesDispenser(pos, (cga)blockAccess);
            }
            case 13: {
                return this.matchesShulker(pos, (cga)blockAccess);
            }
        }
        return true;
    }

    public static String getName(elm screen) {
        rq itc = screen.n();
        if (itc == null) {
            return null;
        }
        return itc.getString();
    }

    private boolean matchesBeacon(gt pos, cga blockAccess) {
        cti te2 = blockAccess.c_(pos);
        if (!(te2 instanceof ctd)) {
            return false;
        }
        ctd teb = (ctd)te2;
        if (this.levels != null) {
            if (!Reflector.TileEntityBeacon_levels.exists()) {
                return false;
            }
            int l2 = Reflector.getFieldValueInt((Object)teb, (ReflectorField)Reflector.TileEntityBeacon_levels, (int)-1);
            if (!this.levels.isInRange(l2)) {
                return false;
            }
        }
        return true;
    }

    private boolean matchesChest(gt pos, cga blockAccess) {
        cti te2 = blockAccess.c_(pos);
        if (te2 instanceof ctn) {
            ctn tec = (ctn)te2;
            return this.matchesChest(tec, pos, blockAccess);
        }
        if (te2 instanceof ctx) {
            ctx teec = (ctx)te2;
            return this.matchesEnderChest(teec, pos, blockAccess);
        }
        return false;
    }

    private boolean matchesChest(ctn tec, gt pos, cga blockAccess) {
        cvo blockState = blockAccess.a_(pos);
        cwg chestType = blockState.b((cwr)ckr.c) ? (cwg)blockState.c((cwr)ckr.c) : cwg.a;
        boolean isLarge = chestType != cwg.a;
        boolean isTrapped = tec instanceof cus;
        boolean isChristmas = CustomGuis.isChristmas;
        boolean isEnder = false;
        return this.matchesChest(isLarge, isTrapped, isChristmas, isEnder);
    }

    private boolean matchesEnderChest(ctx teec, gt pos, cga blockAccess) {
        return this.matchesChest(false, false, false, true);
    }

    private boolean matchesChest(boolean isLarge, boolean isTrapped, boolean isChristmas, boolean isEnder) {
        if (this.large != null && this.large != isLarge) {
            return false;
        }
        if (this.trapped != null && this.trapped != isTrapped) {
            return false;
        }
        if (this.christmas != null && this.christmas != isChristmas) {
            return false;
        }
        return this.ender == null || this.ender == isEnder;
    }

    private boolean matchesDispenser(gt pos, cga blockAccess) {
        EnumVariant var;
        cti te2 = blockAccess.c_(pos);
        if (!(te2 instanceof ctu)) {
            return false;
        }
        ctu ted = (ctu)te2;
        return this.variants == null || Config.equalsOne((Object)(var = this.getDispenserVariant(ted)), (Object[])this.variants);
    }

    private EnumVariant getDispenserVariant(ctu ted) {
        if (ted instanceof ctv) {
            return EnumVariant.DROPPER;
        }
        return EnumVariant.DISPENSER;
    }

    private boolean matchesShulker(gt pos, cga blockAccess) {
        bzq col;
        cti te2 = blockAccess.c_(pos);
        if (!(te2 instanceof cuj)) {
            return false;
        }
        cuj tesb = (cuj)te2;
        return this.colors == null || Config.equalsOne((Object)(col = tesb.j()), (Object[])this.colors);
    }

    public boolean matchesEntity(EnumContainer ec, bbn entity, cha blockAccess) {
        String entityName;
        if (!this.matchesGeneral(ec, entity.da(), blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(entityName = entity.cq())) {
            return false;
        }
        switch (1.$SwitchMap$net$optifine$CustomGuiProperties$EnumContainer[ec.ordinal()]) {
            case 14: {
                return this.matchesVillager(entity, (cga)blockAccess);
            }
            case 11: {
                return this.matchesHorse(entity, (cga)blockAccess);
            }
        }
        return true;
    }

    private boolean matchesVillager(bbn entity, cga blockAccess) {
        int level;
        btq vd;
        bts vp;
        if (!(entity instanceof btp)) {
            return false;
        }
        btp entityVillager = (btp)entity;
        return this.professions == null || MatchProfession.matchesOne((bts)(vp = (vd = entityVillager.fU()).b()), (int)(level = vd.c()), (MatchProfession[])this.professions);
    }

    private boolean matchesHorse(bbn entity, cga blockAccess) {
        bpd el;
        bzq col;
        EnumVariant var;
        if (!(entity instanceof bpa)) {
            return false;
        }
        bpa ah = (bpa)entity;
        if (this.variants != null && !Config.equalsOne((Object)(var = this.getHorseVariant(ah)), (Object[])this.variants)) {
            return false;
        }
        return this.colors == null || !(ah instanceof bpd) || Config.equalsOne((Object)(col = (el = (bpd)ah).gs()), (Object[])this.colors);
    }

    private EnumVariant getHorseVariant(bpa entity) {
        if (entity instanceof bpc) {
            return EnumVariant.HORSE;
        }
        if (entity instanceof bpb) {
            return EnumVariant.DONKEY;
        }
        if (entity instanceof bpf) {
            return EnumVariant.MULE;
        }
        if (entity instanceof bpd) {
            return EnumVariant.LLAMA;
        }
        return null;
    }

    public EnumContainer getContainer() {
        return this.container;
    }

    public abb getTextureLocation(abb loc) {
        abb locNew = (abb)this.textureLocations.get(loc);
        if (locNew == null) {
            return loc;
        }
        return locNew;
    }

    public String toString() {
        return "name: " + this.fileName + ", container: " + this.container + ", textures: " + this.textureLocations;
    }
}

