/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.thread;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.util.profiling.metrics.MetricSampler;
import net.minecraft.util.profiling.metrics.MetricsRegistry;
import net.minecraft.util.profiling.metrics.ProfilerMeasured;
import net.minecraft.util.thread.ProcessorHandle;
import net.optifine.Config;
import net.optifine.util.PacketRunnable;
import org.slf4j.Logger;

public abstract class BlockableEventLoop<R extends Runnable>
implements ProfilerMeasured,
ProcessorHandle<R>,
Executor {
    private final String f_18680_;
    private static final Logger f_18681_ = LogUtils.getLogger();
    private final Queue<R> f_18682_ = Queues.newConcurrentLinkedQueue();
    private int f_18683_;

    protected BlockableEventLoop(String nameIn) {
        this.f_18680_ = nameIn;
        MetricsRegistry.f_146067_.m_146072_((ProfilerMeasured)this);
    }

    protected abstract R m_6681_(Runnable var1);

    protected abstract boolean m_6362_(R var1);

    public boolean m_18695_() {
        return Thread.currentThread() == this.m_6304_();
    }

    protected abstract Thread m_6304_();

    protected boolean m_5660_() {
        return !this.m_18695_();
    }

    public int m_18696_() {
        return this.f_18682_.size();
    }

    public String m_7326_() {
        return this.f_18680_;
    }

    public <V> CompletableFuture<V> m_18691_(Supplier<V> supplier) {
        return this.m_5660_() ? CompletableFuture.supplyAsync(supplier, (Executor)this) : CompletableFuture.completedFuture(supplier.get());
    }

    private CompletableFuture<Void> m_18689_(Runnable taskIn) {
        return CompletableFuture.supplyAsync(() -> {
            taskIn.run();
            return null;
        }, (Executor)this);
    }

    public CompletableFuture<Void> m_18707_(Runnable taskIn) {
        if (this.m_5660_()) {
            return this.m_18689_(taskIn);
        }
        taskIn.run();
        return CompletableFuture.completedFuture(null);
    }

    public void m_18709_(Runnable taskIn) {
        if (!this.m_18695_()) {
            this.m_18689_(taskIn).join();
        } else {
            taskIn.run();
        }
    }

    public void m_6937_(R taskIn) {
        this.f_18682_.add(taskIn);
        LockSupport.unpark(this.m_6304_());
    }

    @Override
    public void execute(Runnable p_execute_1_) {
        if (this.m_5660_()) {
            this.m_6937_(this.m_6681_(p_execute_1_));
        } else {
            p_execute_1_.run();
        }
    }

    public void m_201446_(Runnable runnableIn) {
        this.execute(runnableIn);
    }

    protected void m_18698_() {
        this.f_18682_.clear();
    }

    protected void m_18699_() {
        int count = Integer.MAX_VALUE;
        if (Config.isLazyChunkLoading() && this == Minecraft.m_91087_()) {
            count = this.getTaskCount();
        }
        while (this.m_7245_() && --count > 0) {
        }
    }

    public boolean m_7245_() {
        Runnable r = (Runnable)this.f_18682_.peek();
        if (r == null) {
            return false;
        }
        if (this.f_18683_ == 0 && !this.m_6362_(r)) {
            return false;
        }
        this.m_6367_((Runnable)this.f_18682_.remove());
        return true;
    }

    public void m_18701_(BooleanSupplier isDone) {
        ++this.f_18683_;
        try {
            while (!isDone.getAsBoolean()) {
                if (this.m_7245_()) continue;
                this.m_5667_();
            }
        }
        finally {
            --this.f_18683_;
        }
    }

    protected void m_5667_() {
        Thread.yield();
        LockSupport.parkNanos("waiting for tasks", 100000L);
    }

    protected void m_6367_(R taskIn) {
        try {
            taskIn.run();
        }
        catch (Exception exception) {
            f_18681_.error(LogUtils.FATAL_MARKER, "Error executing task on {}", (Object)this.m_7326_(), (Object)exception);
        }
    }

    public List<MetricSampler> m_142754_() {
        return ImmutableList.of((Object)MetricSampler.m_146009_((String)(this.f_18680_ + "-pending-tasks"), (MetricCategory)MetricCategory.EVENT_LOOPS, () -> this.m_18696_()));
    }

    private int getTaskCount() {
        if (this.f_18682_.isEmpty()) {
            return 0;
        }
        Runnable[] rs = this.f_18682_.toArray(new Runnable[this.f_18682_.size()]);
        double chunkUpdateWeight = this.getChunkUpdateWeight(rs);
        if (chunkUpdateWeight < 5.0) {
            return Integer.MAX_VALUE;
        }
        int queueSize = rs.length;
        int fps = Math.max(Config.getFpsAverage(), 1);
        double weight = queueSize * 10 / fps;
        int count = this.getCount(rs, weight);
        return count;
    }

    private int getCount(R[] rs, double maxWeight) {
        double weight = 0.0;
        for (int i2 = 0; i2 < rs.length; ++i2) {
            R r = rs[i2];
            if (!((weight += this.getChunkUpdateWeight(r)) > maxWeight)) continue;
            return i2 + 1;
        }
        return rs.length;
    }

    private double getChunkUpdateWeight(R[] rs) {
        double weight = 0.0;
        for (int i2 = 0; i2 < rs.length; ++i2) {
            R r = rs[i2];
            weight += this.getChunkUpdateWeight(r);
        }
        return weight;
    }

    private double getChunkUpdateWeight(Runnable r) {
        if (r instanceof PacketRunnable) {
            PacketRunnable pr = (PacketRunnable)r;
            Packet p2 = pr.getPacket();
            if (p2 instanceof ClientboundLevelChunkWithLightPacket) {
                return 1.0;
            }
            if (p2 instanceof ClientboundLightUpdatePacket) {
                return 0.2;
            }
            if (p2 instanceof ClientboundForgetLevelChunkPacket) {
                return 2.6;
            }
        }
        return 0.0;
    }
}

