/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.FolderPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.resource.ResourceCacheManager;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class VanillaPackResources
implements PackResources {
    @Nullable
    public static Path f_10312_;
    private static final Logger f_10315_;
    public static Class<?> f_10313_;
    private static final Map<PackType, Path> f_182296_;
    public final PackMetadataSection f_143759_;
    public final Set<String> f_10314_;
    private static final boolean ON_WINDOWS;
    private static final boolean FORGE;
    private final ResourceCacheManager cacheManager;

    private static Path m_182297_(URI p_182297_0_) throws IOException {
        try {
            return Paths.get(p_182297_0_);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
        }
        catch (Throwable throwable) {
            f_10315_.warn("Unable to get path for: {}", (Object)p_182297_0_, (Object)throwable);
        }
        try {
            FileSystems.newFileSystem(p_182297_0_, Collections.emptyMap());
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            // empty catch block
        }
        return Paths.get(p_182297_0_);
    }

    public VanillaPackResources(PackMetadataSection packMetadataIn, String ... resourceNamespacesIn) {
        this.cacheManager = new ResourceCacheManager(false, ForgeConfig.COMMON.indexVanillaPackCachesOnThread, (packType, namespace) -> ((Path)f_182296_.get(packType)).resolve((String)namespace));
        this.f_143759_ = packMetadataIn;
        this.f_10314_ = ImmutableSet.copyOf((Object[])resourceNamespacesIn);
    }

    public InputStream m_5542_(String fileName) throws IOException {
        if (!fileName.contains("/") && !fileName.contains("\\")) {
            Path path;
            if (f_10312_ != null && Files.exists(path = f_10312_.resolve(fileName), new LinkOption[0])) {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            return this.m_5539_(fileName);
        }
        throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
    }

    public InputStream m_8031_(PackType type, ResourceLocation location) throws IOException {
        InputStream inputstream = this.m_8033_(type, location);
        if (inputstream != null) {
            return inputstream;
        }
        throw new FileNotFoundException(location.m_135815_());
    }

    public Collection<ResourceLocation> m_214146_(PackType type, String namespaceIn, String pathIn, Predicate<ResourceLocation> filterIn) {
        HashSet set = Sets.newHashSet();
        if (f_10312_ != null) {
            try {
                VanillaPackResources.m_215357_((Collection)set, (String)namespaceIn, (Path)f_10312_.resolve(type.m_10305_()), (String)pathIn, filterIn);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (type == PackType.CLIENT_RESOURCES) {
                Enumeration<URL> enumeration = null;
                try {
                    enumeration = f_10313_.getClassLoader().getResources(type.m_10305_() + "/");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                while (enumeration != null && enumeration.hasMoreElements()) {
                    try {
                        URI uri = enumeration.nextElement().toURI();
                        if (!"file".equals(uri.getScheme())) continue;
                        VanillaPackResources.m_215357_((Collection)set, (String)namespaceIn, (Path)Paths.get(uri), (String)pathIn, filterIn);
                    }
                    catch (IOException | URISyntaxException exception) {}
                }
            }
        }
        try {
            Path path = (Path)f_182296_.get(type);
            if (path != null) {
                if (ResourceCacheManager.shouldUseCache() && this.cacheManager.hasCached(type, namespaceIn)) {
                    set.addAll(this.cacheManager.getResources(type, namespaceIn, path.getFileSystem().getPath(pathIn, new String[0]), filterIn));
                } else {
                    VanillaPackResources.m_215357_((Collection)set, (String)namespaceIn, (Path)path, (String)pathIn, filterIn);
                }
            } else {
                f_10315_.error("Can't access assets root for type: {}", (Object)type);
            }
        }
        catch (FileNotFoundException | NoSuchFileException path) {
        }
        catch (IOException ioexception) {
            f_10315_.error("Couldn't get a list of all vanilla resources", (Throwable)ioexception);
        }
        return set;
    }

    private static void m_215357_(Collection<ResourceLocation> locationsIn, String namespaceIn, Path pathIn, String pathNameIn, Predicate<ResourceLocation> filterIn) throws IOException {
        Path path = pathIn.resolve(namespaceIn);
        try (Stream<Path> stream = Files.walk(path.resolve(pathNameIn), new FileVisitOption[0]);){
            stream.filter(p_215350_0_ -> !p_215350_0_.endsWith(".mcmeta") && Files.isRegularFile(p_215350_0_, new LinkOption[0])).mapMulti((p_242539_2_, p_242539_3_) -> {
                String s = path.relativize((Path)p_242539_2_).toString().replaceAll("\\\\", "/");
                ResourceLocation resourcelocation = ResourceLocation.m_214293_((String)namespaceIn, (String)s);
                if (resourcelocation == null) {
                    Util.m_143785_((String)String.format(Locale.ROOT, "Invalid path in datapack: %s:%s, ignoring", namespaceIn, s));
                } else {
                    p_242539_3_.accept(resourcelocation);
                }
            }).filter(filterIn).forEach(locationsIn::add);
        }
    }

    @Nullable
    protected InputStream m_8033_(PackType type, ResourceLocation location) {
        Path path;
        String s = VanillaPackResources.m_10362_((PackType)type, (ResourceLocation)location);
        InputStream is = ReflectorForge.getOptiFineResourceStream((String)s);
        if (is != null) {
            return is;
        }
        if (f_10312_ != null && Files.exists(path = f_10312_.resolve(type.m_10305_() + "/" + location.m_135827_() + "/" + location.m_135815_()), new LinkOption[0])) {
            try {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            URL url = VanillaPackResources.class.getResource(s);
            return VanillaPackResources.m_10335_((String)s, (URL)url) ? (FORGE ? this.getExtraInputStream(type, s) : url.openStream()) : null;
        }
        catch (IOException ioexception) {
            return VanillaPackResources.class.getResourceAsStream(s);
        }
    }

    private static String m_10362_(PackType packTypeIn, ResourceLocation locationIn) {
        return "/" + packTypeIn.m_10305_() + "/" + locationIn.m_135827_() + "/" + locationIn.m_135815_();
    }

    private static boolean m_10335_(String pathIn, @Nullable URL urlIn) throws IOException {
        return urlIn != null && (urlIn.getProtocol().equals("jar") || VanillaPackResources.validatePath((File)new File(urlIn.getFile()), (String)pathIn));
    }

    @Nullable
    protected InputStream m_5539_(String pathIn) {
        if (FORGE) {
            return this.getExtraInputStream(PackType.SERVER_DATA, "/" + pathIn);
        }
        return VanillaPackResources.class.getResourceAsStream("/" + pathIn);
    }

    public boolean m_7211_(PackType type, ResourceLocation location) {
        Path path;
        String s = VanillaPackResources.m_10362_((PackType)type, (ResourceLocation)location);
        InputStream is = ReflectorForge.getOptiFineResourceStream((String)s);
        if (is != null) {
            return true;
        }
        if (f_10312_ != null && Files.exists(path = f_10312_.resolve(type.m_10305_() + "/" + location.m_135827_() + "/" + location.m_135815_()), new LinkOption[0])) {
            return true;
        }
        try {
            URL url = VanillaPackResources.class.getResource(s);
            return VanillaPackResources.m_10335_((String)s, (URL)url);
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    public Set<String> m_5698_(PackType type) {
        return this.f_10314_;
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) throws IOException {
        try {
            Object object;
            block9: {
                block8: {
                    try (InputStream inputstream = this.m_5542_("pack.mcmeta");){
                        Object t;
                        if (inputstream == null || (t = AbstractPackResources.m_10214_(deserializer, (InputStream)inputstream)) == null) break block8;
                        object = t;
                        break block9;
                    }
                }
                return (T)(deserializer == PackMetadataSection.f_10366_ ? this.f_143759_ : null);
            }
            return (T)object;
        }
        catch (FileNotFoundException | RuntimeException runtimeexception) {
            return (T)(deserializer == PackMetadataSection.f_10366_ ? this.f_143759_ : null);
        }
    }

    public String m_8017_() {
        return "Default";
    }

    public void close() {
    }

    public ResourceProvider m_215363_() {
        return p_215343_1_ -> Optional.of(new Resource(this.m_8017_(), () -> this.m_8031_(PackType.CLIENT_RESOURCES, p_215343_1_)));
    }

    private static boolean validatePath(File file, String path) throws IOException {
        String s = file.getPath();
        if (s.startsWith("file:")) {
            if (ON_WINDOWS) {
                s = s.replace("\\", "/");
            }
            return s.endsWith(path);
        }
        return FolderPackResources.m_10273_((File)file, (String)path);
    }

    public void initForNamespace(String nameSpace) {
        if (ResourceCacheManager.shouldUseCache()) {
            this.cacheManager.index(nameSpace);
        }
    }

    public void init(PackType packType) {
        this.initForNamespace("minecraft");
        this.initForNamespace("realms");
    }

    private InputStream getExtraInputStream(PackType type, String resource) {
        try {
            Path rootDir = (Path)f_182296_.get(type);
            if (rootDir != null) {
                return Files.newInputStream(rootDir.resolve(resource), new OpenOption[0]);
            }
            return VanillaPackResources.class.getResourceAsStream(resource);
        }
        catch (IOException e2) {
            return VanillaPackResources.class.getResourceAsStream(resource);
        }
    }

    static {
        f_10315_ = LogUtils.getLogger();
        f_182296_ = (Map)Util.m_137537_(() -> {
            Class<VanillaPackResources> clazz = VanillaPackResources.class;
            synchronized (VanillaPackResources.class) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (PackType packtype : PackType.values()) {
                    String s = "/" + packtype.m_10305_() + "/.mcassetsroot";
                    URL url = VanillaPackResources.class.getResource(s);
                    if (url == null) {
                        f_10315_.error("File {} does not exist in classpath", (Object)s);
                        continue;
                    }
                    try {
                        URI uri = url.toURI();
                        String s1 = uri.getScheme();
                        if (!"jar".equals(s1) && !"file".equals(s1)) {
                            f_10315_.warn("Assets URL '{}' uses unexpected schema", (Object)uri);
                        }
                        Path path = VanillaPackResources.m_182297_((URI)uri);
                        builder.put((Object)packtype, (Object)path.getParent());
                    }
                    catch (Exception exception) {
                        f_10315_.error("Couldn't resolve path to vanilla assets", (Throwable)exception);
                    }
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return builder.build();
            }
        });
        ON_WINDOWS = Util.m_137581_() == Util.OS.WINDOWS;
        FORGE = Reflector.ForgeHooksClient.exists();
    }
}

