/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResourceLocation
implements Comparable<ResourceLocation> {
    public static final Codec<ResourceLocation> f_135803_ = Codec.STRING.comapFlatMap(ResourceLocation::m_135837_, ResourceLocation::toString).stable();
    private static final SimpleCommandExceptionType f_135806_ = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"argument.id.invalid"));
    public static final char f_179907_ = ':';
    public static final String f_179908_ = "minecraft";
    public static final String f_179909_ = "realms";
    protected final String f_135804_;
    protected final String f_135805_;

    protected ResourceLocation(String[] resourceParts) {
        this.f_135804_ = StringUtils.isEmpty((CharSequence)resourceParts[0]) ? "minecraft" : resourceParts[0];
        this.f_135805_ = resourceParts[1];
        if (!this.f_135805_.equals("DUMMY")) {
            return;
        }
        if (!ResourceLocation.m_135843_((String)this.f_135804_)) {
            throw new ResourceLocationException("Non [a-z0-9_.-] character in namespace of location: " + this.f_135804_ + ":" + this.f_135805_);
        }
        if (!ResourceLocation.m_135841_((String)this.f_135805_)) {
            throw new ResourceLocationException("Non [a-z0-9/._-] character in path of location: " + this.f_135804_ + ":" + this.f_135805_);
        }
    }

    public ResourceLocation(String resourceName) {
        this(ResourceLocation.m_135832_((String)resourceName, (char)':'));
    }

    public ResourceLocation(String namespaceIn, String pathIn) {
        this(new String[]{namespaceIn, pathIn});
    }

    public static ResourceLocation m_135822_(String resourceName, char splitOn) {
        return new ResourceLocation(ResourceLocation.m_135832_((String)resourceName, (char)splitOn));
    }

    @Nullable
    public static ResourceLocation m_135820_(String string) {
        try {
            return new ResourceLocation(string);
        }
        catch (ResourceLocationException resourcelocationexception) {
            return null;
        }
    }

    @Nullable
    public static ResourceLocation m_214293_(String namespaceIn, String pathIn) {
        try {
            return new ResourceLocation(namespaceIn, pathIn);
        }
        catch (ResourceLocationException resourcelocationexception) {
            return null;
        }
    }

    protected static String[] m_135832_(String resourceName, char splitOn) {
        String[] astring = new String[]{"minecraft", resourceName};
        int i2 = resourceName.indexOf(splitOn);
        if (i2 >= 0) {
            astring[1] = resourceName.substring(i2 + 1, resourceName.length());
            if (i2 >= 1) {
                astring[0] = resourceName.substring(0, i2);
            }
        }
        return astring;
    }

    public static DataResult<ResourceLocation> m_135837_(String stringIn) {
        try {
            return DataResult.success((Object)new ResourceLocation(stringIn));
        }
        catch (ResourceLocationException resourcelocationexception) {
            return DataResult.error((String)("Not a valid resource location: " + stringIn + " " + resourcelocationexception.getMessage()));
        }
    }

    public String m_135815_() {
        return this.f_135805_;
    }

    public String m_135827_() {
        return this.f_135804_;
    }

    public String toString() {
        return this.f_135804_ + ":" + this.f_135805_;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof ResourceLocation)) {
            return false;
        }
        ResourceLocation resourcelocation = (ResourceLocation)p_equals_1_;
        return this.f_135804_.equals(resourcelocation.f_135804_) && this.f_135805_.equals(resourcelocation.f_135805_);
    }

    public int hashCode() {
        return 31 * this.f_135804_.hashCode() + this.f_135805_.hashCode();
    }

    @Override
    public int compareTo(ResourceLocation p_compareTo_1_) {
        int i2 = this.f_135805_.compareTo(p_compareTo_1_.f_135805_);
        if (i2 == 0) {
            i2 = this.f_135804_.compareTo(p_compareTo_1_.f_135804_);
        }
        return i2;
    }

    public String m_179910_() {
        return this.toString().replace('/', '_').replace(':', '_');
    }

    public String m_214298_() {
        return this.f_135804_ + "." + this.f_135805_;
    }

    public String m_214299_() {
        return this.f_135804_.equals("minecraft") ? this.f_135805_ : this.m_214298_();
    }

    public String m_214296_(String prefixIn) {
        return prefixIn + "." + this.m_214298_();
    }

    public static ResourceLocation m_135818_(StringReader reader) throws CommandSyntaxException {
        int i2 = reader.getCursor();
        while (reader.canRead() && ResourceLocation.m_135816_((char)reader.peek())) {
            reader.skip();
        }
        String s = reader.getString().substring(i2, reader.getCursor());
        try {
            return new ResourceLocation(s);
        }
        catch (ResourceLocationException resourcelocationexception) {
            reader.setCursor(i2);
            throw f_135806_.createWithContext((ImmutableStringReader)reader);
        }
    }

    public static boolean m_135816_(char charIn) {
        return charIn >= '0' && charIn <= '9' || charIn >= 'a' && charIn <= 'z' || charIn == '_' || charIn == ':' || charIn == '/' || charIn == '.' || charIn == '-';
    }

    private static boolean m_135841_(String pathIn) {
        for (int i2 = 0; i2 < pathIn.length(); ++i2) {
            if (ResourceLocation.m_135828_((char)pathIn.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private static boolean m_135843_(String namespaceIn) {
        for (int i2 = 0; i2 < namespaceIn.length(); ++i2) {
            if (ResourceLocation.m_135835_((char)namespaceIn.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean m_135828_(char charIn) {
        return charIn == '_' || charIn == '-' || charIn >= 'a' && charIn <= 'z' || charIn >= '0' && charIn <= '9' || charIn == '/' || charIn == '.';
    }

    private static boolean m_135835_(char charIn) {
        return charIn == '_' || charIn == '-' || charIn >= 'a' && charIn <= 'z' || charIn >= '0' && charIn <= '9' || charIn == '.';
    }

    public static boolean m_135830_(String resourceName) {
        String[] astring = ResourceLocation.m_135832_((String)resourceName, (char)':');
        return ResourceLocation.m_135843_((String)(StringUtils.isEmpty((CharSequence)astring[0]) ? "minecraft" : astring[0])) && ResourceLocation.m_135841_((String)astring[1]);
    }

    public int compareNamespaced(ResourceLocation o2) {
        int ret = this.f_135804_.compareTo(o2.f_135804_);
        return ret != 0 ? ret : this.f_135805_.compareTo(o2.f_135805_);
    }
}

