/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;

/*
 * Exception performing whole class analysis ignored.
 */
public enum Direction implements StringRepresentable
{
    DOWN(0, 1, -1, "down", AxisDirection.NEGATIVE, Axis.Y, new Vec3i(0, -1, 0)),
    UP(1, 0, -1, "up", AxisDirection.POSITIVE, Axis.Y, new Vec3i(0, 1, 0)),
    NORTH(2, 3, 2, "north", AxisDirection.NEGATIVE, Axis.Z, new Vec3i(0, 0, -1)),
    SOUTH(3, 2, 0, "south", AxisDirection.POSITIVE, Axis.Z, new Vec3i(0, 0, 1)),
    WEST(4, 5, 1, "west", AxisDirection.NEGATIVE, Axis.X, new Vec3i(-1, 0, 0)),
    EAST(5, 4, 3, "east", AxisDirection.POSITIVE, Axis.X, new Vec3i(1, 0, 0));

    public static final StringRepresentable.EnumCodec<Direction> f_175356_;
    public static final Codec<Direction> f_194527_;
    private final int f_122339_;
    private final int f_122340_;
    private final int f_122341_;
    private final String f_122342_;
    private final Axis f_122343_;
    private final AxisDirection f_122344_;
    private final Vec3i f_122345_;
    public static final Direction[] f_122346_;
    public static final Direction[] f_122348_;
    private static final Direction[] f_122349_;
    private static final Long2ObjectMap<Direction> f_122350_;

    private Direction(int indexIn, int oppositeIn, int horizontalIndexIn, String nameIn, AxisDirection axisDirectionIn, Axis axisIn, Vec3i directionVecIn) {
        this.f_122339_ = indexIn;
        this.f_122341_ = horizontalIndexIn;
        this.f_122340_ = oppositeIn;
        this.f_122342_ = nameIn;
        this.f_122343_ = axisIn;
        this.f_122344_ = axisDirectionIn;
        this.f_122345_ = directionVecIn;
    }

    public static Direction[] m_122382_(Entity entityIn) {
        Direction direction2;
        float f2 = entityIn.m_5686_(1.0f) * ((float)Math.PI / 180);
        float f1 = -entityIn.m_5675_(1.0f) * ((float)Math.PI / 180);
        float f22 = Mth.m_14031_((float)f2);
        float f3 = Mth.m_14089_((float)f2);
        float f4 = Mth.m_14031_((float)f1);
        float f5 = Mth.m_14089_((float)f1);
        boolean flag = f4 > 0.0f;
        boolean flag1 = f22 < 0.0f;
        boolean flag2 = f5 > 0.0f;
        float f6 = flag ? f4 : -f4;
        float f7 = flag1 ? -f22 : f22;
        float f8 = flag2 ? f5 : -f5;
        float f9 = f6 * f3;
        float f10 = f8 * f3;
        Direction direction = flag ? EAST : WEST;
        Direction direction1 = flag1 ? UP : DOWN;
        Direction direction3 = direction2 = flag2 ? SOUTH : NORTH;
        if (f6 > f8) {
            if (f7 > f9) {
                return Direction.m_122398_((Direction)direction1, (Direction)direction, (Direction)direction2);
            }
            return f10 > f7 ? Direction.m_122398_((Direction)direction, (Direction)direction2, (Direction)direction1) : Direction.m_122398_((Direction)direction, (Direction)direction1, (Direction)direction2);
        }
        if (f7 > f10) {
            return Direction.m_122398_((Direction)direction1, (Direction)direction2, (Direction)direction);
        }
        return f9 > f7 ? Direction.m_122398_((Direction)direction2, (Direction)direction, (Direction)direction1) : Direction.m_122398_((Direction)direction2, (Direction)direction1, (Direction)direction);
    }

    private static Direction[] m_122398_(Direction first, Direction second, Direction third) {
        return new Direction[]{first, second, third, third.m_122424_(), second.m_122424_(), first.m_122424_()};
    }

    public static Direction m_122384_(Matrix4f matrixIn, Direction directionIn) {
        Vec3i vec3i = directionIn.m_122436_();
        Vector4f vector4f = new Vector4f((float)vec3i.m_123341_(), (float)vec3i.m_123342_(), (float)vec3i.m_123343_(), 0.0f);
        vector4f.m_123607_(matrixIn);
        return Direction.m_122372_((float)vector4f.m_123601_(), (float)vector4f.m_123615_(), (float)vector4f.m_123616_());
    }

    public static Collection<Direction> m_235667_(RandomSource randomIn) {
        return Util.m_214681_((Object[])Direction.values(), (RandomSource)randomIn);
    }

    public static Stream<Direction> m_235666_() {
        return Stream.of(f_122346_);
    }

    public Quaternion m_122406_() {
        Quaternion quaternion = Vector3f.f_122223_.m_122240_(90.0f);
        return switch (1.$SwitchMap$net$minecraft$core$Direction[this.ordinal()]) {
            case 1 -> Vector3f.f_122223_.m_122240_(180.0f);
            case 2 -> Quaternion.f_80118_.m_80161_();
            case 3 -> {
                quaternion.m_80148_(Vector3f.f_122227_.m_122240_(180.0f));
                yield quaternion;
            }
            case 4 -> quaternion;
            case 5 -> {
                quaternion.m_80148_(Vector3f.f_122227_.m_122240_(90.0f));
                yield quaternion;
            }
            case 6 -> {
                quaternion.m_80148_(Vector3f.f_122227_.m_122240_(-90.0f));
                yield quaternion;
            }
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public int m_122411_() {
        return this.f_122339_;
    }

    public int m_122416_() {
        return this.f_122341_;
    }

    public AxisDirection m_122421_() {
        return this.f_122344_;
    }

    public static Direction m_175357_(Entity entityIn, Axis axisIn) {
        return switch (1.$SwitchMap$net$minecraft$core$Direction$Axis[axisIn.ordinal()]) {
            case 1 -> EAST.m_122370_(entityIn.m_5675_(1.0f)) ? EAST : WEST;
            case 2 -> SOUTH.m_122370_(entityIn.m_5675_(1.0f)) ? SOUTH : NORTH;
            case 3 -> entityIn.m_5686_(1.0f) < 0.0f ? UP : DOWN;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public Direction m_122424_() {
        return f_122346_[this.f_122340_];
    }

    public Direction m_175362_(Axis axisIn) {
        return switch (1.$SwitchMap$net$minecraft$core$Direction$Axis[axisIn.ordinal()]) {
            case 1 -> this != WEST && this != EAST ? this.m_175366_() : this;
            case 2 -> this != NORTH && this != SOUTH ? this.m_175368_() : this;
            case 3 -> this != UP && this != DOWN ? this.m_122427_() : this;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public Direction m_175364_(Axis axisIn) {
        return switch (1.$SwitchMap$net$minecraft$core$Direction$Axis[axisIn.ordinal()]) {
            case 1 -> this != WEST && this != EAST ? this.m_175367_() : this;
            case 2 -> this != NORTH && this != SOUTH ? this.m_175369_() : this;
            case 3 -> this != UP && this != DOWN ? this.m_122428_() : this;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public Direction m_122427_() {
        return switch (1.$SwitchMap$net$minecraft$core$Direction[this.ordinal()]) {
            case 3 -> EAST;
            case 4 -> WEST;
            case 5 -> NORTH;
            case 6 -> SOUTH;
            default -> throw new IllegalStateException("Unable to get Y-rotated facing of " + this);
        };
    }

    private Direction m_175366_() {
        return switch (1.$SwitchMap$net$minecraft$core$Direction[this.ordinal()]) {
            case 1 -> SOUTH;
            case 2 -> NORTH;
            case 3 -> DOWN;
            case 4 -> UP;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + this);
        };
    }

    private Direction m_175367_() {
        return switch (1.$SwitchMap$net$minecraft$core$Direction[this.ordinal()]) {
            case 1 -> NORTH;
            case 2 -> SOUTH;
            case 3 -> UP;
            case 4 -> DOWN;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + this);
        };
    }

    private Direction m_175368_() {
        return switch (1.$SwitchMap$net$minecraft$core$Direction[this.ordinal()]) {
            case 1 -> WEST;
            case 2 -> EAST;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + this);
            case 5 -> UP;
            case 6 -> DOWN;
        };
    }

    private Direction m_175369_() {
        return switch (1.$SwitchMap$net$minecraft$core$Direction[this.ordinal()]) {
            case 1 -> EAST;
            case 2 -> WEST;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + this);
            case 5 -> DOWN;
            case 6 -> UP;
        };
    }

    public Direction m_122428_() {
        return switch (1.$SwitchMap$net$minecraft$core$Direction[this.ordinal()]) {
            case 3 -> WEST;
            case 4 -> EAST;
            case 5 -> SOUTH;
            case 6 -> NORTH;
            default -> throw new IllegalStateException("Unable to get CCW facing of " + this);
        };
    }

    public int m_122429_() {
        return this.f_122345_.m_123341_();
    }

    public int m_122430_() {
        return this.f_122345_.m_123342_();
    }

    public int m_122431_() {
        return this.f_122345_.m_123343_();
    }

    public Vector3f m_122432_() {
        return new Vector3f((float)this.m_122429_(), (float)this.m_122430_(), (float)this.m_122431_());
    }

    public String m_122433_() {
        return this.f_122342_;
    }

    public Axis m_122434_() {
        return this.f_122343_;
    }

    @Nullable
    public static Direction m_122402_(@Nullable String name) {
        return (Direction)f_175356_.m_216455_(name);
    }

    public static Direction m_122376_(int index) {
        return f_122348_[Mth.m_14040_((int)(index % f_122348_.length))];
    }

    public static Direction m_122407_(int horizontalIndexIn) {
        return f_122349_[Mth.m_14040_((int)(horizontalIndexIn % f_122349_.length))];
    }

    @Nullable
    public static Direction m_175360_(BlockPos posIn) {
        return (Direction)f_122350_.get(posIn.m_121878_());
    }

    @Nullable
    public static Direction m_122378_(int x, int y, int z) {
        return (Direction)f_122350_.get(BlockPos.m_121882_((int)x, (int)y, (int)z));
    }

    public static Direction m_122364_(double angle) {
        return Direction.m_122407_((int)(Mth.m_14107_((double)(angle / 90.0 + 0.5)) & 3));
    }

    public static Direction m_122387_(Axis axisIn, AxisDirection axisDirectionIn) {
        return switch (1.$SwitchMap$net$minecraft$core$Direction$Axis[axisIn.ordinal()]) {
            case 1 -> axisDirectionIn == AxisDirection.POSITIVE ? EAST : WEST;
            case 2 -> axisDirectionIn == AxisDirection.POSITIVE ? SOUTH : NORTH;
            case 3 -> axisDirectionIn == AxisDirection.POSITIVE ? UP : DOWN;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public float m_122435_() {
        return (this.f_122341_ & 3) * 90;
    }

    public static Direction m_235672_(RandomSource randomIn) {
        return (Direction)Util.m_214670_((Object[])f_122346_, (RandomSource)randomIn);
    }

    public static Direction m_122366_(double x, double y, double z) {
        return Direction.m_122372_((float)((float)x), (float)((float)y), (float)((float)z));
    }

    public static Direction m_122372_(float x, float y, float z) {
        Direction direction = NORTH;
        float f2 = Float.MIN_VALUE;
        for (Direction direction1 : f_122346_) {
            float f1 = x * (float)direction1.f_122345_.m_123341_() + y * (float)direction1.f_122345_.m_123342_() + z * (float)direction1.f_122345_.m_123343_();
            if (!(f1 > f2)) continue;
            f2 = f1;
            direction = direction1;
        }
        return direction;
    }

    public String toString() {
        return this.f_122342_;
    }

    public String m_7912_() {
        return this.f_122342_;
    }

    private static DataResult<Direction> m_194528_(Direction directionIn) {
        return directionIn.m_122434_().m_122478_() ? DataResult.success((Object)directionIn) : DataResult.error((String)"Expected a vertical direction");
    }

    public static Direction m_122390_(AxisDirection axisDirectionIn, Axis axisIn) {
        for (Direction direction : f_122346_) {
            if (direction.m_122421_() != axisDirectionIn || direction.m_122434_() != axisIn) continue;
            return direction;
        }
        throw new IllegalArgumentException("No such direction: " + axisDirectionIn + " " + axisIn);
    }

    public Vec3i m_122436_() {
        return this.f_122345_;
    }

    public boolean m_122370_(float p_122370_1_) {
        float f2 = p_122370_1_ * ((float)Math.PI / 180);
        float f1 = -Mth.m_14031_((float)f2);
        float f22 = Mth.m_14089_((float)f2);
        return (float)this.f_122345_.m_123341_() * f1 + (float)this.f_122345_.m_123343_() * f22 > 0.0f;
    }

    static {
        f_175356_ = StringRepresentable.m_216439_(Direction::values);
        f_194527_ = f_175356_.flatXmap(Direction::m_194528_, Direction::m_194528_);
        f_122346_ = Direction.values();
        f_122348_ = (Direction[])Arrays.stream(f_122346_).sorted(Comparator.comparingInt(p_235686_0_ -> p_235686_0_.f_122339_)).toArray(Direction[]::new);
        f_122349_ = (Direction[])Arrays.stream(f_122346_).filter(p_235684_0_ -> p_235684_0_.m_122434_().m_122479_()).sorted(Comparator.comparingInt(p_235682_0_ -> p_235682_0_.f_122341_)).toArray(Direction[]::new);
        f_122350_ = (Long2ObjectMap)Arrays.stream(f_122346_).collect(Collectors.toMap(p_235678_0_ -> new BlockPos(p_235678_0_.m_122436_()).m_121878_(), p_235674_0_ -> p_235674_0_, (p_235669_0_, p_235669_1_) -> {
            throw new IllegalArgumentException("Duplicate keys");
        }, Long2ObjectOpenHashMap::new));
    }
}

