/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.PngInfo;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SpriteCoordinateExpander;
import net.minecraft.client.renderer.texture.MipmapGenerator;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.optifine.Config;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersTextureType;
import net.optifine.texture.ColorBlenderKeepAlpha;
import net.optifine.texture.IColorBlender;
import net.optifine.util.CounterInt;
import net.optifine.util.TextureUtils;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class TextureAtlasSprite
implements AutoCloseable {
    private static final Logger f_174721_ = LogUtils.getLogger();
    private final TextureAtlas f_118343_;
    private final ResourceLocation f_174722_;
    final int f_174723_;
    final int f_174724_;
    protected final NativeImage[] f_118342_;
    @Nullable
    private final AnimatedTexture f_174725_;
    private final int f_118349_;
    private final int f_118350_;
    private final float f_118351_;
    private final float f_118352_;
    private final float f_118353_;
    private final float f_118354_;
    private int indexInMap = -1;
    public float baseU;
    public float baseV;
    public int sheetWidth;
    public int sheetHeight;
    public int glSpriteTextureId = -1;
    public TextureAtlasSprite spriteSingle = null;
    public boolean isSpriteSingle = false;
    public static final String SUFFIX_SPRITE_SINGLE = ".sprite_single";
    public int mipmapLevels = 0;
    public TextureAtlasSprite spriteNormal = null;
    public TextureAtlasSprite spriteSpecular = null;
    public ShadersTextureType spriteShadersType = null;
    public TextureAtlasSprite spriteEmissive = null;
    public boolean isSpriteEmissive = false;
    private int animationIndex = -1;
    private boolean animationActive = false;
    private boolean usesParentAnimationTime = false;
    private boolean terrain;
    private boolean shaders;
    private boolean multiTexture;
    private ResourceManager resourceManager;
    private final int imageWidth;
    private final int imageHeight;
    private final AnimationMetadataSection animationMetadata;

    public TextureAtlasSprite(ResourceLocation name) {
        this.f_118343_ = null;
        this.f_174722_ = name;
        this.f_174723_ = 0;
        this.f_174724_ = 0;
        this.animationMetadata = null;
        this.f_118342_ = null;
        this.f_118349_ = 0;
        this.f_118350_ = 0;
        this.f_118351_ = 0.0f;
        this.f_118352_ = 0.0f;
        this.f_118353_ = 0.0f;
        this.f_118354_ = 0.0f;
        this.f_174725_ = null;
        this.imageWidth = 0;
        this.imageHeight = 0;
    }

    private TextureAtlasSprite(TextureAtlasSprite parent) {
        this.f_118343_ = parent.f_118343_;
        this.f_174722_ = parent.m_118413_();
        this.f_174723_ = parent.m_118405_();
        this.f_174724_ = parent.m_118408_();
        this.imageWidth = parent.imageWidth;
        this.imageHeight = parent.imageHeight;
        this.animationMetadata = parent.animationMetadata;
        this.usesParentAnimationTime = true;
        this.f_118342_ = parent.f_118342_;
        Info info = new Info(this.f_174722_, this.f_174723_, this.f_174724_, this.animationMetadata);
        this.f_174725_ = this.m_174729_(info, this.imageWidth, this.imageHeight, parent.mipmapLevels);
        if (this.f_174725_ != null && this.f_174725_.f_174752_ != null && parent.f_174725_ != null && parent.f_174725_.f_174752_ != null) {
            this.f_174725_.f_174752_.f_118443_ = parent.f_174725_.f_174752_.f_118443_;
        }
        this.f_118349_ = 0;
        this.f_118350_ = 0;
        this.f_118351_ = 0.0f;
        this.f_118352_ = 1.0f;
        this.f_118353_ = 0.0f;
        this.f_118354_ = 1.0f;
        this.indexInMap = parent.indexInMap;
        this.baseU = parent.baseU;
        this.baseV = parent.baseV;
        this.sheetWidth = parent.sheetWidth;
        this.sheetHeight = parent.sheetHeight;
        this.isSpriteSingle = true;
        this.mipmapLevels = parent.mipmapLevels;
        this.animationIndex = parent.animationIndex;
        this.animationActive = parent.animationActive;
    }

    protected TextureAtlasSprite(TextureAtlas atlasTextureIn, Info spriteInfoIn, int mipmapLevelsIn, int atlasWidthIn, int atlasHeightIn, int xIn, int yIn, NativeImage imageIn) {
        this(atlasTextureIn, spriteInfoIn, mipmapLevelsIn, atlasWidthIn, atlasHeightIn, xIn, yIn, imageIn, null);
    }

    protected TextureAtlasSprite(TextureAtlas atlasTextureIn, Info spriteInfoIn, int mipmapLevelsIn, int atlasWidthIn, int atlasHeightIn, int xIn, int yIn, NativeImage imageIn, ShadersTextureType spriteShadersTypeIn) {
        int widthScaled;
        NativeImage imageScaled;
        this.f_118343_ = atlasTextureIn;
        this.f_174723_ = spriteInfoIn.f_118423_;
        this.f_174724_ = spriteInfoIn.f_118424_;
        this.f_174722_ = spriteInfoIn.f_118422_;
        this.imageWidth = imageIn.m_84982_();
        this.imageHeight = imageIn.m_85084_();
        this.animationMetadata = spriteInfoIn.getSpriteAnimationMetadata();
        this.f_118349_ = xIn;
        this.f_118350_ = yIn;
        this.f_118351_ = (float)xIn / (float)atlasWidthIn;
        this.f_118352_ = (float)(xIn + this.f_174723_) / (float)atlasWidthIn;
        this.f_118353_ = (float)yIn / (float)atlasHeightIn;
        this.f_118354_ = (float)(yIn + this.f_174724_) / (float)atlasHeightIn;
        if (spriteInfoIn.scaleFactor > 1.0 && (imageScaled = TextureUtils.scaleImage((NativeImage)imageIn, (int)(widthScaled = (int)Math.round((double)imageIn.m_84982_() * spriteInfoIn.scaleFactor)))) != imageIn) {
            imageIn.close();
            imageIn = imageScaled;
        }
        this.spriteShadersType = spriteShadersTypeIn;
        IColorBlender colorBlender = this.f_118343_.getShadersColorBlender(this.spriteShadersType);
        if (this.spriteShadersType == null) {
            if (!spriteInfoIn.m_118431_().m_135815_().endsWith("_leaves")) {
                this.fixTransparentColor(imageIn);
            }
            if (colorBlender == null && this.f_174722_.m_135815_().endsWith("glass_pane_top")) {
                colorBlender = new ColorBlenderKeepAlpha();
            }
        }
        NativeImage imageInF = imageIn;
        this.f_174725_ = this.m_174729_(spriteInfoIn, imageIn.m_84982_(), imageIn.m_85084_(), mipmapLevelsIn);
        try {
            try {
                this.f_118342_ = MipmapGenerator.generateMipmaps((NativeImage)imageIn, (int)mipmapLevelsIn, (IColorBlender)colorBlender);
            }
            catch (Throwable throwable) {
                CrashReport crashreport1 = CrashReport.m_127521_((Throwable)throwable, (String)"Generating mipmaps for frame");
                CrashReportCategory crashreportcategory1 = crashreport1.m_127514_("Frame being iterated");
                crashreportcategory1.m_128165_("First frame", () -> {
                    StringBuilder stringbuilder = new StringBuilder();
                    if (stringbuilder.length() > 0) {
                        stringbuilder.append(", ");
                    }
                    stringbuilder.append(imageInF.m_84982_()).append("x").append(imageInF.m_85084_());
                    return stringbuilder.toString();
                });
                throw new ReportedException(crashreport1);
            }
        }
        catch (Throwable throwable1) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable1, (String)"Applying mipmap");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Sprite being mipmapped");
            crashreportcategory.m_128165_("Sprite name", () -> ((ResourceLocation)this.f_174722_).toString());
            crashreportcategory.m_128165_("Sprite size", () -> this.f_174723_ + " x " + this.f_174724_);
            crashreportcategory.m_128165_("Sprite frames", () -> this.m_118415_() + " frames");
            crashreportcategory.m_128159_("Mipmap levels", (Object)mipmapLevelsIn);
            throw new ReportedException(crashreport);
        }
        this.mipmapLevels = mipmapLevelsIn;
        this.baseU = Math.min(this.f_118351_, this.f_118352_);
        this.baseV = Math.min(this.f_118353_, this.f_118354_);
        this.sheetWidth = atlasWidthIn;
        this.sheetHeight = atlasHeightIn;
    }

    private int m_118415_() {
        return this.f_174725_ != null ? this.f_174725_.f_174750_.size() : 1;
    }

    @Nullable
    private AnimatedTexture m_174729_(Info infoIn, int widthIn, int heightIn, int mipmapsIn) {
        AnimationMetadataSection animationmetadatasection = infoIn.f_118425_;
        int i2 = widthIn / animationmetadatasection.m_119031_(infoIn.f_118423_);
        int j2 = heightIn / animationmetadatasection.m_119026_(infoIn.f_118424_);
        int k2 = i2 * j2;
        ArrayList list = Lists.newArrayList();
        animationmetadatasection.m_174861_((indexIn, timeIn) -> list.add(new FrameInfo(indexIn, timeIn)));
        if (list.isEmpty()) {
            for (int l2 = 0; l2 < k2; ++l2) {
                list.add(new FrameInfo(l2, animationmetadatasection.m_119030_()));
            }
        } else {
            int i1 = 0;
            IntOpenHashSet intset = new IntOpenHashSet();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FrameInfo textureatlassprite$frameinfo = (FrameInfo)iterator.next();
                boolean flag = true;
                if (textureatlassprite$frameinfo.f_174772_ <= 0) {
                    f_174721_.warn("Invalid frame duration on sprite {} frame {}: {}", new Object[]{this.f_174722_, i1, textureatlassprite$frameinfo.f_174772_});
                    flag = false;
                }
                if (textureatlassprite$frameinfo.f_174771_ < 0 || textureatlassprite$frameinfo.f_174771_ >= k2) {
                    f_174721_.warn("Invalid frame index on sprite {} frame {}: {}", new Object[]{this.f_174722_, i1, textureatlassprite$frameinfo.f_174771_});
                    flag = false;
                }
                if (flag) {
                    intset.add(textureatlassprite$frameinfo.f_174771_);
                } else {
                    iterator.remove();
                }
                ++i1;
            }
            int[] aint = IntStream.range(0, k2).filter(arg_0 -> TextureAtlasSprite.lambda$createTicker$4((IntSet)intset, arg_0)).toArray();
            if (aint.length > 0) {
                f_174721_.warn("Unused frames in sprite {}: {}", (Object)this.f_174722_, (Object)Arrays.toString(aint));
            }
        }
        if (list.size() <= 1) {
            return null;
        }
        InterpolationData textureatlassprite$interpolationdata = animationmetadatasection.m_119036_() ? new InterpolationData(this, infoIn, mipmapsIn) : null;
        return new AnimatedTexture(this, (List)ImmutableList.copyOf((Collection)list), i2, textureatlassprite$interpolationdata);
    }

    void m_118375_(int xOffsetIn, int yOffsetIn, NativeImage[] framesIn) {
        boolean blur = false;
        boolean clamp = this.isSpriteSingle;
        for (int i2 = 0; i2 < framesIn.length && this.m_118405_() >> i2 > 0 && this.m_118408_() >> i2 > 0; ++i2) {
            framesIn[i2].m_85003_(i2, this.f_118349_ >> i2, this.f_118350_ >> i2, xOffsetIn >> i2, yOffsetIn >> i2, this.f_174723_ >> i2, this.f_174724_ >> i2, framesIn.length > 1, false);
        }
    }

    public int m_174743_() {
        return this.f_118349_;
    }

    public int m_174744_() {
        return this.f_118350_;
    }

    public int m_118405_() {
        return this.f_174723_;
    }

    public int m_118408_() {
        return this.f_174724_;
    }

    public float m_118409_() {
        return this.f_118351_;
    }

    public float m_118410_() {
        return this.f_118352_;
    }

    public float m_118367_(double u) {
        float f2 = this.f_118352_ - this.f_118351_;
        return this.f_118351_ + f2 * (float)u / 16.0f;
    }

    public float m_174727_(float u) {
        float f2 = this.f_118352_ - this.f_118351_;
        return (u - this.f_118351_) / f2 * 16.0f;
    }

    public float m_118411_() {
        return this.f_118353_;
    }

    public float m_118412_() {
        return this.f_118354_;
    }

    public float m_118393_(double v) {
        float f2 = this.f_118354_ - this.f_118353_;
        return this.f_118353_ + f2 * (float)v / 16.0f;
    }

    public float m_174741_(float v) {
        float f2 = this.f_118354_ - this.f_118353_;
        return (v - this.f_118353_) / f2 * 16.0f;
    }

    public ResourceLocation m_118413_() {
        return this.f_174722_;
    }

    public TextureAtlas m_118414_() {
        return this.f_118343_;
    }

    public IntStream m_174745_() {
        return this.f_174725_ != null ? this.f_174725_.m_174763_() : IntStream.of(1);
    }

    @Override
    public void close() {
        for (NativeImage nativeimage : this.f_118342_) {
            if (nativeimage == null) continue;
            nativeimage.close();
        }
        if (this.f_174725_ != null) {
            this.f_174725_.close();
        }
        if (this.spriteSingle != null) {
            // empty if block
        }
        if (this.spriteNormal != null) {
            this.spriteNormal.close();
        }
        if (this.spriteSpecular != null) {
            this.spriteSpecular.close();
        }
    }

    public String toString() {
        return "TextureAtlasSprite{name='" + this.f_174722_ + "', frameCount=" + this.m_118415_() + ", x=" + this.f_118349_ + ", y=" + this.f_118350_ + ", height=" + this.f_174724_ + ", width=" + this.f_174723_ + ", u0=" + this.f_118351_ + ", u1=" + this.f_118352_ + ", v0=" + this.f_118353_ + ", v1=" + this.f_118354_ + "}";
    }

    public boolean m_118371_(int frameIndex, int pixelX, int pixelY) {
        int i2 = pixelX;
        int j2 = pixelY;
        if (this.f_174725_ != null) {
            i2 = pixelX + this.f_174725_.m_174759_(frameIndex) * this.f_174723_;
            j2 = pixelY + this.f_174725_.m_174764_(frameIndex) * this.f_174724_;
        }
        return (this.f_118342_[0].m_84985_(i2, j2) >> 24 & 0xFF) == 0;
    }

    public void m_118416_() {
        if (this.f_174725_ != null) {
            this.f_174725_.m_174758_();
        } else {
            this.m_118375_(0, 0, this.f_118342_);
        }
    }

    private float m_118366_() {
        float f2 = (float)this.f_174723_ / (this.f_118352_ - this.f_118351_);
        float f1 = (float)this.f_174724_ / (this.f_118354_ - this.f_118353_);
        return Math.max(f1, f2);
    }

    public float m_118417_() {
        return 4.0f / this.m_118366_();
    }

    @Nullable
    public Tickable m_174746_() {
        return this.f_174725_;
    }

    public VertexConsumer m_118381_(VertexConsumer bufferIn) {
        MultiBufferSource.BufferSource rtb;
        if (this.m_118413_() == TextureUtils.LOCATION_SPRITE_EMPTY && (rtb = bufferIn.getRenderTypeBuffer()) != null) {
            return rtb.getDummyBuffer();
        }
        return new SpriteCoordinateExpander(bufferIn, this);
    }

    public int getIndexInMap() {
        return this.indexInMap;
    }

    public void updateIndexInMap(CounterInt counterInt) {
        TextureAtlasSprite registeredSprite;
        if (this.indexInMap >= 0) {
            return;
        }
        if (this.f_118343_ != null && (registeredSprite = this.f_118343_.getRegisteredSprite(this.m_118413_())) != null) {
            this.indexInMap = registeredSprite.getIndexInMap();
        }
        if (this.indexInMap < 0) {
            this.indexInMap = counterInt.nextValue();
        }
    }

    public int getAnimationIndex() {
        return this.animationIndex;
    }

    public void setAnimationIndex(int animationIndex) {
        this.animationIndex = animationIndex;
        if (this.spriteSingle != null) {
            this.spriteSingle.setAnimationIndex(animationIndex);
        }
        if (this.spriteNormal != null) {
            this.spriteNormal.setAnimationIndex(animationIndex);
        }
        if (this.spriteSpecular != null) {
            this.spriteSpecular.setAnimationIndex(animationIndex);
        }
    }

    public boolean isAnimationActive() {
        return this.animationActive;
    }

    private void fixTransparentColor(NativeImage ni) {
        int[] data = new int[ni.m_84982_() * ni.m_85084_()];
        ni.getBufferRGBA().get(data);
        this.fixTransparentColor(data);
        ni.getBufferRGBA().put(data);
    }

    private void fixTransparentColor(int[] data) {
        if (data == null) {
            return;
        }
        long redSum = 0L;
        long greenSum = 0L;
        long blueSum = 0L;
        long count = 0L;
        for (int i2 = 0; i2 < data.length; ++i2) {
            int col = data[i2];
            int alpha = col >> 24 & 0xFF;
            if (alpha < 16) continue;
            int red = col >> 16 & 0xFF;
            int green = col >> 8 & 0xFF;
            int blue = col & 0xFF;
            redSum += (long)red;
            greenSum += (long)green;
            blueSum += (long)blue;
            ++count;
        }
        if (count <= 0L) {
            return;
        }
        int redAvg = (int)(redSum / count);
        int greenAvg = (int)(greenSum / count);
        int blueAvg = (int)(blueSum / count);
        int colAvg = redAvg << 16 | greenAvg << 8 | blueAvg;
        for (int i3 = 0; i3 < data.length; ++i3) {
            int col = data[i3];
            int alpha = col >> 24 & 0xFF;
            if (alpha > 16) continue;
            data[i3] = colAvg;
        }
    }

    public double getSpriteU16(float atlasU) {
        float dU = this.f_118352_ - this.f_118351_;
        return (atlasU - this.f_118351_) / dU * 16.0f;
    }

    public double getSpriteV16(float atlasV) {
        float dV = this.f_118354_ - this.f_118353_;
        return (atlasV - this.f_118353_) / dV * 16.0f;
    }

    public void bindSpriteTexture() {
        if (this.glSpriteTextureId < 0) {
            this.glSpriteTextureId = TextureUtil.m_85280_();
            TextureUtil.m_85287_((int)this.glSpriteTextureId, (int)this.mipmapLevels, (int)this.m_118405_(), (int)this.m_118408_());
            boolean blend = this.f_118343_.isTextureBlend(this.spriteShadersType);
            if (blend) {
                TextureUtils.applyAnisotropicLevel();
            } else {
                GlStateManager.m_84160_((int)3553, (int)34046, (float)1.0f);
                int minFilter = this.mipmapLevels > 0 ? 9984 : 9728;
                GlStateManager.m_84331_((int)3553, (int)10241, (int)minFilter);
                GlStateManager.m_84331_((int)3553, (int)10240, (int)9728);
            }
        }
        TextureUtils.bindTexture((int)this.glSpriteTextureId);
    }

    public void deleteSpriteTexture() {
        if (this.glSpriteTextureId < 0) {
            return;
        }
        TextureUtil.m_85281_((int)this.glSpriteTextureId);
        this.glSpriteTextureId = -1;
    }

    public float toSingleU(float u) {
        u -= this.baseU;
        float ku = (float)this.sheetWidth / (float)this.m_118405_();
        return u *= ku;
    }

    public float toSingleV(float v) {
        v -= this.baseV;
        float kv = (float)this.sheetHeight / (float)this.m_118408_();
        return v *= kv;
    }

    public NativeImage[] getMipmapImages() {
        return this.f_118342_;
    }

    public AnimationMetadataSection getAnimationMetadata() {
        return this.animationMetadata;
    }

    public int getOriginX() {
        return this.f_118349_;
    }

    public int getOriginY() {
        return this.f_118350_;
    }

    public float getUnInterpolatedU(float u) {
        float f2 = this.f_118352_ - this.f_118351_;
        return (u - this.f_118351_) / f2 * 16.0f;
    }

    public float getUnInterpolatedV(float v) {
        float f2 = this.f_118354_ - this.f_118353_;
        return (v - this.f_118353_) / f2 * 16.0f;
    }

    public TextureAtlasSprite makeSpriteSingle() {
        TextureAtlasSprite ss = new TextureAtlasSprite(this);
        ss.isSpriteSingle = true;
        return ss;
    }

    public TextureAtlasSprite makeSpriteShaders(ShadersTextureType type, int colDef, AnimatedTexture parentAnimatedTexture) {
        String suffix = type.getSuffix();
        ResourceLocation loc = new ResourceLocation(this.m_118413_().m_135827_(), this.m_118413_().m_135815_() + suffix);
        ResourceLocation locPng = this.f_118343_.m_118324_(loc);
        TextureAtlasSprite ss = null;
        Optional optRes = this.resourceManager.m_213713_(locPng);
        if (optRes.isPresent()) {
            try {
                NativeImage imageScaled;
                Resource iresource = (Resource)optRes.get();
                Resource resPngSize = this.resourceManager.m_215593_(locPng);
                PngInfo pngSize = new PngInfo(() -> locPng.toString(), resPngSize.m_215507_());
                AnimationMetadataSection animMeta = iresource.m_215509_().m_214059_((MetadataSectionSerializer)AnimationMetadataSection.f_119011_).orElse(AnimationMetadataSection.f_119012_);
                Pair sizePair = animMeta.m_7117_(pngSize.f_85207_, pngSize.f_85208_);
                Info infoShaders = new Info(loc, ((Integer)sizePair.getFirst()).intValue(), ((Integer)sizePair.getSecond()).intValue(), animMeta);
                NativeImage image = NativeImage.m_85058_((InputStream)iresource.m_215507_());
                if (image.m_84982_() != this.m_118405_() && (imageScaled = TextureUtils.scaleImage((NativeImage)image, (int)this.m_118405_())) != image) {
                    double scaleFactor = 1.0 * (double)this.m_118405_() / (double)image.m_84982_();
                    image.close();
                    image = imageScaled;
                    infoShaders = new Info(loc, (int)((double)((Integer)sizePair.getFirst()).intValue() * scaleFactor), (int)((double)((Integer)sizePair.getSecond()).intValue() * scaleFactor), animMeta);
                }
                ss = new TextureAtlasSprite(this.f_118343_, infoShaders, this.mipmapLevels, this.sheetWidth, this.sheetHeight, this.f_118349_, this.f_118350_, image, type);
            }
            catch (IOException iresource) {
                // empty catch block
            }
        }
        if (ss == null) {
            NativeImage image = new NativeImage(this.m_118405_(), this.m_118408_(), false);
            int colAbgr = TextureUtils.toAbgr((int)colDef);
            image.m_84997_(0, 0, image.m_84982_(), image.m_85084_(), colAbgr);
            Info infoShaders = new Info(loc, this.m_118405_(), this.m_118408_(), AnimationMetadataSection.f_119012_);
            ss = new TextureAtlasSprite(this.f_118343_, infoShaders, this.mipmapLevels, this.sheetWidth, this.sheetHeight, this.f_118349_, this.f_118350_, image, type);
        }
        if (this.terrain && this.multiTexture && !this.isSpriteSingle) {
            ss.spriteSingle = ss.makeSpriteSingle();
        }
        ss.usesParentAnimationTime = TextureAtlasSprite.matchesTiming((AnimatedTexture)ss.f_174725_, (AnimatedTexture)parentAnimatedTexture);
        return ss;
    }

    public boolean isTerrain() {
        return this.terrain;
    }

    private void setTerrain(boolean terrainIn) {
        this.terrain = terrainIn;
        this.multiTexture = false;
        this.shaders = false;
        if (this.spriteSingle != null) {
            this.deleteSpriteTexture();
            this.spriteSingle = null;
        }
        if (this.spriteNormal != null) {
            if (this.spriteNormal.spriteSingle != null) {
                this.spriteNormal.deleteSpriteTexture();
            }
            this.spriteNormal.close();
            this.spriteNormal = null;
        }
        if (this.spriteSpecular != null) {
            if (this.spriteSpecular.spriteSingle != null) {
                this.spriteSpecular.deleteSpriteTexture();
            }
            this.spriteSpecular.close();
            this.spriteSpecular = null;
        }
        this.multiTexture = Config.isMultiTexture();
        this.shaders = Config.isShaders();
        if (this.terrain && this.multiTexture && !this.isSpriteSingle) {
            this.spriteSingle = this.makeSpriteSingle();
        }
        if (this.shaders && !this.isSpriteSingle) {
            if (this.spriteNormal == null && Shaders.configNormalMap) {
                this.spriteNormal = this.makeSpriteShaders(ShadersTextureType.NORMAL, -8421377, this.f_174725_);
            }
            if (this.spriteSpecular == null && Shaders.configSpecularMap) {
                this.spriteSpecular = this.makeSpriteShaders(ShadersTextureType.SPECULAR, 0, this.f_174725_);
            }
        }
    }

    private static boolean matchesTiming(AnimatedTexture at1, AnimatedTexture at2) {
        boolean ip2;
        if (at1 == null || at2 == null) {
            return false;
        }
        if (at1 == at2) {
            return true;
        }
        boolean ip1 = at1.f_174752_ != null;
        boolean bl = ip2 = at2.f_174752_ != null;
        if (ip1 != ip2) {
            return false;
        }
        List frames1 = at1.f_174750_;
        List frames2 = at2.f_174750_;
        if (frames1 == null || frames2 == null) {
            return false;
        }
        if (frames1.size() != frames2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < frames1.size(); ++i2) {
            FrameInfo fi1 = (FrameInfo)frames1.get(i2);
            FrameInfo fi2 = (FrameInfo)frames2.get(i2);
            if (fi1 == null || fi2 == null) {
                return false;
            }
            if (fi1.f_174771_ != fi2.f_174771_) {
                return false;
            }
            if (fi1.f_174772_ == fi2.f_174772_) continue;
            return false;
        }
        return true;
    }

    public void update(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.updateIndexInMap(this.f_118343_.getCounterIndexInMap());
        this.setTerrain(this.f_118343_.isTerrain());
    }

    public void updateAnimation() {
        if (this.f_174725_ != null) {
            this.f_174725_.m_7673_();
        }
    }

    public int getPixelRGBA(int frameIndex, int x, int y) {
        if (this.f_174725_ != null) {
            x += this.f_174725_.m_174759_(frameIndex) * this.f_174723_;
            y += this.f_174725_.m_174764_(frameIndex) * this.f_174724_;
        }
        return this.f_118342_[0].m_84985_(x, y);
    }

    private static /* synthetic */ boolean lambda$createTicker$4(IntSet intset, int intIn) {
        return !intset.contains(intIn);
    }
}

