/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.optifine.Config;
import net.optifine.CustomItems;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorMethod;

public class HumanoidArmorLayer<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private static final Map<String, ResourceLocation> f_117070_ = Maps.newHashMap();
    private final A f_117071_;
    private final A f_117072_;

    public HumanoidArmorLayer(RenderLayerParent<T, M> rendererIn, A modelLeggingsIn, A modelArmorIn) {
        super(rendererIn);
        this.f_117071_ = modelLeggingsIn;
        this.f_117072_ = modelArmorIn;
    }

    public void m_6494_(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_117118_(matrixStackIn, bufferIn, entitylivingbaseIn, EquipmentSlot.CHEST, packedLightIn, this.m_117078_(EquipmentSlot.CHEST));
        this.m_117118_(matrixStackIn, bufferIn, entitylivingbaseIn, EquipmentSlot.LEGS, packedLightIn, this.m_117078_(EquipmentSlot.LEGS));
        this.m_117118_(matrixStackIn, bufferIn, entitylivingbaseIn, EquipmentSlot.FEET, packedLightIn, this.m_117078_(EquipmentSlot.FEET));
        this.m_117118_(matrixStackIn, bufferIn, entitylivingbaseIn, EquipmentSlot.HEAD, packedLightIn, this.m_117078_(EquipmentSlot.HEAD));
    }

    private void m_117118_(PoseStack matrixStackIn, MultiBufferSource bufferIn, T livingEntityIn, EquipmentSlot slotIn, int packedLightIn, A modelIn) {
        ArmorItem armoritem;
        ItemStack itemstack = livingEntityIn.m_6844_(slotIn);
        if (itemstack.m_41720_() instanceof ArmorItem && (armoritem = (ArmorItem)itemstack.m_41720_()).m_40402_() == slotIn) {
            ((HumanoidModel)this.m_117386_()).m_102872_(modelIn);
            this.m_117125_(modelIn, slotIn);
            Model model = this.getArmorModelHook(livingEntityIn, itemstack, slotIn, modelIn);
            boolean flag = this.m_117128_(slotIn);
            boolean flag1 = itemstack.m_41790_();
            if (armoritem instanceof DyeableLeatherItem) {
                int i2 = ((DyeableLeatherItem)armoritem).m_41121_(itemstack);
                float f2 = (float)(i2 >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i2 >> 8 & 0xFF) / 255.0f;
                float f22 = (float)(i2 & 0xFF) / 255.0f;
                this.renderModel(matrixStackIn, bufferIn, packedLightIn, flag1, model, f2, f1, f22, this.getArmorResource(livingEntityIn, itemstack, slotIn, null));
                this.renderModel(matrixStackIn, bufferIn, packedLightIn, flag1, model, 1.0f, 1.0f, 1.0f, this.getArmorResource(livingEntityIn, itemstack, slotIn, "overlay"));
            } else {
                this.renderModel(matrixStackIn, bufferIn, packedLightIn, flag1, model, 1.0f, 1.0f, 1.0f, this.getArmorResource(livingEntityIn, itemstack, slotIn, null));
            }
        }
    }

    protected void m_117125_(A modelIn, EquipmentSlot slotIn) {
        modelIn.m_8009_(false);
        switch (1.$SwitchMap$net$minecraft$world$entity$EquipmentSlot[slotIn.ordinal()]) {
            case 1: {
                ((HumanoidModel)modelIn).f_102808_.f_104207_ = true;
                ((HumanoidModel)modelIn).f_102809_.f_104207_ = true;
                break;
            }
            case 2: {
                ((HumanoidModel)modelIn).f_102810_.f_104207_ = true;
                ((HumanoidModel)modelIn).f_102811_.f_104207_ = true;
                ((HumanoidModel)modelIn).f_102812_.f_104207_ = true;
                break;
            }
            case 3: {
                ((HumanoidModel)modelIn).f_102810_.f_104207_ = true;
                ((HumanoidModel)modelIn).f_102813_.f_104207_ = true;
                ((HumanoidModel)modelIn).f_102814_.f_104207_ = true;
                break;
            }
            case 4: {
                ((HumanoidModel)modelIn).f_102813_.f_104207_ = true;
                ((HumanoidModel)modelIn).f_102814_.f_104207_ = true;
            }
        }
    }

    private void m_117106_(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, ArmorItem itemIn, boolean hasEffect, A bipedModelIn, boolean isLegSlot, float red, float green, float blue, @Nullable String suffixIn) {
        this.renderModel(matrixStackIn, bufferIn, packedLightIn, hasEffect, bipedModelIn, red, green, blue, this.m_117080_(itemIn, isLegSlot, suffixIn));
    }

    private void renderModel(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, boolean hasEffect, Model bipedModelIn, float red, float green, float blue, ResourceLocation armorResource) {
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110431_((ResourceLocation)armorResource), (boolean)false, (boolean)hasEffect);
        bipedModelIn.m_7695_(matrixStackIn, vertexconsumer, packedLightIn, OverlayTexture.f_118083_, red, green, blue, 1.0f);
    }

    private A m_117078_(EquipmentSlot slotIn) {
        return (A)(this.m_117128_(slotIn) ? this.f_117071_ : this.f_117072_);
    }

    private boolean m_117128_(EquipmentSlot slotIn) {
        return slotIn == EquipmentSlot.LEGS;
    }

    private ResourceLocation m_117080_(ArmorItem itemIn, boolean isLegSlot, @Nullable String suffixIn) {
        String s = "textures/models/armor/" + itemIn.m_40401_().m_6082_() + "_layer_" + (isLegSlot ? 2 : 1) + (String)(suffixIn == null ? "" : "_" + suffixIn) + ".png";
        return f_117070_.computeIfAbsent(s, ResourceLocation::new);
    }

    protected Model getArmorModelHook(T entity, ItemStack itemStack, EquipmentSlot slot, A model) {
        if (Reflector.ForgeHooksClient_getArmorModel.exists()) {
            return (Model)Reflector.ForgeHooksClient_getArmorModel.call(new Object[]{entity, itemStack, slot, model});
        }
        return model;
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, String type) {
        ResourceLocation resourcelocation;
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.m_117128_(slot) ? 2 : 1, type == null ? "" : String.format(Locale.ROOT, "_%s", type));
        if (Reflector.ForgeHooksClient_getArmorTexture.exists()) {
            s1 = Reflector.callString((ReflectorMethod)Reflector.ForgeHooksClient_getArmorTexture, (Object[])new Object[]{entity, stack, s1, slot, type});
        }
        if ((resourcelocation = (ResourceLocation)f_117070_.get(s1)) == null) {
            resourcelocation = new ResourceLocation(s1);
            f_117070_.put(s1, resourcelocation);
        }
        if (Config.isCustomItems()) {
            resourcelocation = CustomItems.getCustomArmorTexture((ItemStack)stack, (EquipmentSlot)slot, (String)type, (ResourceLocation)resourcelocation);
        }
        return resourcelocation;
    }
}

