/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.LiquidBlockRenderer;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.model.data.ModelData;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorConstructor;

public class BlockRenderDispatcher
implements ResourceManagerReloadListener {
    private final BlockModelShaper f_110899_;
    private final ModelBlockRenderer f_110900_;
    private final BlockEntityWithoutLevelRenderer f_173397_;
    private final LiquidBlockRenderer f_110901_;
    private final RandomSource f_110902_ = RandomSource.m_216327_();
    private final BlockColors f_110903_;

    public BlockRenderDispatcher(BlockModelShaper shapes, BlockEntityWithoutLevelRenderer renderer, BlockColors colors) {
        this.f_110899_ = shapes;
        this.f_173397_ = renderer;
        this.f_110903_ = colors;
        this.f_110900_ = Reflector.ForgeModelBlockRenderer_Constructor.exists() ? (ModelBlockRenderer)Reflector.newInstance((ReflectorConstructor)Reflector.ForgeModelBlockRenderer_Constructor, (Object[])new Object[]{this.f_110903_}) : new ModelBlockRenderer(this.f_110903_);
        this.f_110901_ = new LiquidBlockRenderer();
    }

    public BlockModelShaper m_110907_() {
        return this.f_110899_;
    }

    public void m_110918_(BlockState blockStateIn, BlockPos posIn, BlockAndTintGetter lightReaderIn, PoseStack matrixStackIn, VertexConsumer vertexBuilderIn) {
        this.renderBreakingTexture(blockStateIn, posIn, lightReaderIn, matrixStackIn, vertexBuilderIn, ModelData.EMPTY);
    }

    public void renderBreakingTexture(BlockState blockStateIn, BlockPos posIn, BlockAndTintGetter lightReaderIn, PoseStack matrixStackIn, VertexConsumer vertexBuilderIn, ModelData modelData) {
        if (blockStateIn.m_60799_() == RenderShape.MODEL) {
            BakedModel bakedmodel = this.f_110899_.m_110893_(blockStateIn);
            long i2 = blockStateIn.m_60726_(posIn);
            this.f_110900_.tesselateBlock(lightReaderIn, bakedmodel, blockStateIn, posIn, matrixStackIn, vertexBuilderIn, true, this.f_110902_, i2, OverlayTexture.f_118083_, modelData, null);
        }
    }

    public void m_234355_(BlockState blockStateIn, BlockPos posIn, BlockAndTintGetter lightReaderIn, PoseStack matrixStackIn, VertexConsumer vertexBuilderIn, boolean checkSides, RandomSource rand) {
        this.renderBatched(blockStateIn, posIn, lightReaderIn, matrixStackIn, vertexBuilderIn, checkSides, rand, ModelData.EMPTY, null);
    }

    public void renderBatched(BlockState blockStateIn, BlockPos posIn, BlockAndTintGetter lightReaderIn, PoseStack matrixStackIn, VertexConsumer vertexBuilderIn, boolean checkSides, RandomSource rand, ModelData modelData, RenderType renderType) {
        try {
            RenderShape rendershape = blockStateIn.m_60799_();
            if (rendershape == RenderShape.MODEL) {
                this.f_110900_.tesselateBlock(lightReaderIn, this.m_110910_(blockStateIn), blockStateIn, posIn, matrixStackIn, vertexBuilderIn, checkSides, rand, blockStateIn.m_60726_(posIn), OverlayTexture.f_118083_, modelData, renderType);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Tesselating block in world");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Block being tesselated");
            CrashReportCategory.m_178950_((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)lightReaderIn, (BlockPos)posIn, (BlockState)blockStateIn);
            throw new ReportedException(crashreport);
        }
    }

    public void m_234363_(BlockPos posIn, BlockAndTintGetter lightReaderIn, VertexConsumer vertexBuilderIn, BlockState blockStateIn, FluidState fluidStateIn) {
        try {
            this.f_110901_.m_234369_(lightReaderIn, posIn, vertexBuilderIn, blockStateIn, fluidStateIn);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Tesselating liquid in world");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Block being tesselated");
            CrashReportCategory.m_178950_((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)lightReaderIn, (BlockPos)posIn, (BlockState)null);
            throw new ReportedException(crashreport);
        }
    }

    public ModelBlockRenderer m_110937_() {
        return this.f_110900_;
    }

    public BakedModel m_110910_(BlockState state) {
        return this.f_110899_.m_110893_(state);
    }

    public void m_110912_(BlockState blockStateIn, PoseStack matrixStackIn, MultiBufferSource bufferTypeIn, int combinedLightIn, int combinedOverlayIn) {
        this.renderSingleBlock(blockStateIn, matrixStackIn, bufferTypeIn, combinedLightIn, combinedOverlayIn, ModelData.EMPTY, null);
    }

    public void renderSingleBlock(BlockState blockStateIn, PoseStack matrixStackIn, MultiBufferSource bufferTypeIn, int combinedLightIn, int combinedOverlayIn, ModelData modelData, RenderType renderType) {
        RenderShape rendershape = blockStateIn.m_60799_();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (1.$SwitchMap$net$minecraft$world$level$block$RenderShape[rendershape.ordinal()]) {
                case 1: {
                    BakedModel bakedmodel = this.m_110910_(blockStateIn);
                    int i2 = this.f_110903_.m_92577_(blockStateIn, (BlockAndTintGetter)null, (BlockPos)null, 0);
                    float f2 = (float)(i2 >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i2 >> 8 & 0xFF) / 255.0f;
                    float f22 = (float)(i2 & 0xFF) / 255.0f;
                    if (Reflector.ForgeHooksClient.exists()) {
                        for (RenderType rt : bakedmodel.getRenderTypes(blockStateIn, RandomSource.m_216335_((long)42L), modelData)) {
                            this.f_110900_.renderModel(matrixStackIn.m_85850_(), bufferTypeIn.m_6299_(renderType != null ? renderType : RenderTypeHelper.getEntityRenderType((RenderType)rt, (boolean)false)), blockStateIn, bakedmodel, f2, f1, f22, combinedLightIn, combinedOverlayIn, modelData, rt);
                        }
                        break;
                    }
                    this.f_110900_.m_111067_(matrixStackIn.m_85850_(), bufferTypeIn.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)blockStateIn, (boolean)false)), blockStateIn, bakedmodel, f2, f1, f22, combinedLightIn, combinedOverlayIn);
                    break;
                }
                case 2: {
                    if (Reflector.MinecraftForge.exists()) {
                        ItemStack stack = new ItemStack((ItemLike)blockStateIn.m_60734_());
                        IClientItemExtensions irp = IClientItemExtensions.of((ItemStack)stack);
                        BlockEntityWithoutLevelRenderer teisr = irp.getCustomRenderer();
                        teisr.m_108829_(stack, ItemTransforms.TransformType.NONE, matrixStackIn, bufferTypeIn, combinedLightIn, combinedOverlayIn);
                        break;
                    }
                    this.f_173397_.m_108829_(new ItemStack((ItemLike)blockStateIn.m_60734_()), ItemTransforms.TransformType.NONE, matrixStackIn, bufferTypeIn, combinedLightIn, combinedOverlayIn);
                }
            }
        }
    }

    public void m_6213_(ResourceManager resourceManager) {
        this.f_110901_.m_110944_();
    }
}

