/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.optifine.Config;
import net.optifine.render.VboRegion;

public class ViewArea {
    protected final LevelRenderer f_110838_;
    protected final Level f_110839_;
    protected int f_110840_;
    protected int f_110841_;
    protected int f_110842_;
    public ChunkRenderDispatcher.RenderChunk[] f_110843_;
    private Map<ChunkPos, VboRegion[]> mapVboRegions = new HashMap();

    public ViewArea(ChunkRenderDispatcher renderDispatcherIn, Level worldIn, int countChunksIn, LevelRenderer renderGlobalIn) {
        this.f_110838_ = renderGlobalIn;
        this.f_110839_ = worldIn;
        this.m_110853_(countChunksIn);
        this.m_110864_(renderDispatcherIn);
    }

    protected void m_110864_(ChunkRenderDispatcher renderChunkFactory) {
        int l2;
        if (!Minecraft.m_91087_().m_18695_()) {
            throw new IllegalStateException("createChunks called from wrong thread: " + Thread.currentThread().getName());
        }
        int i2 = this.f_110841_ * this.f_110840_ * this.f_110842_;
        this.f_110843_ = new ChunkRenderDispatcher.RenderChunk[i2];
        int minBuildHeight = this.f_110839_.m_141937_();
        for (int j2 = 0; j2 < this.f_110841_; ++j2) {
            for (int k2 = 0; k2 < this.f_110840_; ++k2) {
                for (l2 = 0; l2 < this.f_110842_; ++l2) {
                    int i1 = this.m_110855_(j2, k2, l2);
                    ChunkRenderDispatcher chunkRenderDispatcher = renderChunkFactory;
                    Objects.requireNonNull(chunkRenderDispatcher);
                    this.f_110843_[i1] = new ChunkRenderDispatcher.RenderChunk(chunkRenderDispatcher, i1, j2 * 16, k2 * 16, l2 * 16);
                    this.f_110843_[i1].m_112801_(j2 * 16, k2 * 16 + minBuildHeight, l2 * 16);
                    if (!Config.isVbo() || !Config.isRenderRegions()) continue;
                    this.updateVboRegion(this.f_110843_[i1]);
                }
            }
        }
        for (int k3 = 0; k3 < this.f_110843_.length; ++k3) {
            ChunkRenderDispatcher.RenderChunk renderChunk = this.f_110843_[k3];
            for (l2 = 0; l2 < Direction.f_122346_.length; ++l2) {
                Direction facing = Direction.f_122346_[l2];
                BlockPos posOffset16 = renderChunk.m_112824_(facing);
                ChunkRenderDispatcher.RenderChunk neighbour = this.m_110866_(posOffset16);
                renderChunk.setRenderChunkNeighbour(facing, neighbour);
            }
        }
    }

    public void m_110849_() {
        for (ChunkRenderDispatcher.RenderChunk chunkrenderdispatcher$renderchunk : this.f_110843_) {
            chunkrenderdispatcher$renderchunk.m_112838_();
        }
        this.deleteVboRegions();
    }

    private int m_110855_(int x, int y, int z) {
        return (z * this.f_110840_ + y) * this.f_110841_ + x;
    }

    protected void m_110853_(int renderDistanceChunks) {
        int i2;
        this.f_110841_ = i2 = renderDistanceChunks * 2 + 1;
        this.f_110840_ = this.f_110839_.m_151559_();
        this.f_110842_ = i2;
    }

    public void m_110850_(double viewEntityX, double viewEntityZ) {
        int i2 = Mth.m_14165_((double)viewEntityX);
        int j2 = Mth.m_14165_((double)viewEntityZ);
        for (int k2 = 0; k2 < this.f_110841_; ++k2) {
            int l2 = this.f_110841_ * 16;
            int i1 = i2 - 7 - l2 / 2;
            int j1 = i1 + Math.floorMod(k2 * 16 - i1, l2);
            for (int k1 = 0; k1 < this.f_110842_; ++k1) {
                int l1 = this.f_110842_ * 16;
                int i22 = j2 - 7 - l1 / 2;
                int j22 = i22 + Math.floorMod(k1 * 16 - i22, l1);
                for (int k22 = 0; k22 < this.f_110840_; ++k22) {
                    int l22 = this.f_110839_.m_141937_() + k22 * 16;
                    ChunkRenderDispatcher.RenderChunk chunkrenderdispatcher$renderchunk = this.f_110843_[this.m_110855_(k2, k22, k1)];
                    BlockPos blockpos = chunkrenderdispatcher$renderchunk.m_112839_();
                    if (j1 == blockpos.m_123341_() && l22 == blockpos.m_123342_() && j22 == blockpos.m_123343_()) continue;
                    chunkrenderdispatcher$renderchunk.m_112801_(j1, l22, j22);
                }
            }
        }
    }

    public void m_110859_(int sectionX, int sectionY, int sectionZ, boolean rerenderOnMainThread) {
        int i2 = Math.floorMod(sectionX, this.f_110841_);
        int j2 = Math.floorMod(sectionY - this.f_110839_.m_151560_(), this.f_110840_);
        int k2 = Math.floorMod(sectionZ, this.f_110842_);
        ChunkRenderDispatcher.RenderChunk chunkrenderdispatcher$renderchunk = this.f_110843_[this.m_110855_(i2, j2, k2)];
        chunkrenderdispatcher$renderchunk.m_112828_(rerenderOnMainThread);
    }

    @Nullable
    public ChunkRenderDispatcher.RenderChunk m_110866_(BlockPos pos) {
        int i2 = pos.m_123341_() >> 4;
        int j2 = pos.m_123342_() - this.f_110839_.m_141937_() >> 4;
        int k2 = pos.m_123343_() >> 4;
        if (j2 >= 0 && j2 < this.f_110840_) {
            i2 = Mth.m_14100_((int)i2, (int)this.f_110841_);
            k2 = Mth.m_14100_((int)k2, (int)this.f_110842_);
            return this.f_110843_[this.m_110855_(i2, j2, k2)];
        }
        return null;
    }

    private void updateVboRegion(ChunkRenderDispatcher.RenderChunk renderChunk) {
        int ix;
        BlockPos pos = renderChunk.m_112839_();
        int rx = pos.m_123341_() >> 8 << 8;
        int rz = pos.m_123343_() >> 8 << 8;
        ChunkPos cp = new ChunkPos(rx, rz);
        RenderType[] layers = RenderType.CHUNK_RENDER_TYPES;
        VboRegion[] regions = (VboRegion[])this.mapVboRegions.get(cp);
        if (regions == null) {
            regions = new VboRegion[layers.length];
            for (ix = 0; ix < layers.length; ++ix) {
                if (layers[ix].isNeedsSorting()) continue;
                regions[ix] = new VboRegion(layers[ix]);
            }
            this.mapVboRegions.put(cp, regions);
        }
        for (ix = 0; ix < layers.length; ++ix) {
            RenderType layer = layers[ix];
            VboRegion vr = regions[ix];
            renderChunk.m_112807_(layer).setVboRegion(vr);
        }
    }

    public void deleteVboRegions() {
        Set keys = this.mapVboRegions.keySet();
        for (ChunkPos cp : keys) {
            VboRegion[] vboRegions = (VboRegion[])this.mapVboRegions.get(cp);
            for (int i2 = 0; i2 < vboRegions.length; ++i2) {
                VboRegion vboRegion = vboRegions[i2];
                if (vboRegion != null) {
                    vboRegion.deleteGlBuffers();
                }
                vboRegions[i2] = null;
            }
        }
        this.mapVboRegions.clear();
    }

    public int getHighestUsedChunkIndex(int chunkX, int minChunkIndex, int chunkZ) {
        chunkX = Mth.m_14100_((int)chunkX, (int)this.f_110841_);
        minChunkIndex = Mth.m_14045_((int)minChunkIndex, (int)0, (int)this.f_110840_);
        chunkZ = Mth.m_14100_((int)chunkZ, (int)this.f_110842_);
        for (int chunkY = this.f_110840_ - 1; chunkY >= minChunkIndex; --chunkY) {
            ChunkRenderDispatcher.RenderChunk rc = this.f_110843_[this.m_110855_(chunkX, chunkY, chunkZ)];
            if (rc.m_112835_().m_112757_()) continue;
            return chunkY;
        }
        return -1;
    }
}

