/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.dimension.DimensionType;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorMethod;
import net.optifine.shaders.Shaders;
import net.optifine.util.TextureUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class LightTexture
implements AutoCloseable {
    public static final int f_173040_ = 0xF000F0;
    public static final int f_173041_ = 0xF00000;
    public static final int f_173042_ = 240;
    private final DynamicTexture f_109870_;
    private final NativeImage f_109871_;
    private final ResourceLocation f_109872_;
    private boolean f_109873_;
    private float f_109874_;
    private final GameRenderer f_109875_;
    private final Minecraft f_109876_;
    private boolean allowed = true;
    private boolean custom = false;
    private Vector3f tempVector = new Vector3f();
    public static final int MAX_BRIGHTNESS = LightTexture.m_109885_((int)15, (int)15);

    public LightTexture(GameRenderer entityRendererIn, Minecraft mcIn) {
        this.f_109875_ = entityRendererIn;
        this.f_109876_ = mcIn;
        this.f_109870_ = new DynamicTexture(16, 16, false);
        this.f_109872_ = this.f_109876_.m_91097_().m_118490_("light_map", this.f_109870_);
        this.f_109871_ = this.f_109870_.m_117991_();
        for (int i2 = 0; i2 < 16; ++i2) {
            for (int j2 = 0; j2 < 16; ++j2) {
                this.f_109871_.m_84988_(j2, i2, -1);
            }
        }
        this.f_109870_.m_117985_();
    }

    @Override
    public void close() {
        this.f_109870_.close();
    }

    public void m_109880_() {
        this.f_109874_ += (float)((Math.random() - Math.random()) * Math.random() * Math.random() * 0.1);
        this.f_109874_ *= 0.9f;
        this.f_109873_ = true;
    }

    public void m_109891_() {
        RenderSystem.m_157453_((int)2, (int)0);
        if (Config.isShaders()) {
            Shaders.disableLightmap();
        }
    }

    public void m_109896_() {
        if (!this.allowed) {
            RenderSystem.m_157456_((int)2, (ResourceLocation)TextureUtils.WHITE_TEXTURE_LOCATION);
            this.f_109876_.m_91097_().m_174784_(TextureUtils.WHITE_TEXTURE_LOCATION);
        } else {
            RenderSystem.m_157456_((int)2, (ResourceLocation)this.f_109872_);
            this.f_109876_.m_91097_().m_174784_(this.f_109872_);
        }
        RenderSystem.m_69937_((int)3553, (int)10241, (int)9729);
        RenderSystem.m_69937_((int)3553, (int)10240, (int)9729);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (Config.isShaders()) {
            Shaders.enableLightmap();
        }
    }

    private float m_234319_(float partialTicks) {
        MobEffectInstance mobeffectinstance;
        if (this.f_109876_.f_91074_.m_21023_(MobEffects.f_216964_) && (mobeffectinstance = this.f_109876_.f_91074_.m_21124_(MobEffects.f_216964_)) != null && mobeffectinstance.m_216895_().isPresent()) {
            return ((MobEffectInstance.FactorData)mobeffectinstance.m_216895_().get()).m_238413_((LivingEntity)this.f_109876_.f_91074_, partialTicks);
        }
        return 0.0f;
    }

    private float m_234312_(LivingEntity entityIn, float gammaIn, float partialTicks) {
        float f2 = 0.45f * gammaIn;
        return Math.max(0.0f, Mth.m_14089_((float)(((float)entityIn.f_19797_ - partialTicks) * (float)Math.PI * 0.025f)) * f2);
    }

    public void m_109881_(float partialTicks) {
        if (this.f_109873_) {
            this.f_109873_ = false;
            this.f_109876_.m_91307_().m_6180_("lightTex");
            ClientLevel clientlevel = this.f_109876_.f_91073_;
            if (clientlevel != null) {
                float darkLightFactor;
                float darkGammaFactor;
                float darkLight;
                boolean nightVision;
                this.custom = false;
                if (Config.isCustomColors() && CustomColors.updateLightmap((ClientLevel)clientlevel, (float)this.f_109874_, (NativeImage)this.f_109871_, (boolean)(nightVision = this.f_109876_.f_91074_.m_21023_(MobEffects.f_19611_) || this.f_109876_.f_91074_.m_21023_(MobEffects.f_19592_)), (float)(darkLight = (darkGammaFactor = this.getDarknessGammaFactor(partialTicks)) * 0.25f + (darkLightFactor = this.getDarknessLightFactor(clientlevel, partialTicks)) * 0.75f), (float)partialTicks)) {
                    this.f_109870_.m_117985_();
                    this.f_109873_ = false;
                    this.f_109876_.m_91307_().m_7238_();
                    this.custom = true;
                    return;
                }
                float f2 = clientlevel.m_104805_(1.0f);
                float f1 = clientlevel.m_104819_() > 0 ? 1.0f : f2 * 0.95f + 0.05f;
                float f22 = ((Double)this.f_109876_.f_91066_.m_231926_().m_231551_()).floatValue();
                float f3 = this.m_234319_(partialTicks) * f22;
                float f4 = this.m_234312_((LivingEntity)this.f_109876_.f_91074_, f3, partialTicks) * f22;
                if (Config.isShaders()) {
                    Shaders.setDarknessFactor((float)f3);
                    Shaders.setDarknessLightFactor((float)f4);
                }
                float f6 = this.f_109876_.f_91074_.m_108639_();
                float f5 = this.f_109876_.f_91074_.m_21023_(MobEffects.f_19611_) ? GameRenderer.m_109108_((LivingEntity)this.f_109876_.f_91074_, (float)partialTicks) : (f6 > 0.0f && this.f_109876_.f_91074_.m_21023_(MobEffects.f_19592_) ? f6 : 0.0f);
                Vector3f vector3f = new Vector3f(f2, f2, 1.0f);
                vector3f.m_122255_(new Vector3f(1.0f, 1.0f, 1.0f), 0.35f);
                float f7 = this.f_109874_ + 1.5f;
                Vector3f vector3f1 = new Vector3f();
                for (int i2 = 0; i2 < 16; ++i2) {
                    for (int j2 = 0; j2 < 16; ++j2) {
                        float f13;
                        float f8 = LightTexture.m_234316_((DimensionType)clientlevel.m_6042_(), (int)i2) * f1;
                        float f9 = LightTexture.m_234316_((DimensionType)clientlevel.m_6042_(), (int)j2) * f7;
                        float f10 = f9 * ((f9 * 0.6f + 0.4f) * 0.6f + 0.4f);
                        float f11 = f9 * (f9 * f9 * 0.6f + 0.4f);
                        vector3f1.m_122245_(f9, f10, f11);
                        boolean flag = clientlevel.m_104583_().m_108884_();
                        if (flag) {
                            vector3f1.m_122255_(this.getTempVector3f(0.99f, 1.12f, 1.0f), 0.25f);
                            vector3f1.m_122242_(0.0f, 1.0f);
                        } else {
                            Vector3f vector3f2 = this.getTempCopy(vector3f);
                            vector3f2.m_122261_(f8);
                            vector3f1.m_122253_(vector3f2);
                            vector3f1.m_122255_(this.getTempVector3f(0.75f, 0.75f, 0.75f), 0.04f);
                            if (this.f_109875_.m_109131_(partialTicks) > 0.0f) {
                                float f12 = this.f_109875_.m_109131_(partialTicks);
                                Vector3f vector3f3 = this.getTempCopy(vector3f1);
                                vector3f3.m_122263_(0.7f, 0.6f, 0.6f);
                                vector3f1.m_122255_(vector3f3, f12);
                            }
                        }
                        if (Reflector.IForgeDimensionSpecialEffects_adjustLightmapColors.exists()) {
                            Reflector.call((Object)clientlevel.m_104583_(), (ReflectorMethod)Reflector.IForgeDimensionSpecialEffects_adjustLightmapColors, (Object[])new Object[]{clientlevel, Float.valueOf(partialTicks), Float.valueOf(f2), Float.valueOf(f7), Float.valueOf(f8), j2, i2, vector3f1});
                        }
                        if (f5 > 0.0f && (f13 = Math.max(vector3f1.m_122239_(), Math.max(vector3f1.m_122260_(), vector3f1.m_122269_()))) < 1.0f) {
                            float f15 = 1.0f / f13;
                            Vector3f vector3f5 = this.getTempCopy(vector3f1);
                            vector3f5.m_122261_(f15);
                            vector3f1.m_122255_(vector3f5, f5);
                        }
                        if (!flag) {
                            if (f4 > 0.0f) {
                                vector3f1.m_122272_(-f4, -f4, -f4);
                            }
                            vector3f1.m_122242_(0.0f, 1.0f);
                        }
                        float f14 = ((Double)this.f_109876_.f_91066_.m_231927_().m_231551_()).floatValue();
                        Vector3f vector3f4 = this.getTempCopy(vector3f1);
                        vector3f4.m_122258_(arg_0 -> this.m_109892_(arg_0));
                        vector3f1.m_122255_(vector3f4, Math.max(0.0f, f14 - f3));
                        vector3f1.m_122255_(this.getTempVector3f(0.75f, 0.75f, 0.75f), 0.04f);
                        vector3f1.m_122242_(0.0f, 1.0f);
                        vector3f1.m_122261_(255.0f);
                        int j1 = 255;
                        int k2 = (int)vector3f1.m_122239_();
                        int l2 = (int)vector3f1.m_122260_();
                        int i1 = (int)vector3f1.m_122269_();
                        this.f_109871_.m_84988_(j2, i2, 0xFF000000 | i1 << 16 | l2 << 8 | k2);
                    }
                }
                this.f_109870_.m_117985_();
                this.f_109876_.m_91307_().m_7238_();
            }
        }
    }

    private float m_109892_(float valueIn) {
        float f2 = 1.0f - valueIn;
        return 1.0f - f2 * f2 * f2 * f2;
    }

    public static float m_234316_(DimensionType dimensionIn, int lightLevelIn) {
        float f2 = (float)lightLevelIn / 15.0f;
        float f1 = f2 / (4.0f - 3.0f * f2);
        return Mth.m_14179_((float)dimensionIn.f_63838_(), (float)f1, (float)1.0f);
    }

    public static int m_109885_(int blockLightIn, int skyLightIn) {
        return blockLightIn << 4 | skyLightIn << 20;
    }

    public static int m_109883_(int packedLightIn) {
        return (packedLightIn & 0xFFFF) >> 4;
    }

    public static int m_109894_(int packedLightIn) {
        return packedLightIn >> 20 & 0xFFFF;
    }

    private Vector3f getTempVector3f(float x, float y, float z) {
        this.tempVector.m_122245_(x, y, z);
        return this.tempVector;
    }

    private Vector3f getTempCopy(Vector3f vec) {
        this.tempVector.m_122245_(vec.m_122239_(), vec.m_122260_(), vec.m_122269_());
        return this.tempVector;
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public void setAllowed(boolean allowed) {
        this.allowed = allowed;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public float getDarknessGammaFactor(float partialTicks) {
        float darknessScale = ((Double)this.f_109876_.f_91066_.m_231926_().m_231551_()).floatValue();
        float darknessGamma = this.m_234319_(partialTicks) * darknessScale;
        return darknessGamma;
    }

    public float getDarknessLightFactor(ClientLevel clientLevel, float partialTicks) {
        boolean forceBrightness = clientLevel.m_104583_().m_108884_();
        if (forceBrightness) {
            return 0.0f;
        }
        float darknessScale = ((Double)this.f_109876_.f_91066_.m_231926_().m_231551_()).floatValue();
        float darknessGamma = this.m_234319_(partialTicks) * darknessScale;
        float darknessLightFactor = this.m_234312_((LivingEntity)this.f_109876_.f_91074_, darknessGamma, partialTicks) * darknessScale;
        return darknessLightFactor;
    }
}

