/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model.geom;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntities;
import net.optifine.entity.model.CustomEntityModels;
import net.optifine.entity.model.anim.ModelUpdater;
import net.optifine.model.ModelSprite;
import net.optifine.render.VertexPosition;
import net.optifine.shaders.Shaders;

public final class ModelPart {
    public static final float f_233552_ = 1.0f;
    public float f_104200_;
    public float f_104201_;
    public float f_104202_;
    public float f_104203_;
    public float f_104204_;
    public float f_104205_;
    public float f_233553_ = 1.0f;
    public float f_233554_ = 1.0f;
    public float f_233555_ = 1.0f;
    public boolean f_104207_ = true;
    public boolean f_233556_;
    public final List<Cube> f_104212_;
    public final Map<String, ModelPart> f_104213_;
    public List<ModelPart> childModelsList;
    public List<ModelSprite> spriteList = new ArrayList();
    public boolean mirrorV = false;
    private ResourceLocation textureLocation = null;
    private String id = null;
    private ModelUpdater modelUpdater;
    private LevelRenderer renderGlobal = Config.getRenderGlobal();
    private boolean custom;
    public float textureWidth = 64.0f;
    public float textureHeight = 32.0f;
    public int textureOffsetX;
    public int textureOffsetY;
    public boolean mirror;
    private PartPose f_233557_ = PartPose.f_171404_;

    public ModelPart setTextureOffset(int x, int y) {
        this.textureOffsetX = x;
        this.textureOffsetY = y;
        return this;
    }

    public ModelPart setTextureSize(int textureWidthIn, int textureHeightIn) {
        this.textureWidth = textureWidthIn;
        this.textureHeight = textureHeightIn;
        return this;
    }

    public ModelPart(List<Cube> cubeListIn, Map<String, ModelPart> childModelsIn) {
        if (cubeListIn instanceof ImmutableList) {
            cubeListIn = new ArrayList<Cube>(cubeListIn);
        }
        this.f_104212_ = cubeListIn;
        this.f_104213_ = childModelsIn;
        this.childModelsList = new ArrayList(this.f_104213_.values());
    }

    public PartPose m_171308_() {
        return PartPose.m_171423_((float)this.f_104200_, (float)this.f_104201_, (float)this.f_104202_, (float)this.f_104203_, (float)this.f_104204_, (float)this.f_104205_);
    }

    public PartPose m_233566_() {
        return this.f_233557_;
    }

    public void m_233560_(PartPose partPoseIn) {
        this.f_233557_ = partPoseIn;
    }

    public void m_233569_() {
        this.m_171322_(this.f_233557_);
    }

    public void m_171322_(PartPose partPoseIn) {
        if (this.custom) {
            return;
        }
        this.f_104200_ = partPoseIn.f_171405_;
        this.f_104201_ = partPoseIn.f_171406_;
        this.f_104202_ = partPoseIn.f_171407_;
        this.f_104203_ = partPoseIn.f_171408_;
        this.f_104204_ = partPoseIn.f_171409_;
        this.f_104205_ = partPoseIn.f_171410_;
        this.f_233553_ = 1.0f;
        this.f_233554_ = 1.0f;
        this.f_233555_ = 1.0f;
    }

    public void m_104315_(ModelPart modelRendererIn) {
        this.f_233553_ = modelRendererIn.f_233553_;
        this.f_233554_ = modelRendererIn.f_233554_;
        this.f_233555_ = modelRendererIn.f_233555_;
        this.f_104203_ = modelRendererIn.f_104203_;
        this.f_104204_ = modelRendererIn.f_104204_;
        this.f_104205_ = modelRendererIn.f_104205_;
        this.f_104200_ = modelRendererIn.f_104200_;
        this.f_104201_ = modelRendererIn.f_104201_;
        this.f_104202_ = modelRendererIn.f_104202_;
    }

    public boolean m_233562_(String keyIn) {
        return this.f_104213_.containsKey(keyIn);
    }

    public ModelPart m_171324_(String nameIn) {
        ModelPart modelpart = (ModelPart)this.f_104213_.get(nameIn);
        if (modelpart == null) {
            throw new NoSuchElementException("Can't find part " + nameIn);
        }
        return modelpart;
    }

    public void m_104227_(float rotationPointXIn, float rotationPointYIn, float rotationPointZIn) {
        this.f_104200_ = rotationPointXIn;
        this.f_104201_ = rotationPointYIn;
        this.f_104202_ = rotationPointZIn;
    }

    public void m_171327_(float xRotIn, float yRotIn, float zRotIn) {
        this.f_104203_ = xRotIn;
        this.f_104204_ = yRotIn;
        this.f_104205_ = zRotIn;
    }

    public void m_104301_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn) {
        this.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void m_104306_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha, true);
    }

    public void render(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha, boolean updateModel) {
        if (!(!this.f_104207_ || this.f_104212_.isEmpty() && this.f_104213_.isEmpty() && this.spriteList.isEmpty())) {
            RenderType lastRenderType = null;
            MultiBufferSource.BufferSource renderTypeBuffer = null;
            if (this.textureLocation != null) {
                if (this.renderGlobal.renderOverlayEyes) {
                    return;
                }
                renderTypeBuffer = bufferIn.getRenderTypeBuffer();
                if (renderTypeBuffer != null) {
                    VertexConsumer secondaryBuilder = bufferIn.getSecondaryBuilder();
                    lastRenderType = renderTypeBuffer.getLastRenderType();
                    bufferIn = renderTypeBuffer.getBuffer(this.textureLocation, bufferIn);
                    if (secondaryBuilder != null) {
                        bufferIn = VertexMultiConsumer.m_86168_((VertexConsumer)secondaryBuilder, (VertexConsumer)bufferIn);
                    }
                }
            }
            if (updateModel && CustomEntityModels.isActive()) {
                this.updateModel();
            }
            matrixStackIn.m_85836_();
            this.m_104299_(matrixStackIn);
            if (!this.f_233556_) {
                this.m_104290_(matrixStackIn.m_85850_(), bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
            int childModelsSize = this.childModelsList.size();
            for (int ix = 0; ix < childModelsSize; ++ix) {
                ModelPart modelpart = (ModelPart)this.childModelsList.get(ix);
                modelpart.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha, false);
            }
            int spriteListSize = this.spriteList.size();
            for (int ix = 0; ix < spriteListSize; ++ix) {
                ModelSprite sprite = (ModelSprite)this.spriteList.get(ix);
                sprite.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
            matrixStackIn.m_85849_();
            if (lastRenderType != null) {
                renderTypeBuffer.m_6299_(lastRenderType);
            }
        }
    }

    public void m_171309_(PoseStack matrixStackIn, Visitor visitorIn) {
        this.m_171312_(matrixStackIn, visitorIn, "");
    }

    private void m_171312_(PoseStack matrixStackIn, Visitor visitorIn, String pathIn) {
        if (!this.f_104212_.isEmpty() || !this.f_104213_.isEmpty()) {
            matrixStackIn.m_85836_();
            this.m_104299_(matrixStackIn);
            PoseStack.Pose posestack$pose = matrixStackIn.m_85850_();
            for (int i2 = 0; i2 < this.f_104212_.size(); ++i2) {
                visitorIn.m_171341_(posestack$pose, pathIn, i2, (Cube)this.f_104212_.get(i2));
            }
            String s = pathIn + "/";
            this.f_104213_.forEach((p_171316_3_, p_171316_4_) -> p_171316_4_.m_171312_(matrixStackIn, visitorIn, s + p_171316_3_));
            matrixStackIn.m_85849_();
        }
    }

    public void m_104299_(PoseStack matrixStackIn) {
        matrixStackIn.m_85837_((double)(this.f_104200_ / 16.0f), (double)(this.f_104201_ / 16.0f), (double)(this.f_104202_ / 16.0f));
        if (this.f_104205_ != 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122270_(this.f_104205_));
        }
        if (this.f_104204_ != 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122270_(this.f_104204_));
        }
        if (this.f_104203_ != 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122270_(this.f_104203_));
        }
        if (this.f_233553_ != 1.0f || this.f_233554_ != 1.0f || this.f_233555_ != 1.0f) {
            matrixStackIn.m_85841_(this.f_233553_, this.f_233554_, this.f_233555_);
        }
    }

    private void m_104290_(PoseStack.Pose matrixEntryIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        boolean shadersVelocity = Config.isShaders() && Shaders.useVelocityAttrib && Config.isMinecraftThread();
        int cubeListSize = this.f_104212_.size();
        for (int ic = 0; ic < cubeListSize; ++ic) {
            IRandomEntity entity;
            Cube modelpart$cube = (Cube)this.f_104212_.get(ic);
            VertexPosition[][] boxPos = null;
            if (shadersVelocity && (entity = RandomEntities.getRandomEntityRendered()) != null) {
                boxPos = modelpart$cube.getBoxVertexPositions(entity.getId());
            }
            modelpart$cube.compile(matrixEntryIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha, boxPos);
        }
    }

    public Cube m_233558_(RandomSource randomIn) {
        return (Cube)this.f_104212_.get(randomIn.m_188503_(this.f_104212_.size()));
    }

    public boolean m_171326_() {
        return this.f_104212_.isEmpty();
    }

    public void m_233564_(Vector3f vecIn) {
        this.f_104200_ += vecIn.m_122239_();
        this.f_104201_ += vecIn.m_122260_();
        this.f_104202_ += vecIn.m_122269_();
    }

    public void m_233567_(Vector3f vecIn) {
        this.f_104203_ += vecIn.m_122239_();
        this.f_104204_ += vecIn.m_122260_();
        this.f_104205_ += vecIn.m_122269_();
    }

    public void m_233570_(Vector3f vecIn) {
        this.f_233553_ += vecIn.m_122239_();
        this.f_233554_ += vecIn.m_122260_();
        this.f_233555_ += vecIn.m_122269_();
    }

    public Stream<ModelPart> m_171331_() {
        return Stream.concat(Stream.of(this), this.f_104213_.values().stream().flatMap(ModelPart::m_171331_));
    }

    public void addSprite(float posX, float posY, float posZ, int sizeX, int sizeY, int sizeZ, float sizeAdd) {
        this.spriteList.add(new ModelSprite(this, this.textureOffsetX, this.textureOffsetY, posX, posY, posZ, sizeX, sizeY, sizeZ, sizeAdd));
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    public void setTextureLocation(ResourceLocation textureLocation) {
        this.textureLocation = textureLocation;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void addBox(int[][] faceUvs, float x, float y, float z, float dx, float dy, float dz, float delta) {
        this.f_104212_.add(new Cube(faceUvs, x, y, z, dx, dy, dz, delta, delta, delta, this.mirror, this.textureWidth, this.textureHeight));
    }

    public void addBox(float x, float y, float z, float width, float height, float depth, float delta) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, delta, delta, delta, this.mirror, false);
    }

    private void addBox(int texOffX, int texOffY, float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ, boolean mirror, boolean dummyIn) {
        this.f_104212_.add(new Cube(texOffX, texOffY, x, y, z, width, height, depth, deltaX, deltaY, deltaZ, mirror, this.textureWidth, this.textureHeight));
    }

    public ModelPart getChildModelDeep(String name) {
        if (name == null) {
            return null;
        }
        if (this.f_104213_.containsKey(name)) {
            return this.m_171324_(name);
        }
        if (this.f_104213_ != null) {
            Set keys = this.f_104213_.keySet();
            for (String key : keys) {
                ModelPart child = (ModelPart)this.f_104213_.get(key);
                ModelPart mr = child.getChildModelDeep(name);
                if (mr == null) continue;
                return mr;
            }
        }
        return null;
    }

    public ModelPart getChild(String id) {
        if (id == null) {
            return null;
        }
        if (this.f_104213_ != null) {
            Set keys = this.f_104213_.keySet();
            for (String key : keys) {
                ModelPart child = (ModelPart)this.f_104213_.get(key);
                if (!id.equals(child.getId())) continue;
                return child;
            }
        }
        return null;
    }

    public ModelPart getChildDeep(String id) {
        if (id == null) {
            return null;
        }
        ModelPart mrChild = this.getChild(id);
        if (mrChild != null) {
            return mrChild;
        }
        if (this.f_104213_ != null) {
            Set keys = this.f_104213_.keySet();
            for (String key : keys) {
                ModelPart child = (ModelPart)this.f_104213_.get(key);
                ModelPart mr = child.getChildDeep(id);
                if (mr == null) continue;
                return mr;
            }
        }
        return null;
    }

    public void setModelUpdater(ModelUpdater modelUpdater) {
        this.modelUpdater = modelUpdater;
    }

    public void addChildModel(String name, ModelPart part) {
        if (part == null) {
            return;
        }
        this.f_104213_.put(name, part);
        this.childModelsList = new ArrayList(this.f_104213_.values());
    }

    public String getUniqueChildModelName(String name) {
        String baseName = name;
        int counter = 2;
        while (this.f_104213_.containsKey(name)) {
            name = baseName + "-" + counter;
            ++counter;
        }
        return name;
    }

    private void updateModel() {
        if (this.modelUpdater != null) {
            this.modelUpdater.update();
        }
        int childModelsSize = this.childModelsList.size();
        for (int ix = 0; ix < childModelsSize; ++ix) {
            ModelPart modelpart = (ModelPart)this.childModelsList.get(ix);
            modelpart.updateModel();
        }
    }

    public boolean isCustom() {
        return this.custom;
    }

    public void setCustom(boolean custom) {
        this.custom = custom;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("id: " + this.id + ", boxes: " + (this.f_104212_ != null ? Integer.valueOf(this.f_104212_.size()) : null) + ", submodels: " + (this.f_104213_ != null ? Integer.valueOf(this.f_104213_.size()) : null));
        return sb.toString();
    }
}

