/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.optifine.Config;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorMethod;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class Screenshot {
    private static final Logger f_92276_ = LogUtils.getLogger();
    private int f_168594_;
    private final DataOutputStream f_168595_;
    private final byte[] f_168596_;
    private final int f_168597_;
    private final int f_168598_;
    private File f_168599_;

    public static void m_92289_(File gameDirectory, RenderTarget buffer, Consumer<Component> messageConsumer) {
        Screenshot.m_92295_((File)gameDirectory, (String)null, (RenderTarget)buffer, messageConsumer);
    }

    public static void m_92295_(File gameDirectory, @Nullable String screenshotName, RenderTarget buffer, Consumer<Component> messageConsumer) {
        if (!RenderSystem.m_69586_()) {
            RenderSystem.m_69879_(() -> Screenshot.m_92305_((File)gameDirectory, (String)screenshotName, (RenderTarget)buffer, (Consumer)messageConsumer));
        } else {
            Screenshot.m_92305_((File)gameDirectory, (String)screenshotName, (RenderTarget)buffer, messageConsumer);
        }
    }

    private static void m_92305_(File gameDirectory, @Nullable String screenshotName, RenderTarget buffer, Consumer<Component> messageConsumer) {
        boolean resize;
        Minecraft mc = Config.getMinecraft();
        Window mainWindow = mc.m_91268_();
        Options gameSettings = Config.getGameSettings();
        int fbWidth = mainWindow.m_85441_();
        int fbHeight = mainWindow.m_85442_();
        int guiScaleOld = (Integer)gameSettings.m_231928_().m_231551_();
        int guiScale = mainWindow.m_85385_(((Integer)mc.f_91066_.m_231928_().m_231551_()).intValue(), ((Boolean)mc.f_91066_.m_231819_().m_231551_()).booleanValue());
        int mul = Config.getScreenshotSize();
        boolean bl = resize = GLX.isUsingFBOs() && mul > 1;
        if (resize) {
            gameSettings.m_231928_().m_231514_((Object)(guiScale * mul));
            try {
                mainWindow.resizeFramebuffer(fbWidth * mul, fbHeight * mul);
            }
            catch (Exception e2) {
                f_92276_.warn("Couldn't save screenshot", (Throwable)e2);
                messageConsumer.accept((Component)Component.m_237110_((String)"screenshot.failure", (Object[])new Object[]{e2.getMessage()}));
            }
            GlStateManager.clear((int)16640);
            mc.m_91385_().m_83947_(true);
            GlStateManager.m_84109_();
            RenderSystem.m_157191_().m_85836_();
            mc.f_91063_.m_109093_(GameRenderer.getRenderPartialTicks(), System.nanoTime(), true);
            RenderSystem.m_157191_().m_85849_();
            RenderSystem.m_157182_();
        }
        NativeImage nativeimage = Screenshot.m_92279_((RenderTarget)buffer);
        if (resize) {
            mc.m_91385_().m_83970_();
            Config.getGameSettings().m_231928_().m_231514_((Object)guiScaleOld);
            mainWindow.resizeFramebuffer(fbWidth, fbHeight);
        }
        File file1 = new File(gameDirectory, "screenshots");
        file1.mkdir();
        File file2 = screenshotName == null ? Screenshot.m_92287_((File)file1) : new File(file1, screenshotName);
        Object event = null;
        if (Reflector.ForgeHooksClient_onScreenshot.exists()) {
            event = Reflector.call((ReflectorMethod)Reflector.ForgeHooksClient_onScreenshot, (Object[])new Object[]{nativeimage, file2});
            if (Reflector.callBoolean((Object)event, (ReflectorMethod)Reflector.Event_isCanceled, (Object[])new Object[0])) {
                Component msg = (Component)Reflector.call((Object)event, (ReflectorMethod)Reflector.ScreenshotEvent_getCancelMessage, (Object[])new Object[0]);
                messageConsumer.accept(msg);
                return;
            }
            file2 = (File)Reflector.call((Object)event, (ReflectorMethod)Reflector.ScreenshotEvent_getScreenshotFile, (Object[])new Object[0]);
        }
        File target = file2;
        Object eventF = event;
        Util.m_183992_().execute(() -> {
            try {
                nativeimage.m_85056_(target);
                MutableComponent component = Component.m_237113_((String)target.getName()).m_130940_(ChatFormatting.UNDERLINE).m_130938_(p_168606_1_ -> p_168606_1_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, target.getAbsolutePath())));
                if (eventF != null && Reflector.call((Object)eventF, (ReflectorMethod)Reflector.ScreenshotEvent_getResultMessage, (Object[])new Object[0]) != null) {
                    messageConsumer.accept((Component)Reflector.call((Object)eventF, (ReflectorMethod)Reflector.ScreenshotEvent_getResultMessage, (Object[])new Object[0]));
                } else {
                    messageConsumer.accept((Component)Component.m_237110_((String)"screenshot.success", (Object[])new Object[]{component}));
                }
            }
            catch (Exception exception) {
                f_92276_.warn("Couldn't save screenshot", (Throwable)exception);
                messageConsumer.accept((Component)Component.m_237110_((String)"screenshot.failure", (Object[])new Object[]{exception.getMessage()}));
            }
            finally {
                nativeimage.close();
            }
        });
    }

    public static NativeImage m_92279_(RenderTarget framebufferIn) {
        if (!GLX.isUsingFBOs()) {
            NativeImage nativeimage = new NativeImage(framebufferIn.f_83915_, framebufferIn.f_83916_, false);
            nativeimage.downloadFromFramebuffer();
            nativeimage.m_85122_();
            return nativeimage;
        }
        int i2 = framebufferIn.f_83915_;
        int j2 = framebufferIn.f_83916_;
        NativeImage nativeimage = new NativeImage(i2, j2, false);
        RenderSystem.m_69396_((int)framebufferIn.m_83975_());
        nativeimage.m_85045_(0, true);
        nativeimage.m_85122_();
        return nativeimage;
    }

    private static File m_92287_(File gameDirectory) {
        String s = Util.m_241986_();
        int i2 = 1;
        File file1;
        while ((file1 = new File(gameDirectory, s + (String)(i2 == 1 ? "" : "_" + i2) + ".png")).exists()) {
            ++i2;
        }
        return file1;
    }

    public Screenshot(File fileIn, int widthIn, int heightIn, int rowHeightIn) throws IOException {
        this.f_168597_ = widthIn;
        this.f_168598_ = heightIn;
        this.f_168594_ = rowHeightIn;
        File file1 = new File(fileIn, "screenshots");
        file1.mkdir();
        String s = "huge_" + Util.m_241986_();
        int i2 = 1;
        while ((this.f_168599_ = new File(file1, s + (String)(i2 == 1 ? "" : "_" + i2) + ".tga")).exists()) {
            ++i2;
        }
        byte[] abyte = new byte[18];
        abyte[2] = 2;
        abyte[12] = (byte)(widthIn % 256);
        abyte[13] = (byte)(widthIn / 256);
        abyte[14] = (byte)(heightIn % 256);
        abyte[15] = (byte)(heightIn / 256);
        abyte[16] = 24;
        this.f_168596_ = new byte[widthIn * rowHeightIn * 3];
        this.f_168595_ = new DataOutputStream(new FileOutputStream(this.f_168599_));
        this.f_168595_.write(abyte);
    }

    public void m_168609_(ByteBuffer p_168609_1_, int p_168609_2_, int p_168609_3_, int p_168609_4_, int p_168609_5_) {
        int i2 = p_168609_4_;
        int j2 = p_168609_5_;
        if (p_168609_4_ > this.f_168597_ - p_168609_2_) {
            i2 = this.f_168597_ - p_168609_2_;
        }
        if (p_168609_5_ > this.f_168598_ - p_168609_3_) {
            j2 = this.f_168598_ - p_168609_3_;
        }
        this.f_168594_ = j2;
        for (int k2 = 0; k2 < j2; ++k2) {
            p_168609_1_.position((p_168609_5_ - j2) * p_168609_4_ * 3 + k2 * p_168609_4_ * 3);
            int l2 = (p_168609_2_ + k2 * this.f_168597_) * 3;
            p_168609_1_.get(this.f_168596_, l2, i2 * 3);
        }
    }

    public void m_168605_() throws IOException {
        this.f_168595_.write(this.f_168596_, 0, this.f_168597_ * 3 * this.f_168594_);
    }

    public File m_168615_() throws IOException {
        this.f_168595_.close();
        return this.f_168599_;
    }
}

