/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.systems;

import com.google.common.collect.Queues;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.optifine.Config;
import net.optifine.CustomGuis;
import net.optifine.shaders.Shaders;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
@dyi
public class RenderSystem {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final ConcurrentLinkedQueue<dza> recordingQueue = Queues.newConcurrentLinkedQueue();
    private static final eas RENDER_THREAD_TESSELATOR = new eas();
    private static final int MINIMUM_ATLAS_TEXTURE_SIZE = 1024;
    private static boolean isReplayingQueue;
    @Nullable
    private static Thread gameThread;
    @Nullable
    private static Thread renderThread;
    private static int MAX_SUPPORTED_TEXTURE_SIZE;
    private static boolean isInInit;
    private static double lastDrawTime;
    private static final a sharedSequential;
    private static final a sharedSequentialQuad;
    private static final a sharedSequentialLines;
    private static c inverseViewRotationMatrix;
    private static d projectionMatrix;
    private static d savedProjectionMatrix;
    private static eaq modelViewStack;
    private static d modelViewMatrix;
    private static d textureMatrix;
    private static final int[] shaderTextures;
    private static final float[] shaderColor;
    private static float shaderFogStart;
    private static float shaderFogEnd;
    private static final float[] shaderFogColor;
    private static ead shaderFogShape;
    private static final k[] shaderLightDirections;
    private static float shaderGameTime;
    private static float shaderLineWidth;
    private static String apiDescription;
    @Nullable
    private static fad shader;
    private static boolean fogAllowed;
    private static boolean colorToAttribute;

    public static void initRenderThread() {
        if (renderThread != null || gameThread == Thread.currentThread()) {
            throw new IllegalStateException("Could not initialize render thread");
        }
        renderThread = Thread.currentThread();
    }

    public static boolean isOnRenderThread() {
        return Thread.currentThread() == renderThread;
    }

    public static boolean isOnRenderThreadOrInit() {
        return isInInit || RenderSystem.isOnRenderThread();
    }

    public static void initGameThread(boolean onRenderThreadIn) {
        boolean flag;
        boolean bl = flag = renderThread == Thread.currentThread();
        if (gameThread != null || renderThread == null || flag == onRenderThreadIn) {
            throw new IllegalStateException("Could not initialize tick thread");
        }
        gameThread = Thread.currentThread();
    }

    public static boolean isOnGameThread() {
        return true;
    }

    public static void assertInInitPhase() {
        if (!RenderSystem.isInInitPhase()) {
            throw RenderSystem.constructThreadException();
        }
    }

    public static void assertOnGameThreadOrInit() {
        if (!isInInit && !RenderSystem.isOnGameThread()) {
            throw RenderSystem.constructThreadException();
        }
    }

    public static void assertOnRenderThreadOrInit() {
        if (!isInInit && !RenderSystem.isOnRenderThread()) {
            throw RenderSystem.constructThreadException();
        }
    }

    public static void assertOnRenderThread() {
        if (!RenderSystem.isOnRenderThread()) {
            throw RenderSystem.constructThreadException();
        }
    }

    public static void assertOnGameThread() {
        if (!RenderSystem.isOnGameThread()) {
            throw RenderSystem.constructThreadException();
        }
    }

    private static IllegalStateException constructThreadException() {
        return new IllegalStateException("Rendersystem called from wrong thread");
    }

    public static boolean isInInitPhase() {
        return true;
    }

    public static void recordRenderCall(dza renderCallIn) {
        recordingQueue.add(renderCallIn);
    }

    public static void flipFrame(long handleIn) {
        GLFW.glfwPollEvents();
        RenderSystem.replayQueue();
        eas.a().c().g();
        GLFW.glfwSwapBuffers((long)handleIn);
        GLFW.glfwPollEvents();
    }

    public static void replayQueue() {
        isReplayingQueue = true;
        while (!recordingQueue.isEmpty()) {
            dza rendercall = (dza)recordingQueue.poll();
            rendercall.execute();
        }
        isReplayingQueue = false;
    }

    public static void limitDisplayFPS(int fpsLimitIn) {
        double d0 = lastDrawTime + 1.0 / (double)fpsLimitIn;
        double d1 = GLFW.glfwGetTime();
        while (d1 < d0) {
            GLFW.glfwWaitEventsTimeout((double)(d0 - d1));
            d1 = GLFW.glfwGetTime();
        }
        lastDrawTime = d1;
    }

    public static void disableDepthTest() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._disableDepthTest();
    }

    public static void enableDepthTest() {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._enableDepthTest();
    }

    public static void enableScissor(int x, int y, int width, int height) {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._enableScissorTest();
        GlStateManager._scissorBox((int)x, (int)y, (int)width, (int)height);
    }

    public static void disableScissor() {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._disableScissorTest();
    }

    public static void depthFunc(int depthFunc) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._depthFunc((int)depthFunc);
    }

    public static void depthMask(boolean depthMask) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._depthMask((boolean)depthMask);
    }

    public static void enableBlend() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._enableBlend();
    }

    public static void disableBlend() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._disableBlend();
    }

    public static void blendFunc(GlStateManager.SourceFactor srcFactor, GlStateManager.DestFactor dstFactor) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._blendFunc((int)srcFactor.value, (int)dstFactor.value);
    }

    public static void blendFunc(int srcFactor, int dstFactor) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._blendFunc((int)srcFactor, (int)dstFactor);
    }

    public static void blendFuncSeparate(GlStateManager.SourceFactor srcFactor, GlStateManager.DestFactor dstFactor, GlStateManager.SourceFactor srcFactorAlpha, GlStateManager.DestFactor dstFactorAlpha) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._blendFuncSeparate((int)srcFactor.value, (int)dstFactor.value, (int)srcFactorAlpha.value, (int)dstFactorAlpha.value);
    }

    public static void blendFuncSeparate(int srcFactor, int dstFactor, int srcFactorAlpha, int dstFactorAlpha) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._blendFuncSeparate((int)srcFactor, (int)dstFactor, (int)srcFactorAlpha, (int)dstFactorAlpha);
    }

    public static void blendEquation(int blendEquation) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._blendEquation((int)blendEquation);
    }

    public static void enableCull() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._enableCull();
    }

    public static void disableCull() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._disableCull();
    }

    public static void polygonMode(int face, int mode) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._polygonMode((int)face, (int)mode);
    }

    public static void enablePolygonOffset() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._enablePolygonOffset();
    }

    public static void disablePolygonOffset() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._disablePolygonOffset();
    }

    public static void polygonOffset(float factor, float units) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._polygonOffset((float)factor, (float)units);
    }

    public static void enableColorLogicOp() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._enableColorLogicOp();
    }

    public static void disableColorLogicOp() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._disableColorLogicOp();
    }

    public static void logicOp(GlStateManager.g logicOp) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._logicOp((int)logicOp.q);
    }

    public static void activeTexture(int textureIn) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._activeTexture((int)textureIn);
    }

    public static void enableTexture() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._enableTexture();
    }

    public static void disableTexture() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._disableTexture();
    }

    public static void texParameter(int target, int parameterName, int parameter) {
        GlStateManager._texParameter((int)target, (int)parameterName, (int)parameter);
    }

    public static void deleteTexture(int textureIn) {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._deleteTexture((int)textureIn);
    }

    public static void bindTextureForSetup(int textureIn) {
        RenderSystem.bindTexture((int)textureIn);
    }

    public static void bindTexture(int textureIn) {
        GlStateManager._bindTexture((int)textureIn);
    }

    public static void viewport(int x, int y, int width, int height) {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._viewport((int)x, (int)y, (int)width, (int)height);
    }

    public static void colorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._colorMask((boolean)red, (boolean)green, (boolean)blue, (boolean)alpha);
    }

    public static void stencilFunc(int func, int ref, int mask) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._stencilFunc((int)func, (int)ref, (int)mask);
    }

    public static void stencilMask(int mask) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._stencilMask((int)mask);
    }

    public static void stencilOp(int sfail, int dpfail, int dppass) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._stencilOp((int)sfail, (int)dpfail, (int)dppass);
    }

    public static void clearDepth(double depth) {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._clearDepth((double)depth);
    }

    public static void clearColor(float red, float green, float blue, float alpha) {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._clearColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void clearStencil(int index) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._clearStencil((int)index);
    }

    public static void clear(int mask, boolean checkError) {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._clear((int)mask, (boolean)checkError);
    }

    public static void setShaderFogStart(float fogStartIn) {
        RenderSystem.assertOnRenderThread();
        RenderSystem._setShaderFogStart((float)fogStartIn);
    }

    private static void _setShaderFogStart(float fogStartIn) {
        shaderFogStart = fogStartIn;
    }

    public static float getShaderFogStart() {
        if (!fogAllowed) {
            return Float.MAX_VALUE;
        }
        RenderSystem.assertOnRenderThread();
        return shaderFogStart;
    }

    public static void setShaderFogEnd(float fogEndIn) {
        RenderSystem.assertOnRenderThread();
        RenderSystem._setShaderFogEnd((float)fogEndIn);
    }

    private static void _setShaderFogEnd(float fogEndIn) {
        shaderFogEnd = fogEndIn;
    }

    public static float getShaderFogEnd() {
        if (!fogAllowed) {
            return Float.MAX_VALUE;
        }
        RenderSystem.assertOnRenderThread();
        return shaderFogEnd;
    }

    public static void setShaderFogColor(float red, float green, float blue, float alpha) {
        RenderSystem.assertOnRenderThread();
        RenderSystem._setShaderFogColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void setShaderFogColor(float red, float green, float blue) {
        RenderSystem.setShaderFogColor((float)red, (float)green, (float)blue, (float)1.0f);
    }

    private static void _setShaderFogColor(float red, float green, float blue, float alpha) {
        RenderSystem.shaderFogColor[0] = red;
        RenderSystem.shaderFogColor[1] = green;
        RenderSystem.shaderFogColor[2] = blue;
        RenderSystem.shaderFogColor[3] = alpha;
    }

    public static float[] getShaderFogColor() {
        RenderSystem.assertOnRenderThread();
        return shaderFogColor;
    }

    public static void setShaderFogShape(ead shapeIn) {
        RenderSystem.assertOnRenderThread();
        RenderSystem._setShaderFogShape((ead)shapeIn);
    }

    private static void _setShaderFogShape(ead shapeIn) {
        shaderFogShape = shapeIn;
    }

    public static ead getShaderFogShape() {
        RenderSystem.assertOnRenderThread();
        return shaderFogShape;
    }

    public static void setShaderLights(k dir1, k dir2) {
        RenderSystem.assertOnRenderThread();
        RenderSystem._setShaderLights((k)dir1, (k)dir2);
    }

    public static void _setShaderLights(k dir1, k dir2) {
        RenderSystem.shaderLightDirections[0] = dir1;
        RenderSystem.shaderLightDirections[1] = dir2;
    }

    public static void setupShaderLights(fad shaderInstanceIn) {
        RenderSystem.assertOnRenderThread();
        if (shaderInstanceIn.g != null) {
            shaderInstanceIn.g.a(shaderLightDirections[0]);
        }
        if (shaderInstanceIn.h != null) {
            shaderInstanceIn.h.a(shaderLightDirections[1]);
        }
    }

    public static void setShaderColor(float red, float green, float blue, float alpha) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._setShaderColor((float)red, (float)green, (float)blue, (float)alpha));
        } else {
            RenderSystem._setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
        }
    }

    private static void _setShaderColor(float red, float green, float blue, float alpha) {
        RenderSystem.shaderColor[0] = red;
        RenderSystem.shaderColor[1] = green;
        RenderSystem.shaderColor[2] = blue;
        RenderSystem.shaderColor[3] = alpha;
        if (colorToAttribute) {
            Shaders.setDefaultAttribColor((float)red, (float)green, (float)blue, (float)alpha);
        }
    }

    public static float[] getShaderColor() {
        RenderSystem.assertOnRenderThread();
        return shaderColor;
    }

    public static void drawElements(int mode, int count, int type) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._drawElements((int)mode, (int)count, (int)type, (long)0L);
    }

    public static void lineWidth(float widthIn) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                shaderLineWidth = widthIn;
            });
        } else {
            shaderLineWidth = widthIn;
        }
    }

    public static float getShaderLineWidth() {
        RenderSystem.assertOnRenderThread();
        return shaderLineWidth;
    }

    public static void pixelStore(int pname, int param) {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._pixelStore((int)pname, (int)param);
    }

    public static void readPixels(int x, int y, int width, int height, int format, int type, ByteBuffer pixels) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._readPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (ByteBuffer)pixels);
    }

    public static void getString(int nameIn, Consumer<String> consumerIn) {
        RenderSystem.assertOnRenderThread();
        consumerIn.accept(GlStateManager._getString((int)nameIn));
    }

    public static String getBackendDescription() {
        RenderSystem.assertInInitPhase();
        return String.format(Locale.ROOT, "LWJGL version %s", GLX._getLWJGLVersion());
    }

    public static String getApiDescription() {
        return apiDescription;
    }

    public static anb.a initBackendSystem() {
        RenderSystem.assertInInitPhase();
        return GLX._initGlfw()::getAsLong;
    }

    public static void initRenderer(int debugVerbosityIn, boolean debugSyncIn) {
        RenderSystem.assertInInitPhase();
        GLX._init((int)debugVerbosityIn, (boolean)debugSyncIn);
        apiDescription = GLX.getOpenGLVersionString();
    }

    public static void setErrorCallback(GLFWErrorCallbackI errorCallbackIn) {
        RenderSystem.assertInInitPhase();
        GLX._setGlfwErrorCallback((GLFWErrorCallbackI)errorCallbackIn);
    }

    public static void renderCrosshair(int heightIn) {
        RenderSystem.assertOnRenderThread();
        GLX._renderCrosshair((int)heightIn, (boolean)true, (boolean)true, (boolean)true);
    }

    public static String getCapsString() {
        RenderSystem.assertOnRenderThread();
        return "Using framebuffer using OpenGL 3.2";
    }

    public static void setupDefaultState(int x, int y, int width, int height) {
        RenderSystem.assertInInitPhase();
        GlStateManager._enableTexture();
        GlStateManager._clearDepth((double)1.0);
        GlStateManager._enableDepthTest();
        GlStateManager._depthFunc((int)515);
        projectionMatrix.b();
        savedProjectionMatrix.b();
        modelViewMatrix.b();
        textureMatrix.b();
        GlStateManager._viewport((int)x, (int)y, (int)width, (int)height);
    }

    public static int maxSupportedTextureSize() {
        if (MAX_SUPPORTED_TEXTURE_SIZE == -1) {
            RenderSystem.assertOnRenderThreadOrInit();
            int i2 = GlStateManager._getInteger((int)3379);
            for (int j2 = Math.max(32768, i2); j2 >= 1024; j2 >>= 1) {
                GlStateManager._texImage2D((int)32868, (int)0, (int)6408, (int)j2, (int)j2, (int)0, (int)6408, (int)5121, (IntBuffer)null);
                int k2 = GlStateManager._getTexLevelParameter((int)32868, (int)0, (int)4096);
                if (k2 == 0) continue;
                MAX_SUPPORTED_TEXTURE_SIZE = j2;
                return j2;
            }
            MAX_SUPPORTED_TEXTURE_SIZE = Math.max(i2, 1024);
            LOGGER.info("Failed to determine maximum texture size by probing, trying GL_MAX_TEXTURE_SIZE = {}", (Object)MAX_SUPPORTED_TEXTURE_SIZE);
        }
        return MAX_SUPPORTED_TEXTURE_SIZE;
    }

    public static void glBindBuffer(int target, IntSupplier buffer) {
        GlStateManager._glBindBuffer((int)target, (int)buffer.getAsInt());
    }

    public static void glBindVertexArray(Supplier<Integer> arrayIn) {
        GlStateManager._glBindVertexArray((int)arrayIn.get());
    }

    public static void glBufferData(int target, ByteBuffer data, int usage) {
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager._glBufferData((int)target, (ByteBuffer)data, (int)usage);
    }

    public static void glDeleteBuffers(int buffer) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glDeleteBuffers((int)buffer);
    }

    public static void glDeleteVertexArrays(int array) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glDeleteVertexArrays((int)array);
    }

    public static void glUniform1i(int location, int value) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform1i((int)location, (int)value);
    }

    public static void glUniform1(int location, IntBuffer value) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform1((int)location, (IntBuffer)value);
    }

    public static void glUniform2(int location, IntBuffer value) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform2((int)location, (IntBuffer)value);
    }

    public static void glUniform3(int location, IntBuffer value) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform3((int)location, (IntBuffer)value);
    }

    public static void glUniform4(int location, IntBuffer value) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform4((int)location, (IntBuffer)value);
    }

    public static void glUniform1(int location, FloatBuffer value) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform1((int)location, (FloatBuffer)value);
    }

    public static void glUniform2(int location, FloatBuffer value) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform2((int)location, (FloatBuffer)value);
    }

    public static void glUniform3(int location, FloatBuffer value) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform3((int)location, (FloatBuffer)value);
    }

    public static void glUniform4(int location, FloatBuffer value) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform4((int)location, (FloatBuffer)value);
    }

    public static void glUniformMatrix2(int location, boolean transpose, FloatBuffer value) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniformMatrix2((int)location, (boolean)transpose, (FloatBuffer)value);
    }

    public static void glUniformMatrix3(int location, boolean transpose, FloatBuffer value) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniformMatrix3((int)location, (boolean)transpose, (FloatBuffer)value);
    }

    public static void glUniformMatrix4(int location, boolean transpose, FloatBuffer value) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniformMatrix4((int)location, (boolean)transpose, (FloatBuffer)value);
    }

    public static void setupOverlayColor(IntSupplier textureIn, int colorIn) {
        RenderSystem.assertOnRenderThread();
        int i2 = textureIn.getAsInt();
        RenderSystem.setShaderTexture((int)1, (int)i2);
    }

    public static void teardownOverlayColor() {
        RenderSystem.assertOnRenderThread();
        RenderSystem.setShaderTexture((int)1, (int)0);
    }

    public static void setupLevelDiffuseLighting(k vec1, k vec2, d matrixIn) {
        RenderSystem.assertOnRenderThread();
        GlStateManager.setupLevelDiffuseLighting((k)vec1, (k)vec2, (d)matrixIn);
    }

    public static void setupGuiFlatDiffuseLighting(k vec1, k vec2) {
        RenderSystem.assertOnRenderThread();
        GlStateManager.setupGuiFlatDiffuseLighting((k)vec1, (k)vec2);
    }

    public static void setupGui3DDiffuseLighting(k vec1, k vec2) {
        RenderSystem.assertOnRenderThread();
        GlStateManager.setupGui3DDiffuseLighting((k)vec1, (k)vec2);
    }

    public static void beginInitialization() {
        isInInit = true;
    }

    public static void finishInitialization() {
        isInInit = false;
        if (!recordingQueue.isEmpty()) {
            RenderSystem.replayQueue();
        }
        if (!recordingQueue.isEmpty()) {
            throw new IllegalStateException("Recorded to render queue during initialization");
        }
    }

    public static void glGenBuffers(Consumer<Integer> consumerIn) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> consumerIn.accept(GlStateManager._glGenBuffers()));
        } else {
            consumerIn.accept(GlStateManager._glGenBuffers());
        }
    }

    public static void glGenVertexArrays(Consumer<Integer> consumerIn) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> consumerIn.accept(GlStateManager._glGenVertexArrays()));
        } else {
            consumerIn.accept(GlStateManager._glGenVertexArrays());
        }
    }

    public static eas renderThreadTesselator() {
        RenderSystem.assertOnRenderThread();
        return RENDER_THREAD_TESSELATOR;
    }

    public static void defaultBlendFunc() {
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }

    @Deprecated
    public static void runAsFancy(Runnable runnableIn) {
        boolean flag = efu.G();
        if (!flag) {
            runnableIn.run();
        } else {
            efx optioninstance = efu.I().m.i();
            efo graphicsstatus = (efo)optioninstance.c();
            optioninstance.a((Object)efo.b);
            runnableIn.run();
            optioninstance.a((Object)graphicsstatus);
        }
    }

    public static void setShader(Supplier<fad> shaderIn) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                shader = (fad)shaderIn.get();
            });
        } else {
            shader = shaderIn.get();
        }
    }

    @Nullable
    public static fad getShader() {
        RenderSystem.assertOnRenderThread();
        return shader;
    }

    public static int getTextureId(int textureUnitIn) {
        return GlStateManager._getTextureId((int)textureUnitIn);
    }

    public static void setShaderTexture(int textureUnitIn, abb locIn) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._setShaderTexture((int)textureUnitIn, (abb)locIn));
        } else {
            RenderSystem._setShaderTexture((int)textureUnitIn, (abb)locIn);
        }
    }

    public static void _setShaderTexture(int textureUnitIn, abb locIn) {
        if (Config.isCustomGuis()) {
            locIn = CustomGuis.getTextureLocation((abb)locIn);
        }
        if (textureUnitIn >= 0 && textureUnitIn < shaderTextures.length) {
            fkf texturemanager = efu.I().R();
            fjs abstracttexture = texturemanager.b(locIn);
            RenderSystem.shaderTextures[textureUnitIn] = abstracttexture.b();
        }
    }

    public static void setShaderTexture(int textureUnitIn, int textureIn) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._setShaderTexture((int)textureUnitIn, (int)textureIn));
        } else {
            RenderSystem._setShaderTexture((int)textureUnitIn, (int)textureIn);
        }
    }

    public static void _setShaderTexture(int textureUnitIn, int textureIn) {
        if (textureUnitIn >= 0 && textureUnitIn < shaderTextures.length) {
            RenderSystem.shaderTextures[textureUnitIn] = textureIn;
        }
    }

    public static int getShaderTexture(int textureUnitIn) {
        RenderSystem.assertOnRenderThread();
        return textureUnitIn >= 0 && textureUnitIn < shaderTextures.length ? shaderTextures[textureUnitIn] : 0;
    }

    public static void setProjectionMatrix(d matrixIn) {
        d matrix4f = matrixIn.h();
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                projectionMatrix = matrix4f;
            });
        } else {
            projectionMatrix = matrix4f;
        }
    }

    public static void setInverseViewRotationMatrix(c matrixIn) {
        c matrix3f = matrixIn.h();
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                inverseViewRotationMatrix = matrix3f;
            });
        } else {
            inverseViewRotationMatrix = matrix3f;
        }
    }

    public static void setTextureMatrix(d matrixIn) {
        d matrix4f = matrixIn.h();
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                textureMatrix = matrix4f;
            });
        } else {
            textureMatrix = matrix4f;
        }
    }

    public static void resetTextureMatrix() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> textureMatrix.b());
        } else {
            textureMatrix.b();
        }
    }

    public static void applyModelViewMatrix() {
        d matrix4f = modelViewStack.c().a().h();
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                modelViewMatrix = matrix4f;
            });
        } else {
            modelViewMatrix = matrix4f;
        }
    }

    public static void backupProjectionMatrix() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._backupProjectionMatrix());
        } else {
            RenderSystem._backupProjectionMatrix();
        }
    }

    private static void _backupProjectionMatrix() {
        savedProjectionMatrix = projectionMatrix;
    }

    public static void restoreProjectionMatrix() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._restoreProjectionMatrix());
        } else {
            RenderSystem._restoreProjectionMatrix();
        }
    }

    private static void _restoreProjectionMatrix() {
        projectionMatrix = savedProjectionMatrix;
    }

    public static d getProjectionMatrix() {
        RenderSystem.assertOnRenderThread();
        return projectionMatrix;
    }

    public static c getInverseViewRotationMatrix() {
        RenderSystem.assertOnRenderThread();
        return inverseViewRotationMatrix;
    }

    public static d getModelViewMatrix() {
        RenderSystem.assertOnRenderThread();
        return modelViewMatrix;
    }

    public static eaq getModelViewStack() {
        return modelViewStack;
    }

    public static d getTextureMatrix() {
        RenderSystem.assertOnRenderThread();
        return textureMatrix;
    }

    public static a getSequentialBuffer(eav.b modeIn) {
        RenderSystem.assertOnRenderThread();
        return switch (1.$SwitchMap$com$mojang$blaze3d$vertex$VertexFormat$Mode[modeIn.ordinal()]) {
            case 1 -> sharedSequentialQuad;
            case 2 -> sharedSequentialLines;
            default -> sharedSequential;
        };
    }

    public static void setShaderGameTime(long gameTimeIn, float partialTicks) {
        float f2 = ((float)(gameTimeIn % 24000L) + partialTicks) / 24000.0f;
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                shaderGameTime = f2;
            });
        } else {
            shaderGameTime = f2;
        }
    }

    public static float getShaderGameTime() {
        RenderSystem.assertOnRenderThread();
        return shaderGameTime;
    }

    public static void setFogAllowed(boolean fogAllowed) {
        RenderSystem.fogAllowed = fogAllowed;
        if (Config.isShaders()) {
            Shaders.setFogAllowed((boolean)fogAllowed);
        }
    }

    public static boolean isFogAllowed() {
        return fogAllowed;
    }

    public static void setColorToAttribute(boolean colorToAttribute) {
        if (!Config.isShaders()) {
            return;
        }
        if (RenderSystem.colorToAttribute == colorToAttribute) {
            return;
        }
        RenderSystem.colorToAttribute = colorToAttribute;
        if (colorToAttribute) {
            Shaders.setDefaultAttribColor((float)shaderColor[0], (float)shaderColor[1], (float)shaderColor[2], (float)shaderColor[3]);
        } else {
            Shaders.setDefaultAttribColor();
        }
    }

    static {
        MAX_SUPPORTED_TEXTURE_SIZE = -1;
        lastDrawTime = Double.MIN_VALUE;
        sharedSequential = new a(1, 1, IntConsumer::accept);
        sharedSequentialQuad = new a(4, 6, (consumerIn, positionIn) -> {
            consumerIn.accept(positionIn + 0);
            consumerIn.accept(positionIn + 1);
            consumerIn.accept(positionIn + 2);
            consumerIn.accept(positionIn + 2);
            consumerIn.accept(positionIn + 3);
            consumerIn.accept(positionIn + 0);
        });
        sharedSequentialLines = new a(4, 6, (consumerIn, positionIn) -> {
            consumerIn.accept(positionIn + 0);
            consumerIn.accept(positionIn + 1);
            consumerIn.accept(positionIn + 2);
            consumerIn.accept(positionIn + 3);
            consumerIn.accept(positionIn + 2);
            consumerIn.accept(positionIn + 1);
        });
        inverseViewRotationMatrix = new c();
        projectionMatrix = new d();
        savedProjectionMatrix = new d();
        modelViewStack = new eaq();
        modelViewMatrix = new d();
        textureMatrix = new d();
        shaderTextures = new int[12];
        shaderColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        shaderFogEnd = 1.0f;
        shaderFogColor = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        shaderFogShape = ead.a;
        shaderLightDirections = new k[2];
        shaderLineWidth = 1.0f;
        apiDescription = "Unknown";
        fogAllowed = true;
        colorToAttribute = false;
        projectionMatrix.b();
        savedProjectionMatrix.b();
        modelViewMatrix.b();
        textureMatrix.b();
    }
}

