/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.mojang.blaze3d.platform.DisplayData;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.MacosUtil;
import com.mojang.blaze3d.platform.Monitor;
import com.mojang.blaze3d.platform.ScreenManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.platform.VideoMode;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.platform.WindowEventHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.loading.progress.EarlyProgressVisualization;
import net.optifine.Config;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorField;
import net.optifine.reflect.ReflectorMethod;
import net.optifine.util.TextureUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.opengl.GL;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import org.slf4j.Logger;

public final class Window
implements AutoCloseable {
    private static final Logger f_85345_ = LogUtils.getLogger();
    private final GLFWErrorCallback f_85346_ = GLFWErrorCallback.create((arg_0, arg_1) -> this.m_85382_(arg_0, arg_1));
    private final WindowEventHandler f_85347_;
    private final ScreenManager f_85348_;
    private final long f_85349_;
    private int f_85350_;
    private int f_85351_;
    private int f_85352_;
    private int f_85353_;
    private Optional<VideoMode> f_85354_;
    private boolean f_85355_;
    private boolean f_85356_;
    private int f_85357_;
    private int f_85358_;
    private int f_85359_;
    private int f_85360_;
    private int f_85361_;
    private int f_85362_;
    private int f_85363_;
    private int f_85364_;
    private double f_85365_;
    private String f_85366_ = "";
    private boolean f_85367_;
    private int f_85368_;
    private boolean f_85369_;
    private boolean closed;

    public Window(WindowEventHandler p_i85371_1_, ScreenManager p_i85371_2_, DisplayData p_i85371_3_, @Nullable String videoModeName, String titleIn) {
        RenderSystem.m_187551_();
        this.f_85348_ = p_i85371_2_;
        this.m_85451_();
        this.m_85403_("Pre startup");
        this.f_85347_ = p_i85371_1_;
        Optional optional = VideoMode.m_85333_((String)videoModeName);
        this.f_85354_ = optional.isPresent() ? optional : (p_i85371_3_.f_84007_.isPresent() && p_i85371_3_.f_84008_.isPresent() ? Optional.of(new VideoMode(p_i85371_3_.f_84007_.getAsInt(), p_i85371_3_.f_84008_.getAsInt(), 8, 8, 8, 60)) : Optional.empty());
        this.f_85356_ = this.f_85355_ = p_i85371_3_.f_84009_;
        Monitor monitor = p_i85371_2_.m_85271_(GLFW.glfwGetPrimaryMonitor());
        this.f_85359_ = p_i85371_3_.f_84005_ > 0 ? p_i85371_3_.f_84005_ : 1;
        this.f_85352_ = this.f_85359_;
        this.f_85360_ = p_i85371_3_.f_84006_ > 0 ? p_i85371_3_.f_84006_ : 1;
        this.f_85353_ = this.f_85360_;
        GLFW.glfwDefaultWindowHints();
        if (Config.isAntialiasing()) {
            GLFW.glfwWindowHint((int)135181, (int)Config.getAntialiasingLevel());
        }
        GLFW.glfwWindowHint((int)139265, (int)196609);
        GLFW.glfwWindowHint((int)139275, (int)221185);
        GLFW.glfwWindowHint((int)139266, (int)3);
        GLFW.glfwWindowHint((int)139267, (int)2);
        GLFW.glfwWindowHint((int)139272, (int)204801);
        GLFW.glfwWindowHint((int)139270, (int)1);
        long handleForge = 0L;
        if (Reflector.EarlyProgressVisualization_handOffWindow.exists()) {
            Object epvInstance = Reflector.getFieldValue((ReflectorField)Reflector.EarlyProgressVisualization_INSTANCE);
            handleForge = Reflector.callLong((Object)epvInstance, (ReflectorMethod)Reflector.EarlyProgressVisualization_handOffWindow, (Object[])new Object[]{() -> this.f_85359_, () -> this.f_85360_, () -> titleIn, () -> this.f_85355_ && monitor != null ? monitor.m_84954_() : 0L});
            if (Config.isAntialiasing()) {
                GLFW.glfwDestroyWindow((long)handleForge);
                handleForge = 0L;
            }
        }
        this.f_85349_ = handleForge != 0L ? handleForge : GLFW.glfwCreateWindow((int)this.f_85359_, (int)this.f_85360_, (CharSequence)titleIn, (long)(this.f_85355_ && monitor != null ? monitor.m_84954_() : 0L), (long)0L);
        if (monitor != null) {
            VideoMode videomode = monitor.m_84948_(this.f_85355_ ? this.f_85354_ : Optional.empty());
            this.f_85350_ = this.f_85357_ = monitor.m_84951_() + videomode.m_85332_() / 2 - this.f_85359_ / 2;
            this.f_85351_ = this.f_85358_ = monitor.m_84952_() + videomode.m_85335_() / 2 - this.f_85360_ / 2;
        } else {
            int[] aint1 = new int[1];
            int[] aint = new int[1];
            GLFW.glfwGetWindowPos((long)this.f_85349_, (int[])aint1, (int[])aint);
            this.f_85350_ = this.f_85357_ = aint1[0];
            this.f_85351_ = this.f_85358_ = aint[0];
        }
        GLFW.glfwMakeContextCurrent((long)this.f_85349_);
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        Locale.setDefault(Locale.Category.FORMAT, Locale.ROOT);
        GL.createCapabilities();
        Locale.setDefault(Locale.Category.FORMAT, locale);
        this.m_85453_();
        this.m_85452_();
        GLFW.glfwSetFramebufferSizeCallback((long)this.f_85349_, (arg_0, arg_1, arg_2) -> this.m_85415_(arg_0, arg_1, arg_2));
        GLFW.glfwSetWindowPosCallback((long)this.f_85349_, (arg_0, arg_1, arg_2) -> this.m_85388_(arg_0, arg_1, arg_2));
        GLFW.glfwSetWindowSizeCallback((long)this.f_85349_, (arg_0, arg_1, arg_2) -> this.m_85427_(arg_0, arg_1, arg_2));
        GLFW.glfwSetWindowFocusCallback((long)this.f_85349_, (arg_0, arg_1) -> this.m_85392_(arg_0, arg_1));
        GLFW.glfwSetCursorEnterCallback((long)this.f_85349_, (arg_0, arg_1) -> this.m_85419_(arg_0, arg_1));
    }

    public int m_85377_() {
        RenderSystem.m_187554_();
        return GLX.m_69341_((Window)this);
    }

    public boolean m_85411_() {
        return GLX.m_69355_((Window)this);
    }

    public static void m_85407_(BiConsumer<Integer, String> errorHandlerIn) {
        RenderSystem.m_187551_();
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            PointerBuffer pointerbuffer = memorystack.mallocPointer(1);
            int i2 = GLFW.glfwGetError((PointerBuffer)pointerbuffer);
            if (i2 != 0) {
                long j2 = pointerbuffer.get();
                String s = j2 == 0L ? "" : MemoryUtil.memUTF8((long)j2);
                errorHandlerIn.accept(i2, s);
            }
        }
    }

    public void m_85395_(InputStream stream16, InputStream stream32) {
        RenderSystem.m_187551_();
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            if (stream16 == null) {
                throw new FileNotFoundException("icons/icon_16x16.png");
            }
            if (stream32 == null) {
                throw new FileNotFoundException("icons/icon_32x32.png");
            }
            IntBuffer intbuffer = memorystack.mallocInt(1);
            IntBuffer intbuffer1 = memorystack.mallocInt(1);
            IntBuffer intbuffer2 = memorystack.mallocInt(1);
            GLFWImage.Buffer buffer = GLFWImage.mallocStack((int)2, (MemoryStack)memorystack);
            ByteBuffer bytebuffer = this.m_85398_(stream16, intbuffer, intbuffer1, intbuffer2);
            if (bytebuffer == null) {
                throw new IllegalStateException("Could not load icon: " + STBImage.stbi_failure_reason());
            }
            buffer.position(0);
            buffer.width(intbuffer.get(0));
            buffer.height(intbuffer1.get(0));
            buffer.pixels(bytebuffer);
            ByteBuffer bytebuffer1 = this.m_85398_(stream32, intbuffer, intbuffer1, intbuffer2);
            if (bytebuffer1 == null) {
                throw new IllegalStateException("Could not load icon: " + STBImage.stbi_failure_reason());
            }
            buffer.position(1);
            buffer.width(intbuffer.get(0));
            buffer.height(intbuffer1.get(0));
            buffer.pixels(bytebuffer1);
            buffer.position(0);
            GLFW.glfwSetWindowIcon((long)this.f_85349_, (GLFWImage.Buffer)buffer);
            STBImage.stbi_image_free((ByteBuffer)bytebuffer);
            STBImage.stbi_image_free((ByteBuffer)bytebuffer1);
        }
        catch (IOException ioexception) {
            f_85345_.error("Couldn't set icon", (Throwable)ioexception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ByteBuffer m_85398_(InputStream streamIn, IntBuffer bufferX, IntBuffer bufferY, IntBuffer bufferChannels) throws IOException {
        ByteBuffer bytebuffer1;
        RenderSystem.m_187551_();
        ByteBuffer bytebuffer = null;
        try {
            bytebuffer = TextureUtil.m_85303_((InputStream)streamIn);
            bytebuffer.rewind();
            bytebuffer1 = STBImage.stbi_load_from_memory((ByteBuffer)bytebuffer, (IntBuffer)bufferX, (IntBuffer)bufferY, (IntBuffer)bufferChannels, (int)0);
        }
        finally {
            if (bytebuffer != null) {
                MemoryUtil.memFree((Buffer)bytebuffer);
            }
        }
        return bytebuffer1;
    }

    public void m_85403_(String renderPhaseIn) {
        this.f_85366_ = renderPhaseIn;
        if (renderPhaseIn.equals("Startup")) {
            TextureUtils.registerTickableTextures();
        }
    }

    private void m_85451_() {
        RenderSystem.m_187551_();
        GLFW.glfwSetErrorCallback(Window::m_85412_);
    }

    private static void m_85412_(int error, long description) {
        RenderSystem.m_187551_();
        String s = "GLFW error " + error + ": " + MemoryUtil.memUTF8((long)description);
        TinyFileDialogs.tinyfd_messageBox((CharSequence)"Minecraft", (CharSequence)(s + ".\n\nPlease make sure you have up-to-date drivers (see aka.ms/mcdriver for instructions)."), (CharSequence)"ok", (CharSequence)"error", (boolean)false);
        throw new WindowInitFailed(s);
    }

    public void m_85382_(int error, long description) {
        RenderSystem.m_187554_();
        String s = MemoryUtil.memUTF8((long)description);
        f_85345_.error("########## GL ERROR ##########");
        f_85345_.error("@ {}", (Object)this.f_85366_);
        f_85345_.error("{}: {}", (Object)error, (Object)s);
    }

    public void m_85426_() {
        GLFWErrorCallback glfwerrorcallback = GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)this.f_85346_);
        if (glfwerrorcallback != null) {
            glfwerrorcallback.free();
        }
        TextureUtils.registerResourceListener();
    }

    public void m_85409_(boolean vsyncEnabled) {
        RenderSystem.m_187555_();
        this.f_85369_ = vsyncEnabled;
        GLFW.glfwSwapInterval((int)(vsyncEnabled ? 1 : 0));
    }

    @Override
    public void close() {
        RenderSystem.m_187554_();
        this.closed = true;
        Callbacks.glfwFreeCallbacks((long)this.f_85349_);
        this.f_85346_.close();
        GLFW.glfwDestroyWindow((long)this.f_85349_);
        GLFW.glfwTerminate();
    }

    private void m_85388_(long windowPointer, int windowXIn, int windowYIn) {
        this.f_85357_ = windowXIn;
        this.f_85358_ = windowYIn;
    }

    private void m_85415_(long windowPointer, int framebufferWidth, int framebufferHeight) {
        if (windowPointer == this.f_85349_) {
            int i2 = this.m_85441_();
            int j2 = this.m_85442_();
            if (framebufferWidth != 0 && framebufferHeight != 0) {
                this.f_85361_ = framebufferWidth;
                this.f_85362_ = framebufferHeight;
                if (this.m_85441_() != i2 || this.m_85442_() != j2) {
                    this.f_85347_.m_5741_();
                }
            }
        }
    }

    private void m_85452_() {
        RenderSystem.m_187551_();
        int[] aint = new int[1];
        int[] aint1 = new int[1];
        GLFW.glfwGetFramebufferSize((long)this.f_85349_, (int[])aint, (int[])aint1);
        this.f_85361_ = aint[0] > 0 ? aint[0] : 1;
        int n2 = this.f_85362_ = aint1[0] > 0 ? aint1[0] : 1;
        if (this.f_85362_ == 0 || this.f_85361_ == 0) {
            EarlyProgressVisualization.INSTANCE.updateFBSize(w -> {
                this.f_85361_ = w;
            }, h2 -> {
                this.f_85362_ = h2;
            });
        }
    }

    private void m_85427_(long windowPointer, int windowWidthIn, int windowHeightIn) {
        this.f_85359_ = windowWidthIn;
        this.f_85360_ = windowHeightIn;
    }

    private void m_85392_(long windowPointer, boolean hasFocus) {
        if (windowPointer == this.f_85349_) {
            this.f_85347_.m_7440_(hasFocus);
        }
    }

    private void m_85419_(long windowPointer, boolean enterIn) {
        if (enterIn) {
            this.f_85347_.m_5740_();
        }
    }

    public void m_85380_(int limitIn) {
        this.f_85368_ = limitIn;
    }

    public int m_85434_() {
        if (((Boolean)Minecraft.m_91087_().f_91066_.m_231817_().m_231551_()).booleanValue()) {
            return 260;
        }
        if (this.f_85368_ <= 0) {
            return 260;
        }
        return this.f_85368_;
    }

    public void m_85435_() {
        RenderSystem.m_69495_((long)this.f_85349_);
        if (this.f_85355_ != this.f_85356_) {
            this.f_85356_ = this.f_85355_;
            this.m_85431_(this.f_85369_);
        }
    }

    public Optional<VideoMode> m_85436_() {
        return this.f_85354_;
    }

    public void m_85405_(Optional<VideoMode> fullscreenModeIn) {
        boolean flag = !fullscreenModeIn.equals(this.f_85354_);
        this.f_85354_ = fullscreenModeIn;
        if (flag) {
            this.f_85367_ = true;
        }
    }

    public void m_85437_() {
        if (this.f_85355_ && this.f_85367_) {
            this.f_85367_ = false;
            this.m_85453_();
            this.f_85347_.m_5741_();
        }
    }

    private void m_85453_() {
        boolean flag;
        RenderSystem.m_187551_();
        boolean bl = flag = GLFW.glfwGetWindowMonitor((long)this.f_85349_) != 0L;
        if (this.f_85355_) {
            Monitor monitor = this.f_85348_.m_85276_(this);
            if (monitor == null) {
                f_85345_.warn("Failed to find suitable monitor for fullscreen mode");
                this.f_85355_ = false;
            } else {
                if (Minecraft.f_91002_) {
                    MacosUtil.m_182517_((long)this.f_85349_);
                }
                VideoMode videomode = monitor.m_84948_(this.f_85354_);
                if (!flag) {
                    this.f_85350_ = this.f_85357_;
                    this.f_85351_ = this.f_85358_;
                    this.f_85352_ = this.f_85359_;
                    this.f_85353_ = this.f_85360_;
                }
                this.f_85357_ = 0;
                this.f_85358_ = 0;
                this.f_85359_ = videomode.m_85332_();
                this.f_85360_ = videomode.m_85335_();
                GLFW.glfwSetWindowMonitor((long)this.f_85349_, (long)monitor.m_84954_(), (int)this.f_85357_, (int)this.f_85358_, (int)this.f_85359_, (int)this.f_85360_, (int)videomode.m_85341_());
            }
        } else {
            this.f_85357_ = this.f_85350_;
            this.f_85358_ = this.f_85351_;
            this.f_85359_ = this.f_85352_;
            this.f_85360_ = this.f_85353_;
            GLFW.glfwSetWindowMonitor((long)this.f_85349_, (long)0L, (int)this.f_85357_, (int)this.f_85358_, (int)this.f_85359_, (int)this.f_85360_, (int)-1);
        }
    }

    public void m_85438_() {
        this.f_85355_ = !this.f_85355_;
    }

    public void m_166447_(int widthIn, int heightIn) {
        this.f_85352_ = widthIn;
        this.f_85353_ = heightIn;
        this.f_85355_ = false;
        this.m_85453_();
    }

    private void m_85431_(boolean vsyncEnabled) {
        RenderSystem.m_187554_();
        try {
            this.m_85453_();
            this.f_85347_.m_5741_();
            this.m_85409_(vsyncEnabled);
            this.m_85435_();
        }
        catch (Exception exception) {
            f_85345_.error("Couldn't toggle fullscreen", (Throwable)exception);
        }
    }

    public int m_85385_(int guiScaleIn, boolean forceUnicode) {
        int i2;
        for (i2 = 1; i2 != guiScaleIn && i2 < this.f_85361_ && i2 < this.f_85362_ && this.f_85361_ / (i2 + 1) >= 320 && this.f_85362_ / (i2 + 1) >= 240; ++i2) {
        }
        if (forceUnicode && i2 % 2 != 0) {
            ++i2;
        }
        return i2;
    }

    public void m_85378_(double scaleFactor) {
        this.f_85365_ = scaleFactor;
        int i2 = (int)((double)this.f_85361_ / scaleFactor);
        this.f_85363_ = (double)this.f_85361_ / scaleFactor > (double)i2 ? i2 + 1 : i2;
        int j2 = (int)((double)this.f_85362_ / scaleFactor);
        this.f_85364_ = (double)this.f_85362_ / scaleFactor > (double)j2 ? j2 + 1 : j2;
    }

    public void m_85422_(String titleIn) {
        GLFW.glfwSetWindowTitle((long)this.f_85349_, (CharSequence)titleIn);
    }

    public long m_85439_() {
        return this.f_85349_;
    }

    public boolean m_85440_() {
        return this.f_85355_;
    }

    public int m_85441_() {
        return this.f_85361_;
    }

    public int m_85442_() {
        return this.f_85362_;
    }

    public void m_166450_(int widthIn) {
        this.f_85361_ = widthIn;
    }

    public void m_166452_(int heightIn) {
        this.f_85362_ = heightIn;
    }

    public int m_85443_() {
        return this.f_85359_;
    }

    public int m_85444_() {
        return this.f_85360_;
    }

    public int m_85445_() {
        return this.f_85363_;
    }

    public int m_85446_() {
        return this.f_85364_;
    }

    public int m_85447_() {
        return this.f_85357_;
    }

    public int m_85448_() {
        return this.f_85358_;
    }

    public double m_85449_() {
        return this.f_85365_;
    }

    @Nullable
    public Monitor m_85450_() {
        return this.f_85348_.m_85276_(this);
    }

    public void m_85424_(boolean valueIn) {
        InputConstants.m_84848_((long)this.f_85349_, (boolean)valueIn);
    }

    public void resizeFramebuffer(int width, int height) {
        this.m_85415_(this.f_85349_, width, height);
    }

    public boolean isClosed() {
        return this.closed;
    }
}

