/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.google.common.base.Charsets;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.optifine.Config;
import net.optifine.SmartAnimations;
import net.optifine.render.GlAlphaState;
import net.optifine.render.GlBlendState;
import net.optifine.render.GlCullState;
import net.optifine.shaders.Shaders;
import net.optifine.util.LockCounter;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.ARBDrawBuffersBlend;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.opengl.GL42;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

/*
 * Exception performing whole class analysis ignored.
 */
@dyi
public class GlStateManager {
    private static final boolean ON_LINUX = ad.j() == ad.b.a;
    public static final int TEXTURE_COUNT = 12;
    private static final a BLEND = new a();
    private static final f DEPTH = new f();
    private static final e CULL = new e();
    private static final h POLY_OFFSET = new h();
    private static final c COLOR_LOGIC = new c();
    private static final k STENCIL = new k();
    private static final i SCISSOR = new i();
    private static int activeTexture;
    private static final l[] TEXTURES;
    private static final d COLOR_MASK;
    private static boolean alphaTest;
    private static int alphaTestFunc;
    private static float alphaTestRef;
    private static LockCounter alphaLock;
    private static GlAlphaState alphaLockState;
    private static LockCounter blendLock;
    private static GlBlendState blendLockState;
    private static LockCounter cullLock;
    private static GlCullState cullLockState;
    public static boolean vboRegions;
    public static int GL_COPY_READ_BUFFER;
    public static int GL_COPY_WRITE_BUFFER;
    public static int GL_ARRAY_BUFFER;
    public static int GL_STATIC_DRAW;
    public static final int GL_QUADS = 7;
    public static final int GL_TRIANGLES = 4;
    public static final int GL_TEXTURE0 = 33984;
    public static final int GL_TEXTURE1 = 33985;
    public static final int GL_TEXTURE2 = 33986;
    private static int framebufferRead;
    private static int framebufferDraw;
    private static final int[] IMAGE_TEXTURES;
    private static int glProgram;
    public static float lastBrightnessX;
    public static float lastBrightnessY;

    public static void disableAlphaTest() {
        if (alphaLock.isLocked()) {
            alphaLockState.setDisabled();
            return;
        }
        alphaTest = false;
        GlStateManager.applyAlphaTest();
    }

    public static void enableAlphaTest() {
        if (alphaLock.isLocked()) {
            alphaLockState.setEnabled();
            return;
        }
        alphaTest = true;
        GlStateManager.applyAlphaTest();
    }

    public static void alphaFunc(int func, float ref) {
        if (alphaLock.isLocked()) {
            alphaLockState.setFuncRef(func, ref);
            return;
        }
        alphaTestFunc = func;
        alphaTestRef = ref;
        GlStateManager.applyAlphaTest();
    }

    public static void applyAlphaTest() {
        if (Config.isShaders()) {
            if (alphaTest && alphaTestFunc == 516) {
                Shaders.uniform_alphaTestRef.setValue(alphaTestRef);
            } else {
                Shaders.uniform_alphaTestRef.setValue(0.0f);
            }
        }
    }

    public static void _disableScissorTest() {
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager.SCISSOR.a.a();
    }

    public static void _enableScissorTest() {
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager.SCISSOR.a.b();
    }

    public static void _scissorBox(int x, int y, int width, int height) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL20.glScissor((int)x, (int)y, (int)width, (int)height);
    }

    public static void _disableDepthTest() {
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager.DEPTH.a.a();
    }

    public static void _enableDepthTest() {
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager.DEPTH.a.b();
    }

    public static void _depthFunc(int depthFunc) {
        RenderSystem.assertOnRenderThreadOrInit();
        if (depthFunc != GlStateManager.DEPTH.c) {
            GlStateManager.DEPTH.c = depthFunc;
            GL11.glDepthFunc((int)depthFunc);
        }
    }

    public static void _depthMask(boolean flagIn) {
        RenderSystem.assertOnRenderThread();
        if (flagIn != GlStateManager.DEPTH.b) {
            GlStateManager.DEPTH.b = flagIn;
            GL11.glDepthMask((boolean)flagIn);
        }
    }

    public static void _disableBlend() {
        RenderSystem.assertOnRenderThread();
        if (blendLock.isLocked()) {
            blendLockState.setDisabled();
            return;
        }
        GlStateManager.BLEND.a.a();
    }

    public static void _enableBlend() {
        RenderSystem.assertOnRenderThread();
        if (blendLock.isLocked()) {
            blendLockState.setEnabled();
            return;
        }
        GlStateManager.BLEND.a.b();
    }

    public static void _blendFunc(int srcFactor, int dstFactor) {
        RenderSystem.assertOnRenderThread();
        if (blendLock.isLocked()) {
            blendLockState.setFactors(srcFactor, dstFactor);
            return;
        }
        if (srcFactor != GlStateManager.BLEND.b || dstFactor != GlStateManager.BLEND.c || srcFactor != GlStateManager.BLEND.d || dstFactor != GlStateManager.BLEND.e) {
            GlStateManager.BLEND.b = srcFactor;
            GlStateManager.BLEND.c = dstFactor;
            GlStateManager.BLEND.d = srcFactor;
            GlStateManager.BLEND.e = dstFactor;
            if (Config.isShaders()) {
                Shaders.uniform_blendFunc.setValue(srcFactor, dstFactor, srcFactor, dstFactor);
            }
            GL11.glBlendFunc((int)srcFactor, (int)dstFactor);
        }
    }

    public static void _blendFuncSeparate(int srcFactor, int dstFactor, int srcFactorAlpha, int dstFactorAlpha) {
        RenderSystem.assertOnRenderThread();
        if (blendLock.isLocked()) {
            blendLockState.setFactors(srcFactor, dstFactor, srcFactorAlpha, dstFactorAlpha);
            return;
        }
        if (srcFactor != GlStateManager.BLEND.b || dstFactor != GlStateManager.BLEND.c || srcFactorAlpha != GlStateManager.BLEND.d || dstFactorAlpha != GlStateManager.BLEND.e) {
            GlStateManager.BLEND.b = srcFactor;
            GlStateManager.BLEND.c = dstFactor;
            GlStateManager.BLEND.d = srcFactorAlpha;
            GlStateManager.BLEND.e = dstFactorAlpha;
            if (Config.isShaders()) {
                Shaders.uniform_blendFunc.setValue(srcFactor, dstFactor, srcFactorAlpha, dstFactorAlpha);
            }
            GlStateManager.glBlendFuncSeparate((int)srcFactor, (int)dstFactor, (int)srcFactorAlpha, (int)dstFactorAlpha);
        }
    }

    public static void _blendEquation(int blendEquation) {
        RenderSystem.assertOnRenderThread();
        GL14.glBlendEquation((int)blendEquation);
    }

    public static void init(GLCapabilities glCapabilities) {
        RenderSystem.assertOnGameThreadOrInit();
        Config.initDisplay();
        GL_COPY_READ_BUFFER = 36662;
        GL_COPY_WRITE_BUFFER = 36663;
        GL_ARRAY_BUFFER = 34962;
        GL_STATIC_DRAW = 35044;
        boolean copyBuffer = true;
        boolean multiDrawArrays = true;
        boolean bl = vboRegions = copyBuffer && multiDrawArrays;
        if (!vboRegions) {
            ArrayList<String> list = new ArrayList<String>();
            if (!copyBuffer) {
                list.add("OpenGL 1.3, ARB_copy_buffer");
            }
            if (!multiDrawArrays) {
                list.add("OpenGL 1.4");
            }
            String vboRegionWarn = "VboRegions not supported, missing: " + Config.listToString(list);
            Config.dbg((String)vboRegionWarn);
        }
    }

    public static int glGetProgrami(int program, int pname) {
        RenderSystem.assertOnRenderThread();
        return GL20.glGetProgrami((int)program, (int)pname);
    }

    public static void glAttachShader(int program, int shaderIn) {
        RenderSystem.assertOnRenderThread();
        GL20.glAttachShader((int)program, (int)shaderIn);
    }

    public static void glDeleteShader(int shaderIn) {
        RenderSystem.assertOnRenderThread();
        GL20.glDeleteShader((int)shaderIn);
    }

    public static int glCreateShader(int type) {
        RenderSystem.assertOnRenderThread();
        return GL20.glCreateShader((int)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glShaderSource(int shaderIn, List<String> source) {
        RenderSystem.assertOnRenderThread();
        StringBuilder stringbuilder = new StringBuilder();
        for (String s : source) {
            stringbuilder.append(s);
        }
        byte[] abyte = stringbuilder.toString().getBytes(Charsets.UTF_8);
        ByteBuffer bytebuffer = MemoryUtil.memAlloc((int)(abyte.length + 1));
        bytebuffer.put(abyte);
        bytebuffer.put((byte)0);
        bytebuffer.flip();
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            PointerBuffer pointerbuffer = memorystack.mallocPointer(1);
            pointerbuffer.put(bytebuffer);
            GL20C.nglShaderSource((int)shaderIn, (int)1, (long)pointerbuffer.address0(), (long)0L);
        }
        finally {
            MemoryUtil.memFree((Buffer)bytebuffer);
        }
    }

    public static void glCompileShader(int shaderIn) {
        RenderSystem.assertOnRenderThread();
        GL20.glCompileShader((int)shaderIn);
    }

    public static int glGetShaderi(int shaderIn, int pname) {
        RenderSystem.assertOnRenderThread();
        return GL20.glGetShaderi((int)shaderIn, (int)pname);
    }

    public static void _glUseProgram(int program) {
        RenderSystem.assertOnRenderThread();
        if (glProgram == program) {
            return;
        }
        GL20.glUseProgram((int)program);
        glProgram = program;
    }

    public static int glCreateProgram() {
        RenderSystem.assertOnRenderThread();
        return GL20.glCreateProgram();
    }

    public static void glDeleteProgram(int program) {
        RenderSystem.assertOnRenderThread();
        GL20.glDeleteProgram((int)program);
    }

    public static void glLinkProgram(int program) {
        RenderSystem.assertOnRenderThread();
        GL20.glLinkProgram((int)program);
    }

    public static int _glGetUniformLocation(int program, CharSequence name) {
        RenderSystem.assertOnRenderThread();
        return GL20.glGetUniformLocation((int)program, (CharSequence)name);
    }

    public static void _glUniform1(int location, IntBuffer value) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform1iv((int)location, (IntBuffer)value);
    }

    public static void _glUniform1i(int location, int value) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform1i((int)location, (int)value);
    }

    public static void _glUniform1(int location, FloatBuffer value) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform1fv((int)location, (FloatBuffer)value);
    }

    public static void _glUniform2(int location, IntBuffer value) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform2iv((int)location, (IntBuffer)value);
    }

    public static void _glUniform2(int location, FloatBuffer value) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform2fv((int)location, (FloatBuffer)value);
    }

    public static void _glUniform3(int location, IntBuffer value) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform3iv((int)location, (IntBuffer)value);
    }

    public static void _glUniform3(int location, FloatBuffer value) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform3fv((int)location, (FloatBuffer)value);
    }

    public static void _glUniform4(int location, IntBuffer value) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform4iv((int)location, (IntBuffer)value);
    }

    public static void _glUniform4(int location, FloatBuffer value) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform4fv((int)location, (FloatBuffer)value);
    }

    public static void _glUniformMatrix2(int location, boolean transpose, FloatBuffer value) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniformMatrix2fv((int)location, (boolean)transpose, (FloatBuffer)value);
    }

    public static void _glUniformMatrix3(int location, boolean transpose, FloatBuffer value) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniformMatrix3fv((int)location, (boolean)transpose, (FloatBuffer)value);
    }

    public static void _glUniformMatrix4(int location, boolean transpose, FloatBuffer value) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniformMatrix4fv((int)location, (boolean)transpose, (FloatBuffer)value);
    }

    public static int _glGetAttribLocation(int program, CharSequence name) {
        RenderSystem.assertOnRenderThread();
        return GL20.glGetAttribLocation((int)program, (CharSequence)name);
    }

    public static void _glBindAttribLocation(int program, int index, CharSequence name) {
        RenderSystem.assertOnRenderThread();
        GL20.glBindAttribLocation((int)program, (int)index, (CharSequence)name);
    }

    public static int _glGenBuffers() {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL15.glGenBuffers();
    }

    public static int _glGenVertexArrays() {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL30.glGenVertexArrays();
    }

    public static void _glBindBuffer(int target, int buffer) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL15.glBindBuffer((int)target, (int)buffer);
    }

    public static void _glBindVertexArray(int array) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glBindVertexArray((int)array);
    }

    public static void _glBufferData(int target, ByteBuffer data, int usage) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL15.glBufferData((int)target, (ByteBuffer)data, (int)usage);
    }

    public static void _glBufferData(int targetIn, long dataIn, int usageIn) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL15.glBufferData((int)targetIn, (long)dataIn, (int)usageIn);
    }

    @Nullable
    public static ByteBuffer _glMapBuffer(int targetIn, int accessIn) {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL15.glMapBuffer((int)targetIn, (int)accessIn);
    }

    public static void _glUnmapBuffer(int targetIn) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL15.glUnmapBuffer((int)targetIn);
    }

    public static void _glDeleteBuffers(int buffer) {
        RenderSystem.assertOnRenderThread();
        if (ON_LINUX) {
            GL32C.glBindBuffer((int)34962, (int)buffer);
            GL32C.glBufferData((int)34962, (long)0L, (int)35048);
            GL32C.glBindBuffer((int)34962, (int)0);
        }
        GL15.glDeleteBuffers((int)buffer);
    }

    public static void _glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL20.glCopyTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)x, (int)y, (int)width, (int)height);
    }

    public static void _glDeleteVertexArrays(int array) {
        RenderSystem.assertOnRenderThread();
        GL30.glDeleteVertexArrays((int)array);
    }

    public static void _glBindFramebuffer(int target, int framebufferIn) {
        RenderSystem.assertOnRenderThreadOrInit();
        if (target == 36160) {
            if (framebufferRead == framebufferIn && framebufferDraw == framebufferIn) {
                return;
            }
            framebufferRead = framebufferIn;
            framebufferDraw = framebufferIn;
        } else if (target == 36008) {
            if (framebufferRead == framebufferIn) {
                return;
            }
            framebufferRead = framebufferIn;
        }
        if (target == 36009) {
            if (framebufferDraw == framebufferIn) {
                return;
            }
            framebufferDraw = framebufferIn;
        }
        GL30.glBindFramebuffer((int)target, (int)framebufferIn);
    }

    public static void _glBlitFrameBuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glBlitFramebuffer((int)srcX0, (int)srcY0, (int)srcX1, (int)srcY1, (int)dstX0, (int)dstY0, (int)dstX1, (int)dstY1, (int)mask, (int)filter);
    }

    public static void _glBindRenderbuffer(int target, int renderbuffer) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glBindRenderbuffer((int)target, (int)renderbuffer);
    }

    public static void _glDeleteRenderbuffers(int renderbuffer) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glDeleteRenderbuffers((int)renderbuffer);
    }

    public static void _glDeleteFramebuffers(int framebufferIn) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glDeleteFramebuffers((int)framebufferIn);
    }

    public static int glGenFramebuffers() {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL30.glGenFramebuffers();
    }

    public static int glGenRenderbuffers() {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL30.glGenRenderbuffers();
    }

    public static void _glRenderbufferStorage(int target, int internalFormat, int width, int height) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glRenderbufferStorage((int)target, (int)internalFormat, (int)width, (int)height);
    }

    public static void _glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glFramebufferRenderbuffer((int)target, (int)attachment, (int)renderbuffertarget, (int)renderbuffer);
    }

    public static int glCheckFramebufferStatus(int framebufferIn) {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL30.glCheckFramebufferStatus((int)framebufferIn);
    }

    public static void _glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glFramebufferTexture2D((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
    }

    public static int getBoundFramebuffer() {
        RenderSystem.assertOnRenderThread();
        return GlStateManager._getInteger((int)36006);
    }

    public static void glActiveTexture(int textureIn) {
        RenderSystem.assertOnRenderThread();
        GL13.glActiveTexture((int)textureIn);
    }

    public static void glBlendFuncSeparate(int srcFactor, int dstFactor, int srcFactorAlpha, int dstFactorAlpha) {
        RenderSystem.assertOnRenderThread();
        GL14.glBlendFuncSeparate((int)srcFactor, (int)dstFactor, (int)srcFactorAlpha, (int)dstFactorAlpha);
    }

    public static String glGetShaderInfoLog(int shader, int maxLen) {
        RenderSystem.assertOnRenderThread();
        return GL20.glGetShaderInfoLog((int)shader, (int)maxLen);
    }

    public static String glGetProgramInfoLog(int program, int maxLen) {
        RenderSystem.assertOnRenderThread();
        return GL20.glGetProgramInfoLog((int)program, (int)maxLen);
    }

    public static void setupLevelDiffuseLighting(k vec1, k vec2, d matrixIn) {
        RenderSystem.assertOnRenderThread();
        l vector4f = new l(vec1);
        vector4f.a(matrixIn);
        l vector4f1 = new l(vec2);
        vector4f1.a(matrixIn);
        RenderSystem.setShaderLights((k)new k(vector4f), (k)new k(vector4f1));
    }

    public static void setupGuiFlatDiffuseLighting(k vec1, k vec2) {
        RenderSystem.assertOnRenderThread();
        d matrix4f = new d();
        matrix4f.b();
        matrix4f.b(d.b((float)1.0f, (float)-1.0f, (float)1.0f));
        matrix4f.a(k.e.c(-22.5f));
        matrix4f.a(k.c.c(135.0f));
        GlStateManager.setupLevelDiffuseLighting((k)vec1, (k)vec2, (d)matrix4f);
    }

    public static void setupGui3DDiffuseLighting(k vec1, k vec2) {
        RenderSystem.assertOnRenderThread();
        d matrix4f = new d();
        matrix4f.b();
        matrix4f.a(k.e.c(62.0f));
        matrix4f.a(k.c.c(185.5f));
        matrix4f.a(k.e.c(-22.5f));
        matrix4f.a(k.c.c(135.0f));
        GlStateManager.setupLevelDiffuseLighting((k)vec1, (k)vec2, (d)matrix4f);
    }

    public static void _enableCull() {
        RenderSystem.assertOnRenderThread();
        if (cullLock.isLocked()) {
            cullLockState.setEnabled();
            return;
        }
        GlStateManager.CULL.a.b();
    }

    public static void _disableCull() {
        RenderSystem.assertOnRenderThread();
        if (cullLock.isLocked()) {
            cullLockState.setDisabled();
            return;
        }
        GlStateManager.CULL.a.a();
    }

    public static void _polygonMode(int face, int mode) {
        RenderSystem.assertOnRenderThread();
        GL11.glPolygonMode((int)face, (int)mode);
    }

    public static void _enablePolygonOffset() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.POLY_OFFSET.a.b();
    }

    public static void _disablePolygonOffset() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.POLY_OFFSET.a.a();
    }

    public static void _polygonOffset(float factor, float units) {
        RenderSystem.assertOnRenderThread();
        if (factor != GlStateManager.POLY_OFFSET.c || units != GlStateManager.POLY_OFFSET.d) {
            GlStateManager.POLY_OFFSET.c = factor;
            GlStateManager.POLY_OFFSET.d = units;
            GL11.glPolygonOffset((float)factor, (float)units);
        }
    }

    public static void _enableColorLogicOp() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.COLOR_LOGIC.a.b();
    }

    public static void _disableColorLogicOp() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.COLOR_LOGIC.a.a();
    }

    public static void _logicOp(int logicOperation) {
        RenderSystem.assertOnRenderThread();
        if (logicOperation != GlStateManager.COLOR_LOGIC.b) {
            GlStateManager.COLOR_LOGIC.b = logicOperation;
            GL11.glLogicOp((int)logicOperation);
        }
    }

    public static void _activeTexture(int textureIn) {
        RenderSystem.assertOnRenderThread();
        if (activeTexture != textureIn - 33984) {
            activeTexture = textureIn - 33984;
            GlStateManager.glActiveTexture((int)textureIn);
        }
    }

    public static void _enableTexture() {
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager.TEXTURES[GlStateManager.activeTexture].a = true;
    }

    public static void _disableTexture() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.TEXTURES[GlStateManager.activeTexture].a = false;
    }

    public static void _texParameter(int target, int parameterName, float parameter) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glTexParameterf((int)target, (int)parameterName, (float)parameter);
    }

    public static void _texParameter(int target, int parameterName, int parameter) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glTexParameteri((int)target, (int)parameterName, (int)parameter);
    }

    public static int _getTexLevelParameter(int target, int level, int parameterName) {
        RenderSystem.assertInInitPhase();
        return GL11.glGetTexLevelParameteri((int)target, (int)level, (int)parameterName);
    }

    public static int _genTexture() {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL11.glGenTextures();
    }

    public static void _genTextures(int[] texturesIn) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glGenTextures((int[])texturesIn);
    }

    public static void _deleteTexture(int textureIn) {
        RenderSystem.assertOnRenderThreadOrInit();
        if (textureIn == 0) {
            return;
        }
        for (int i2 = 0; i2 < IMAGE_TEXTURES.length; ++i2) {
            if (IMAGE_TEXTURES[i2] != textureIn) continue;
            GlStateManager.IMAGE_TEXTURES[i2] = 0;
        }
        GL11.glDeleteTextures((int)textureIn);
        for (l glstatemanager$texturestate : TEXTURES) {
            if (glstatemanager$texturestate.b != textureIn) continue;
            glstatemanager$texturestate.b = 0;
        }
    }

    public static void _deleteTextures(int[] texturesIn) {
        RenderSystem.assertOnRenderThreadOrInit();
        for (l glstatemanager$texturestate : TEXTURES) {
            for (int i2 : texturesIn) {
                if (glstatemanager$texturestate.b != i2) continue;
                glstatemanager$texturestate.b = -1;
            }
        }
        GL11.glDeleteTextures((int[])texturesIn);
    }

    public static void _bindTexture(int textureIn) {
        RenderSystem.assertOnRenderThreadOrInit();
        if (textureIn != GlStateManager.TEXTURES[GlStateManager.activeTexture].b) {
            GlStateManager.TEXTURES[GlStateManager.activeTexture].b = textureIn;
            GL11.glBindTexture((int)3553, (int)textureIn);
            if (SmartAnimations.isActive()) {
                SmartAnimations.textureRendered((int)textureIn);
            }
        }
    }

    public static int _getTextureId(int textureIn) {
        return textureIn >= 0 && textureIn < 12 && GlStateManager.TEXTURES[textureIn].a ? GlStateManager.TEXTURES[textureIn].b : 0;
    }

    public static int _getActiveTexture() {
        return activeTexture + 33984;
    }

    public static void _texImage2D(int target, int level, int internalFormat, int width, int height, int border, int format, int type, @Nullable IntBuffer pixels) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glTexImage2D((int)target, (int)level, (int)internalFormat, (int)width, (int)height, (int)border, (int)format, (int)type, (IntBuffer)pixels);
    }

    public static void _texSubImage2D(int target, int level, int xOffset, int yOffset, int width, int height, int format, int type, long pixels) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glTexSubImage2D((int)target, (int)level, (int)xOffset, (int)yOffset, (int)width, (int)height, (int)format, (int)type, (long)pixels);
    }

    public static void _getTexImage(int tex, int level, int format, int type, long pixels) {
        RenderSystem.assertOnRenderThread();
        GL11.glGetTexImage((int)tex, (int)level, (int)format, (int)type, (long)pixels);
    }

    public static void _viewport(int x, int y, int width, int height) {
        RenderSystem.assertOnRenderThreadOrInit();
        m.a.b = x;
        m.a.c = y;
        m.a.d = width;
        m.a.e = height;
        GL11.glViewport((int)x, (int)y, (int)width, (int)height);
    }

    public static void _colorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        RenderSystem.assertOnRenderThread();
        if (red != GlStateManager.COLOR_MASK.a || green != GlStateManager.COLOR_MASK.b || blue != GlStateManager.COLOR_MASK.c || alpha != GlStateManager.COLOR_MASK.d) {
            GlStateManager.COLOR_MASK.a = red;
            GlStateManager.COLOR_MASK.b = green;
            GlStateManager.COLOR_MASK.c = blue;
            GlStateManager.COLOR_MASK.d = alpha;
            GL11.glColorMask((boolean)red, (boolean)green, (boolean)blue, (boolean)alpha);
        }
    }

    public static void _stencilFunc(int func, int ref, int mask) {
        RenderSystem.assertOnRenderThread();
        if (func != GlStateManager.STENCIL.a.a || func != GlStateManager.STENCIL.a.b || func != GlStateManager.STENCIL.a.c) {
            GlStateManager.STENCIL.a.a = func;
            GlStateManager.STENCIL.a.b = ref;
            GlStateManager.STENCIL.a.c = mask;
            GL11.glStencilFunc((int)func, (int)ref, (int)mask);
        }
    }

    public static void _stencilMask(int mask) {
        RenderSystem.assertOnRenderThread();
        if (mask != GlStateManager.STENCIL.b) {
            GlStateManager.STENCIL.b = mask;
            GL11.glStencilMask((int)mask);
        }
    }

    public static void _stencilOp(int sfail, int dpfail, int dppass) {
        RenderSystem.assertOnRenderThread();
        if (sfail != GlStateManager.STENCIL.c || dpfail != GlStateManager.STENCIL.d || dppass != GlStateManager.STENCIL.e) {
            GlStateManager.STENCIL.c = sfail;
            GlStateManager.STENCIL.d = dpfail;
            GlStateManager.STENCIL.e = dppass;
            GL11.glStencilOp((int)sfail, (int)dpfail, (int)dppass);
        }
    }

    public static void _clearDepth(double depth) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glClearDepth((double)depth);
    }

    public static void _clearColor(float red, float green, float blue, float alpha) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glClearColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void _clearStencil(int index) {
        RenderSystem.assertOnRenderThread();
        GL11.glClearStencil((int)index);
    }

    public static void _clear(int mask, boolean checkError) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glClear((int)mask);
        if (checkError) {
            GlStateManager._getError();
        }
    }

    public static void _glDrawPixels(int width, int height, int format, int type, long pixels) {
        RenderSystem.assertOnRenderThread();
        GL11.glDrawPixels((int)width, (int)height, (int)format, (int)type, (long)pixels);
    }

    public static void _vertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long pointer) {
        RenderSystem.assertOnRenderThread();
        GL20.glVertexAttribPointer((int)index, (int)size, (int)type, (boolean)normalized, (int)stride, (long)pointer);
    }

    public static void _vertexAttribIPointer(int index, int size, int type, int stride, long pointer) {
        RenderSystem.assertOnRenderThread();
        GL30.glVertexAttribIPointer((int)index, (int)size, (int)type, (int)stride, (long)pointer);
    }

    public static void _enableVertexAttribArray(int index) {
        RenderSystem.assertOnRenderThread();
        GL20.glEnableVertexAttribArray((int)index);
    }

    public static void _disableVertexAttribArray(int index) {
        RenderSystem.assertOnRenderThread();
        GL20.glDisableVertexAttribArray((int)index);
    }

    public static void _drawElements(int modeIn, int countIn, int typeIn, long indicesIn) {
        int countInstances;
        RenderSystem.assertOnRenderThread();
        GL11.glDrawElements((int)modeIn, (int)countIn, (int)typeIn, (long)indicesIn);
        if (Config.isShaders() && Shaders.isRenderingWorld && (countInstances = Shaders.activeProgram.getCountInstances()) > 1) {
            for (int i2 = 1; i2 < countInstances; ++i2) {
                Shaders.uniform_instanceId.setValue(i2);
                GL11.glDrawElements((int)modeIn, (int)countIn, (int)typeIn, (long)indicesIn);
            }
            Shaders.uniform_instanceId.setValue(0);
        }
    }

    public static void drawArrays(int mode, int first, int count) {
        int countInstances;
        RenderSystem.assertOnRenderThread();
        GL11.glDrawArrays((int)mode, (int)first, (int)count);
        if (Config.isShaders() && Shaders.isRenderingWorld && (countInstances = Shaders.activeProgram.getCountInstances()) > 1) {
            for (int i2 = 1; i2 < countInstances; ++i2) {
                Shaders.uniform_instanceId.setValue(i2);
                GL11.glDrawArrays((int)mode, (int)first, (int)count);
            }
            Shaders.uniform_instanceId.setValue(0);
        }
    }

    public static void _pixelStore(int pname, int param) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glPixelStorei((int)pname, (int)param);
    }

    public static void _readPixels(int x, int y, int width, int height, int format, int type, ByteBuffer pixels) {
        RenderSystem.assertOnRenderThread();
        GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (ByteBuffer)pixels);
    }

    public static void _readPixels(int x, int y, int width, int height, int format, int type, long pixels) {
        RenderSystem.assertOnRenderThread();
        GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (long)pixels);
    }

    public static int _getError() {
        RenderSystem.assertOnRenderThread();
        return GL11.glGetError();
    }

    public static String _getString(int name) {
        RenderSystem.assertOnRenderThread();
        return GL11.glGetString((int)name);
    }

    public static int _getInteger(int pname) {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL11.glGetInteger((int)pname);
    }

    public static void color4f(float red, float green, float blue, float alpha) {
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static int getActiveTextureUnit() {
        return 33984 + activeTexture;
    }

    public static void bindCurrentTexture() {
        GL11.glBindTexture((int)3553, (int)GlStateManager.TEXTURES[GlStateManager.activeTexture].b);
    }

    public static int getBoundTexture() {
        return GlStateManager.TEXTURES[GlStateManager.activeTexture].b;
    }

    public static int getBoundTexture(int textureUnit) {
        return GlStateManager.TEXTURES[textureUnit].b;
    }

    public static void checkBoundTexture() {
        if (!Config.isMinecraftThread()) {
            return;
        }
        int glAct = GL11.glGetInteger((int)34016);
        int glTex = GL11.glGetInteger((int)32873);
        int act = GlStateManager.getActiveTextureUnit();
        int tex = GlStateManager.getBoundTexture();
        if (tex <= 0) {
            return;
        }
        if (glAct != act || glTex != tex) {
            Config.dbg((String)("checkTexture: act: " + act + ", glAct: " + glAct + ", tex: " + tex + ", glTex: " + glTex));
        }
    }

    public static void genTextures(IntBuffer buf) {
        GL11.glGenTextures((IntBuffer)buf);
    }

    public static void deleteTextures(IntBuffer buf) {
        buf.rewind();
        while (buf.position() < buf.limit()) {
            int texId = buf.get();
            GlStateManager._deleteTexture((int)texId);
        }
        buf.rewind();
    }

    public static void lockAlpha(GlAlphaState stateNew) {
        if (alphaLock.isLocked()) {
            return;
        }
        GlStateManager.getAlphaState((GlAlphaState)alphaLockState);
        GlStateManager.setAlphaState((GlAlphaState)stateNew);
        alphaLock.lock();
    }

    public static void unlockAlpha() {
        if (!alphaLock.unlock()) {
            return;
        }
        GlStateManager.setAlphaState((GlAlphaState)alphaLockState);
    }

    public static void getAlphaState(GlAlphaState state) {
        if (alphaLock.isLocked()) {
            state.setState(alphaLockState);
            return;
        }
        state.setState(alphaTest, alphaTestFunc, alphaTestRef);
    }

    public static void setAlphaState(GlAlphaState state) {
        if (alphaLock.isLocked()) {
            alphaLockState.setState(state);
            return;
        }
        alphaTest = state.isEnabled();
        GlStateManager.alphaFunc((int)state.getFunc(), (float)state.getRef());
    }

    public static void lockBlend(GlBlendState stateNew) {
        if (blendLock.isLocked()) {
            return;
        }
        GlStateManager.getBlendState((GlBlendState)blendLockState);
        GlStateManager.setBlendState((GlBlendState)stateNew);
        blendLock.lock();
    }

    public static void unlockBlend() {
        if (!blendLock.unlock()) {
            return;
        }
        GlStateManager.setBlendState((GlBlendState)blendLockState);
    }

    public static void getBlendState(GlBlendState gbs) {
        if (blendLock.isLocked()) {
            gbs.setState(blendLockState);
            return;
        }
        gbs.setState(GlStateManager.BLEND.a.b, GlStateManager.BLEND.b, GlStateManager.BLEND.c, GlStateManager.BLEND.d, GlStateManager.BLEND.e);
    }

    public static void setBlendState(GlBlendState gbs) {
        if (blendLock.isLocked()) {
            blendLockState.setState(gbs);
            return;
        }
        GlStateManager.BLEND.a.a(gbs.isEnabled());
        if (!gbs.isSeparate()) {
            GlStateManager._blendFunc((int)gbs.getSrcFactor(), (int)gbs.getDstFactor());
        } else {
            GlStateManager._blendFuncSeparate((int)gbs.getSrcFactor(), (int)gbs.getDstFactor(), (int)gbs.getSrcFactorAlpha(), (int)gbs.getDstFactorAlpha());
        }
    }

    public static void lockCull(GlCullState stateNew) {
        if (cullLock.isLocked()) {
            return;
        }
        GlStateManager.getCullState((GlCullState)cullLockState);
        GlStateManager.setCullState((GlCullState)stateNew);
        cullLock.lock();
    }

    public static void unlockCull() {
        if (!cullLock.unlock()) {
            return;
        }
        GlStateManager.setCullState((GlCullState)cullLockState);
    }

    public static void getCullState(GlCullState state) {
        if (cullLock.isLocked()) {
            state.setState(cullLockState);
            return;
        }
        state.setState(GlStateManager.CULL.a.b, GlStateManager.CULL.b);
    }

    public static void setCullState(GlCullState state) {
        if (cullLock.isLocked()) {
            cullLockState.setState(state);
            return;
        }
        GlStateManager.CULL.a.a(state.isEnabled());
        GlStateManager.CULL.b = state.getMode();
    }

    public static void glMultiDrawArrays(int mode, IntBuffer bFirst, IntBuffer bCount) {
        int countInstances;
        GL14.glMultiDrawArrays((int)mode, (IntBuffer)bFirst, (IntBuffer)bCount);
        if (Config.isShaders() && (countInstances = Shaders.activeProgram.getCountInstances()) > 1) {
            for (int i2 = 1; i2 < countInstances; ++i2) {
                Shaders.uniform_instanceId.setValue(i2);
                GL14.glMultiDrawArrays((int)mode, (IntBuffer)bFirst, (IntBuffer)bCount);
            }
            Shaders.uniform_instanceId.setValue(0);
        }
    }

    public static void glMultiDrawElements(int modeIn, IntBuffer countsIn, int typeIn, PointerBuffer indicesIn) {
        int countInstances;
        RenderSystem.assertOnRenderThread();
        GL14.glMultiDrawElements((int)modeIn, (IntBuffer)countsIn, (int)typeIn, (PointerBuffer)indicesIn);
        if (Config.isShaders() && Shaders.isRenderingWorld && (countInstances = Shaders.activeProgram.getCountInstances()) > 1) {
            for (int i2 = 1; i2 < countInstances; ++i2) {
                Shaders.uniform_instanceId.setValue(i2);
                GL14.glMultiDrawElements((int)modeIn, (IntBuffer)countsIn, (int)typeIn, (PointerBuffer)indicesIn);
            }
            Shaders.uniform_instanceId.setValue(0);
        }
    }

    public static void clear(int mask) {
        GlStateManager._clear((int)mask, (boolean)false);
    }

    public static void bufferSubData(int target, long offset, ByteBuffer data) {
        GL15.glBufferSubData((int)target, (long)offset, (ByteBuffer)data);
    }

    public static void copyBufferSubData(int readTarget, int writeTarget, long readOffset, long writeOffset, long size) {
        GL31.glCopyBufferSubData((int)readTarget, (int)writeTarget, (long)readOffset, (long)writeOffset, (long)size);
    }

    public static void readPixels(int x, int y, int width, int height, int format, int type, long pixels) {
        GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (long)pixels);
    }

    public static int getFramebufferRead() {
        return framebufferRead;
    }

    public static int getFramebufferDraw() {
        return framebufferDraw;
    }

    public static void applyCurrentBlend() {
        if (GlStateManager.BLEND.a.b) {
            GL11.glEnable((int)3042);
        } else {
            GL11.glDisable((int)3042);
        }
        GL14.glBlendFuncSeparate((int)GlStateManager.BLEND.b, (int)GlStateManager.BLEND.c, (int)GlStateManager.BLEND.d, (int)GlStateManager.BLEND.e);
    }

    public static void setBlendsIndexed(GlBlendState[] blends) {
        if (blends == null) {
            return;
        }
        for (int i2 = 0; i2 < blends.length; ++i2) {
            GlBlendState bs = blends[i2];
            if (bs == null) continue;
            if (bs.isEnabled()) {
                GL30.glEnablei((int)3042, (int)i2);
            } else {
                GL30.glDisablei((int)3042, (int)i2);
            }
            ARBDrawBuffersBlend.glBlendFuncSeparateiARB((int)i2, (int)bs.getSrcFactor(), (int)bs.getDstFactor(), (int)bs.getSrcFactorAlpha(), (int)bs.getDstFactorAlpha());
        }
    }

    public static void bindImageTexture(int unit, int texture, int level, boolean layered, int layer, int access, int format) {
        if (unit >= 0 && unit < IMAGE_TEXTURES.length) {
            if (IMAGE_TEXTURES[unit] == texture) {
                return;
            }
            GlStateManager.IMAGE_TEXTURES[unit] = texture;
        }
        GL42.glBindImageTexture((int)unit, (int)texture, (int)level, (boolean)layered, (int)layer, (int)access, (int)format);
    }

    public static int getProgram() {
        return glProgram;
    }

    static {
        TEXTURES = (l[])IntStream.range(0, 32).mapToObj(indexIn -> new l()).toArray(l[]::new);
        COLOR_MASK = new d();
        alphaTest = false;
        alphaTestFunc = 519;
        alphaTestRef = 0.0f;
        alphaLock = new LockCounter();
        alphaLockState = new GlAlphaState();
        blendLock = new LockCounter();
        blendLockState = new GlBlendState();
        cullLock = new LockCounter();
        cullLockState = new GlCullState();
        IMAGE_TEXTURES = new int[8];
        glProgram = 0;
        lastBrightnessX = 0.0f;
        lastBrightnessY = 0.0f;
    }
}

