/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.optifine.Config;
import org.lwjgl.Version;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.slf4j.Logger;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;

@dyi
public class GLX {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static String cpuInfo;

    public static String getOpenGLVersionString() {
        RenderSystem.assertOnRenderThread();
        return GLFW.glfwGetCurrentContext() == 0L ? "NO CONTEXT" : GlStateManager._getString((int)7937) + " GL version " + GlStateManager._getString((int)7938) + ", " + GlStateManager._getString((int)7936);
    }

    public static int _getRefreshRate(dzu windowIn) {
        RenderSystem.assertOnRenderThread();
        long i2 = GLFW.glfwGetWindowMonitor((long)windowIn.i());
        if (i2 == 0L) {
            i2 = GLFW.glfwGetPrimaryMonitor();
        }
        GLFWVidMode glfwvidmode = i2 == 0L ? null : GLFW.glfwGetVideoMode((long)i2);
        return glfwvidmode == null ? 0 : glfwvidmode.refreshRate();
    }

    public static String _getLWJGLVersion() {
        RenderSystem.assertInInitPhase();
        return Version.getVersion();
    }

    public static LongSupplier _initGlfw() {
        RenderSystem.assertInInitPhase();
        dzu.a((p_241705_0_, p_241705_1_) -> {
            throw new IllegalStateException(String.format(Locale.ROOT, "GLFW error before init: [0x%X]%s", p_241705_0_, p_241705_1_));
        });
        ArrayList list = Lists.newArrayList();
        GLFWErrorCallback glfwerrorcallback = GLFW.glfwSetErrorCallback((p_241704_1_, p_241704_2_) -> list.add(String.format(Locale.ROOT, "GLFW error during init: [0x%X]%s", p_241704_1_, p_241704_2_)));
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Failed to initialize GLFW, errors: " + Joiner.on((String)",").join((Iterable)list));
        }
        LongSupplier longsupplier = () -> (long)(GLFW.glfwGetTime() * 1.0E9);
        for (String s : list) {
            LOGGER.error("GLFW error collected during initialization: {}", (Object)s);
        }
        RenderSystem.setErrorCallback((GLFWErrorCallbackI)glfwerrorcallback);
        return longsupplier;
    }

    public static void _setGlfwErrorCallback(GLFWErrorCallbackI errorCallbackIn) {
        RenderSystem.assertInInitPhase();
        GLFWErrorCallback glfwerrorcallback = GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)errorCallbackIn);
        if (glfwerrorcallback != null) {
            glfwerrorcallback.free();
        }
    }

    public static boolean _shouldClose(dzu windowIn) {
        return GLFW.glfwWindowShouldClose((long)windowIn.i());
    }

    public static void _init(int debugVerbosityIn, boolean debugSyncIn) {
        RenderSystem.assertInInitPhase();
        GLCapabilities glcapabilities = GL.getCapabilities();
        GlStateManager.init((GLCapabilities)glcapabilities);
        try {
            CentralProcessor centralprocessor = new SystemInfo().getHardware().getProcessor();
            cpuInfo = String.format(Locale.ROOT, "%dx %s", centralprocessor.getLogicalProcessorCount(), centralprocessor.getProcessorIdentifier().getName()).replaceAll("\\s+", " ");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        dzi.a((int)debugVerbosityIn, (boolean)debugSyncIn);
    }

    public static String _getCpuInfo() {
        return cpuInfo == null ? "<unknown>" : cpuInfo;
    }

    public static void _renderCrosshair(int sizeIn, boolean drawX, boolean drawY, boolean drawZ) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._disableTexture();
        GlStateManager._depthMask((boolean)false);
        GlStateManager._disableCull();
        RenderSystem.setShader(ezl::aq);
        eas tesselator = RenderSystem.renderThreadTesselator();
        eal bufferbuilder = tesselator.c();
        RenderSystem.lineWidth((float)4.0f);
        bufferbuilder.a(eav.b.a, eao.o);
        if (drawX) {
            bufferbuilder.a(0.0, 0.0, 0.0).a(0, 0, 0, 255).b(1.0f, 0.0f, 0.0f).e();
            bufferbuilder.a((double)sizeIn, 0.0, 0.0).a(0, 0, 0, 255).b(1.0f, 0.0f, 0.0f).e();
        }
        if (drawY) {
            bufferbuilder.a(0.0, 0.0, 0.0).a(0, 0, 0, 255).b(0.0f, 1.0f, 0.0f).e();
            bufferbuilder.a(0.0, (double)sizeIn, 0.0).a(0, 0, 0, 255).b(0.0f, 1.0f, 0.0f).e();
        }
        if (drawZ) {
            bufferbuilder.a(0.0, 0.0, 0.0).a(0, 0, 0, 255).b(0.0f, 0.0f, 1.0f).e();
            bufferbuilder.a(0.0, 0.0, (double)sizeIn).a(0, 0, 0, 255).b(0.0f, 0.0f, 1.0f).e();
        }
        tesselator.b();
        RenderSystem.lineWidth((float)2.0f);
        bufferbuilder.a(eav.b.a, eao.o);
        if (drawX) {
            bufferbuilder.a(0.0, 0.0, 0.0).a(255, 0, 0, 255).b(1.0f, 0.0f, 0.0f).e();
            bufferbuilder.a((double)sizeIn, 0.0, 0.0).a(255, 0, 0, 255).b(1.0f, 0.0f, 0.0f).e();
        }
        if (drawY) {
            bufferbuilder.a(0.0, 0.0, 0.0).a(0, 255, 0, 255).b(0.0f, 1.0f, 0.0f).e();
            bufferbuilder.a(0.0, (double)sizeIn, 0.0).a(0, 255, 0, 255).b(0.0f, 1.0f, 0.0f).e();
        }
        if (drawZ) {
            bufferbuilder.a(0.0, 0.0, 0.0).a(127, 127, 255, 255).b(0.0f, 0.0f, 1.0f).e();
            bufferbuilder.a(0.0, 0.0, (double)sizeIn).a(127, 127, 255, 255).b(0.0f, 0.0f, 1.0f).e();
        }
        tesselator.b();
        RenderSystem.lineWidth((float)1.0f);
        GlStateManager._enableCull();
        GlStateManager._depthMask((boolean)true);
        GlStateManager._enableTexture();
    }

    public static <T> T make(Supplier<T> supplierIn) {
        return supplierIn.get();
    }

    public static <T> T make(T objIn, Consumer<T> consumerIn) {
        consumerIn.accept(objIn);
        return objIn;
    }

    public static boolean isUsingFBOs() {
        return !Config.isAntialiasing();
    }

    public static boolean useVbo() {
        return true;
    }
}

