/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.NativeError;
import dev.latvian.mods.rhino.RhinoException;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;

public class JavaScriptException
extends RhinoException {
    private static final long serialVersionUID = -7666130513694669293L;
    private final Context localContext;
    private final Object value;

    public JavaScriptException(Context cx, Object value, String sourceName, int lineNumber) {
        super(cx);
        this.localContext = cx;
        this.recordErrorOrigin(sourceName, lineNumber, null, 0);
        this.value = value;
    }

    @Override
    public String details() {
        if (this.value == null) {
            return "null";
        }
        if (this.value instanceof NativeError) {
            return this.value.toString();
        }
        try {
            return ScriptRuntime.toString(this.localContext, this.value);
        }
        catch (RuntimeException rte) {
            if (this.value instanceof Scriptable) {
                return ScriptRuntime.defaultObjectToString((Scriptable)this.value);
            }
            return this.value.toString();
        }
    }

    public Object getValue() {
        return this.value;
    }
}

