/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.transfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mezz.jei.common.transfer.RecipeTransferUtil;
import mezz.jei.common.transfer.TransferOperation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class BasicRecipeTransferHandlerServer {
    private static final Logger LOGGER = LogManager.getLogger();

    private BasicRecipeTransferHandlerServer() {
    }

    public static void setItems(Player player, List<TransferOperation> transferOperations, List<Slot> craftingSlots, List<Slot> inventorySlots, boolean maxTransfer, boolean requireCompleteSets) {
        if (!RecipeTransferUtil.validateSlots(player, transferOperations, craftingSlots, inventorySlots)) {
            return;
        }
        Map<Slot, ItemStackWithSlotHint> recipeSlotToRequiredItemStack = BasicRecipeTransferHandlerServer.calculateRequiredStacks(transferOperations, player);
        if (recipeSlotToRequiredItemStack == null) {
            return;
        }
        boolean transferAsCompleteSets = requireCompleteSets || !maxTransfer;
        Map<Slot, ItemStack> recipeSlotToTakenStacks = BasicRecipeTransferHandlerServer.takeItemsFromInventory(player, recipeSlotToRequiredItemStack, craftingSlots, inventorySlots, transferAsCompleteSets, maxTransfer);
        if (recipeSlotToTakenStacks.isEmpty()) {
            LOGGER.error("Tried to transfer recipe but was unable to remove any items from the inventory.");
            return;
        }
        List<ItemStack> clearedCraftingItems = BasicRecipeTransferHandlerServer.clearCraftingGrid(craftingSlots, player);
        List<ItemStack> remainderItems = BasicRecipeTransferHandlerServer.putItemsIntoCraftingGrid(recipeSlotToTakenStacks, requireCompleteSets);
        BasicRecipeTransferHandlerServer.stowItems(player, inventorySlots, clearedCraftingItems);
        BasicRecipeTransferHandlerServer.stowItems(player, inventorySlots, remainderItems);
        AbstractContainerMenu container = player.f_36096_;
        container.m_38946_();
    }

    private static int getSlotStackLimit(Map<Slot, ItemStack> recipeSlotToTakenStacks, boolean requireCompleteSets) {
        if (!requireCompleteSets) {
            return Integer.MAX_VALUE;
        }
        return recipeSlotToTakenStacks.entrySet().stream().mapToInt(e -> {
            ItemStack transferItem;
            Slot craftingSlot = (Slot)e.getKey();
            if (craftingSlot.m_5857_(transferItem = (ItemStack)e.getValue())) {
                return craftingSlot.m_5866_(transferItem);
            }
            return Integer.MAX_VALUE;
        }).min().orElse(Integer.MAX_VALUE);
    }

    private static List<ItemStack> clearCraftingGrid(List<Slot> craftingSlots, Player player) {
        ArrayList<ItemStack> clearedCraftingItems = new ArrayList<ItemStack>();
        for (Slot craftingSlot : craftingSlots) {
            if (!craftingSlot.m_8010_(player) || !craftingSlot.m_6657_()) continue;
            ItemStack craftingItem = craftingSlot.m_6201_(Integer.MAX_VALUE);
            clearedCraftingItems.add(craftingItem);
        }
        return clearedCraftingItems;
    }

    private static List<ItemStack> putItemsIntoCraftingGrid(Map<Slot, ItemStack> recipeSlotToTakenStacks, boolean requireCompleteSets) {
        int slotStackLimit = BasicRecipeTransferHandlerServer.getSlotStackLimit(recipeSlotToTakenStacks, requireCompleteSets);
        ArrayList<ItemStack> remainderItems = new ArrayList<ItemStack>();
        recipeSlotToTakenStacks.forEach((slot, stack) -> {
            if (slot.m_7993_().m_41619_() && slot.m_5857_(stack)) {
                ItemStack remainder = slot.m_150656_(stack, slotStackLimit);
                if (!remainder.m_41619_()) {
                    remainderItems.add(remainder);
                }
            } else {
                remainderItems.add((ItemStack)stack);
            }
        });
        return remainderItems;
    }

    @Nullable
    private static Map<Slot, ItemStackWithSlotHint> calculateRequiredStacks(List<TransferOperation> transferOperations, Player player) {
        HashMap<Slot, ItemStackWithSlotHint> recipeSlotToRequired = new HashMap<Slot, ItemStackWithSlotHint>(transferOperations.size());
        for (TransferOperation transferOperation : transferOperations) {
            Slot recipeSlot = transferOperation.craftingSlot();
            Slot inventorySlot = transferOperation.inventorySlot();
            if (!inventorySlot.m_8010_(player)) {
                LOGGER.error("Tried to transfer recipe but was given an inventory slot that the player can't pickup from: {}", (Object)inventorySlot.f_40219_);
                return null;
            }
            ItemStack slotStack = inventorySlot.m_7993_();
            if (slotStack.m_41619_()) {
                LOGGER.error("Tried to transfer recipe but was given an empty inventory slot as an ingredient source: {}", (Object)inventorySlot.f_40219_);
                return null;
            }
            ItemStack stack = slotStack.m_41777_();
            stack.m_41764_(1);
            recipeSlotToRequired.put(recipeSlot, new ItemStackWithSlotHint(inventorySlot, stack));
        }
        return recipeSlotToRequired;
    }

    @Nonnull
    private static Map<Slot, ItemStack> takeItemsFromInventory(Player player, Map<Slot, ItemStackWithSlotHint> recipeSlotToRequiredItemStack, List<Slot> craftingSlots, List<Slot> inventorySlots, boolean transferAsCompleteSets, boolean maxTransfer) {
        Map<Slot, ItemStack> foundItemsInSet;
        if (!maxTransfer) {
            return BasicRecipeTransferHandlerServer.removeOneSetOfItemsFromInventory(player, recipeSlotToRequiredItemStack, craftingSlots, inventorySlots, transferAsCompleteSets);
        }
        HashMap<Slot, ItemStack> recipeSlotToResult = new HashMap<Slot, ItemStack>(recipeSlotToRequiredItemStack.size());
        while (!(foundItemsInSet = BasicRecipeTransferHandlerServer.removeOneSetOfItemsFromInventory(player, recipeSlotToRequiredItemStack, craftingSlots, inventorySlots, transferAsCompleteSets)).isEmpty()) {
            Set<Slot> fullSlots = BasicRecipeTransferHandlerServer.merge(recipeSlotToResult, foundItemsInSet);
            for (Slot fullSlot : fullSlots) {
                recipeSlotToRequiredItemStack.remove(fullSlot);
            }
        }
        return recipeSlotToResult;
    }

    private static Map<Slot, ItemStack> removeOneSetOfItemsFromInventory(Player player, Map<Slot, ItemStackWithSlotHint> recipeSlotToRequiredItemStack, List<Slot> craftingSlots, List<Slot> inventorySlots, boolean transferAsCompleteSets) {
        HashMap<Slot, ItemStack> originalSlotContents = null;
        if (transferAsCompleteSets) {
            originalSlotContents = new HashMap<Slot, ItemStack>();
        }
        HashMap<Slot, ItemStack> foundItemsInSet = new HashMap<Slot, ItemStack>(recipeSlotToRequiredItemStack.size());
        for (Map.Entry<Slot, ItemStackWithSlotHint> entry : recipeSlotToRequiredItemStack.entrySet()) {
            Slot recipeSlot = entry.getKey();
            ItemStack requiredStack = entry.getValue().stack;
            Slot hint = entry.getValue().hint;
            Slot slot = BasicRecipeTransferHandlerServer.getSlotWithStack(player, requiredStack, craftingSlots, inventorySlots, hint);
            if (slot != null) {
                if (originalSlotContents != null && !originalSlotContents.containsKey(slot)) {
                    originalSlotContents.put(slot, slot.m_7993_().m_41777_());
                }
                ItemStack removedItemStack = slot.m_6201_(1);
                foundItemsInSet.put(recipeSlot, removedItemStack);
                continue;
            }
            if (!transferAsCompleteSets) continue;
            for (Map.Entry slotEntry : originalSlotContents.entrySet()) {
                ItemStack stack = (ItemStack)slotEntry.getValue();
                ((Slot)slotEntry.getKey()).m_5852_(stack);
            }
            return Map.of();
        }
        return foundItemsInSet;
    }

    private static Set<Slot> merge(Map<Slot, ItemStack> result, Map<Slot, ItemStack> addition) {
        HashSet<Slot> fullSlots = new HashSet<Slot>();
        addition.forEach((slot, itemStack) -> {
            assert (itemStack.m_41613_() == 1);
            ItemStack resultItemStack = (ItemStack)result.get(slot);
            if (resultItemStack == null) {
                resultItemStack = itemStack;
                result.put((Slot)slot, resultItemStack);
            } else {
                assert (ItemStack.m_150942_((ItemStack)resultItemStack, (ItemStack)itemStack));
                resultItemStack.m_41769_(itemStack.m_41613_());
            }
            if (resultItemStack.m_41613_() == slot.m_5866_(resultItemStack)) {
                fullSlots.add((Slot)slot);
            }
        });
        return fullSlots;
    }

    @Nullable
    private static Slot getSlotWithStack(Player player, ItemStack stack, List<Slot> craftingSlots, List<Slot> inventorySlots, Slot hint) {
        Slot slot = BasicRecipeTransferHandlerServer.getSlotWithStack(player, craftingSlots, stack);
        if (slot == null) {
            if (hint.m_8010_(player) && !hint.m_7993_().m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)hint.m_7993_())) {
                return hint;
            }
            slot = BasicRecipeTransferHandlerServer.getSlotWithStack(player, inventorySlots, stack);
        }
        return slot;
    }

    private static void stowItems(Player player, List<Slot> inventorySlots, List<ItemStack> itemStacks) {
        for (ItemStack itemStack : itemStacks) {
            ItemStack remainder = BasicRecipeTransferHandlerServer.stowItem(inventorySlots, itemStack);
            if (remainder.m_41619_() || player.m_150109_().m_36054_(remainder)) continue;
            player.m_36176_(remainder, false);
        }
    }

    private static ItemStack stowItem(Collection<Slot> slots, ItemStack stack) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack remainder = stack.m_41777_();
        for (Slot slot : slots) {
            ItemStack inventoryStack = slot.m_7993_();
            if (inventoryStack.m_41619_() || !inventoryStack.m_41753_()) continue;
            slot.m_150659_(remainder);
            if (!remainder.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        for (Slot slot : slots) {
            if (!slot.m_7993_().m_41619_()) continue;
            slot.m_150659_(remainder);
            if (!remainder.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return remainder;
    }

    @Nullable
    private static Slot getSlotWithStack(Player player, Iterable<Slot> slots, ItemStack itemStack) {
        for (Slot slot : slots) {
            ItemStack slotStack = slot.m_7993_();
            if (!ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)slotStack) || !slot.m_8010_(player)) continue;
            return slot;
        }
        return null;
    }

    private record ItemStackWithSlotHint(Slot hint, ItemStack stack) {
    }
}

