/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.recipes;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeCatalystLookup;
import mezz.jei.api.recipe.IRecipeCategoriesLookup;
import mezz.jei.api.recipe.IRecipeLookup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.common.focus.FocusGroup;
import mezz.jei.common.gui.recipes.layout.RecipeLayout;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.recipes.RecipeCatalystLookup;
import mezz.jei.common.recipes.RecipeCategoriesLookup;
import mezz.jei.common.recipes.RecipeLookup;
import mezz.jei.common.recipes.RecipeManagerInternal;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class RecipeManager
implements IRecipeManager {
    private final RecipeManagerInternal internal;
    private final IModIdHelper modIdHelper;
    private final RegisteredIngredients registeredIngredients;
    private final Textures textures;
    private final IIngredientVisibility ingredientVisibility;

    public RecipeManager(RecipeManagerInternal internal, IModIdHelper modIdHelper, RegisteredIngredients registeredIngredients, Textures textures, IIngredientVisibility ingredientVisibility) {
        this.internal = internal;
        this.modIdHelper = modIdHelper;
        this.registeredIngredients = registeredIngredients;
        this.textures = textures;
        this.ingredientVisibility = ingredientVisibility;
    }

    @Override
    public <R> IRecipeLookup<R> createRecipeLookup(RecipeType<R> recipeType) {
        ErrorUtil.checkNotNull(recipeType, "recipeType");
        return new RecipeLookup<R>(recipeType, this.internal, this.registeredIngredients);
    }

    @Override
    public IRecipeCategoriesLookup createRecipeCategoryLookup() {
        return new RecipeCategoriesLookup(this.internal, this.registeredIngredients);
    }

    @Override
    public IRecipeCatalystLookup createRecipeCatalystLookup(RecipeType<?> recipeType) {
        return new RecipeCatalystLookup(recipeType, this.internal);
    }

    @Override
    public <T> void addRecipes(RecipeType<T> recipeType, List<T> recipes) {
        ErrorUtil.checkNotNull(recipeType, "recipeType");
        ErrorUtil.checkNotNull(recipes, "recipes");
        ErrorUtil.assertMainThread();
        this.internal.addRecipes(recipeType, recipes);
    }

    @Override
    public <T> IRecipeLayoutDrawable createRecipeLayoutDrawable(IRecipeCategory<T> recipeCategory, T recipe, @Nullable IFocus<?> focus) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        ErrorUtil.checkNotNull(recipe, "recipe");
        IFocusGroup focusGroup = FocusGroup.createFromNullable(focus, this.registeredIngredients);
        RecipeLayout<T> recipeLayout = RecipeLayout.create(-1, recipeCategory, recipe, focusGroup, this.registeredIngredients, this.ingredientVisibility, this.modIdHelper, 0, 0, this.textures);
        Preconditions.checkNotNull(recipeLayout, (Object)"Recipe layout crashed during creation, see log.");
        return recipeLayout;
    }

    @Override
    public <T> void hideRecipes(RecipeType<T> recipeType, Collection<T> recipes) {
        ErrorUtil.checkNotNull(recipes, "recipe");
        ErrorUtil.checkNotNull(recipeType, "recipeType");
        ErrorUtil.assertMainThread();
        this.internal.hideRecipes(recipeType, recipes);
    }

    @Override
    public <T> void unhideRecipes(RecipeType<T> recipeType, Collection<T> recipes) {
        ErrorUtil.checkNotNull(recipes, "recipe");
        ErrorUtil.checkNotNull(recipeType, "recipeType");
        ErrorUtil.assertMainThread();
        this.internal.unhideRecipes(recipeType, recipes);
    }

    @Override
    public void hideRecipeCategory(RecipeType<?> recipeType) {
        ErrorUtil.checkNotNull(recipeType, "recipeType");
        ErrorUtil.assertMainThread();
        this.internal.hideRecipeCategory(recipeType);
    }

    @Override
    public void unhideRecipeCategory(RecipeType<?> recipeType) {
        ErrorUtil.checkNotNull(recipeType, "recipeType");
        ErrorUtil.assertMainThread();
        this.internal.unhideRecipeCategory(recipeType);
    }

    @Override
    public Optional<RecipeType<?>> getRecipeType(ResourceLocation recipeUid) {
        return this.internal.getRecipeType(recipeUid);
    }
}

