/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.helpers;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.config.IModIdFormatConfig;
import mezz.jei.common.platform.IPlatformModHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.core.config.IClientConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;

public final class ModIdHelper
implements IModIdHelper {
    private final IClientConfig config;
    private final IModIdFormatConfig modIdFormattingConfig;

    public ModIdHelper(IClientConfig config, IModIdFormatConfig modIdFormattingConfig) {
        this.config = config;
        this.modIdFormattingConfig = modIdFormattingConfig;
    }

    @Override
    public boolean isDisplayingModNameEnabled() {
        String modNameFormat = this.modIdFormattingConfig.getModNameFormat();
        return !modNameFormat.isEmpty();
    }

    @Override
    public <T> List<Component> addModNameToIngredientTooltip(List<Component> tooltip, T ingredient, IIngredientHelper<T> ingredientHelper) {
        if (this.config.isDebugModeEnabled() && Minecraft.m_91087_().f_91066_.f_92125_) {
            tooltip = ModIdHelper.addDebugInfo(tooltip, ingredient, ingredientHelper);
        }
        if (!this.isDisplayingModNameEnabled()) {
            return tooltip;
        }
        if (this.modIdFormattingConfig.isModNameFormatOverrideActive() && ingredient instanceof ItemStack) {
            return tooltip;
        }
        String modId = ingredientHelper.getDisplayModId(ingredient);
        String modName = this.getFormattedModNameForModId(modId);
        ArrayList<Component> tooltipCopy = new ArrayList<Component>(tooltip);
        tooltipCopy.add((Component)Component.m_237113_((String)modName));
        return tooltipCopy;
    }

    private static String removeChatFormatting(String string) {
        String withoutFormattingCodes = ChatFormatting.m_126649_((String)string);
        return withoutFormattingCodes == null ? "" : withoutFormattingCodes;
    }

    private static <T> List<Component> addDebugInfo(List<Component> tooltip, T ingredient, IIngredientHelper<T> ingredientHelper) {
        tooltip = new ArrayList<Component>(tooltip);
        MutableComponent jeiDebug = Component.m_237113_((String)"JEI Debug:");
        MutableComponent info = Component.m_237113_((String)("info: " + ingredientHelper.getErrorInfo(ingredient)));
        MutableComponent uid = Component.m_237113_((String)("uid: " + ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient)));
        tooltip.add((Component)jeiDebug.m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)info.m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)uid.m_130940_(ChatFormatting.DARK_GRAY));
        return tooltip;
    }

    @Override
    public String getFormattedModNameForModId(String modId) {
        String modName = this.getModNameForModId(modId);
        modName = ModIdHelper.removeChatFormatting(modName);
        String modNameFormat = this.modIdFormattingConfig.getModNameFormat();
        if (!modNameFormat.isEmpty()) {
            if (modNameFormat.contains("%MODNAME%")) {
                return StringUtils.replaceOnce((String)modNameFormat, (String)"%MODNAME%", (String)modName);
            }
            return modNameFormat + modName;
        }
        return modName;
    }

    @Override
    public String getModNameForModId(String modId) {
        IPlatformModHelper modHelper = Services.PLATFORM.getModHelper();
        return modHelper.getModNameForModId(modId);
    }
}

