/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mezz.jei.common.config.IModIdFormatConfig;
import mezz.jei.common.config.file.IConfigCategoryBuilder;
import mezz.jei.common.config.file.IConfigSchemaBuilder;
import mezz.jei.common.config.file.serializers.ChatFormattingSerializer;
import mezz.jei.common.platform.IPlatformItemStackHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.core.util.function.CachedSupplierTransformer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ModIdFormatConfig
implements IModIdFormatConfig {
    protected static final List<ChatFormatting> defaultModNameFormat = List.of(ChatFormatting.BLUE, ChatFormatting.ITALIC);
    public static final String MOD_NAME_FORMAT_CODE = "%MODNAME%";
    private final Supplier<String> modNameFormat;
    @Nullable
    private String cachedOverride;

    public ModIdFormatConfig(IConfigSchemaBuilder builder) {
        IConfigCategoryBuilder modName = builder.addCategory("modname");
        Supplier<List<ChatFormatting>> configValue = modName.addList("ModNameFormat", defaultModNameFormat, ChatFormattingSerializer.INSTANCE, "Formatting for mod name tooltip");
        this.modNameFormat = new CachedSupplierTransformer<List, String>(configValue, ModIdFormatConfig::toFormatString);
    }

    private static String toFormatString(List<ChatFormatting> values) {
        return values.stream().map(ChatFormatting::toString).collect(Collectors.joining());
    }

    private String getOverride() {
        if (this.cachedOverride == null) {
            this.cachedOverride = this.detectModNameTooltipFormatting();
        }
        return this.cachedOverride;
    }

    @Override
    public final String getModNameFormat() {
        String override = this.getOverride();
        if (!override.isEmpty()) {
            return override;
        }
        return this.modNameFormat.get();
    }

    @Override
    public final boolean isModNameFormatOverrideActive() {
        return !this.getOverride().isEmpty();
    }

    private String detectModNameTooltipFormatting() {
        IPlatformItemStackHelper itemStackHelper = Services.PLATFORM.getItemStackHelper();
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        List<Component> tooltip = itemStackHelper.getTestTooltip((Player)player, new ItemStack((ItemLike)Items.f_42410_));
        if (tooltip.size() <= 1) {
            return "";
        }
        for (int lineNum = 1; lineNum < tooltip.size(); ++lineNum) {
            String withoutFormatting;
            Component line = tooltip.get(lineNum);
            String lineString = line.getString();
            if (!lineString.contains("Minecraft") || (withoutFormatting = ChatFormatting.m_126649_((String)lineString)) == null || !withoutFormatting.contains("Minecraft")) continue;
            return StringUtils.replaceOnce((String)lineString, (String)"Minecraft", (String)MOD_NAME_FORMAT_CODE);
        }
        return "";
    }
}

