/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util;

import org.tlauncher.TLSkinCape;

public final class TLModCfg {
    private static String MINECRAFT_VERSION = "forge1.18";
    private static GameVersionCategory GAME_VERSION_CATEGORY;
    private static boolean isForgeDetected;
    private static boolean isOptiFineDetected;
    private static boolean isFabricDetected;

    private static void defineGameVersionCategory(ClassLoader classLoader) {
        GAME_VERSION_CATEGORY = GameVersionCategory.CAVES_AND_CLIFFS;
    }

    public static String getMinecraftVersion() {
        return MINECRAFT_VERSION;
    }

    public static boolean isElytraSupported() {
        return !MINECRAFT_VERSION.startsWith("1.8");
    }

    public static boolean isNativeImageSupported() {
        return !MINECRAFT_VERSION.startsWith("1.8") && !MINECRAFT_VERSION.equals("1.12.2");
    }

    public static GameVersionCategory getGameVersionCategory() {
        if (GAME_VERSION_CATEGORY == null) {
            TLModCfg.defineGameVersionCategory(TLSkinCape.getMinecraftInstance().getClass().getClassLoader());
        }
        return GAME_VERSION_CATEGORY;
    }

    private TLModCfg() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static boolean isForgeDetected() {
        return isForgeDetected;
    }

    public static boolean isOptiFineDetected() {
        return isOptiFineDetected;
    }

    public static boolean isFabricDetected() {
        return isFabricDetected;
    }

    static {
        System.out.println("[TLSkinCape] Current TLSkinCape version is 1.27");
        if (TLModCfg.getMinecraftVersion().startsWith("forge")) {
            isForgeDetected = true;
            MINECRAFT_VERSION = MINECRAFT_VERSION.replace("forge", "");
        }
        if (TLModCfg.getMinecraftVersion().startsWith("fabric")) {
            isFabricDetected = true;
            MINECRAFT_VERSION = MINECRAFT_VERSION.replace("fabric", "");
        }
        System.out.printf("[TLSkinCape] Current Minecraft version is %s.%n", TLModCfg.getMinecraftVersion());
        try {
            Class.forName("net.optifine.shaders.ShadersTex", false, TLModCfg.class.getClassLoader());
            isOptiFineDetected = true;
            System.out.println("[TLSkinCape] OptiFine detected.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static enum GameVersionCategory {
        CAVES_AND_CLIFFS;

    }
}

