/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.client.VisibleClientPlayers;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class SendVisiblePlayerListPacket
extends BaseS2CMessage {
    public final List<UUID> uuids;

    private SendVisiblePlayerListPacket(List<UUID> uuids) {
        this.uuids = uuids;
    }

    SendVisiblePlayerListPacket(FriendlyByteBuf buf) {
        this.uuids = new ArrayList<UUID>();
        int size = buf.m_130242_();
        for (int i = 0; i < size; ++i) {
            this.uuids.add(buf.m_130259_());
        }
    }

    public MessageType getType() {
        return FTBChunksNet.SEND_VISIBLE_PLAYER_LIST;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.uuids.size());
        this.uuids.forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130077_(arg_0));
    }

    public void handle(NetworkManager.PacketContext context) {
        VisibleClientPlayers.updatePlayerList(this.uuids);
    }

    public static void syncToLevel(Level level) {
        SendVisiblePlayerListPacket.syncToPlayers(FTBChunksAPI.getManager().getMinecraftServer().m_6846_().m_11314_().stream().filter(p -> p.f_19853_ == level).toList());
    }

    public static void syncToAll() {
        SendVisiblePlayerListPacket.syncToPlayers(FTBChunksAPI.getManager().getMinecraftServer().m_6846_().m_11314_());
    }

    public static void syncToPlayers(List<ServerPlayer> players) {
        if (players == null) {
            players = FTBChunksAPI.getManager().getMinecraftServer().m_6846_().m_11314_();
        }
        List playerList = players.stream().map(player -> new VisiblePlayerItem((ServerPlayer)player, FTBChunksAPI.getManager().getData((ServerPlayer)player))).collect(Collectors.toList());
        for (VisiblePlayerItem recipient : playerList) {
            ArrayList<UUID> playerIds = new ArrayList<UUID>();
            for (VisiblePlayerItem other : playerList) {
                if (!recipient.player.m_20310_(2) && !other.data.canUse(recipient.player, FTBChunksTeamData.LOCATION_MODE)) continue;
                playerIds.add(other.player.m_20148_());
            }
            new SendVisiblePlayerListPacket(playerIds).sendTo(recipient.player);
        }
    }

    private record VisiblePlayerItem(ServerPlayer player, FTBChunksTeamData data) {
    }
}

