/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.registry.registries.Registries;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ImageIcon;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.monster.Enemy;

public class EntityIcons
extends SimplePreparableReloadListener<Map<EntityType<?>, Icon>> {
    public static final Icon NORMAL = Icon.getIcon((String)"ftbchunks:textures/faces/normal.png");
    public static final Icon HOSTILE = Icon.getIcon((String)"ftbchunks:textures/faces/hostile.png");
    public static final Map<EntityType<?>, Icon> ENTITY_ICONS = new HashMap();

    protected Map<EntityType<?>, Icon> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap map = new HashMap();
        for (Map.Entry entry : Registries.get((String)"ftbchunks").get(Registry.f_122903_).entrySet()) {
            ResourceLocation id = ((ResourceKey)entry.getKey()).m_135782_();
            EntityType t = (EntityType)entry.getValue();
            if (t.m_20674_() == MobCategory.MISC) continue;
            ResourceLocation invisible = new ResourceLocation("ftbchunks:textures/faces/" + id.m_135827_() + "/" + id.m_135815_() + ".invisible");
            if (resourceManager.m_213713_(invisible).isPresent()) {
                map.put(t, (Icon)Icon.EMPTY);
                continue;
            }
            ResourceLocation texture = new ResourceLocation("ftbchunks:textures/faces/" + id.m_135827_() + "/" + id.m_135815_() + ".png");
            if (!resourceManager.m_213713_(texture).isPresent()) continue;
            map.put(t, Icon.getIcon((ResourceLocation)texture));
        }
        return map;
    }

    protected void apply(Map<EntityType<?>, Icon> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        ENTITY_ICONS.clear();
        ENTITY_ICONS.putAll(object);
        Minecraft.m_91087_().m_18707_(() -> {
            for (Icon icon : object.values()) {
                if (!(icon instanceof ImageIcon)) continue;
                ((ImageIcon)icon).bindTexture();
                RenderSystem.m_69937_((int)3553, (int)10241, (int)9729);
                RenderSystem.m_69937_((int)3553, (int)10240, (int)9729);
            }
        });
    }

    public static Icon get(Entity entity) {
        Icon texture = ENTITY_ICONS.get(entity.m_6095_());
        if (texture == null || !((Boolean)FTBChunksClientConfig.MINIMAP_ENTITY_HEADS.get()).booleanValue()) {
            if (entity instanceof Enemy) {
                return HOSTILE;
            }
            return NORMAL;
        }
        return texture;
    }
}

