/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.ExplosionEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.Registries;
import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.value.IntValue;
import dev.ftb.mods.ftbchunks.FTBChunksCommands;
import dev.ftb.mods.ftbchunks.FTBChunksCommon;
import dev.ftb.mods.ftbchunks.FTBChunksExpected;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.FTBRanksIntegration;
import dev.ftb.mods.ftbchunks.LongRangePlayerTracker;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.data.ClaimExpirationManager;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManager;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.data.Protection;
import dev.ftb.mods.ftbchunks.integration.waystones.WaystonesCommon;
import dev.ftb.mods.ftbchunks.net.ChunkSendingUtils;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import dev.ftb.mods.ftbchunks.net.LoginDataPacket;
import dev.ftb.mods.ftbchunks.net.PlayerDeathPacket;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftbchunks.net.SendManyChunksPacket;
import dev.ftb.mods.ftbchunks.net.SendVisiblePlayerListPacket;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.config.ConfigUtil;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.event.PlayerJoinedPartyTeamEvent;
import dev.ftb.mods.ftbteams.event.PlayerLeftPartyTeamEvent;
import dev.ftb.mods.ftbteams.event.PlayerLoggedInAfterTeamEvent;
import dev.ftb.mods.ftbteams.event.PlayerTransferredTeamOwnershipEvent;
import dev.ftb.mods.ftbteams.event.TeamAllyEvent;
import dev.ftb.mods.ftbteams.event.TeamCollectPropertiesEvent;
import dev.ftb.mods.ftbteams.event.TeamCreatedEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import dev.ftb.mods.ftbteams.event.TeamManagerEvent;
import dev.ftb.mods.ftbteams.event.TeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FTBChunks {
    public static final String MOD_ID = "ftbchunks";
    public static final Logger LOGGER = LogManager.getLogger((String)"FTB Chunks");
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setLenient().create();
    public static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor();
    public static FTBChunks instance;
    public static FTBChunksCommon PROXY;
    public static final int TILES = 15;
    public static final int TILE_SIZE = 16;
    public static final int TILE_OFFSET = 7;
    public static final int MINIMAP_SIZE = 240;
    public static final XZ[] RELATIVE_SPIRAL_POSITIONS;
    public static final Registrar<Block> BLOCK_REGISTRY;
    public static boolean ranksMod;

    public FTBChunks() {
        PROXY = (FTBChunksCommon)EnvExecutor.getEnvSpecific(() -> FTBChunksClient::new, () -> FTBChunksCommon::new);
        ranksMod = Platform.isModLoaded((String)"ftbranks");
        FTBChunksNet.init();
        for (int i = 0; i < RELATIVE_SPIRAL_POSITIONS.length; ++i) {
            FTBChunks.RELATIVE_SPIRAL_POSITIONS[i] = MathUtils.getSpiralPoint((int)(i + 1));
        }
        LifecycleEvent.SERVER_BEFORE_START.register(this::serverBeforeStart);
        LifecycleEvent.SERVER_LEVEL_LOAD.register(this::serverLevelLoad);
        TeamManagerEvent.CREATED.register(this::teamManagerCreated);
        TeamManagerEvent.DESTROYED.register(this::teamManagerDestroyed);
        TeamEvent.PLAYER_LOGGED_IN.register(this::loggedIn);
        TeamEvent.CREATED.register(this::teamCreated);
        TeamEvent.LOADED.register(this::teamLoaded);
        TeamEvent.SAVED.register(this::teamSaved);
        TeamEvent.COLLECT_PROPERTIES.register(this::teamConfig);
        TeamEvent.PLAYER_JOINED_PARTY.register(this::playerJoinedParty);
        TeamEvent.PLAYER_LEFT_PARTY.register(this::playerLeftParty);
        TeamEvent.OWNERSHIP_TRANSFERRED.register(this::teamOwnershipTransferred);
        TeamEvent.PROPERTIES_CHANGED.register(this::teamPropertiesChanged);
        TeamEvent.ADD_ALLY.register(this::playerAllianceChange);
        TeamEvent.REMOVE_ALLY.register(this::playerAllianceChange);
        InteractionEvent.LEFT_CLICK_BLOCK.register(this::blockLeftClick);
        InteractionEvent.RIGHT_CLICK_BLOCK.register(this::blockRightClick);
        InteractionEvent.RIGHT_CLICK_ITEM.register(this::itemRightClick);
        InteractionEvent.INTERACT_ENTITY.register(this::interactEntity);
        InteractionEvent.FARMLAND_TRAMPLE.register(this::farmlandTrample);
        BlockEvent.BREAK.register(this::blockBreak);
        BlockEvent.PLACE.register(this::blockPlace);
        PlayerEvent.PLAYER_QUIT.register(this::loggedOut);
        PlayerEvent.FILL_BUCKET.register(this::fillBucket);
        PlayerEvent.PLAYER_CLONE.register(this::playerCloned);
        EntityEvent.ENTER_SECTION.register(this::enterSection);
        EntityEvent.LIVING_CHECK_SPAWN.register(this::checkSpawn);
        ExplosionEvent.DETONATE.register(this::explosionDetonate);
        CommandRegistrationEvent.EVENT.register(FTBChunksCommands::registerCommands);
        TickEvent.SERVER_POST.register(this::serverTickPost);
        TickEvent.PLAYER_POST.register(this::playerTickPost);
        if (ranksMod) {
            FTBRanksIntegration.registerEvents();
        }
        if (Platform.isModLoaded((String)"waystones")) {
            WaystonesCommon.init();
        }
        PROXY.init();
    }

    private void playerTickPost(Player player) {
        if (player.f_19853_.f_46443_ && player.f_19853_.m_46467_() % 20L == 0L) {
            PROXY.maybeClearDeathpoint(player);
        }
    }

    private void serverBeforeStart(MinecraftServer server) {
        Path configPath = server.m_129843_(ConfigUtil.SERVER_CONFIG_DIR);
        ConfigUtil.loadDefaulted((SNBTConfig)FTBChunksWorldConfig.CONFIG, (Path)configPath, (String)MOD_ID);
        FTBChunksWorldConfig.CLAIM_DIMENSION_BLACKLIST_SET.clear();
        for (String s : (List)FTBChunksWorldConfig.CLAIM_DIMENSION_BLACKLIST.get()) {
            FTBChunksWorldConfig.CLAIM_DIMENSION_BLACKLIST_SET.add((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(s)));
        }
    }

    private void serverLevelLoad(ServerLevel level) {
        if (FTBChunksAPI.manager != null) {
            FTBChunksAPI.manager.initForceLoadedChunks(level);
        } else {
            LOGGER.warn("Level " + level.m_46472_().m_135782_() + " loaded before FTB Chunks manager was initialized! Unable to force-load chunks");
        }
    }

    private void teamManagerCreated(TeamManagerEvent event) {
        FTBChunksAPI.manager = new ClaimedChunkManager(event.getManager());
    }

    private void teamManagerDestroyed(TeamManagerEvent event) {
        FTBChunksAPI.manager = null;
    }

    private void loggedIn(PlayerLoggedInAfterTeamEvent event) {
        ServerPlayer player = event.getPlayer();
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(player);
        data.updateLimits();
        SNBTCompoundTag config = new SNBTCompoundTag();
        FTBChunksWorldConfig.CONFIG.write(config);
        new LoginDataPacket(event.getTeam().manager.getId(), config).sendTo(player);
        SendGeneralDataPacket.send(data, player);
        long now = System.currentTimeMillis();
        HashMap<Pair, List> chunksToSend = new HashMap<Pair, List>();
        for (ClaimedChunk chunk : FTBChunksAPI.getManager().getAllClaimedChunks()) {
            chunksToSend.computeIfAbsent(Pair.of((Object)chunk.pos.dimension, (Object)chunk.teamData.getTeamId()), s -> new ArrayList()).add(new SendChunkPacket.SingleChunk(now, chunk.pos.x, chunk.pos.z, chunk));
        }
        chunksToSend.forEach((dimensionAndId, chunkPackets) -> {
            Team team = FTBTeamsAPI.getManager().getTeamByID((UUID)dimensionAndId.getRight());
            FTBChunksTeamData teamData = FTBChunksAPI.getManager().getData(team);
            if (teamData.canUse(player, FTBChunksTeamData.CLAIM_VISIBILITY)) {
                SendManyChunksPacket packet = new SendManyChunksPacket((ResourceKey<Level>)((ResourceKey)dimensionAndId.getLeft()), (UUID)dimensionAndId.getRight(), (List<SendChunkPacket.SingleChunk>)chunkPackets);
                packet.sendTo(player);
            }
        });
        data.setLastLoginTime(now);
        data.setForceLoadMember(player.m_20148_(), FTBChunksWorldConfig.canPlayerOfflineForceload(player));
        if (data.getTeam().getOnlineMembers().size() == 1 && !data.canForceLoadChunks()) {
            data.updateChunkTickets(true);
        }
        SendVisiblePlayerListPacket.syncToLevel(player.f_19853_);
    }

    public void loggedOut(ServerPlayer player) {
        if (!(FTBTeamsAPI.isManagerLoaded() && FTBChunksAPI.isManagerLoaded() && FTBChunksAPI.getManager().hasData(player))) {
            return;
        }
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(player);
        data.setForceLoadMember(player.m_20148_(), FTBChunksWorldConfig.canPlayerOfflineForceload(player));
        FTBChunksAPI.getManager().clearForceLoadedCache();
        LongRangePlayerTracker.INSTANCE.stopTracking(player);
        if (data.getTeam().getOnlineMembers().size() == 1 && !data.canForceLoadChunks()) {
            data.updateChunkTickets(false);
        }
    }

    private void teamCreated(TeamCreatedEvent teamEvent) {
        FTBChunksAPI.manager.getData(teamEvent.getTeam());
    }

    private void teamLoaded(TeamEvent teamEvent) {
        FTBChunksAPI.manager.getData(teamEvent.getTeam());
    }

    private void teamSaved(TeamEvent teamEvent) {
        FTBChunksAPI.manager.getData(teamEvent.getTeam()).saveNow();
    }

    public EventResult blockLeftClick(Player player, InteractionHand hand, BlockPos pos, Direction face) {
        if (player instanceof ServerPlayer && FTBChunksAPI.getManager().protect((Entity)player, hand, pos, Protection.EDIT_BLOCK, null)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public EventResult blockRightClick(Player player, InteractionHand hand, BlockPos pos, Direction face) {
        if (player instanceof ServerPlayer && FTBChunksAPI.getManager().protect((Entity)player, hand, pos, Protection.INTERACT_BLOCK, null)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public CompoundEventResult<ItemStack> itemRightClick(Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer && FTBChunksAPI.getManager().protect((Entity)player, hand, new BlockPos(player.m_20299_(1.0f)), Protection.RIGHT_CLICK_ITEM, null)) {
            return CompoundEventResult.interruptFalse((Object)player.m_21120_(hand));
        }
        return CompoundEventResult.pass();
    }

    private EventResult interactEntity(Player player, Entity entity, InteractionHand hand) {
        if (player instanceof ServerPlayer && FTBChunksAPI.getManager().protect((Entity)player, hand, entity.m_20183_(), Protection.INTERACT_ENTITY, entity)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public EventResult blockBreak(Level level, BlockPos pos, BlockState blockState, ServerPlayer player, @Nullable IntValue intValue) {
        if (FTBChunksAPI.getManager().protect((Entity)player, InteractionHand.MAIN_HAND, pos, Protection.EDIT_BLOCK, null)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public EventResult blockPlace(Level level, BlockPos pos, BlockState blockState, @Nullable Entity entity) {
        if (entity instanceof ServerPlayer && FTBChunksAPI.getManager().protect(entity, InteractionHand.MAIN_HAND, pos, Protection.EDIT_BLOCK, null)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public CompoundEventResult<ItemStack> fillBucket(Player player, Level level, ItemStack emptyBucket, @Nullable HitResult target) {
        if (player instanceof ServerPlayer && target instanceof BlockHitResult && FTBChunksAPI.getManager().protect((Entity)player, InteractionHand.MAIN_HAND, ((BlockHitResult)target).m_82425_(), Protection.EDIT_FLUID, null)) {
            return CompoundEventResult.interrupt((Boolean)false, null);
        }
        return CompoundEventResult.pass();
    }

    public EventResult farmlandTrample(Level world, BlockPos pos, BlockState blockState, float distance, Entity entity) {
        if (entity instanceof ServerPlayer && FTBChunksAPI.getManager().protect(entity, InteractionHand.MAIN_HAND, pos, Protection.EDIT_BLOCK, null)) {
            return EventResult.interrupt((Boolean)false);
        }
        return EventResult.pass();
    }

    public void enterSection(Entity entity, int chunkX, int chunkY, int chunkZ, int prevX, int prevY, int prevZ) {
        ServerPlayer player;
        block11: {
            block10: {
                if (chunkX == prevX && chunkZ == prevZ && chunkY != prevY) {
                    return;
                }
                if (!(entity instanceof ServerPlayer)) break block10;
                player = (ServerPlayer)entity;
                if (!PlayerHooks.isFake((Player)((ServerPlayer)entity))) break block11;
            }
            return;
        }
        if (!FTBTeamsAPI.isManagerLoaded() || !FTBChunksAPI.isManagerLoaded()) {
            return;
        }
        Team team = FTBTeamsAPI.getPlayerTeam((UUID)player.m_20148_());
        if (team == null) {
            return;
        }
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(team);
        if (data.prevChunkX != chunkX || data.prevChunkZ != chunkZ) {
            String s;
            ClaimedChunk chunk = FTBChunksAPI.getManager().getChunk(new ChunkDimPos((Entity)player));
            String string = s = chunk == null ? "-" : chunk.getTeamData().getTeamId().toString();
            if (!data.lastChunkID.equals(s)) {
                data.lastChunkID = s;
                if (chunk != null) {
                    player.m_5661_(chunk.getTeamData().getTeam().getColoredName(), true);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"wilderness").m_130940_(ChatFormatting.DARK_GREEN), true);
                }
            }
            data.prevChunkX = chunkX;
            data.prevChunkZ = chunkZ;
        }
    }

    public EventResult checkSpawn(LivingEntity entity, LevelAccessor level, double x, double y, double z, MobSpawnType type, @Nullable BaseSpawner spawner) {
        if (!level.m_5776_() && !(entity instanceof Player) && level instanceof Level) {
            switch (type) {
                case NATURAL: 
                case CHUNK_GENERATION: 
                case SPAWNER: 
                case STRUCTURE: 
                case JOCKEY: 
                case PATROL: {
                    ClaimedChunk chunk = FTBChunksAPI.getManager().getChunk(new ChunkDimPos((Level)level, new BlockPos(x, y, z)));
                    if (chunk == null || chunk.canEntitySpawn((Entity)entity)) break;
                    return EventResult.interrupt((Boolean)false);
                }
            }
        }
        return EventResult.pass();
    }

    private boolean ignoreExplosion(Level level, Explosion explosion) {
        if (level.m_5776_() || explosion.m_46081_().isEmpty()) {
            return true;
        }
        return explosion.f_46016_ == null && (Boolean)FTBChunksWorldConfig.PROTECT_UNKNOWN_EXPLOSIONS.get() == false;
    }

    public void explosionDetonate(Level level, Explosion explosion, List<Entity> affectedEntities) {
        if (this.ignoreExplosion(level, explosion)) {
            return;
        }
        ArrayList list = new ArrayList(explosion.m_46081_());
        explosion.m_46080_();
        HashMap<ChunkDimPos, Boolean> map = new HashMap<ChunkDimPos, Boolean>();
        for (BlockPos pos : list) {
            if (!map.computeIfAbsent(new ChunkDimPos(level, pos), cpos -> {
                ClaimedChunk chunk = FTBChunksAPI.getManager().getChunk((ChunkDimPos)cpos);
                return chunk == null || chunk.allowExplosions();
            }).booleanValue()) continue;
            explosion.m_46081_().add(pos);
        }
    }

    private void playerCloned(ServerPlayer oldPlayer, ServerPlayer newPlayer, boolean wonGame) {
        if (!wonGame) {
            ResourceKey dim = oldPlayer.f_19853_.m_46472_();
            int x = oldPlayer.m_146903_();
            int y = oldPlayer.m_146904_();
            int z = oldPlayer.m_146907_();
            int num = newPlayer.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12935_));
            new PlayerDeathPacket((ResourceKey<Level>)dim, x, y, z, num).sendTo(newPlayer);
        }
    }

    private void teamConfig(TeamCollectPropertiesEvent event) {
        event.add((TeamProperty)FTBChunksTeamData.ALLOW_EXPLOSIONS);
        event.add((TeamProperty)FTBChunksTeamData.ALLOW_FAKE_PLAYERS);
        event.add((TeamProperty)FTBChunksTeamData.BLOCK_EDIT_MODE);
        event.add((TeamProperty)FTBChunksTeamData.BLOCK_INTERACT_MODE);
        event.add((TeamProperty)FTBChunksTeamData.ENTITY_INTERACT_MODE);
        event.add((TeamProperty)FTBChunksTeamData.CLAIM_VISIBILITY);
        event.add((TeamProperty)FTBChunksTeamData.LOCATION_MODE);
    }

    private void playerJoinedParty(PlayerJoinedPartyTeamEvent event) {
        FTBChunksTeamData playerData = FTBChunksAPI.getManager().getData((Team)event.getPreviousTeam());
        FTBChunksTeamData partyData = FTBChunksAPI.getManager().getData(event.getTeam());
        partyData.addMemberData(event.getPlayer(), playerData);
        partyData.updateLimits();
        this.transferClaims(playerData, partyData, playerData.getClaimedChunks());
        partyData.setForceLoadMember(event.getPlayer().m_20148_(), FTBChunksWorldConfig.canPlayerOfflineForceload(event.getPlayer()));
        SendVisiblePlayerListPacket.syncToLevel(event.getPlayer().f_19853_);
        partyData.syncChunksToPlayer(event.getPlayer());
    }

    private void playerLeftParty(PlayerLeftPartyTeamEvent event) {
        FTBChunksTeamData partyData = FTBChunksAPI.getManager().getData(event.getTeam());
        PlayerTeam personalTeam = FTBTeamsAPI.getManager().getInternalPlayerTeam(event.getPlayerId());
        if (personalTeam != null) {
            FTBChunksTeamData playerData = FTBChunksAPI.getManager().getData((Team)personalTeam);
            if (event.getTeamDeleted()) {
                this.transferClaims(partyData, playerData, partyData.getClaimedChunks());
                FTBChunksAPI.getManager().deleteTeam(event.getTeam());
            } else {
                this.transferClaims(partyData, playerData, partyData.getOriginalClaims(event.getPlayerId()));
            }
        }
        partyData.deleteMemberData(event.getPlayerId());
        partyData.updateLimits();
        if (event.getPlayer() != null) {
            SendVisiblePlayerListPacket.syncToLevel(event.getPlayer().f_19853_);
            partyData.syncChunksToPlayer(event.getPlayer());
        }
    }

    private void transferClaims(FTBChunksTeamData transferFrom, FTBChunksTeamData transferTo, Collection<ClaimedChunk> chunksToTransfer) {
        CommandSourceStack sourceStack = FTBTeamsAPI.getManager().server.m_129893_();
        HashMap<ResourceKey, List> chunksToSend = new HashMap<ResourceKey, List>();
        HashMap<ResourceKey, List> chunksToUnclaim = new HashMap<ResourceKey, List>();
        int chunks = 0;
        long now = System.currentTimeMillis();
        int total = transferTo.getClaimedChunks().size();
        for (ClaimedChunk chunk : chunksToTransfer) {
            ServerLevel level;
            if (total >= transferTo.getMaxClaimChunks()) {
                chunk.unclaim(sourceStack, false);
                chunksToUnclaim.computeIfAbsent(chunk.pos.dimension, s -> new ArrayList()).add(new SendChunkPacket.SingleChunk(now, chunk.pos.x, chunk.pos.z, null));
            } else {
                chunk.teamData = transferTo;
                chunksToSend.computeIfAbsent(chunk.pos.dimension, s -> new ArrayList()).add(new SendChunkPacket.SingleChunk(now, chunk.pos.x, chunk.pos.z, chunk));
                ++chunks;
            }
            if (chunk.isForceLoaded() && (level = FTBChunksAPI.getManager().getMinecraftServer().m_129880_(chunk.pos.dimension)) != null) {
                FTBChunksExpected.addChunkToForceLoaded(level, MOD_ID, transferFrom.getTeamId(), chunk.pos.x, chunk.pos.z, false);
                if (chunk.isActuallyForceLoaded()) {
                    FTBChunksExpected.addChunkToForceLoaded(level, MOD_ID, transferTo.getTeamId(), chunk.pos.x, chunk.pos.z, true);
                }
            }
            ++total;
        }
        transferFrom.save();
        transferTo.save();
        if (chunks > 0) {
            chunksToSend.forEach((dimension, chunkPackets) -> {
                if (!chunkPackets.isEmpty()) {
                    ChunkSendingUtils.sendManyChunksToAll(sourceStack.m_81377_(), transferTo, new SendManyChunksPacket((ResourceKey<Level>)dimension, transferTo.getTeamId(), (List<SendChunkPacket.SingleChunk>)chunkPackets));
                }
            });
            chunksToUnclaim.forEach((dimension, chunkPackets) -> {
                if (!chunkPackets.isEmpty()) {
                    new SendManyChunksPacket((ResourceKey<Level>)dimension, Util.f_137441_, (List<SendChunkPacket.SingleChunk>)chunkPackets).sendToAll(sourceStack.m_81377_());
                }
            });
            LOGGER.info("Transferred " + chunks + "/" + total + " chunks from " + transferFrom + " to " + transferTo);
        }
    }

    private void teamOwnershipTransferred(PlayerTransferredTeamOwnershipEvent event) {
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(event.getTeam());
        data.updateLimits();
    }

    private void teamPropertiesChanged(TeamPropertiesChangedEvent event) {
        MinecraftServer server = FTBChunksAPI.getManager().getMinecraftServer();
        if (server == null) {
            return;
        }
        if (event.getOldProperties().get((TeamProperty)FTBChunksTeamData.LOCATION_MODE) != event.getTeam().getProperty((TeamProperty)FTBChunksTeamData.LOCATION_MODE)) {
            SendVisiblePlayerListPacket.syncToAll();
        }
        if (event.getOldProperties().get((TeamProperty)FTBChunksTeamData.CLAIM_VISIBILITY) != event.getTeam().getProperty((TeamProperty)FTBChunksTeamData.CLAIM_VISIBILITY)) {
            FTBChunksTeamData teamData = FTBChunksAPI.getManager().getData(event.getTeam());
            teamData.syncChunksToAll(server);
        }
    }

    private void playerAllianceChange(TeamAllyEvent event) {
        FTBChunksTeamData teamData = FTBChunksAPI.getManager().getData(event.getTeam());
        ArrayList<ServerPlayer> players = new ArrayList<ServerPlayer>();
        event.getPlayers().forEach(profile -> {
            ServerPlayer p = FTBChunksAPI.getManager().getMinecraftServer().m_6846_().m_11259_(profile.getId());
            if (p != null) {
                teamData.syncChunksToPlayer(p);
                players.add(p);
            }
        });
        SendVisiblePlayerListPacket.syncToPlayers(players);
    }

    private void serverTickPost(MinecraftServer minecraftServer) {
        ClaimExpirationManager.INSTANCE.tick(minecraftServer);
        LongRangePlayerTracker.INSTANCE.tick(minecraftServer);
    }

    static {
        RELATIVE_SPIRAL_POSITIONS = new XZ[225];
        BLOCK_REGISTRY = Registries.get((String)MOD_ID).get(Registry.f_122901_);
        ranksMod = false;
    }
}

