/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.snbt.config;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.config.BaseValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.nbt.StringTag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EnumValue<T>
extends BaseValue<T> {
    private final NameMap<T> nameMap;

    EnumValue(SNBTConfig c, String n, NameMap<T> nm) {
        super(c, n, nm.defaultValue);
        this.nameMap = nm;
    }

    @Override
    public void set(T v) {
        if (this.nameMap.values.contains(v)) {
            super.set(v);
        } else {
            super.set(this.defaultValue);
        }
    }

    @Override
    public void write(SNBTCompoundTag tag) {
        ArrayList<CallSite> s = new ArrayList<CallSite>(this.comment);
        s.add((CallSite)((Object)("Default: \"" + this.nameMap.getName(this.defaultValue) + "\"")));
        s.add((CallSite)((Object)("Valid values: " + this.nameMap.keys.stream().map(StringTag::m_129303_).collect(Collectors.joining(", ")))));
        tag.comment(this.key, String.join((CharSequence)"\n", s));
        tag.m_128359_(this.key, this.nameMap.getName(this.get()));
    }

    @Override
    public void read(SNBTCompoundTag tag) {
        this.set(this.nameMap.get(tag.m_128461_(this.key)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void createClientConfig(ConfigGroup group) {
        group.addEnum(this.key, this.get(), this::set, this.nameMap).setCanEdit(this.enabled.getAsBoolean());
    }
}

