/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.script;

import com.mojang.serialization.Codec;
import dev.architectury.registry.registries.Registrar;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.util.wrap.TypeWrapperFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class RegistryTypeWrapperFactory<T>
implements TypeWrapperFactory<T> {
    private static List<RegistryTypeWrapperFactory<?>> all;
    public final Class<T> type;
    public final Registrar<T> registry;
    public final String name;

    public static List<RegistryTypeWrapperFactory<?>> getAll() {
        if (all == null) {
            all = new ArrayList();
            try {
                for (Field field : Registry.class.getDeclaredFields()) {
                    if (field.getType() != ResourceKey.class || !Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers())) continue;
                    String id = "unknown";
                    try {
                        field.setAccessible(true);
                        ResourceKey key = (ResourceKey)field.get(null);
                        id = key.m_135782_().m_135815_();
                        Type type = field.getGenericType();
                        Type type1 = ((ParameterizedType)type).getActualTypeArguments()[0];
                        Type type2 = ((ParameterizedType)type1).getActualTypeArguments()[0];
                        Class<?> rawType = UtilsJS.getRawType(type2);
                        if (rawType == Item.class || rawType == ResourceLocation.class || rawType == ResourceKey.class || rawType == Codec.class) continue;
                        all.add(new RegistryTypeWrapperFactory(rawType, KubeJSRegistries.genericRegistry(key), key.m_135782_().toString()));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            catch (Exception ex) {
                KubeJS.LOGGER.error("Failed to register TypeWrappers for registries!");
                ex.printStackTrace();
            }
        }
        return all;
    }

    private RegistryTypeWrapperFactory(Class<T> t, Registrar<T> r, String n) {
        this.type = t;
        this.registry = r;
        this.name = n;
    }

    public T wrap(Context cx, Object o) {
        if (o == null) {
            return null;
        }
        if (this.type.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        ResourceLocation id = UtilsJS.getMCID(cx, o);
        Object value = this.registry.get(id);
        if (value == null) {
            NullPointerException npe = new NullPointerException("No such element with id %s in registry %s!".formatted(id, this.name));
            ConsoleJS.getCurrent(cx).error("Error while wrapping registry element type!", npe);
            throw npe;
        }
        return (T)value;
    }

    public String toString() {
        return "RegistryTypeWrapperFactory{type=" + this.type.getName() + ", registry=" + this.name + "}";
    }
}

