/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.minecraft;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.recipe.IngredientMatch;
import dev.latvian.mods.kubejs.recipe.ItemInputTransformer;
import dev.latvian.mods.kubejs.recipe.ItemOutputTransformer;
import dev.latvian.mods.kubejs.recipe.RecipeArguments;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class CookingRecipeJS
extends RecipeJS {
    public ItemStack result;
    public Ingredient ingredient;

    @Override
    public void create(RecipeArguments args) {
        this.result = this.parseItemOutput(args.get(0));
        this.ingredient = this.parseItemInput(args.get(1));
        if (args.size() >= 3) {
            this.xp(args.getFloat(2, 0.0f));
        }
        if (args.size() >= 4) {
            this.cookingTime(args.getInt(3, 200));
        }
    }

    public CookingRecipeJS xp(float xp) {
        this.json.addProperty("experience", (Number)Float.valueOf(Math.max(0.0f, xp)));
        this.save();
        return this;
    }

    public CookingRecipeJS cookingTime(int time) {
        this.json.addProperty("cookingtime", (Number)Math.max(0, time));
        this.save();
        return this;
    }

    @Override
    public void deserialize() {
        this.result = this.parseItemOutput(this.json.get("result"));
        this.ingredient = this.parseItemInput(this.json.get("ingredient"));
    }

    @Override
    public void serialize() {
        if (this.serializeOutputs) {
            this.json.add("result", this.itemToJson(this.result));
        }
        if (this.serializeInputs) {
            this.json.add("ingredient", this.ingredient.m_43942_());
        }
    }

    @Override
    public JsonElement itemToJson(ItemStack stack) {
        if (Platform.isForge()) {
            return super.itemToJson(this.result);
        }
        return new JsonPrimitive(this.result.kjs$getId());
    }

    @Override
    public boolean hasInput(IngredientMatch match) {
        return match.contains(this.ingredient);
    }

    @Override
    public boolean replaceInput(IngredientMatch match, Ingredient with, ItemInputTransformer transformer) {
        if (match.contains(this.ingredient)) {
            this.ingredient = transformer.transform(this, match, this.ingredient, with);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasOutput(IngredientMatch match) {
        return match.contains(this.result);
    }

    @Override
    public boolean replaceOutput(IngredientMatch match, ItemStack with, ItemOutputTransformer transformer) {
        if (match.contains(this.result)) {
            this.result = transformer.transform(this, match, this.result, with);
            return true;
        }
        return false;
    }
}

