/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.util.UUIDTypeAdapter;
import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.core.RecipeKJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientStack;
import dev.latvian.mods.kubejs.platform.RecipePlatformHelper;
import dev.latvian.mods.kubejs.recipe.IngredientMatch;
import dev.latvian.mods.kubejs.recipe.ItemInputTransformer;
import dev.latvian.mods.kubejs.recipe.ItemOutputTransformer;
import dev.latvian.mods.kubejs.recipe.ModifyRecipeResultCallback;
import dev.latvian.mods.kubejs.recipe.RecipeArguments;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeTypeJS;
import dev.latvian.mods.kubejs.recipe.RecipesEventJS;
import dev.latvian.mods.kubejs.recipe.ingredientaction.CustomIngredientAction;
import dev.latvian.mods.kubejs.recipe.ingredientaction.DamageAction;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientAction;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientActionFilter;
import dev.latvian.mods.kubejs.recipe.ingredientaction.KeepAction;
import dev.latvian.mods.kubejs.recipe.ingredientaction.ReplaceAction;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.JsonIO;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Nullable;

public abstract class RecipeJS
implements RecipeKJS {
    public static RecipeJS currentRecipe = null;
    public static boolean itemErrors = false;
    public ResourceLocation id;
    public RecipeTypeJS type;
    public JsonObject originalJson = null;
    public JsonObject json = null;
    public Recipe<?> originalRecipe = null;
    public boolean serializeOutputs;
    public boolean serializeInputs;
    private String recipeStage = "";

    public abstract void create(RecipeArguments var1);

    public abstract void deserialize();

    public abstract void serialize();

    public final void deserializeJson() {
        currentRecipe = this;
        this.deserialize();
        if (CommonProperties.get().debugInfo) {
            this.originalJson = (JsonObject)JsonIO.copy((JsonElement)this.json);
        }
        currentRecipe = null;
    }

    public final void serializeJson() {
        currentRecipe = this;
        this.json.addProperty("type", this.type.getId().toString());
        this.serialize();
        currentRecipe = null;
    }

    public final void save() {
        this.originalRecipe = null;
    }

    public RecipeJS merge(JsonObject j) {
        if (j != null) {
            for (Map.Entry entry : j.entrySet()) {
                this.json.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            this.save();
        }
        return this;
    }

    public RecipeJS id(ResourceLocation _id) {
        this.id = _id;
        this.save();
        return this;
    }

    public RecipeJS group(String g) {
        this.setGroup(g);
        this.save();
        return this;
    }

    @Override
    @Deprecated
    public final String kjs$getGroup() {
        return this.getGroup();
    }

    @Override
    @Deprecated
    public final void kjs$setGroup(String group) {
        this.setGroup(group);
    }

    @Override
    @Deprecated
    public final ResourceLocation kjs$getOrCreateId() {
        return this.getOrCreateId();
    }

    @Override
    @Deprecated
    public final ResourceLocation kjs$getType() {
        return this.getType();
    }

    @Override
    @Deprecated
    public final boolean kjs$hasInput(IngredientMatch match) {
        return this.hasInput(match);
    }

    @Override
    @Deprecated
    public final boolean kjs$replaceInput(IngredientMatch match, Ingredient with, ItemInputTransformer transformer) {
        return this.replaceInput(match, with, transformer);
    }

    @Override
    @Deprecated
    public final boolean kjs$hasOutput(IngredientMatch match) {
        return this.hasOutput(match);
    }

    @Override
    @Deprecated
    public final boolean kjs$replaceOutput(IngredientMatch match, ItemStack with, ItemOutputTransformer transformer) {
        return this.replaceOutput(match, with, transformer);
    }

    @HideFromJS
    public abstract boolean hasInput(IngredientMatch var1);

    @HideFromJS
    public abstract boolean replaceInput(IngredientMatch var1, Ingredient var2, ItemInputTransformer var3);

    @HideFromJS
    public abstract boolean hasOutput(IngredientMatch var1);

    @HideFromJS
    public abstract boolean replaceOutput(IngredientMatch var1, ItemStack var2, ItemOutputTransformer var3);

    @HideFromJS
    public String getGroup() {
        JsonElement e = this.json.get("group");
        return e instanceof JsonPrimitive ? e.getAsString() : "";
    }

    @HideFromJS
    public void setGroup(String g) {
        if (g.isEmpty()) {
            this.json.remove("group");
        } else {
            this.json.addProperty("group", g);
        }
        this.save();
    }

    public String toString() {
        return this.getOrCreateId() + "[" + this.type + "]";
    }

    public String getId() {
        return this.getOrCreateId().toString();
    }

    public String getPath() {
        return this.getOrCreateId().m_135815_();
    }

    @HideFromJS
    public ResourceLocation getType() {
        return this.type.getId();
    }

    @HideFromJS
    public ResourceLocation getOrCreateId() {
        if (this.id == null) {
            this.id = new ResourceLocation(this.type.getId().m_135827_() + ":kjs_" + this.getUniqueId());
        }
        return this.id;
    }

    @Nullable
    public ItemStack resultFromRecipeJson(JsonObject json) {
        return null;
    }

    @Nullable
    public JsonElement serializeIngredientStack(IngredientStack in) {
        return null;
    }

    @Nullable
    public JsonElement serializeItemStack(ItemStack stack) {
        return null;
    }

    public Ingredient parseItemInput(@Nullable Object o, String key) {
        Ingredient ingredient = IngredientJS.of(o);
        if (ingredient.kjs$isInvalidRecipeIngredient()) {
            if (key.isEmpty()) {
                throw new RecipeExceptionJS(o + " is not a valid ingredient!");
            }
            throw new RecipeExceptionJS(o + " with key '" + key + "' is not a valid ingredient!");
        }
        return ingredient;
    }

    public Ingredient parseItemInput(@Nullable Object o) {
        return this.parseItemInput(o, "");
    }

    public ItemStack parseItemOutput(@Nullable Object o) {
        ItemStack result = ItemStackJS.of(o);
        if (result == null || result.m_41619_()) {
            throw new RecipeExceptionJS(o + " is not a valid result!");
        }
        return result;
    }

    public List<Ingredient> parseItemInputList(@Nullable Object o) {
        ArrayList<Ingredient> list = new ArrayList<Ingredient>();
        if (o instanceof JsonElement) {
            JsonArray jsonArray;
            JsonElement elem = (JsonElement)o;
            if (elem instanceof JsonArray) {
                JsonArray arr2 = (JsonArray)elem;
                jsonArray = arr2;
            } else {
                jsonArray = (JsonArray)Util.m_137469_((Object)new JsonArray(), arr -> arr.add(elem));
            }
            JsonArray array = jsonArray;
            for (JsonElement e : array) {
                list.add(this.parseItemInput(e));
            }
        } else {
            for (Object o1 : ListJS.orSelf(o)) {
                list.add(this.parseItemInput(o1));
            }
        }
        return list;
    }

    public List<ItemStack> parseItemOutputList(@Nullable Object o) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (o instanceof JsonElement) {
            JsonArray jsonArray;
            JsonElement elem = (JsonElement)o;
            if (elem instanceof JsonArray) {
                JsonArray arr2 = (JsonArray)elem;
                jsonArray = arr2;
            } else {
                jsonArray = (JsonArray)Util.m_137469_((Object)new JsonArray(), arr -> arr.add(elem));
            }
            JsonArray array = jsonArray;
            for (JsonElement e : array) {
                list.add(this.parseItemOutput(e));
            }
        } else {
            for (Object o1 : ListJS.orSelf(o)) {
                list.add(this.parseItemOutput(o1));
            }
        }
        return list;
    }

    public String getFromToString() {
        return "unknown -> unknown";
    }

    public String getUniqueId() {
        return UtilsJS.getUniqueId((JsonElement)this.json);
    }

    public RecipeJS stage(String s) {
        this.recipeStage = s;
        this.save();
        if (!Platform.isModLoaded((String)"recipestages")) {
            ConsoleJS.SERVER.warn("Recipe requires stage '" + this.recipeStage + "' but Recipe Stages mod isn't installed!");
        }
        return this;
    }

    public Recipe<?> createRecipe() throws Throwable {
        this.serializeJson();
        if (!this.recipeStage.isEmpty() && Platform.isModLoaded((String)"recipestages")) {
            RecipeSerializer stageSerializer = (RecipeSerializer)KubeJSRegistries.recipeSerializers().get(new ResourceLocation("recipestages:stage"));
            JsonObject o = new JsonObject();
            o.addProperty("stage", this.recipeStage);
            o.add("recipe", (JsonElement)this.json);
            return stageSerializer.m_6729_(this.getOrCreateId(), o);
        }
        return Objects.requireNonNull(RecipePlatformHelper.get().fromJson(this));
    }

    public ItemStack getOriginalRecipeResult() {
        if (this.originalRecipe == null) {
            ConsoleJS.SERVER.warn("Original recipe is null - could not get result");
            return ItemStack.f_41583_;
        }
        return this.originalRecipe.m_8043_();
    }

    public List<Ingredient> getOriginalRecipeIngredients() {
        if (this.originalRecipe == null) {
            ConsoleJS.SERVER.warn("Original recipe is null - could not get ingredients");
            return List.of();
        }
        return List.copyOf(this.originalRecipe.m_7527_());
    }

    public void dontAdd() {
        RecipesEventJS.instance.addedRecipes.remove(this);
    }

    public boolean serializeNBTAsJson() {
        return this.type != null && this.type.getMod().equals("techreborn");
    }

    public RecipeJS ingredientAction(IngredientActionFilter filter, IngredientAction action) {
        JsonArray arr2;
        if (this.json == null) {
            ConsoleJS.SERVER.error("Can't add ingredient action to uninitialized recipe!");
            return this;
        }
        JsonElement jsonElement = this.json.get("kubejs_actions");
        JsonArray array = jsonElement instanceof JsonArray ? (arr2 = (JsonArray)jsonElement) : (JsonArray)Util.m_137469_((Object)new JsonArray(), arr -> this.json.add("kubejs_actions", (JsonElement)arr));
        action.copyFrom(filter);
        array.add((JsonElement)action.toJson());
        this.save();
        return this;
    }

    public final RecipeJS damageIngredient(IngredientActionFilter filter, int damage) {
        return this.ingredientAction(filter, new DamageAction(damage));
    }

    public final RecipeJS damageIngredient(IngredientActionFilter filter) {
        return this.damageIngredient(filter, 1);
    }

    public final RecipeJS replaceIngredient(IngredientActionFilter filter, ItemStack item) {
        return this.ingredientAction(filter, new ReplaceAction(item));
    }

    public final RecipeJS customIngredientAction(IngredientActionFilter filter, String id) {
        return this.ingredientAction(filter, new CustomIngredientAction(id));
    }

    public final RecipeJS keepIngredient(IngredientActionFilter filter) {
        return this.ingredientAction(filter, new KeepAction());
    }

    public final RecipeJS modifyResult(ModifyRecipeResultCallback callback) {
        UUID id = UUID.randomUUID();
        RecipesEventJS.modifyResultCallbackMap.put(id, callback);
        this.json.addProperty("kubejs_modify_result", UUIDTypeAdapter.fromUUID((UUID)id));
        this.save();
        return this;
    }

    public JsonElement itemToJson(ItemStack stack) {
        return stack.toJsonJS();
    }
}

