/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.level;

import dev.architectury.hooks.level.ExplosionHooks;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.level.LevelEventJS;
import dev.latvian.mods.kubejs.player.EntityArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class ExplosionEventJS
extends LevelEventJS {
    protected final Level level;
    protected final Explosion explosion;

    public ExplosionEventJS(Level level, Explosion explosion) {
        this.level = level;
        this.explosion = explosion;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    public Vec3 getPosition() {
        return ExplosionHooks.getPosition((Explosion)this.explosion);
    }

    public double getX() {
        return this.getPosition().f_82479_;
    }

    public double getY() {
        return this.getPosition().f_82480_;
    }

    public double getZ() {
        return this.getPosition().f_82481_;
    }

    public BlockContainerJS getBlock() {
        return new BlockContainerJS(this.level, new BlockPos(this.getPosition()));
    }

    @Nullable
    public LivingEntity getExploder() {
        return this.explosion.m_46079_();
    }

    public static class After
    extends ExplosionEventJS {
        private final List<Entity> affectedEntities;

        public After(Level level, Explosion explosion, List<Entity> affectedEntities) {
            super(level, explosion);
            this.affectedEntities = affectedEntities;
        }

        public EntityArrayList getAffectedEntities() {
            return new EntityArrayList(this.level, this.affectedEntities);
        }

        public void removeAffectedEntity(Entity entity) {
            this.affectedEntities.remove(entity);
        }

        public void removeAllAffectedEntities() {
            this.affectedEntities.clear();
        }

        public List<BlockContainerJS> getAffectedBlocks() {
            ArrayList<BlockContainerJS> list = new ArrayList<BlockContainerJS>(this.explosion.m_46081_().size());
            for (BlockPos pos : this.explosion.m_46081_()) {
                list.add(new BlockContainerJS(this.level, pos));
            }
            return list;
        }

        public void removeAffectedBlock(BlockContainerJS block) {
            this.explosion.m_46081_().remove(block.getPos());
        }

        public void removeAllAffectedBlocks() {
            this.explosion.m_46081_().clear();
        }

        public void removeKnockback() {
            this.explosion.m_46078_().clear();
        }
    }

    public static class Before
    extends ExplosionEventJS {
        public Before(Level level, Explosion explosion) {
            super(level, explosion);
        }

        public float getSize() {
            return this.explosion.f_46017_;
        }

        public void setSize(float s) {
            this.explosion.f_46017_ = s;
        }
    }
}

