/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.utils.value.IntValue;
import dev.latvian.mods.kubejs.bindings.event.BlockEvents;
import dev.latvian.mods.kubejs.block.BlockBrokenEventJS;
import dev.latvian.mods.kubejs.block.BlockLeftClickedEventJS;
import dev.latvian.mods.kubejs.block.BlockPlacedEventJS;
import dev.latvian.mods.kubejs.block.BlockRightClickedEventJS;
import dev.latvian.mods.kubejs.block.FarmlandTrampledEventJS;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class KubeJSBlockEventHandler {
    public static void init() {
        InteractionEvent.RIGHT_CLICK_BLOCK.register(KubeJSBlockEventHandler::rightClick);
        InteractionEvent.LEFT_CLICK_BLOCK.register(KubeJSBlockEventHandler::leftClick);
        BlockEvent.BREAK.register(KubeJSBlockEventHandler::blockBreak);
        BlockEvent.PLACE.register(KubeJSBlockEventHandler::blockPlace);
        InteractionEvent.FARMLAND_TRAMPLE.register(KubeJSBlockEventHandler::farmlandTrample);
    }

    private static EventResult rightClick(Player player, InteractionHand hand, BlockPos pos, Direction direction) {
        if (player instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)player;
            if (!player.m_36335_().m_41519_(player.m_21120_(hand).m_41720_()) && BlockEvents.RIGHT_CLICKED.post(player.f_19853_.m_8055_(pos).m_60734_(), new BlockRightClickedEventJS(p, hand, pos, direction))) {
                return EventResult.interruptFalse();
            }
        }
        return EventResult.pass();
    }

    private static EventResult leftClick(Player player, InteractionHand hand, BlockPos pos, Direction direction) {
        if (player instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)player;
            if (BlockEvents.LEFT_CLICKED.post(player.f_19853_.m_8055_(pos).m_60734_(), new BlockLeftClickedEventJS(p, hand, pos, direction))) {
                return EventResult.interruptFalse();
            }
        }
        return EventResult.pass();
    }

    private static EventResult blockBreak(Level level, BlockPos pos, BlockState state, ServerPlayer player, @Nullable IntValue xp) {
        if (level instanceof ServerLevel && player != null && BlockEvents.BROKEN.post(state.m_60734_(), new BlockBrokenEventJS(player, level, pos, state, xp))) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static EventResult blockPlace(Level level, BlockPos pos, BlockState state, @Nullable Entity placer) {
        if (level instanceof ServerLevel && (placer == null || placer.f_19853_ != null) && BlockEvents.PLACED.post(state.m_60734_(), new BlockPlacedEventJS(placer, level, pos, state))) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static EventResult farmlandTrample(Level level, BlockPos pos, BlockState state, float distance, @Nullable Entity entity) {
        if (level instanceof ServerLevel && (entity == null || entity.f_19853_ != null) && BlockEvents.FARMLAND_TRAMPLED.post(state.m_60734_(), new FarmlandTrampledEventJS(level, pos, state, distance, entity))) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }
}

