/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs;

import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.util.KubeJSPlugins;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;

public class DevProperties {
    private static DevProperties instance;
    private final Properties properties;
    private boolean writeProperties;
    public boolean dataPackOutput;
    public boolean logAddedRecipes;
    public boolean logRemovedRecipes;
    public boolean logModifiedRecipes;
    public boolean logOverrides;
    public boolean logSkippedRecipes;
    public boolean logSkippedTags;
    public boolean logErroringRecipes;
    public boolean logInvalidRecipeHandlers;
    public boolean logSkippedPlugins;

    public static DevProperties get() {
        if (instance == null) {
            instance = new DevProperties();
        }
        return instance;
    }

    private DevProperties() {
        block16: {
            this.dataPackOutput = false;
            this.logAddedRecipes = false;
            this.logRemovedRecipes = false;
            this.logModifiedRecipes = false;
            this.logOverrides = false;
            this.logSkippedRecipes = false;
            this.logSkippedTags = false;
            this.logErroringRecipes = true;
            this.logInvalidRecipeHandlers = true;
            this.logSkippedPlugins = false;
            this.properties = new Properties();
            try {
                Path propertiesFile = CommonProperties.get().saveDevPropertiesInConfig ? KubeJSPaths.CONFIG.resolve("dev.properties") : KubeJSPaths.LOCAL.resolve("kubejsdev.properties");
                this.writeProperties = false;
                if (Files.exists(propertiesFile, new LinkOption[0])) {
                    try (BufferedReader reader = Files.newBufferedReader(propertiesFile);){
                        this.properties.load(reader);
                    }
                } else {
                    this.writeProperties = true;
                }
                this.dataPackOutput = this.get("dataPackOutput", false);
                this.logAddedRecipes = this.get("logAddedRecipes", false);
                this.logRemovedRecipes = this.get("logRemovedRecipes", false);
                this.logModifiedRecipes = this.get("logModifiedRecipes", false);
                this.logOverrides = this.get("logOverrides", false);
                this.logSkippedRecipes = this.get("logSkippedRecipes", false);
                this.logSkippedTags = this.get("logSkippedTags", false);
                this.logErroringRecipes = this.get("logErroringRecipes", true);
                this.logInvalidRecipeHandlers = this.get("logInvalidRecipeHandlers", true);
                this.logSkippedPlugins = this.get("logSkippedPlugins", true);
                KubeJSPlugins.forEachPlugin(p -> p.loadDevProperties(this));
                if (!this.writeProperties) break block16;
                try (BufferedWriter writer = Files.newBufferedWriter(propertiesFile, new OpenOption[0]);){
                    this.properties.store(writer, "KubeJS Dev Properties");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        KubeJS.LOGGER.info("Loaded dev.properties");
    }

    public void remove(String key) {
        String s = this.properties.getProperty(key);
        if (s != null) {
            this.properties.remove(key);
            this.writeProperties = true;
        }
    }

    public String get(String key, String def) {
        String s = this.properties.getProperty(key);
        if (s == null) {
            this.properties.setProperty(key, def);
            this.writeProperties = true;
            return def;
        }
        return s;
    }

    public boolean get(String key, boolean def) {
        return this.get(key, def ? "true" : "false").equals("true");
    }
}

