/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.util.KnownServerRegistries;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.BooleanTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DimensionTask
extends BooleanTask {
    public ResourceKey<Level> dimension = Level.f_46429_;

    public DimensionTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.DIMENSION;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("dimension", this.dimension.m_135782_().toString());
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("dimension")));
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130085_(this.dimension.m_135782_());
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buffer.m_130281_());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        if (KnownServerRegistries.client != null && !KnownServerRegistries.client.dimensions.isEmpty()) {
            config.addEnum("dim", (Object)this.dimension.m_135782_(), v -> {
                this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)v);
            }, NameMap.of((Object)((ResourceLocation)KnownServerRegistries.client.dimensions.iterator().next()), (Object[])KnownServerRegistries.client.dimensions.toArray(new ResourceLocation[0])).create());
        } else {
            config.addString("dim", this.dimension.m_135782_().toString(), v -> {
                this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(v));
            }, "minecraft:the_nether");
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.m_237115_((String)"ftbquests.task.ftbquests.dimension").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)this.dimension.m_135782_().toString()).m_130940_(ChatFormatting.DARK_GREEN));
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 100;
    }

    @Override
    public boolean canSubmit(TeamData teamData, ServerPlayer player) {
        return !player.m_5833_() && player.f_19853_.m_46472_() == this.dimension;
    }
}

