/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.loot;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconAnimation;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.math.Bits;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.gui.EditRewardTableScreen;
import dev.ftb.mods.ftbquests.gui.RewardTablesScreen;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.integration.FTBQuestsJEIHelper;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.loot.LootCrate;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class RewardTable
extends QuestObjectBase {
    public final QuestFile file;
    public final List<WeightedReward> rewards;
    public final Quest fakeQuest;
    public int emptyWeight;
    public int lootSize;
    public boolean hideTooltip;
    public boolean useTitle;
    public LootCrate lootCrate;
    public ResourceLocation lootTableId;
    public String filename;

    public RewardTable(QuestFile f) {
        this.file = f;
        this.rewards = new ArrayList<WeightedReward>();
        this.fakeQuest = new Quest(new Chapter(this.file, f.defaultChapterGroup));
        this.emptyWeight = 0;
        this.lootSize = 1;
        this.hideTooltip = false;
        this.useTitle = false;
        this.lootCrate = null;
        this.lootTableId = null;
        this.filename = "";
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.REWARD_TABLE;
    }

    @Override
    public QuestFile getQuestFile() {
        return this.file;
    }

    public int getTotalWeight(boolean includeEmpty) {
        int w = includeEmpty ? this.emptyWeight : 0;
        for (WeightedReward r : this.rewards) {
            w += r.weight;
        }
        return w;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        if (this.emptyWeight > 0) {
            nbt.m_128405_("empty_weight", this.emptyWeight);
        }
        nbt.m_128405_("loot_size", this.lootSize);
        if (this.hideTooltip) {
            nbt.m_128379_("hide_tooltip", true);
        }
        if (this.useTitle) {
            nbt.m_128379_("use_title", true);
        }
        ListTag list = new ListTag();
        for (WeightedReward reward : this.rewards) {
            SNBTCompoundTag nbt1 = new SNBTCompoundTag();
            reward.reward.writeData((CompoundTag)nbt1);
            if (reward.reward.getType() != RewardTypes.ITEM) {
                nbt1.m_128359_("type", reward.reward.getType().getTypeForNBT());
            } else if (nbt1.m_128435_("item") == 8) {
                nbt1.singleLine();
            }
            if (reward.weight != 1) {
                nbt1.m_128405_("weight", reward.weight);
            }
            list.add((Object)nbt1);
        }
        nbt.m_128365_("rewards", (Tag)list);
        if (this.lootCrate != null) {
            CompoundTag nbt1 = new CompoundTag();
            this.lootCrate.writeData(nbt1);
            nbt.m_128365_("loot_crate", (Tag)nbt1);
        }
        if (this.lootTableId != null) {
            nbt.m_128359_("loot_table_id", this.lootTableId.toString());
        }
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.emptyWeight = nbt.m_128451_("empty_weight");
        this.lootSize = nbt.m_128451_("loot_size");
        this.hideTooltip = nbt.m_128471_("hide_tooltip");
        this.useTitle = nbt.m_128471_("use_title");
        this.rewards.clear();
        ListTag list = nbt.m_128437_("rewards", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag nbt1 = list.m_128728_(i);
            Reward reward = RewardType.createReward(this.fakeQuest, nbt1.m_128461_("type"));
            if (reward == null) continue;
            reward.readData(nbt1);
            this.rewards.add(new WeightedReward(reward, nbt1.m_128441_("weight") ? nbt1.m_128451_("weight") : 1));
        }
        this.lootCrate = null;
        if (nbt.m_128441_("loot_crate")) {
            this.lootCrate = new LootCrate(this);
            this.lootCrate.readData(nbt.m_128469_("loot_crate"));
        }
        this.lootTableId = nbt.m_128441_("loot_table_id") ? new ResourceLocation(nbt.m_128461_("loot_table_id")) : null;
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130072_(this.filename, Short.MAX_VALUE);
        buffer.m_130130_(this.emptyWeight);
        buffer.m_130130_(this.lootSize);
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (boolean)this.hideTooltip);
        flags = Bits.setFlag((int)flags, (int)2, (boolean)this.useTitle);
        flags = Bits.setFlag((int)flags, (int)4, (this.lootCrate != null ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)8, (this.lootTableId != null ? 1 : 0) != 0);
        buffer.m_130130_(flags);
        buffer.m_130130_(this.rewards.size());
        for (WeightedReward reward : this.rewards) {
            buffer.m_130130_(reward.reward.getType().intId);
            reward.reward.writeNetData(buffer);
            buffer.m_130130_(reward.weight);
        }
        if (this.lootCrate != null) {
            this.lootCrate.writeNetData(buffer);
        }
        if (this.lootTableId != null) {
            buffer.m_130085_(this.lootTableId);
        }
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.filename = buffer.m_130136_(Short.MAX_VALUE);
        this.emptyWeight = buffer.m_130242_();
        this.lootSize = buffer.m_130242_();
        int flags = buffer.m_130242_();
        this.hideTooltip = Bits.getFlag((int)flags, (int)1);
        this.useTitle = Bits.getFlag((int)flags, (int)2);
        boolean hasCrate = Bits.getFlag((int)flags, (int)4);
        boolean hasLootTableId = Bits.getFlag((int)flags, (int)8);
        this.rewards.clear();
        int s = buffer.m_130242_();
        for (int i = 0; i < s; ++i) {
            RewardType type = (RewardType)this.file.rewardTypeIds.get(buffer.m_130242_());
            Reward reward = type.provider.create(this.fakeQuest);
            reward.readNetData(buffer);
            int w = buffer.m_130242_();
            this.rewards.add(new WeightedReward(reward, w));
        }
        this.lootCrate = null;
        if (hasCrate) {
            this.lootCrate = new LootCrate(this);
            this.lootCrate.readNetData(buffer);
        }
        this.lootTableId = hasLootTableId ? buffer.m_130281_() : null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addInt("empty_weight", this.emptyWeight, v -> {
            this.emptyWeight = v;
        }, 0, 0, Integer.MAX_VALUE);
        config.addInt("loot_size", this.lootSize, v -> {
            this.lootSize = v;
        }, 1, 1, Integer.MAX_VALUE);
        config.addBool("hide_tooltip", this.hideTooltip, v -> {
            this.hideTooltip = v;
        }, false);
        config.addBool("use_title", this.useTitle, v -> {
            this.useTitle = v;
        }, false);
        if (this.lootCrate != null) {
            this.lootCrate.getConfig(config.getGroup("loot_crate").setNameKey("item.ftbquests.lootcrate"));
        }
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        for (WeightedReward reward : this.rewards) {
            reward.reward.clearCachedData();
        }
    }

    @Override
    public void deleteSelf() {
        this.file.rewardTables.remove(this);
        super.deleteSelf();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void editedFromGUI() {
        QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
        if (gui != null && gui.isViewingQuest()) {
            gui.viewQuestPanel.refreshWidgets();
        } else {
            RewardTablesScreen gui1 = (RewardTablesScreen)((Object)ClientUtils.getCurrentGuiAs(RewardTablesScreen.class));
            if (gui1 != null) {
                gui1.refreshWidgets();
            }
        }
        this.file.updateLootCrates();
    }

    @Override
    public void editedFromGUIOnServer() {
        this.file.updateLootCrates();
    }

    @Override
    public void onCreated() {
        if (this.filename.isEmpty()) {
            String s;
            this.filename = s = RewardTable.titleToID(this.title).orElse(this.toString());
            Set existingNames = this.file.rewardTables.stream().map(rt -> rt.filename).collect(Collectors.toSet());
            int i = 2;
            while (existingNames.contains(this.filename)) {
                this.filename = s + "_" + i;
                ++i;
            }
        }
        this.file.rewardTables.add(this);
    }

    public String getFilename() {
        if (this.filename.isEmpty()) {
            this.filename = RewardTable.getCodeString(this);
        }
        return this.filename;
    }

    @Override
    public String getPath() {
        return "reward_tables/" + this.getFilename() + ".snbt";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Component getAltTitle() {
        if (this.rewards.size() == 1) {
            return this.rewards.get((int)0).reward.getTitle();
        }
        return Component.m_237115_((String)"ftbquests.reward_table");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        if (this.lootCrate != null) {
            return ItemIcon.getItemIcon((ItemStack)this.lootCrate.createStack());
        }
        if (this.rewards.isEmpty()) {
            return Icons.DICE;
        }
        ArrayList<Icon> icons = new ArrayList<Icon>();
        for (WeightedReward reward : this.rewards) {
            icons.add(reward.reward.getIcon());
        }
        return IconAnimation.fromList(icons, (boolean)false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onEditButtonClicked(Runnable gui) {
        new EditRewardTableScreen(this, () -> new EditObjectMessage(this).sendToServer()).openGui();
    }

    public void addMouseOverText(TooltipList list, boolean includeWeight, boolean includeEmpty) {
        List<WeightedReward> rewards1;
        if (this.hideTooltip) {
            return;
        }
        int totalWeight = this.getTotalWeight(includeEmpty);
        if (includeWeight && includeEmpty && this.emptyWeight > 0) {
            list.add((Component)Component.m_237113_((String)"").m_130940_(ChatFormatting.GRAY).m_130946_("- ").m_7220_((Component)Component.m_237115_((String)"ftbquests.reward_table.nothing")).m_7220_((Component)Component.m_237113_((String)(" [" + WeightedReward.chanceString(this.emptyWeight, totalWeight, true) + "]")).m_130940_(ChatFormatting.DARK_GRAY)));
        }
        if (this.rewards.size() > 1) {
            rewards1 = new ArrayList<WeightedReward>(this.rewards);
            rewards1.sort(null);
        } else {
            rewards1 = this.rewards;
        }
        for (int i = 0; i < rewards1.size(); ++i) {
            if (i == 10) {
                list.add((Component)Component.m_237113_((String)"").m_130940_(ChatFormatting.GRAY).m_130946_("- ").m_7220_((Component)Component.m_237110_((String)"ftbquests.reward_table.and_more", (Object[])new Object[]{rewards1.size() - 10})));
                return;
            }
            WeightedReward r = rewards1.get(i);
            if (includeWeight) {
                list.add((Component)Component.m_237113_((String)"").m_130940_(ChatFormatting.GRAY).m_130946_("- ").m_7220_(r.reward.getTitle()).m_7220_((Component)Component.m_237113_((String)(" [" + WeightedReward.chanceString(r.weight, totalWeight) + "]")).m_130940_(ChatFormatting.DARK_GRAY)));
                continue;
            }
            list.add((Component)Component.m_237113_((String)"").m_130940_(ChatFormatting.GRAY).m_130946_("- ").m_7220_(r.reward.getTitle()));
        }
    }

    @Override
    public int refreshJEI() {
        return FTBQuestsJEIHelper.LOOTCRATES;
    }
}

