/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.integration.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.integration.jei.JEIRecipeTypes;
import dev.ftb.mods.ftbquests.integration.jei.LootCrateRecipeManagerPlugin;
import dev.ftb.mods.ftbquests.integration.jei.WrappedLootCrate;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.ftb.mods.ftbquests.quest.loot.LootCrate;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class LootCrateCategory
implements IRecipeCategory<WrappedLootCrate> {
    public static final ResourceLocation UID = new ResourceLocation("ftbquests", "loot_crate");
    public static final int ITEMSX = 10;
    public static final int ITEMSY = 5;
    public static final int ITEMS = 50;
    private final IDrawable background;
    private final IDrawable icon;

    public LootCrateCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(180, 126);
        this.icon = new IDrawable(){

            public int getWidth() {
                return 16;
            }

            public int getHeight() {
                return 16;
            }

            public void draw(PoseStack poseStack, int xOffset, int yOffset) {
                poseStack.m_85836_();
                poseStack.m_85837_((double)(xOffset + 8), (double)(yOffset + 8), 100.0);
                List<WrappedLootCrate> crates = LootCrateRecipeManagerPlugin.INSTANCE.getWrappedLootCrates();
                if (!crates.isEmpty()) {
                    GuiHelper.drawItem((PoseStack)poseStack, (ItemStack)crates.get((int)((int)(System.currentTimeMillis() / 1000L % (long)crates.size()))).crateStack, (int)0, (boolean)true, null);
                } else {
                    GuiHelper.drawItem((PoseStack)poseStack, (ItemStack)new ItemStack((ItemLike)FTBQuestsItems.LOOTCRATE.get()), (int)0, (boolean)true, null);
                }
                poseStack.m_85849_();
            }
        };
    }

    public RecipeType<WrappedLootCrate> getRecipeType() {
        return JEIRecipeTypes.LOOT_CRATE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.ftbquests.lootcrates");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, WrappedLootCrate recipe, IFocusGroup focuses) {
        for (int slot = 0; slot < Math.min(50, recipe.outputs.size()); ++slot) {
            int finalSlot = slot;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, slot % 10 * 18, slot / 10 * 18 + 36).addItemStacks(recipe.cycledOutputs.get(slot))).addTooltipCallback((recipeSlotView, tooltip) -> recipeSlotView.getDisplayedIngredient().flatMap(ingr -> ingr.getIngredient((IIngredientType)VanillaTypes.ITEM_STACK)).ifPresent(stack -> {
                if (ItemStack.m_41746_((ItemStack)stack, (ItemStack)recipe.outputs.get(finalSlot))) {
                    String chanceStr = ChatFormatting.GOLD + WeightedReward.chanceString(recipe.sortedRewards.get((int)finalSlot).weight, recipe.crate.table.getTotalWeight(true));
                    tooltip.add(Component.m_237110_((String)"jei.ftbquests.lootcrates.chance", (Object[])new Object[]{chanceStr}).m_130940_(ChatFormatting.GRAY));
                }
            }));
        }
    }

    public void draw(WrappedLootCrate recipe, IRecipeSlotsView recipeSlotsView, PoseStack poseStack, double mouseX, double mouseY) {
        LootCrate crate = recipe.crate;
        Font font = Minecraft.m_91087_().f_91062_;
        font.m_92763_(poseStack, (Component)crate.table.getMutableTitle().m_130940_(ChatFormatting.UNDERLINE), 0.0f, 0.0f, -256);
        int total = ClientQuestFile.INSTANCE.lootCrateNoDrop.passive;
        for (Object table : ClientQuestFile.INSTANCE.rewardTables) {
            if (((RewardTable)table).lootCrate == null) continue;
            total += ((RewardTable)table).lootCrate.drops.passive;
        }
        Component p = this.chance("passive", crate.drops.passive, total);
        total = ClientQuestFile.INSTANCE.lootCrateNoDrop.monster;
        for (Object table : ClientQuestFile.INSTANCE.rewardTables) {
            if (((RewardTable)table).lootCrate == null) continue;
            total += ((RewardTable)table).lootCrate.drops.monster;
        }
        Component m = this.chance("monster", crate.drops.monster, total);
        total = ClientQuestFile.INSTANCE.lootCrateNoDrop.boss;
        for (RewardTable table : ClientQuestFile.INSTANCE.rewardTables) {
            if (table.lootCrate == null) continue;
            total += table.lootCrate.drops.boss;
        }
        Component b = this.chance("boss", crate.drops.boss, total);
        int w = Math.max(font.m_92852_((FormattedText)p), Math.max(font.m_92852_((FormattedText)m), font.m_92852_((FormattedText)b)));
        int drawX = this.background.getWidth() - w - 2;
        font.m_92889_(poseStack, p, (float)drawX, 0.0f, -12566464);
        float f = drawX;
        Objects.requireNonNull(font);
        font.m_92889_(poseStack, m, f, 9.0f, -12566464);
        float f2 = drawX;
        Objects.requireNonNull(font);
        font.m_92889_(poseStack, b, f2, (float)(9 * 2), -12566464);
    }

    private Component chance(String type, int w, int t) {
        return Component.m_237115_((String)("ftbquests.loot.entitytype." + type)).m_130946_(": " + WeightedReward.chanceString(w, t, true));
    }
}

