/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui.quests;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.ButtonListBaseScreen;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import dev.latvian.mods.itemfilters.api.IStringValueFilter;
import dev.latvian.mods.itemfilters.api.ItemFiltersAPI;
import dev.latvian.mods.itemfilters.api.ItemFiltersItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class TaskButton
extends Button {
    public final QuestScreen questScreen;
    public Task task;

    public TaskButton(Panel panel, Task t) {
        super(panel, t.getTitle(), Icons.ACCEPT);
        this.questScreen = (QuestScreen)panel.getGui();
        this.task = t;
    }

    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver()) {
            if (button.isRight() || this.getWidgetType() != WidgetType.DISABLED) {
                this.onClicked(button);
            }
            return true;
        }
        return false;
    }

    public void onClicked(MouseButton button) {
        if (button.isLeft()) {
            this.task.onButtonClicked(this, !this.task.invalid && this.questScreen.file.self.canStartTasks(this.task.quest) && !this.questScreen.file.self.isCompleted(this.task));
        } else if (button.isRight() && this.questScreen.file.canEdit()) {
            this.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            if (this.task instanceof ItemTask) {
                final ItemTask i = (ItemTask)this.task;
                final List<ResourceLocation> tags = i.item.m_41720_().m_204114_().m_203616_().map(TagKey::f_203868_).toList();
                if (!tags.isEmpty() && !ItemFiltersAPI.isFilter((ItemStack)i.item)) {
                    contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"ftbquests.task.ftbquests.item.convert_tag"), (Icon)ThemeProperties.RELOAD_ICON.get(), () -> {
                        final ItemStack tagFilter = new ItemStack((ItemLike)ItemFiltersItems.TAG.get());
                        if (tags.size() == 1) {
                            String tag = ((ResourceLocation)tags.iterator().next()).toString();
                            ((IStringValueFilter)tagFilter.m_41720_()).setValue(tagFilter, tag);
                            i.item = tagFilter;
                            if (i.title.isEmpty()) {
                                i.title = "Any #" + tag;
                            }
                            new EditObjectMessage(i).sendToServer();
                        } else {
                            new ButtonListBaseScreen(){

                                public void addButtons(Panel panel) {
                                    for (final ResourceLocation s : tags) {
                                        panel.add((Widget)new SimpleTextButton(panel, (Component)Component.m_237113_((String)s.toString()), (Icon)Icon.EMPTY){

                                            public void onClicked(MouseButton button) {
                                                TaskButton.this.questScreen.openGui();
                                                ((IStringValueFilter)tagFilter.m_41720_()).setValue(tagFilter, s.toString());
                                                i.item = tagFilter;
                                                if (i.title.isEmpty()) {
                                                    i.title = "Any #" + s;
                                                }
                                                new EditObjectMessage(i).sendToServer();
                                            }
                                        });
                                    }
                                }
                            }.openGui();
                        }
                    }));
                    contextMenu.add(ContextMenuItem.SEPARATOR);
                }
            }
            this.questScreen.addObjectMenuItems(contextMenu, (Runnable)this.getGui(), this.task);
            this.getGui().openContextMenu(contextMenu);
        }
    }

    @Nullable
    public Object getIngredientUnderMouse() {
        return this.task.getIngredient();
    }

    public void addMouseOverText(TooltipList list) {
        this.questScreen.addInfoTooltip(list, this.task);
        if (this.task.addTitleInMouseOverText()) {
            list.add(this.getTitle());
        }
        this.task.addMouseOverHeader(list, this.questScreen.file.self, Minecraft.m_91087_().f_91066_.f_92125_);
        if (this.questScreen.file.self.canStartTasks(this.task.quest)) {
            long maxp = this.task.getMaxProgress();
            long progress = this.questScreen.file.self.getProgress(this.task);
            if (maxp > 1L) {
                if (this.task.hideProgressNumbers()) {
                    list.add((Component)Component.m_237113_((String)("[" + this.task.getRelativeProgressFromChildren(this.questScreen.file.self) + "%]")).m_130940_(ChatFormatting.DARK_GREEN));
                } else {
                    String max = TaskButton.isShiftKeyDown() ? Long.toUnsignedString(maxp) : this.task.formatMaxProgress();
                    String prog = TaskButton.isShiftKeyDown() ? Long.toUnsignedString(progress) : this.task.formatProgress(this.questScreen.file.self, progress);
                    String s = (progress > maxp ? max : prog) + " / " + max;
                    if (maxp < 100L) {
                        list.add((Component)Component.m_237113_((String)s).m_130940_(ChatFormatting.DARK_GREEN));
                    } else {
                        list.add((Component)Component.m_237113_((String)s).m_130940_(ChatFormatting.DARK_GREEN).m_7220_((Component)Component.m_237113_((String)(" [" + this.task.getRelativeProgressFromChildren(this.questScreen.file.self) + "%]")).m_130940_(ChatFormatting.DARK_GRAY)));
                    }
                }
            }
        }
        this.task.addMouseOverText(list, this.questScreen.file.self);
    }

    public void drawBackground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        if (this.isMouseOver()) {
            super.drawBackground(matrixStack, theme, x, y, w, h);
        }
    }

    public void drawIcon(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        this.task.drawGUI(this.questScreen.file.self, matrixStack, x, y, w, h);
    }

    public void draw(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        int bs = h >= 32 ? 32 : 16;
        GuiHelper.setupDrawing();
        this.drawBackground(matrixStack, theme, x, y, w, h);
        this.drawIcon(matrixStack, theme, x + (w - bs) / 2, y + (h - bs) / 2, bs, bs);
        if (this.questScreen.file.self == null) {
            return;
        }
        if (this.questScreen.contextMenu != null) {
            // empty if block
        }
        if (this.questScreen.file.self.isCompleted(this.task)) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.0, 200.0);
            RenderSystem.m_69478_();
            ((Icon)ThemeProperties.CHECK_ICON.get()).draw(matrixStack, x + w - 9, y + 1, 8, 8);
            matrixStack.m_85849_();
        } else {
            MutableComponent s = this.task.getButtonText();
            if (s.m_214077_() != ComponentContents.f_237124_) {
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)((float)x + 19.0f - (float)theme.getStringWidth((FormattedText)s) / 2.0f), (double)((float)y + 15.0f), 200.0);
                matrixStack.m_85841_(0.5f, 0.5f, 1.0f);
                RenderSystem.m_69478_();
                theme.drawString(matrixStack, (Object)s, 0.0f, 0.0f, Color4I.WHITE, 2);
                matrixStack.m_85849_();
            }
        }
    }
}

