/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui.quests;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.gui.RewardTablesScreen;
import dev.ftb.mods.ftbquests.gui.quests.TabButton;
import dev.ftb.mods.ftbquests.net.ChangeProgressMessage;
import dev.ftb.mods.ftbquests.net.ForceSaveMessage;
import dev.ftb.mods.ftbquests.quest.theme.ThemeLoader;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class EditSettingsButton
extends TabButton {
    public EditSettingsButton(Panel panel) {
        super(panel, (Component)Component.m_237115_((String)"gui.settings"), (Icon)ThemeProperties.SETTINGS_ICON.get());
    }

    public void onClicked(MouseButton button) {
        this.playClickSound();
        if (this.questScreen.contextMenu != null) {
            this.questScreen.closeContextMenu();
            return;
        }
        ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
        contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"ftbquests.gui.edit_file"), (Icon)ThemeProperties.SETTINGS_ICON.get(), () -> this.questScreen.file.onEditButtonClicked((Runnable)((Object)this))));
        contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"ftbquests.gui.reset_progress"), (Icon)ThemeProperties.RELOAD_ICON.get(), () -> ChangeProgressMessage.send(this.questScreen.file.self, this.questScreen.file, progressChange -> {
            progressChange.reset = true;
        })).setYesNo((Component)Component.m_237115_((String)"ftbquests.gui.reset_progress_q")));
        contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"ftbquests.gui.complete_instantly"), (Icon)ThemeProperties.CHECK_ICON.get(), () -> ChangeProgressMessage.send(this.questScreen.file.self, this.questScreen.file, progressChange -> {
            progressChange.reset = false;
        })).setYesNo((Component)Component.m_237115_((String)"ftbquests.gui.complete_instantly_q")));
        contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"ftbquests.reward_tables"), (Icon)ThemeProperties.REWARD_TABLE_ICON.get(), () -> new RewardTablesScreen().openGui()));
        contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"ftbquests.gui.save_on_server"), (Icon)ThemeProperties.SAVE_ICON.get(), () -> new ForceSaveMessage().sendToServer()));
        contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"ftbquests.gui.save_as_file"), (Icon)ThemeProperties.DOWNLOAD_ICON.get(), () -> {
            try {
                Calendar time = Calendar.getInstance();
                StringBuilder fileName = new StringBuilder("local/ftbquests/saved/");
                this.appendNum(fileName, time.get(1), '-');
                this.appendNum(fileName, time.get(2) + 1, '-');
                this.appendNum(fileName, time.get(5), '-');
                this.appendNum(fileName, time.get(11), '-');
                this.appendNum(fileName, time.get(12), '-');
                this.appendNum(fileName, time.get(13), '\u0000');
                File file = new File(Minecraft.m_91087_().f_91069_, fileName.toString()).getCanonicalFile();
                ClientQuestFile.INSTANCE.writeDataFull(file.toPath());
                MutableComponent component = Component.m_237110_((String)"ftbquests.gui.saved_as_file", (Object[])new Object[]{"." + file.getPath().replace(Minecraft.m_91087_().f_91069_.getCanonicalFile().getAbsolutePath(), "")});
                component.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath()));
                Minecraft.m_91087_().f_91074_.m_213846_((Component)component);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }));
        contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"ftbquests.gui.reload_theme"), (Icon)ThemeProperties.RELOAD_ICON.get(), () -> {
            Minecraft mc = Minecraft.m_91087_();
            ThemeLoader.loadTheme(mc.m_91098_());
            ClientQuestFile.INSTANCE.refreshGui();
        }));
        contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"ftbquests.gui.wiki"), Icons.INFO, () -> this.handleClick("https://help.ftb.team/mods")));
        this.questScreen.openContextMenu(contextMenu);
    }

    private void appendNum(StringBuilder sb, int num, char c) {
        if (num < 10) {
            sb.append('0');
        }
        sb.append(num);
        if (c != '\u0000') {
            sb.append(c);
        }
    }
}

