/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui;

import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.ButtonListBaseScreen;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.gui.FTBQuestsTheme;
import dev.ftb.mods.ftbquests.net.ClaimChoiceRewardMessage;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.ChoiceReward;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class SelectChoiceRewardScreen
extends ButtonListBaseScreen {
    private final ChoiceReward choiceReward;

    public SelectChoiceRewardScreen(ChoiceReward r) {
        this.choiceReward = r;
        this.setTitle((Component)Component.m_237115_((String)"ftbquests.reward.ftbquests.choice"));
        this.setBorder(1, 1, 1);
    }

    public void addButtons(Panel panel) {
        for (WeightedReward r : this.choiceReward.getTable().rewards) {
            panel.add((Widget)new ChoiceRewardButton(panel, r));
        }
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    private class ChoiceRewardButton
    extends SimpleTextButton {
        private final WeightedReward weightedReward;

        private ChoiceRewardButton(Panel panel, WeightedReward r) {
            super(panel, r.reward.getTitle(), r.reward.getIcon());
            this.weightedReward = r;
        }

        public void addMouseOverText(TooltipList list) {
            super.addMouseOverText(list);
            this.weightedReward.reward.addMouseOverText(list);
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            this.closeGui();
            new ClaimChoiceRewardMessage(SelectChoiceRewardScreen.this.choiceReward.id, SelectChoiceRewardScreen.this.choiceReward.getTable().rewards.indexOf(this.weightedReward)).sendToServer();
        }

        @Nullable
        public Object getIngredientUnderMouse() {
            return this.weightedReward.reward.getIngredient();
        }
    }
}

