/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import dev.architectury.utils.Env;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import dev.ftb.mods.ftbquests.gui.CustomToast;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.integration.FTBQuestsJEIHelper;
import dev.ftb.mods.ftbquests.net.DeleteObjectMessage;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.theme.QuestTheme;
import dev.ftb.mods.ftbquests.util.TextUtils;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;

public class ClientQuestFile
extends QuestFile {
    private static final List<String> MISSING_DATA_ERR = List.of("Unable to open Quest GUI: no quest book data received from server!", "- Check that FTB Quests and FTB Teams are installed on the server", "  and that no server-side errors were logged when you connected.");
    public static ClientQuestFile INSTANCE;
    public TeamData self;
    public QuestScreen questScreen;
    public BaseScreen questGui;

    public static boolean exists() {
        return INSTANCE != null && !ClientQuestFile.INSTANCE.invalid;
    }

    @Override
    public void load() {
        if (INSTANCE != null) {
            INSTANCE.deleteChildren();
            INSTANCE.deleteSelf();
        }
        this.self = new TeamData(Util.f_137441_);
        this.self.file = this;
        this.self.name = "Loading...";
        this.self.setLocked(true);
        INSTANCE = this;
        this.refreshGui();
        FTBQuestsJEIHelper.refresh(this);
    }

    @Override
    public boolean canEdit() {
        return this.self.getCanEdit();
    }

    @Override
    public void refreshGui() {
        this.clearCachedData();
        boolean hasPrev = false;
        boolean guiOpen = false;
        int zoom = 0;
        double scrollX = 0.0;
        double scrollY = 0.0;
        long selectedChapter = 0L;
        long[] selectedQuests = new long[]{};
        boolean chaptersExpanded = false;
        if (this.questScreen != null) {
            hasPrev = true;
            zoom = this.questScreen.zoom;
            scrollX = this.questScreen.questPanel.centerQuestX;
            scrollY = this.questScreen.questPanel.centerQuestY;
            selectedChapter = this.questScreen.selectedChapter == null ? 0L : this.questScreen.selectedChapter.id;
            selectedQuests = new long[this.questScreen.selectedObjects.size()];
            int i = 0;
            for (Movable m : this.questScreen.selectedObjects) {
                if (m instanceof Quest) {
                    selectedQuests[i] = ((Quest)m).id;
                }
                ++i;
            }
            if (ClientUtils.getCurrentGuiAs(QuestScreen.class) != null) {
                guiOpen = true;
            }
            chaptersExpanded = this.questScreen.chapterPanel.expanded;
        }
        Minecraft.m_91087_().m_91152_(null);
        this.questScreen = new QuestScreen(this);
        this.questGui = this.questScreen;
        if (hasPrev) {
            this.questScreen.zoom = zoom;
            this.questScreen.selectChapter(this.getChapter(selectedChapter));
            for (long i : selectedQuests) {
                Quest q = this.getQuest(i);
                if (q == null) continue;
                this.questScreen.selectedObjects.add(q);
            }
            if (guiOpen) {
                this.questScreen.openGui();
            }
        }
        this.questScreen.refreshWidgets();
        if (hasPrev) {
            this.questScreen.questPanel.scrollTo(scrollX, scrollY);
        }
        this.questScreen.chapterPanel.setExpanded(chaptersExpanded);
    }

    public static void openGui() {
        if (INSTANCE != null) {
            INSTANCE.openQuestGui();
        } else {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                MISSING_DATA_ERR.forEach(s -> player.m_5661_((Component)Component.m_237113_((String)s).m_130940_(ChatFormatting.RED), false));
            }
        }
    }

    public void openQuestGui() {
        if (ClientQuestFile.exists()) {
            if (this.disableGui && !this.canEdit()) {
                Minecraft.m_91087_().m_91300_().m_94922_((Toast)new CustomToast((Component)Component.m_237115_((String)"item.ftbquests.book.disabled"), Icons.BARRIER, (Component)Component.m_237119_()));
            } else if (this.self.isLocked()) {
                Minecraft.m_91087_().m_91300_().m_94922_((Toast)new CustomToast((Component)(this.lockMessage.isEmpty() ? Component.m_237113_((String)"Quests locked!") : TextUtils.parseRawText(this.lockMessage)), Icons.BARRIER, (Component)Component.m_237119_()));
            } else {
                this.questGui.openGui();
            }
        }
    }

    @Override
    public Env getSide() {
        return Env.CLIENT;
    }

    @Override
    public void deleteObject(long id) {
        new DeleteObjectMessage(id).sendToServer();
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        QuestTheme.instance.clearCache();
    }

    @Override
    public TeamData getData(Entity player) {
        return player == Minecraft.m_91087_().f_91074_ ? this.self : this.getData(Objects.requireNonNull(ClientTeamManager.INSTANCE.getKnownPlayer((UUID)player.m_20148_()), (String)"Non-null team required!").teamId);
    }
}

