/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.block.entity;

import dev.ftb.mods.ftblibrary.config.BooleanConfig;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ItemStackConfig;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.block.FTBQuestsBlocks;
import dev.ftb.mods.ftbquests.block.TaskScreenBlock;
import dev.ftb.mods.ftbquests.block.entity.FTBQuestsBlockEntities;
import dev.ftb.mods.ftbquests.block.entity.ITaskScreen;
import dev.ftb.mods.ftbquests.net.TaskScreenConfigResponse;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class TaskScreenBlockEntity
extends BlockEntity
implements ITaskScreen {
    private long taskId = 0L;
    protected Task task = null;
    private boolean indestructible = false;
    private boolean inputOnly = false;
    private boolean textShadow = false;
    private ItemStack inputModeIcon = ItemStack.f_41583_;
    private ItemStack skin = ItemStack.f_41583_;
    @Nonnull
    private UUID teamId = Util.f_137441_;
    public float[] fakeTextureUV = null;
    private TeamData cachedTeamData = null;

    public TaskScreenBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)FTBQuestsBlockEntities.CORE_TASK_SCREEN.get(), blockPos, blockState);
    }

    public Task getTask() {
        if (this.task == null && this.taskId != 0L || this.task != null && this.task.id != this.taskId) {
            this.task = FTBQuests.PROXY.getQuestFile(this.f_58857_.f_46443_).getTask(this.taskId);
        }
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
        this.taskId = task == null ? 0L : task.id;
        this.m_6596_();
    }

    @Override
    public boolean isInputOnly() {
        return this.inputOnly;
    }

    public void setInputOnly(boolean inputOnly) {
        this.inputOnly = inputOnly;
        this.m_6596_();
    }

    public ItemStack getInputModeIcon() {
        return this.inputModeIcon;
    }

    public void setInputModeIcon(ItemStack inputModeIcon) {
        this.inputModeIcon = inputModeIcon;
        this.m_6596_();
    }

    @Override
    public boolean isIndestructible() {
        return this.indestructible;
    }

    public void setIndestructible(boolean indestructible) {
        this.indestructible = indestructible;
        this.m_6596_();
    }

    @Override
    public ItemStack getSkin() {
        return this.skin;
    }

    public void setSkin(ItemStack skin) {
        this.skin = skin;
        this.fakeTextureUV = null;
    }

    public boolean isTextShadow() {
        return this.textShadow;
    }

    public void setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
    }

    public void setTeamId(@Nonnull UUID teamId) {
        this.teamId = teamId;
        this.cachedTeamData = null;
    }

    @Override
    @Nonnull
    public UUID getTeamId() {
        return this.teamId;
    }

    public TeamData getCachedTeamData() {
        if (this.cachedTeamData == null) {
            QuestFile f = FTBQuests.PROXY.getQuestFile(this.f_58857_.f_46443_);
            this.cachedTeamData = f.getNullableTeamData(this.getTeamId());
        }
        return this.cachedTeamData;
    }

    @Override
    public Optional<TaskScreenBlockEntity> getCoreScreen() {
        return Optional.of(this);
    }

    public void removeAllAuxScreens() {
        Block block;
        if (this.f_58857_ != null && (block = this.m_58900_().m_60734_()) instanceof TaskScreenBlock) {
            TaskScreenBlock tsb = (TaskScreenBlock)block;
            BlockPos.m_121921_((AABB)TaskScreenBlock.getMultiblockBounds(this.m_58899_(), tsb.getSize(), (Direction)this.m_58900_().m_61143_((Property)TaskScreenBlock.FACING))).forEach(pos -> {
                if (this.f_58857_.m_8055_(pos).m_60734_() == FTBQuestsBlocks.AUX_SCREEN.get()) {
                    this.f_58857_.m_7471_(pos, false);
                }
            });
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.teamId = compoundTag.m_128403_("TeamID") ? compoundTag.m_128342_("TeamID") : Util.f_137441_;
        this.taskId = compoundTag.m_128454_("TaskID");
        this.skin = compoundTag.m_128441_("Skin") ? ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("Skin")) : ItemStack.f_41583_;
        this.indestructible = compoundTag.m_128471_("Indestructible");
        this.inputOnly = compoundTag.m_128471_("InputOnly");
        this.inputModeIcon = compoundTag.m_128441_("InputModeIcon") ? ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("InputModeIcon")) : ItemStack.f_41583_;
        this.textShadow = compoundTag.m_128471_("TextShadow");
        this.task = null;
        this.fakeTextureUV = null;
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        if (this.teamId != Util.f_137441_) {
            compoundTag.m_128362_("TeamID", this.teamId);
        }
        if (this.taskId != 0L) {
            compoundTag.m_128356_("TaskID", this.taskId);
        }
        if (!this.skin.m_41619_()) {
            compoundTag.m_128365_("Skin", (Tag)this.skin.m_41739_(new CompoundTag()));
        }
        if (this.indestructible) {
            compoundTag.m_128379_("Indestructible", true);
        }
        if (this.inputOnly) {
            compoundTag.m_128379_("InputOnly", true);
        }
        if (!this.inputModeIcon.m_41619_()) {
            compoundTag.m_128365_("InputModeIcon", (Tag)this.inputModeIcon.m_41739_(new CompoundTag()));
        }
        if (this.textShadow) {
            compoundTag.m_128379_("TextShadow", true);
        }
    }

    public ConfigGroup getConfigGroup(TeamData data) {
        ConfigGroup cg0 = new ConfigGroup("task_screen");
        cg0.setNameKey(this.m_58900_().m_60734_().m_7705_());
        ConfigGroup cg = cg0.getGroup("screen");
        ((ConfigQuestObject)cg.add("task", new ConfigQuestObject(o -> this.isSuitableTask(data, (QuestObjectBase)o)), (Object)this.getTask(), this::setTask, null)).setNameKey("ftbquests.task");
        ((ItemStackConfig)cg.add("skin", (ConfigValue)new ItemStackConfig(true, true), (Object)this.getSkin(), this::setSkin, (Object)ItemStack.f_41583_)).setNameKey("block.ftbquests.screen.skin");
        ((BooleanConfig)cg.add("text_shadow", (ConfigValue)new BooleanConfig(), (Object)this.isTextShadow(), this::setTextShadow, (Object)false)).setNameKey("block.ftbquests.screen.text_shadow");
        ((BooleanConfig)cg.add("indestructible", (ConfigValue)new BooleanConfig(), (Object)this.isIndestructible(), this::setIndestructible, (Object)false)).setNameKey("block.ftbquests.screen.indestructible");
        ((BooleanConfig)cg.add("input_only", (ConfigValue)new BooleanConfig(), (Object)this.isInputOnly(), this::setInputOnly, (Object)false)).setNameKey("block.ftbquests.screen.input_only");
        ((ItemStackConfig)cg.add("input_icon", (ConfigValue)new ItemStackConfig(true, true), (Object)this.getInputModeIcon(), this::setInputModeIcon, (Object)ItemStack.f_41583_)).setNameKey("block.ftbquests.screen.input_mode_icon");
        cg0.savedCallback = accepted -> {
            if (accepted) {
                new TaskScreenConfigResponse(this).sendToServer();
            }
        };
        return cg0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSuitableTask(TeamData data, QuestObjectBase o) {
        if (!(o instanceof Task)) return false;
        Task t = (Task)o;
        if (data.getCanEdit()) return true;
        if (!data.canStartTasks(t.quest)) return false;
        return true;
    }

    public float[] getFakeTextureUV() {
        if (this.fakeTextureUV == null) {
            Item item;
            if (!this.skin.m_41619_() && (item = this.skin.m_41720_()) instanceof BlockItem) {
                BlockItem bi = (BlockItem)item;
                BlockState state = bi.m_40614_().m_49966_();
                Direction facing = (Direction)this.m_58900_().m_61143_((Property)TaskScreenBlock.FACING);
                if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing);
                } else if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)facing);
                }
                this.fakeTextureUV = FTBQuests.PROXY.getTextureUV(state, facing);
            } else {
                this.fakeTextureUV = new float[0];
            }
        }
        return this.fakeTextureUV;
    }
}

