/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.element;

import com.jozufozu.flywheel.core.model.ModelUtil;
import com.jozufozu.flywheel.core.model.ShadeSeparatingVertexConsumer;
import com.jozufozu.flywheel.util.Pair;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.element.AnimatedSceneElement;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.render.SuperByteBufferCache;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.render.TileEntityRenderHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.outliner.AABBOutline;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.data.ModelData;

public class WorldSectionElement
extends AnimatedSceneElement {
    public static final SuperByteBufferCache.Compartment<com.simibubi.create.foundation.utility.Pair<Integer, Integer>> DOC_WORLD_SECTION = new SuperByteBufferCache.Compartment();
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);
    List<BlockEntity> renderedTileEntities;
    List<com.simibubi.create.foundation.utility.Pair<BlockEntity, Consumer<Level>>> tickableTileEntities;
    Selection section;
    boolean redraw;
    Vec3 prevAnimatedOffset = Vec3.f_82478_;
    Vec3 animatedOffset = Vec3.f_82478_;
    Vec3 prevAnimatedRotation = Vec3.f_82478_;
    Vec3 animatedRotation = Vec3.f_82478_;
    Vec3 centerOfRotation = Vec3.f_82478_;
    Vec3 stabilizationAnchor = null;
    BlockPos selectedBlock;

    public WorldSectionElement() {
    }

    public WorldSectionElement(Selection section) {
        this.section = section.copy();
        this.centerOfRotation = section.getCenter();
    }

    public void mergeOnto(WorldSectionElement other) {
        this.setVisible(false);
        if (other.isEmpty()) {
            other.set(this.section);
        } else {
            other.add(this.section);
        }
    }

    public void set(Selection selection) {
        this.applyNewSelection(selection.copy());
    }

    public void add(Selection toAdd) {
        this.applyNewSelection(this.section.add(toAdd));
    }

    public void erase(Selection toErase) {
        this.applyNewSelection(this.section.substract(toErase));
    }

    private void applyNewSelection(Selection selection) {
        this.section = selection;
        this.queueRedraw();
    }

    public void setCenterOfRotation(Vec3 center) {
        this.centerOfRotation = center;
    }

    public void stabilizeRotation(Vec3 anchor) {
        this.stabilizationAnchor = anchor;
    }

    @Override
    public void reset(PonderScene scene) {
        super.reset(scene);
        this.resetAnimatedTransform();
        this.resetSelectedBlock();
    }

    public void selectBlock(BlockPos pos) {
        this.selectedBlock = pos;
    }

    public void resetSelectedBlock() {
        this.selectedBlock = null;
    }

    public void resetAnimatedTransform() {
        this.prevAnimatedOffset = Vec3.f_82478_;
        this.animatedOffset = Vec3.f_82478_;
        this.prevAnimatedRotation = Vec3.f_82478_;
        this.animatedRotation = Vec3.f_82478_;
    }

    public void queueRedraw() {
        this.redraw = true;
    }

    public boolean isEmpty() {
        return this.section == null;
    }

    public void setEmpty() {
        this.section = null;
    }

    public void setAnimatedRotation(Vec3 eulerAngles, boolean force) {
        this.animatedRotation = eulerAngles;
        if (force) {
            this.prevAnimatedRotation = this.animatedRotation;
        }
    }

    public Vec3 getAnimatedRotation() {
        return this.animatedRotation;
    }

    public void setAnimatedOffset(Vec3 offset, boolean force) {
        this.animatedOffset = offset;
        if (force) {
            this.prevAnimatedOffset = this.animatedOffset;
        }
    }

    public Vec3 getAnimatedOffset() {
        return this.animatedOffset;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && !this.isEmpty();
    }

    public com.simibubi.create.foundation.utility.Pair<Vec3, BlockHitResult> rayTrace(PonderWorld world, Vec3 source, Vec3 target) {
        world.setMask(this.section);
        Vec3 transformedTarget = this.reverseTransformVec(target);
        BlockHitResult rayTraceBlocks = world.m_45547_(new ClipContext(this.reverseTransformVec(source), transformedTarget, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, null));
        world.clearMask();
        if (rayTraceBlocks == null) {
            return null;
        }
        if (rayTraceBlocks.m_82450_() == null) {
            return null;
        }
        double t = rayTraceBlocks.m_82450_().m_82546_(transformedTarget).m_82556_() / source.m_82546_(target).m_82556_();
        Vec3 actualHit = VecHelper.lerp((float)t, target, source);
        return com.simibubi.create.foundation.utility.Pair.of(actualHit, rayTraceBlocks);
    }

    private Vec3 reverseTransformVec(Vec3 in) {
        float pt = AnimationTickHolder.getPartialTicks();
        in = in.m_82546_(VecHelper.lerp(pt, this.prevAnimatedOffset, this.animatedOffset));
        if (!this.animatedRotation.equals((Object)Vec3.f_82478_) || !this.prevAnimatedRotation.equals((Object)Vec3.f_82478_)) {
            if (this.centerOfRotation == null) {
                this.centerOfRotation = this.section.getCenter();
            }
            double rotX = Mth.m_14139_((double)pt, (double)this.prevAnimatedRotation.f_82479_, (double)this.animatedRotation.f_82479_);
            double rotZ = Mth.m_14139_((double)pt, (double)this.prevAnimatedRotation.f_82481_, (double)this.animatedRotation.f_82481_);
            double rotY = Mth.m_14139_((double)pt, (double)this.prevAnimatedRotation.f_82480_, (double)this.animatedRotation.f_82480_);
            in = in.m_82546_(this.centerOfRotation);
            in = VecHelper.rotate(in, -rotX, Direction.Axis.X);
            in = VecHelper.rotate(in, -rotZ, Direction.Axis.Z);
            in = VecHelper.rotate(in, -rotY, Direction.Axis.Y);
            in = in.m_82549_(this.centerOfRotation);
            if (this.stabilizationAnchor != null) {
                in = in.m_82546_(this.stabilizationAnchor);
                in = VecHelper.rotate(in, rotX, Direction.Axis.X);
                in = VecHelper.rotate(in, rotZ, Direction.Axis.Z);
                in = VecHelper.rotate(in, rotY, Direction.Axis.Y);
                in = in.m_82549_(this.stabilizationAnchor);
            }
        }
        return in;
    }

    public void transformMS(PoseStack ms, float pt) {
        TransformStack.cast((PoseStack)ms).translate(VecHelper.lerp(pt, this.prevAnimatedOffset, this.animatedOffset));
        if (!this.animatedRotation.equals((Object)Vec3.f_82478_) || !this.prevAnimatedRotation.equals((Object)Vec3.f_82478_)) {
            if (this.centerOfRotation == null) {
                this.centerOfRotation = this.section.getCenter();
            }
            double rotX = Mth.m_14139_((double)pt, (double)this.prevAnimatedRotation.f_82479_, (double)this.animatedRotation.f_82479_);
            double rotZ = Mth.m_14139_((double)pt, (double)this.prevAnimatedRotation.f_82481_, (double)this.animatedRotation.f_82481_);
            double rotY = Mth.m_14139_((double)pt, (double)this.prevAnimatedRotation.f_82480_, (double)this.animatedRotation.f_82480_);
            ((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)ms).translate(this.centerOfRotation)).rotateX(rotX)).rotateZ(rotZ)).rotateY(rotY)).translateBack(this.centerOfRotation);
            if (this.stabilizationAnchor != null) {
                ((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)ms).translate(this.stabilizationAnchor)).rotateX(-rotX)).rotateZ(-rotZ)).rotateY(-rotY)).translateBack(this.stabilizationAnchor);
            }
        }
    }

    @Override
    public void tick(PonderScene scene) {
        this.prevAnimatedOffset = this.animatedOffset;
        this.prevAnimatedRotation = this.animatedRotation;
        if (!this.isVisible()) {
            return;
        }
        this.loadTEsIfMissing(scene.getWorld());
        this.renderedTileEntities.removeIf(te -> scene.getWorld().m_7702_(te.m_58899_()) != te);
        this.tickableTileEntities.removeIf(te -> scene.getWorld().m_7702_(((BlockEntity)te.getFirst()).m_58899_()) != te.getFirst());
        this.tickableTileEntities.forEach(te -> ((Consumer)te.getSecond()).accept(scene.getWorld()));
    }

    @Override
    public void whileSkipping(PonderScene scene) {
        if (this.redraw) {
            this.renderedTileEntities = null;
            this.tickableTileEntities = null;
        }
        this.redraw = false;
    }

    protected void loadTEsIfMissing(PonderWorld world) {
        if (this.renderedTileEntities != null) {
            return;
        }
        this.tickableTileEntities = new ArrayList<com.simibubi.create.foundation.utility.Pair<BlockEntity, Consumer<Level>>>();
        this.renderedTileEntities = new ArrayList<BlockEntity>();
        this.section.forEach(pos -> {
            BlockEntity tileEntity = world.m_7702_((BlockPos)pos);
            BlockState blockState = world.m_8055_((BlockPos)pos);
            Block block = blockState.m_60734_();
            if (tileEntity == null) {
                return;
            }
            if (!(block instanceof EntityBlock)) {
                return;
            }
            tileEntity.m_155250_(world.m_8055_((BlockPos)pos));
            BlockEntityTicker ticker = ((EntityBlock)block).m_142354_((Level)world, blockState, tileEntity.m_58903_());
            if (ticker != null) {
                this.addTicker(tileEntity, ticker);
            }
            this.renderedTileEntities.add(tileEntity);
        });
    }

    private <T extends BlockEntity> void addTicker(T tileEntity, BlockEntityTicker<?> ticker) {
        this.tickableTileEntities.add(com.simibubi.create.foundation.utility.Pair.of(tileEntity, w -> ticker.m_155252_(w, tileEntity.m_58899_(), tileEntity.m_58900_(), tileEntity)));
    }

    @Override
    public void renderFirst(PonderWorld world, MultiBufferSource buffer, PoseStack ms, float fade, float pt) {
        int light = -1;
        if (fade != 1.0f) {
            light = (int)Mth.m_14179_((float)fade, (float)5.0f, (float)14.0f);
        }
        if (this.redraw) {
            this.renderedTileEntities = null;
            this.tickableTileEntities = null;
        }
        ms.m_85836_();
        this.transformMS(ms, pt);
        world.pushFakeLight(light);
        this.renderTileEntities(world, ms, buffer, pt);
        world.popLight();
        Map<BlockPos, Integer> blockBreakingProgressions = world.getBlockBreakingProgressions();
        PoseStack overlayMS = null;
        for (Map.Entry<BlockPos, Integer> entry : blockBreakingProgressions.entrySet()) {
            BlockPos pos = entry.getKey();
            if (!this.section.test(pos)) continue;
            if (overlayMS == null) {
                overlayMS = new PoseStack();
                overlayMS.m_85850_().m_85861_().m_162210_(ms.m_85850_().m_85861_());
                overlayMS.m_85850_().m_85864_().m_8169_(ms.m_85850_().m_85864_());
                float scaleFactor = world.scene.getScaleFactor();
                float f = (float)Math.pow(30.0f * scaleFactor, -1.2);
                overlayMS.m_85841_(f, f, f);
            }
            SheetedDecalTextureGenerator builder = new SheetedDecalTextureGenerator(buffer.m_6299_((RenderType)ModelBakery.f_119229_.get(entry.getValue())), overlayMS.m_85850_().m_85861_(), overlayMS.m_85850_().m_85864_());
            ms.m_85836_();
            ms.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            ModelUtil.VANILLA_RENDERER.renderBreakingTexture(world.m_8055_(pos), pos, (BlockAndTintGetter)world, ms, (VertexConsumer)builder, ModelData.EMPTY);
            ms.m_85849_();
        }
        ms.m_85849_();
    }

    @Override
    protected void renderLayer(PonderWorld world, MultiBufferSource buffer, RenderType type, PoseStack ms, float fade, float pt) {
        SuperByteBuffer contraptionBuffer;
        SuperByteBufferCache bufferCache = CreateClient.BUFFER_CACHE;
        int code = this.hashCode() ^ ((Object)((Object)world)).hashCode();
        com.simibubi.create.foundation.utility.Pair<Integer, Integer> key = com.simibubi.create.foundation.utility.Pair.of(code, RenderType.m_110506_().indexOf(type));
        if (this.redraw) {
            bufferCache.invalidate(DOC_WORLD_SECTION, key);
        }
        if ((contraptionBuffer = bufferCache.get(DOC_WORLD_SECTION, key, () -> this.buildStructureBuffer(world, type))).isEmpty()) {
            return;
        }
        this.transformMS(contraptionBuffer.getTransforms(), pt);
        int light = this.lightCoordsFromFade(fade);
        contraptionBuffer.light(light).renderInto(ms, buffer.m_6299_(type));
    }

    @Override
    protected void renderLast(PonderWorld world, MultiBufferSource buffer, PoseStack ms, float fade, float pt) {
        this.redraw = false;
        if (this.selectedBlock == null) {
            return;
        }
        BlockState blockState = world.m_8055_(this.selectedBlock);
        if (blockState.m_60795_()) {
            return;
        }
        VoxelShape shape = blockState.m_60651_((BlockGetter)world, this.selectedBlock, CollisionContext.m_82750_((Entity)Minecraft.m_91087_().f_91074_));
        if (shape.m_83281_()) {
            return;
        }
        ms.m_85836_();
        this.transformMS(ms, pt);
        ms.m_85837_((double)this.selectedBlock.m_123341_(), (double)this.selectedBlock.m_123342_(), (double)this.selectedBlock.m_123343_());
        AABBOutline aabbOutline = new AABBOutline(shape.m_83215_());
        aabbOutline.getParams().lineWidth(0.015625f).colored(0xEFEFEF).disableNormals();
        aabbOutline.render(ms, (SuperRenderTypeBuffer)buffer, pt);
        ms.m_85849_();
    }

    private void renderTileEntities(PonderWorld world, PoseStack ms, MultiBufferSource buffer, float pt) {
        this.loadTEsIfMissing(world);
        TileEntityRenderHelper.renderTileEntities(world, this.renderedTileEntities, ms, buffer, pt);
    }

    private SuperByteBuffer buildStructureBuffer(PonderWorld world, RenderType layer) {
        BlockRenderDispatcher dispatcher = ModelUtil.VANILLA_RENDERER;
        ModelBlockRenderer renderer = dispatcher.m_110937_();
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        PoseStack poseStack = objects.poseStack;
        RandomSource random = objects.random;
        ShadeSeparatingVertexConsumer shadeSeparatingWrapper = objects.shadeSeparatingWrapper;
        BufferBuilder builder = new BufferBuilder(512);
        BufferBuilder unshadedBuilder = objects.unshadedBuilder;
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        unshadedBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        shadeSeparatingWrapper.prepare((VertexConsumer)builder, (VertexConsumer)unshadedBuilder);
        world.setMask(this.section);
        ModelBlockRenderer.m_111000_();
        this.section.forEach(pos -> {
            BlockState state = world.m_8055_((BlockPos)pos);
            FluidState fluidState = world.m_6425_((BlockPos)pos);
            poseStack.m_85836_();
            poseStack.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            if (state.m_60799_() == RenderShape.MODEL) {
                BakedModel model = dispatcher.m_110910_(state);
                BlockEntity tileEntity = world.m_7702_((BlockPos)pos);
                ModelData modelData = tileEntity != null ? tileEntity.getModelData() : ModelData.EMPTY;
                long seed = state.m_60726_(pos);
                random.m_188584_(seed);
                if (model.getRenderTypes(state, random, modelData).contains(layer)) {
                    renderer.tesselateBlock((BlockAndTintGetter)world, model, state, pos, poseStack, (VertexConsumer)shadeSeparatingWrapper, true, random, seed, OverlayTexture.f_118083_, modelData, layer);
                }
            }
            if (!fluidState.m_76178_() && ItemBlockRenderTypes.m_109287_((FluidState)fluidState) == layer) {
                dispatcher.m_234363_(pos, (BlockAndTintGetter)world, (VertexConsumer)builder, state, fluidState);
            }
            poseStack.m_85849_();
        });
        ModelBlockRenderer.m_111077_();
        world.clearMask();
        shadeSeparatingWrapper.clear();
        Pair pair = ModelUtil.endShadeSeparated((BufferBuilder)builder, (BufferBuilder)unshadedBuilder);
        return new SuperByteBuffer((BufferBuilder.RenderedBuffer)pair.first(), (Integer)pair.second());
    }

    private static class ThreadLocalObjects {
        public final PoseStack poseStack = new PoseStack();
        public final RandomSource random = RandomSource.m_216343_();
        public final ShadeSeparatingVertexConsumer shadeSeparatingWrapper = new ShadeSeparatingVertexConsumer();
        public final BufferBuilder unshadedBuilder = new BufferBuilder(512);

        private ThreadLocalObjects() {
        }
    }

    class WorldSectionRayTraceResult {
        Vec3 actualHitVec;
        BlockPos worldPos;

        WorldSectionRayTraceResult() {
        }
    }
}

