/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.mixin;

import com.google.common.collect.Maps;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationMapData;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationMarker;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationTileEntity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MapItemSavedData.class})
public class MapItemSavedDataMixin
implements StationMapData {
    @Unique
    private static final String STATION_MARKERS_KEY = "create:stations";
    @Shadow
    @Final
    public int f_77885_;
    @Shadow
    @Final
    public int f_77886_;
    @Shadow
    @Final
    public byte f_77890_;
    @Shadow
    @Final
    Map<String, MapDecoration> f_77894_;
    @Shadow
    private int f_181308_;
    @Unique
    private final Map<String, StationMarker> stationMarkers = Maps.newHashMap();

    @Inject(method={"load(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/world/level/saveddata/maps/MapItemSavedData;"}, at={@At(value="RETURN")})
    private static void onLoad(CompoundTag compound, CallbackInfoReturnable<MapItemSavedData> cir) {
        MapItemSavedData mapData = (MapItemSavedData)cir.getReturnValue();
        StationMapData stationMapData = (StationMapData)mapData;
        ListTag listTag = compound.m_128437_(STATION_MARKERS_KEY, 10);
        for (int i = 0; i < listTag.size(); ++i) {
            StationMarker stationMarker = StationMarker.load(listTag.m_128728_(i));
            stationMapData.addStationMarker(stationMarker);
        }
    }

    @Inject(method={"save(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/nbt/CompoundTag;"}, at={@At(value="RETURN")})
    public void onSave(CompoundTag compound, CallbackInfoReturnable<CompoundTag> cir) {
        ListTag listTag = new ListTag();
        for (StationMarker stationMarker : this.stationMarkers.values()) {
            listTag.add((Object)stationMarker.save());
        }
        compound.m_128365_(STATION_MARKERS_KEY, (Tag)listTag);
    }

    @Override
    public void addStationMarker(StationMarker marker) {
        MapDecoration oldDecoration;
        this.stationMarkers.put(marker.getId(), marker);
        int scaleMultiplier = 1 << this.f_77890_;
        float localX = (float)(marker.getTarget().m_123341_() - this.f_77885_) / (float)scaleMultiplier;
        float localZ = (float)(marker.getTarget().m_123343_() - this.f_77886_) / (float)scaleMultiplier;
        if (localX < -63.0f || localX > 63.0f || localZ < -63.0f || localZ > 63.0f) {
            this.m_164799_(marker.getId());
            return;
        }
        byte localXByte = (byte)(localX * 2.0f + 0.5f);
        byte localZByte = (byte)(localZ * 2.0f + 0.5f);
        StationMarker.Decoration decoration = new StationMarker.Decoration(localXByte, localZByte, marker.getName());
        if (!decoration.equals(oldDecoration = this.f_77894_.put(marker.getId(), decoration))) {
            if (oldDecoration != null && oldDecoration.m_77803_().m_181306_()) {
                --this.f_181308_;
            }
            if (decoration.m_77803_().m_181306_()) {
                ++this.f_181308_;
            }
            this.m_164812_();
        }
    }

    @Shadow
    private void m_164799_(String identifier) {
        throw new AssertionError();
    }

    @Shadow
    private void m_164812_() {
        throw new AssertionError();
    }

    @Shadow
    public boolean m_181312_(int trackedCount) {
        throw new AssertionError();
    }

    @Override
    public boolean toggleStation(LevelAccessor level, BlockPos pos, StationTileEntity stationTileEntity) {
        double xCenter = (double)pos.m_123341_() + 0.5;
        double zCenter = (double)pos.m_123343_() + 0.5;
        int scaleMultiplier = 1 << this.f_77890_;
        double localX = (xCenter - (double)this.f_77885_) / (double)scaleMultiplier;
        double localZ = (zCenter - (double)this.f_77886_) / (double)scaleMultiplier;
        if (localX < -63.0 || localX > 63.0 || localZ < -63.0 || localZ > 63.0) {
            return false;
        }
        StationMarker marker = StationMarker.fromWorld((BlockGetter)level, pos);
        if (marker == null) {
            return false;
        }
        if (this.stationMarkers.remove(marker.getId(), marker)) {
            this.m_164799_(marker.getId());
            return true;
        }
        if (!this.m_181312_(256)) {
            this.addStationMarker(marker);
            return true;
        }
        return false;
    }

    @Inject(method={"checkBanners(Lnet/minecraft/world/level/BlockGetter;II)V"}, at={@At(value="RETURN")})
    public void checkBanners(BlockGetter blockGetter, int x, int z, CallbackInfo ci) {
        this.checkStations(blockGetter, x, z);
    }

    private void checkStations(BlockGetter blockGetter, int x, int z) {
        Iterator<StationMarker> iterator = this.stationMarkers.values().iterator();
        ArrayList<StationMarker> newMarkers = new ArrayList<StationMarker>();
        while (iterator.hasNext()) {
            StationMarker other;
            StationMarker marker = iterator.next();
            if (marker.getTarget().m_123341_() != x || marker.getTarget().m_123343_() != z || marker.equals(other = StationMarker.fromWorld(blockGetter, marker.getSource()))) continue;
            iterator.remove();
            this.m_164799_(marker.getId());
            if (other == null || !marker.getTarget().equals((Object)other.getTarget())) continue;
            newMarkers.add(other);
        }
        for (StationMarker marker : newMarkers) {
            this.addStationMarker(marker);
        }
    }
}

