/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui.widget;

import com.simibubi.create.AllKeys;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;

public class ScrollInput
extends AbstractSimiWidget {
    protected Consumer<Integer> onScroll;
    protected int state = 0;
    protected Component title = Lang.translateDirect("gui.scrollInput.defaultTitle", new Object[0]);
    protected final Component scrollToModify = Lang.translateDirect("gui.scrollInput.scrollToModify", new Object[0]);
    protected final Component shiftScrollsFaster = Lang.translateDirect("gui.scrollInput.shiftScrollsFaster", new Object[0]);
    protected Label displayLabel;
    protected boolean inverted;
    protected Function<Integer, Component> formatter;
    protected int min = 0;
    protected int max = 1;
    protected int shiftStep = 5;
    Function<ScrollValueBehaviour.StepContext, Integer> step = this.standardStep();

    public ScrollInput(int xIn, int yIn, int widthIn, int heightIn) {
        super(xIn, yIn, widthIn, heightIn);
        this.formatter = i -> Components.literal(String.valueOf(i));
    }

    public Function<ScrollValueBehaviour.StepContext, Integer> standardStep() {
        return c -> c.shift ? this.shiftStep : 1;
    }

    public ScrollInput inverted() {
        this.inverted = true;
        return this;
    }

    public ScrollInput withRange(int min, int max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public ScrollInput calling(Consumer<Integer> onScroll) {
        this.onScroll = onScroll;
        return this;
    }

    public ScrollInput format(Function<Integer, Component> formatter) {
        this.formatter = formatter;
        return this;
    }

    public ScrollInput removeCallback() {
        this.onScroll = null;
        return this;
    }

    public ScrollInput titled(MutableComponent title) {
        this.title = title;
        this.updateTooltip();
        return this;
    }

    public ScrollInput withStepFunction(Function<ScrollValueBehaviour.StepContext, Integer> step) {
        this.step = step;
        return this;
    }

    public ScrollInput writingTo(Label label) {
        this.displayLabel = label;
        if (label != null) {
            this.writeToLabel();
        }
        return this;
    }

    public int getState() {
        return this.state;
    }

    public ScrollInput setState(int state) {
        this.state = state;
        this.clampState();
        this.updateTooltip();
        if (this.displayLabel != null) {
            this.writeToLabel();
        }
        return this;
    }

    public ScrollInput withShiftStep(int step) {
        this.shiftStep = step;
        return this;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.inverted) {
            delta *= -1.0;
        }
        ScrollValueBehaviour.StepContext context = new ScrollValueBehaviour.StepContext();
        context.control = AllKeys.ctrlDown();
        context.shift = AllKeys.shiftDown();
        context.currentValue = this.state;
        context.forward = delta > 0.0;
        int priorState = this.state;
        boolean shifted = AllKeys.shiftDown();
        int step = (int)Math.signum(delta) * this.step.apply(context);
        this.state += step;
        if (shifted) {
            this.state -= this.state % this.shiftStep;
        }
        this.clampState();
        if (priorState != this.state) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)AllSoundEvents.SCROLL_VALUE.getMainEvent(), (float)(1.5f + 0.1f * (float)(this.state - this.min) / (float)(this.max - this.min))));
            this.onChanged();
        }
        return priorState != this.state;
    }

    protected void clampState() {
        if (this.state >= this.max) {
            this.state = this.max - 1;
        }
        if (this.state < this.min) {
            this.state = this.min;
        }
    }

    public void onChanged() {
        if (this.displayLabel != null) {
            this.writeToLabel();
        }
        if (this.onScroll != null) {
            this.onScroll.accept(this.state);
        }
        this.updateTooltip();
    }

    protected void writeToLabel() {
        this.displayLabel.text = this.formatter.apply(this.state);
    }

    protected void updateTooltip() {
        this.toolTip.clear();
        if (this.title == null) {
            return;
        }
        this.toolTip.add(this.title.m_6879_().m_130938_(s -> s.m_178520_(5476833)));
        this.toolTip.add(this.scrollToModify.m_6879_().m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_GRAY}));
        this.toolTip.add(this.shiftScrollsFaster.m_6879_().m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_GRAY}));
    }
}

