/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.data.LangPartial;
import com.simibubi.create.foundation.utility.FilesHelper;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.util.GsonHelper;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;

public class LangMerger
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String CATEGORY_HEADER = "\t\"_\": \"->------------------------]  %s  [------------------------<-\",";
    private DataGenerator gen;
    private final String modid;
    private final String displayName;
    private final LangPartial[] langPartials;
    private List<Object> mergedLangData;
    private Map<String, List<Object>> populatedLangData;
    private Map<String, Map<String, String>> allLocalizedEntries;
    private Map<String, MutableInt> missingTranslationTally;
    private List<String> langIgnore;

    public <T extends LangPartial> LangMerger(DataGenerator gen, String modid, String displayName, T[] langPartials) {
        this.gen = gen;
        this.modid = modid;
        this.displayName = displayName;
        this.langPartials = langPartials;
        this.mergedLangData = new ArrayList<Object>();
        this.langIgnore = new ArrayList<String>();
        this.allLocalizedEntries = new HashMap<String, Map<String, String>>();
        this.populatedLangData = new HashMap<String, List<Object>>();
        this.missingTranslationTally = new HashMap<String, MutableInt>();
        this.populateLangIgnore();
    }

    protected void populateLangIgnore() {
        this.langIgnore.add("create.ponder.debug_");
        this.langIgnore.add("create.gui.chromatic_projector");
    }

    private boolean shouldIgnore(String key) {
        for (String string : this.langIgnore) {
            if (!key.startsWith(string)) continue;
            return true;
        }
        return false;
    }

    public String m_6055_() {
        return this.displayName + "'s lang merger";
    }

    public void m_213708_(CachedOutput cache) throws IOException {
        Path path = this.gen.m_123916_().resolve("assets/" + this.modid + "/lang/en_us.json");
        for (Pair<String, JsonElement> pair : this.getAllLocalizationFiles()) {
            if (!((JsonElement)pair.getRight()).isJsonObject()) continue;
            HashMap localizedEntries = new HashMap();
            JsonObject jsonobject = ((JsonElement)pair.getRight()).getAsJsonObject();
            jsonobject.entrySet().stream().forEachOrdered(entry -> {
                String key = (String)entry.getKey();
                if (key.startsWith("_")) {
                    return;
                }
                String value = ((JsonElement)entry.getValue()).getAsString();
                localizedEntries.put(key, value);
            });
            String key = (String)pair.getKey();
            this.allLocalizedEntries.put(key, localizedEntries);
            this.populatedLangData.put(key, new ArrayList());
            this.missingTranslationTally.put(key, new MutableInt(0));
        }
        this.collectExistingEntries(path);
        this.collectEntries();
        if (this.mergedLangData.isEmpty()) {
            return;
        }
        this.save(cache, this.mergedLangData, -1, path, "Merging en_us.json with hand-written lang entries...");
        for (Map.Entry entry2 : this.populatedLangData.entrySet()) {
            String key = (String)entry2.getKey();
            Path populatedLangPath = this.gen.m_123916_().resolve("assets/" + this.modid + "/lang/unfinished/" + key);
            this.save(cache, (List)entry2.getValue(), this.missingTranslationTally.get(key).intValue(), populatedLangPath, "Populating " + key + " with missing entries...");
        }
    }

    private void collectExistingEntries(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            Create.LOGGER.warn("Nothing to merge! It appears no lang was generated before me.");
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            JsonObject jsonobject = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
            HashSet keysToRemove = new HashSet();
            MutableBoolean startErasing = new MutableBoolean();
            jsonobject.entrySet().stream().forEachOrdered(entry -> {
                String key = (String)entry.getKey();
                if (key.startsWith("advancement")) {
                    startErasing.setTrue();
                }
                if (startErasing.isFalse()) {
                    return;
                }
                keysToRemove.add(key);
            });
            jsonobject.remove("_");
            keysToRemove.forEach(arg_0 -> ((JsonObject)jsonobject).remove(arg_0));
            this.addAll("Game Elements", jsonobject);
            reader.close();
        }
    }

    protected void addAll(String header, JsonObject jsonobject) {
        if (jsonobject == null) {
            return;
        }
        header = String.format(CATEGORY_HEADER, header);
        this.writeData("\n");
        this.writeData(header);
        this.writeData("\n\n");
        MutableObject previousKey = new MutableObject((Object)"");
        jsonobject.entrySet().stream().forEachOrdered(entry -> {
            String key = (String)entry.getKey();
            if (this.shouldIgnore(key)) {
                return;
            }
            String value = ((JsonElement)entry.getValue()).getAsString();
            if (!((String)previousKey.getValue()).isEmpty() && this.shouldAddLineBreak(key, (String)previousKey.getValue())) {
                this.writeData("\n");
            }
            this.writeEntry(key, value);
            previousKey.setValue((Object)key);
        });
        this.writeData("\n");
    }

    private void writeData(String data) {
        this.mergedLangData.add(data);
        this.populatedLangData.values().forEach(l -> l.add(data));
    }

    private void writeEntry(String key, String value) {
        this.mergedLangData.add(new LangEntry(key, value));
        this.populatedLangData.forEach((k, l) -> {
            ForeignLangEntry entry = new ForeignLangEntry(key, value, this.allLocalizedEntries.get(k));
            if (entry.isMissing()) {
                this.missingTranslationTally.get(k).increment();
            }
            l.add(entry);
        });
    }

    protected boolean shouldAddLineBreak(String key, String previousKey) {
        if (key.endsWith(".tooltip")) {
            return true;
        }
        if (key.startsWith(this.modid + ".ponder") && key.endsWith("header")) {
            return true;
        }
        key = key.replaceFirst("\\.", "");
        previousKey = previousKey.replaceFirst("\\.", "");
        String[] split = key.split("\\.");
        String[] split2 = previousKey.split("\\.");
        if (split.length == 0 || split2.length == 0) {
            return false;
        }
        return !split[0].equals(split2[0]);
    }

    private List<Pair<String, JsonElement>> getAllLocalizationFiles() {
        ArrayList<Pair<String, JsonElement>> list = new ArrayList<Pair<String, JsonElement>>();
        String filepath = "assets/" + this.modid + "/lang/";
        try (InputStream resourceStream = ClassLoader.getSystemResourceAsStream(filepath);){
            String readLine;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(resourceStream));
            while ((readLine = bufferedReader.readLine()) != null) {
                if (!readLine.endsWith(".json") || readLine.startsWith("en_us") || readLine.startsWith("en_ud")) continue;
                list.add((Pair<String, JsonElement>)Pair.of((Object)readLine, (Object)FilesHelper.loadJsonResource(filepath + readLine)));
            }
        }
        catch (IOException | NullPointerException e) {
            e.printStackTrace();
        }
        return list;
    }

    private void collectEntries() {
        for (LangPartial partial : this.langPartials) {
            this.addAll(partial.getDisplayName(), partial.provide().getAsJsonObject());
        }
    }

    private void save(CachedOutput cache, List<Object> dataIn, int missingKeys, Path target, String message) throws IOException {
        Create.LOGGER.info(message);
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        HashingOutputStream hashingoutputstream = new HashingOutputStream(Hashing.sha1(), (OutputStream)bytearrayoutputstream);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)hashingoutputstream, StandardCharsets.UTF_8);
        ((Writer)writer).append(this.createString(dataIn, missingKeys));
        ((Writer)writer).close();
        cache.m_213871_(target, bytearrayoutputstream.toByteArray(), hashingoutputstream.hash());
    }

    protected String createString(List<Object> data, int missingKeys) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        if (missingKeys != -1) {
            builder.append("\t\"_\": \"Missing Localizations: " + missingKeys + "\",\n");
        }
        data.forEach(builder::append);
        builder.append("\t\"_\": \"Thank you for translating ").append(this.displayName).append("!\"\n\n");
        builder.append("}");
        return builder.toString();
    }

    private class LangEntry {
        static final String ENTRY_FORMAT = "\t\"%s\": %s,\n";
        private String key;
        private String value;

        LangEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return String.format(ENTRY_FORMAT, this.key, GSON.toJson((Object)this.value, String.class));
        }
    }

    private class ForeignLangEntry
    extends LangEntry {
        private boolean missing;

        ForeignLangEntry(String key, String value, Map<String, String> localizationMap) {
            super(key, localizationMap.getOrDefault(key, "UNLOCALIZED: " + value));
            this.missing = !localizationMap.containsKey(key);
        }

        public boolean isMissing() {
            return this.missing;
        }
    }
}

